/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class SubjectKeyIdentifier
extends PKCSDerObject
implements EntityIdentifier,
Cloneable {
    private byte[] identifier;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SubjectKeyIdentifier";

    public SubjectKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier");
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", string);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", (Object)byArray);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier", byArray, string);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SubjectKeyIdentifier", string, new Boolean(bl));
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public SubjectKeyIdentifier(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SubjectKeyIdentifier", objectArray);
            debug.exit(16384L, className, "SubjectKeyIdentidier");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SubjectKeyIdentifier subjectKeyIdentifier = new SubjectKeyIdentifier(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", subjectKeyIdentifier);
            }
            return subjectKeyIdentifier;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof SubjectKeyIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        byte[] byArray = ((SubjectKeyIdentifier)object).getIdentifier();
        if (this.identifier.length != byArray.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.identifier[i] == byArray[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.identifier == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "SubjectKeyIdentifier not specified.");
            }
            throw new IOException("SubjectKeyIdentifier not specified.");
        }
        if (this.identifier == null || this.identifier.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding identifier");
            }
            throw new IOException("error encoding identifier");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOctetString(this.identifier);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getData().available() != 0) {
            this.identifier = derValue.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public synchronized void setIdentifier(byte[] byArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setIdentifier", (Object)byArray);
        }
        if (this.identifier != null) {
            if (debug != null) {
                debug.text(16384L, className, "setIdentifier", "Identifier byte array already set.");
            }
            throw new PKCSException("Identifier byte array already set.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setIdentifier", "Identifier byte array not specified.");
            }
            throw new IllegalArgumentException("Identifier byte array not specified.");
        }
        this.identifier = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.identifier, 0, byArray.length);
        if (debug != null) {
            debug.exit(16384L, className, "setIdentifier");
        }
    }

    public byte[] getIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIdentifier");
        }
        if (this.identifier == null || this.identifier.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIdentifier_1", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.identifier.length];
        System.arraycopy(this.identifier, 0, byArray, 0, this.identifier.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIdentifier", byArray);
        }
        return byArray;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 SubjectKeyIdentifier:\r\n";
        string = this.identifier != null ? string + hexDumpEncoder.encodeBuffer(this.identifier) + "\r\n" : string + "null";
        return string;
    }
}

