/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public final class SignedData
extends Content
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    protected static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    protected static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private BigInteger version;
    private AlgorithmId[] digestAlgorithms;
    private EncapsulatedContentInfo encapsulatedContentInfo;
    private Certificate[] certs;
    private CRL[] crls;
    private SignerInfo[] signers;
    private SignerInfo[] orig_signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignedData";

    public SignedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignedData", (Object)byArray);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SignedData", byArray, string);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certificateArray, CRL[] cRLArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SignedData", certificateArray, cRLArray);
        }
        this.addCertificate(certificateArray);
        this.addCRL(cRLArray);
        byte[] byArray = null;
        ContentInfo contentInfo = new ContentInfo(PKCSOID.DATA_OID, byArray);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certificateArray, CRL[] cRLArray, String string) throws IOException {
        super(string);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificateArray, cRLArray, string};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
        }
        this.addCertificate(certificateArray);
        this.addCRL(cRLArray);
        objectArray = null;
        ContentInfo contentInfo = new ContentInfo(PKCSOID.DATA_OID, (byte[])objectArray, string);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo, string);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(AlgorithmId[] algorithmIdArray, EncapsulatedContentInfo encapsulatedContentInfo, Certificate[] certificateArray, CRL[] cRLArray, SignerInfo[] signerInfoArray) {
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmIdArray, encapsulatedContentInfo, certificateArray, cRLArray, signerInfoArray};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
        }
        if (algorithmIdArray != null) {
            this.digestAlgorithms = (AlgorithmId[])algorithmIdArray.clone();
        }
        this.encapsulatedContentInfo = encapsulatedContentInfo;
        this.addCertificate(certificateArray);
        this.addCRL(cRLArray);
        if (signerInfoArray != null) {
            this.signers = (SignerInfo[])signerInfoArray.clone();
            this.orig_signers = this.signers;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(AlgorithmId[] algorithmIdArray, EncapsulatedContentInfo encapsulatedContentInfo, Certificate[] certificateArray, CRL[] cRLArray, SignerInfo[] signerInfoArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmIdArray, encapsulatedContentInfo, certificateArray, cRLArray, signerInfoArray, string};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
        }
        if (algorithmIdArray != null) {
            this.digestAlgorithms = (AlgorithmId[])algorithmIdArray.clone();
        }
        this.encapsulatedContentInfo = encapsulatedContentInfo;
        this.addCertificate(certificateArray);
        this.addCRL(cRLArray);
        if (signerInfoArray != null) {
            this.signers = (SignerInfo[])signerInfoArray.clone();
            this.orig_signers = this.signers;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate certificate, ContentInfo contentInfo, String string, PrivateKey privateKey, boolean bl) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(certificate, contentInfo, string, privateKey, bl, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificate, contentInfo, string, privateKey, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate certificate, ContentInfo contentInfo, String string, PrivateKey privateKey, boolean bl, String string2) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(string2);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, contentInfo, string, privateKey, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "ContentInfo must be specified.");
            }
            throw new IllegalArgumentException("ContentInfo must be specified.");
        }
        objectArray = PKCS7.getDigestAlgorithm(string);
        String string3 = PKCS7.getSignatureAlgorithm(string);
        this.encapsulatedContentInfo = string2 == null ? new EncapsulatedContentInfo(contentInfo) : new EncapsulatedContentInfo(contentInfo, string2);
        if (bl) {
            this.addSignerSignatureOnly(certificate, privateKey, string);
        } else {
            this.addSigner(certificate, privateKey, string, null, null);
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certificateArray, CRL[] cRLArray, ContentInfo contentInfo, String string, PrivateKey[] privateKeyArray, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, boolean bl) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(certificateArray, cRLArray, contentInfo, string, privateKeyArray, pKCSAttributes, pKCSAttributes2, bl, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificateArray, cRLArray, contentInfo, string, privateKeyArray, pKCSAttributes, pKCSAttributes2, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(Certificate[] certificateArray, CRL[] cRLArray, ContentInfo contentInfo, String string, PrivateKey[] privateKeyArray, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, boolean bl, String string2) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(string2);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificateArray, cRLArray, contentInfo, string, privateKeyArray, pKCSAttributes, pKCSAttributes2, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "One or more certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more certificates must be specified.");
        }
        if (privateKeyArray == null || privateKeyArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "One or more private keys must be specified.");
            }
            throw new IllegalArgumentException("One or more private keys must be specified.");
        }
        if (privateKeyArray.length != certificateArray.length) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Length of certificate array must match the length of the private key array.");
            }
            throw new IllegalArgumentException("Length of certificate array must match the length of the private key array.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedData", "ContentInfo must be specified.");
            }
            throw new IllegalArgumentException("ContentInfo must be specified.");
        }
        objectArray = PKCS7.getDigestAlgorithm(string);
        this.addDigestAlgorithm((String)objectArray);
        this.addCertificate(certificateArray);
        this.addCRL(cRLArray);
        this.encapsulatedContentInfo = string2 == null ? new EncapsulatedContentInfo(contentInfo) : new EncapsulatedContentInfo(contentInfo, string2);
        for (int i = 0; i < certificateArray.length; ++i) {
            PKCSAttributes pKCSAttributes3 = null;
            if (pKCSAttributes != null) {
                pKCSAttributes3 = (PKCSAttributes)pKCSAttributes.clone();
            }
            if (bl) {
                this.addSignerSignatureOnly(certificateArray[i], privateKeyArray[i], string);
                continue;
            }
            this.addSigner(certificateArray[i], privateKeyArray[i], string, pKCSAttributes3, pKCSAttributes2);
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SignedData", string, new Boolean(bl));
            debug.exit(16384L, className, "SignedData");
        }
    }

    public SignedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SignedData", objectArray);
            debug.exit(16384L, className, "SignedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SignedData signedData = new SignedData(derOutputStream.toByteArray(), this.provider);
            if (this.orig_signers == null) {
                if (this.signers != null) {
                    signedData.orig_signers = (SignerInfo[])this.signers.clone();
                }
            } else {
                signedData.orig_signers = (SignerInfo[])this.orig_signers.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signedData);
            }
            return signedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNED_DATA_OID);
        }
        return PKCSOID.SIGNED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithms() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithms");
        }
        if (this.digestAlgorithms == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithms_1", null);
            }
            return null;
        }
        AlgorithmId[] algorithmIdArray = new AlgorithmId[this.digestAlgorithms.length];
        for (int i = 0; i < this.digestAlgorithms.length; ++i) {
            try {
                algorithmIdArray[i] = new AlgorithmId(this.digestAlgorithms[i].getOID(), this.digestAlgorithms[i].getParameters(), this.provider);
                continue;
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "getDigestAlgorithms", exception);
                    debug.exit(16384L, (Object)className, "getDigestAlgorithms_2", null);
                }
                return null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithms", algorithmIdArray);
        }
        return algorithmIdArray;
    }

    public EncapsulatedContentInfo getEncapsulatedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContentInfo");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", null);
            }
            return null;
        }
        EncapsulatedContentInfo encapsulatedContentInfo = (EncapsulatedContentInfo)this.encapsulatedContentInfo.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", encapsulatedContentInfo);
        }
        return encapsulatedContentInfo;
    }

    private ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getContentInfo");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContentInfo", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentInfo", this.encapsulatedContentInfo.getContentInfo());
        }
        return this.encapsulatedContentInfo.getContentInfo();
    }

    private byte[] getContent() {
        if (debug != null) {
            debug.entry(8192L, className, "getContent");
        }
        if (this.encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContent", this.encapsulatedContentInfo.getContent());
        }
        return this.encapsulatedContentInfo.getContent();
    }

    public void removeContent() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "removeContent");
        }
        byte[] byArray = null;
        ContentInfo contentInfo = new ContentInfo(this.encapsulatedContentInfo.getContentType(), byArray, this.provider);
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(contentInfo, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "removeContent");
        }
    }

    public boolean hasContent() {
        if (debug != null) {
            debug.entry(16384L, className, "hasContent");
        }
        boolean bl = false;
        if (this.encapsulatedContentInfo.getContent() != null) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasContent", new Boolean(bl));
        }
        return bl;
    }

    public boolean hasCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCertificates");
        }
        boolean bl = false;
        if (this.certs != null && this.certs.length > 0) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificates", new Boolean(bl));
        }
        return bl;
    }

    public boolean hasCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCRLs");
        }
        boolean bl = false;
        if (this.crls != null && this.crls.length > 0) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCRLs", new Boolean(bl));
        }
        return bl;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        Certificate[] certificateArray = null;
        if (this.certs != null) {
            certificateArray = (Certificate[])this.certs.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", certificateArray);
        }
        return certificateArray;
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        CRL[] cRLArray = null;
        if (this.crls != null) {
            cRLArray = (CRL[])this.crls.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", cRLArray);
        }
        return cRLArray;
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
        }
        SignerInfo[] signerInfoArray = null;
        if (this.signers != null) {
            signerInfoArray = new SignerInfo[this.signers.length];
            for (int i = 0; i < this.signers.length; ++i) {
                signerInfoArray[i] = (SignerInfo)this.signers[i].clone();
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfos", signerInfoArray);
        }
        return signerInfoArray;
    }

    public synchronized boolean hasSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "hasSignerInfos");
        }
        boolean bl = false;
        if (this.signers != null && this.signers.length > 0) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignerInfos", new Boolean(bl));
        }
        return bl;
    }

    public SignerInfo getSignerInfo(Certificate certificate) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignerInfo", certificate);
        }
        SignerInfo signerInfo = null;
        if (this.signers != null || certificate != null) {
            for (int i = 0; i < this.signers.length; ++i) {
                if (!this.signers[i].hasCertificate(certificate)) continue;
                signerInfo = (SignerInfo)this.signers[i].clone();
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfo", signerInfo);
        }
        return signerInfo;
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuerAndSerialNumber) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertificate", issuerAndSerialNumber);
        }
        X509CertImpl x509CertImpl = null;
        if (this.certs != null && issuerAndSerialNumber != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                BigInteger bigInteger;
                X509Certificate x509Certificate = (X509Certificate)this.certs[i];
                Principal principal = x509Certificate.getIssuerDN();
                X500Name x500Name = new X500Name(principal.getName());
                if (!x500Name.equals(issuerAndSerialNumber.getIssuer()) || !(bigInteger = x509Certificate.getSerialNumber()).equals(issuerAndSerialNumber.getSerialNumber())) continue;
                try {
                    byte[] byArray = this.certs[i].getEncoded();
                    x509CertImpl = new X509CertImpl(byArray);
                    continue;
                }
                catch (CertificateException certificateException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "getCertificate", certificateException);
                    }
                    throw new IOException(certificateException.toString());
                }
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificate", x509CertImpl);
        }
        return x509CertImpl;
    }

    public boolean hasCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCertificate", certificate);
        }
        boolean bl = false;
        if (this.certs != null && certificate != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                if (!certificate.equals(this.certs[i])) continue;
                bl = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", new Boolean(bl));
        }
        return bl;
    }

    public boolean hasCRL(CRL cRL) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCRL", cRL);
        }
        boolean bl = false;
        if (this.crls == null || cRL == null) {
            bl = false;
        } else {
            for (int i = 0; i < this.crls.length; ++i) {
                if (!cRL.equals(this.crls[i])) continue;
                bl = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCRL", new Boolean(bl));
        }
        return bl;
    }

    public boolean hasCertificatesOnly() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCertificatesOnly");
        }
        boolean bl = false;
        if (this.hasCertificates() && !this.hasSignerInfos()) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificatesOnly", new Boolean(bl));
        }
        return bl;
    }

    public boolean verify(Certificate certificate) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", certificate);
        }
        boolean bl = this.verify(certificate, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(bl));
        }
        return bl;
    }

    public boolean verify(Certificate certificate, byte[] byArray) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", certificate, byArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        byte[] byArray2 = byArray;
        if (byArray2 == null && (byArray2 = this.getContent()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array not specified and content not stored with SignedData.");
            }
            throw new IllegalArgumentException("Byte array not specified and content not stored with SignedData.");
        }
        if (this.signers == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", new Boolean(false));
            }
            return false;
        }
        SignerInfo signerInfo = this.getSignerInfo(certificate);
        if (signerInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_2", new Boolean(false));
            }
            return false;
        }
        boolean bl = signerInfo.verify(certificate, byArray2);
        if (!bl) {
            SignerInfo signerInfo2 = null;
            if (this.orig_signers != null) {
                for (int i = 0; i < this.orig_signers.length; ++i) {
                    if (!this.orig_signers[i].hasCertificate(certificate)) continue;
                    signerInfo2 = this.orig_signers[i];
                    break;
                }
            }
            if (signerInfo2 != null) {
                bl = signerInfo2.verify(((X509Certificate)certificate).getPublicKey(), byArray2, (byte)1);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify_2", bl);
        }
        return bl;
    }

    public synchronized void addSigner(Certificate certificate, PrivateKey privateKey, String string, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, privateKey, string, pKCSAttributes, pKCSAttributes2};
            debug.entry(16384L, (Object)className, "addSigner", objectArray);
        }
        if ((objectArray = this.getContentInfo()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSigner", "SignedData does not contain a ContentInfo to sign.");
            }
            throw new PKCSException("SignedData does not contain a ContentInfo to sign.");
        }
        SignerInfo signerInfo = new SignerInfo(certificate, (ContentInfo)objectArray, string, privateKey, pKCSAttributes, pKCSAttributes2, this.provider);
        this.addSignerInfo(signerInfo);
        String string2 = PKCS7.getDigestAlgorithm(string);
        this.addDigestAlgorithm(string2);
        this.addCertificate(certificate);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addSigner");
        }
    }

    public synchronized void addSignerSignatureOnly(Certificate certificate, PrivateKey privateKey, String string) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, privateKey, string};
            debug.entry(16384L, (Object)className, "addSignerSignatureOnly", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "Digest and Signature Algorithm must be specified.");
            }
            throw new IllegalArgumentException("Digest and Signature Algorithm must be specified.");
        }
        objectArray = this.getContentInfo();
        if (objectArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "SignedData does not contain a ContentInfo to sign.");
            }
            throw new PKCSException("SignedData does not contain a ContentInfo to sign.");
        }
        if (!objectArray.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "addSignerSignatureOnly", "ContentInfo is of type " + objectArray.getContentTypeString() + ".  Type must be Data.");
            }
            throw new PKCSException("ContentInfo is of type " + objectArray.getContentTypeString() + ".  Type must be Data.");
        }
        String string2 = PKCS7.getDigestAlgorithm(string);
        Data data = (Data)objectArray.getContent();
        byte[] byArray = data.getData();
        SignerInfo signerInfo = new SignerInfo(certificate, this.provider);
        signerInfo.signSignatureOnly(byArray, string, privateKey);
        this.addSignerInfo(signerInfo);
        this.addDigestAlgorithm(string2);
        this.addCertificate(certificate);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addSignerSignatureOnly");
        }
    }

    private void addSignerInfo(SignerInfo signerInfo) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addSignerInfo", signerInfo);
        }
        if (signerInfo == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addSignerInfo_1");
            }
            return;
        }
        if (this.signers == null) {
            this.signers = new SignerInfo[1];
            this.signers[0] = signerInfo;
            this.orig_signers = this.signers;
            if (debug != null) {
                debug.exit(8192L, className, "addSignerInfo_2");
            }
            return;
        }
        int n = this.signers.length;
        SignerInfo[] signerInfoArray = new SignerInfo[n + 1];
        for (int i = 0; i < n; ++i) {
            signerInfoArray[i] = this.signers[i];
        }
        this.signers = signerInfoArray;
        this.signers[n] = signerInfo;
        if (this.orig_signers == null) {
            this.orig_signers = this.signers;
        }
        if (debug != null) {
            debug.exit(16384L, className, "addSignerInfo");
        }
    }

    private void addDigestAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addDigestAlgorithm", string);
        }
        if (string != null) {
            AlgorithmId algorithmId = AlgorithmId.get(string);
            this.addDigestAlgorithm(algorithmId);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addDigestAlgorithm");
        }
    }

    private void addDigestAlgorithm(AlgorithmId algorithmId) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addDigestAlgorithm", algorithmId);
        }
        if (algorithmId == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_1");
            }
            return;
        }
        if (this.digestAlgorithms == null) {
            this.digestAlgorithms = new AlgorithmId[1];
            this.digestAlgorithms[0] = algorithmId;
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_2");
            }
            return;
        }
        int n = this.digestAlgorithms.length;
        for (int i = 0; i < n; ++i) {
            if (!algorithmId.equals(this.digestAlgorithms[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addDigestAlgorithm_3");
            }
            return;
        }
        AlgorithmId[] algorithmIdArray = new AlgorithmId[n + 1];
        for (int i = 0; i < n; ++i) {
            algorithmIdArray[i] = this.digestAlgorithms[i];
        }
        this.digestAlgorithms = algorithmIdArray;
        this.digestAlgorithms[n] = algorithmId;
        if (debug != null) {
            debug.exit(8192L, className, "addDigestAlgorithm");
        }
    }

    private void addCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addCertificate", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_1");
            }
            return;
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(8192L, className, "addCertificate", "Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of X509Certificate are supported.");
        }
        if (this.certs == null) {
            this.certs = new Certificate[1];
            this.certs[0] = certificate;
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_2");
            }
            return;
        }
        int n = this.certs.length;
        for (int i = 0; i < n; ++i) {
            if (!certificate.equals(this.certs[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addCertificate_3");
            }
            return;
        }
        Certificate[] certificateArray = new Certificate[n + 1];
        for (int i = 0; i < n; ++i) {
            certificateArray[i] = this.certs[i];
        }
        this.certs = certificateArray;
        this.certs[n] = certificate;
        if (debug != null) {
            debug.exit(8192L, className, "addCertificate");
        }
    }

    public void addCertificate(Certificate[] certificateArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCertificate", certificateArray);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addCertificate_1");
            }
            return;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            this.addCertificate(certificateArray[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addCertificate");
        }
    }

    private void addCRL(CRL cRL) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addCRL", cRL);
        }
        if (cRL == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_1");
            }
            return;
        }
        if (!(cRL instanceof X509CRL)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "addCRL", "CRL type " + cRL.getClass().getName() + "not supported.  Only instances of java.security.cert.X509CRL are supported.");
            }
            throw new IllegalArgumentException("CRL type " + cRL.getClass().getName() + "not supported.  Only instances of java.security.cert.X509CRL are supported.");
        }
        if (this.crls == null) {
            this.crls = new CRL[1];
            this.crls[0] = cRL;
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_2");
            }
            return;
        }
        int n = this.crls.length;
        for (int i = 0; i < n; ++i) {
            if (!cRL.equals(this.crls[i])) continue;
            if (debug != null) {
                debug.exit(8192L, className, "addCRL_3");
            }
            return;
        }
        CRL[] cRLArray = new CRL[n + 1];
        for (int i = 0; i < n; ++i) {
            cRLArray[i] = this.crls[i];
        }
        this.crls = cRLArray;
        this.crls[n] = cRL;
        if (debug != null) {
            debug.exit(8192L, className, "addCRL");
        }
    }

    public void addCRL(CRL[] cRLArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCRL", cRLArray);
        }
        if (cRLArray != null && cRLArray.length != 0) {
            for (int i = 0; i < cRLArray.length; ++i) {
                this.addCRL(cRLArray[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addCRL");
        }
    }

    public void encodeOriginal(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        DerValue[] derValueArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.calculateVersion();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            derValueArray = new DerValue[this.digestAlgorithms.length];
            for (n = 0; n < this.digestAlgorithms.length; ++n) {
                object = new DerOutputStream();
                this.digestAlgorithms[n].encode((DerOutputStream)object);
                derValueArray[n] = new DerValue(((ByteArrayOutputStream)object).toByteArray());
            }
            derOutputStream.putSet(derValueArray);
        } else {
            derValueArray = new DerValue[]{};
            derOutputStream.putOrderedSetOf((byte)49, derValueArray);
        }
        this.encapsulatedContentInfo.encode(derOutputStream);
        try {
            if (this.certs != null && this.certs.length > 0) {
                derValueArray = new DerValue[this.certs.length];
                for (n = 0; n < this.certs.length; ++n) {
                    if (!(this.certs[n] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + n + "] has a type of " + this.certs[n].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + n + "] has a type of " + this.certs[n].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                    }
                    derValueArray[n] = new DerValue(this.certs[n].getEncoded());
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putSet(derValueArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", certificateEncodingException);
            }
            throw new IOException("Error encoding certificates.  " + certificateEncodingException.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                derValueArray = new DerValue[this.crls.length];
                for (int i = 0; i < this.crls.length; ++i) {
                    if (!(this.crls[i] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    object = (X509CRL)this.crls[i];
                    derValueArray[i] = new DerValue(((X509CRL)object).getEncoded());
                }
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putSet(derValueArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
            }
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", cRLException);
            }
            throw new IOException("Error encoding crls.  " + cRLException.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            if (this.orig_signers == null) {
                this.orig_signers = this.signers;
            }
            derValueArray = new DerValue[this.orig_signers.length];
            for (int i = 0; i < this.orig_signers.length; ++i) {
                object = new DerOutputStream();
                this.orig_signers[i].encodeWithOriginalAttrs((OutputStream)object);
                derValueArray[i] = new DerValue(((ByteArrayOutputStream)object).toByteArray());
            }
            derOutputStream.putSet(derValueArray);
        } else {
            derValueArray = new DerValue[]{};
            derOutputStream.putOrderedSetOf((byte)49, derValueArray);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.calculateVersion();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            derOutputStream.putOrderedSetOf((byte)49, this.digestAlgorithms);
        } else {
            objectArray = new DerValue[]{};
            derOutputStream.putOrderedSetOf((byte)49, (DerValue[])objectArray);
        }
        this.encapsulatedContentInfo.encode(derOutputStream);
        try {
            if (this.certs != null && this.certs.length > 0) {
                objectArray = new DerOutputStream[this.certs.length];
                for (int i = 0; i < this.certs.length; ++i) {
                    if (!(this.certs[i] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + i + "] has a type of " + this.certs[i].getClass().getName() + ".  Only instances of X509Certificate are supported.");
                    }
                    objectArray[i] = new DerOutputStream();
                    ((OutputStream)objectArray[i]).write(this.certs[i].getEncoded());
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putOrderedSetOf((byte)49, (DerEncoder[])objectArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", certificateEncodingException);
            }
            throw new IOException("Error encoding certificates.  " + certificateEncodingException.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                objectArray = new DerOutputStream[this.crls.length];
                for (int i = 0; i < this.crls.length; ++i) {
                    if (!(this.crls[i] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    objectArray[i] = new DerOutputStream();
                    X509CRL x509CRL = (X509CRL)this.crls[i];
                    ((OutputStream)objectArray[i]).write(x509CRL.getEncoded());
                }
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putOrderedSetOf((byte)49, (DerEncoder[])objectArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
            }
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", cRLException);
            }
            throw new IOException("Error encoding crls.  " + cRLException.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            derOutputStream.putOrderedSetOf((byte)49, this.signers);
        } else {
            objectArray = new DerValue[]{};
            derOutputStream.putOrderedSetOf((byte)49, (DerValue[])objectArray);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        if (SignedData.debug != null) {
            SignedData.debug.entry(16384L, (Object)SignedData.className, "decode", var1_1);
        }
        if (var1_1.getTag() != 48) {
            if (SignedData.debug != null) {
                SignedData.debug.text(16384L, SignedData.className, "decode", "SignedData parsing error.");
            }
            throw new IOException("SignedData parsing error.");
        }
        this.version = var1_1.getData().getInteger();
        if (this.version.intValue() != 1 && this.version.intValue() != 3) {
            if (SignedData.debug != null) {
                SignedData.debug.text(16384L, SignedData.className, "decode", "Invalid SignedData version = " + this.version + " (must be 1 or 3).");
            }
            throw new IOException("Invalid SignedData version = " + this.version + " (must be 1 or 3).");
        }
        var3_2 = var1_1.getData().getSet(1);
        this.digestAlgorithms = new AlgorithmId[var3_2.length];
        for (var4_3 = 0; var4_3 < var3_2.length; ++var4_3) {
            this.digestAlgorithms[var4_3] = AlgorithmId.parse(var3_2[var4_3]);
        }
        var2_9 = var1_1.getData().getDerValue();
        this.encapsulatedContentInfo = new EncapsulatedContentInfo(var2_9.toByteArray(), this.provider);
lbl19:
        // 3 sources

        try {
            while (var1_1.getData().available() != 0) {
                block19: {
                    block18: {
                        var2_9 = var1_1.getData().getDerValue();
                        if (!var2_9.isContextSpecific((byte)0) || !var2_9.isConstructed()) break block18;
                        var4_4 = new DerInputStream(var2_9.toByteArray());
                        var3_2 = var4_4.getSet(1, true);
                        this.certs = new Certificate[var3_2.length];
                        for (var5_10 = 0; var5_10 < var3_2.length; ++var5_10) {
                            this.certs[var5_10] = new X509CertImpl(var3_2[var5_10].toByteArray());
                        }
                        ** GOTO lbl19
                    }
                    if (!var2_9.isContextSpecific((byte)1) || !var2_9.isConstructed()) break block19;
                    var4_5 = new DerInputStream(var2_9.toByteArray());
                    var3_2 = var4_5.getSet(1, true);
                    this.crls = new X509CRL[var3_2.length];
                    for (var6_11 = 0; var6_11 < var3_2.length; ++var6_11) {
                        this.crls[var6_11] = new X509CRLImpl(var3_2[var6_11].toByteArray());
                    }
                    ** GOTO lbl19
                }
                if (var2_9.getTag() == 49) break;
                if (SignedData.debug != null) {
                    SignedData.debug.text(16384L, SignedData.className, "decode", "Error decoding SignedData.  Unknown tag " + var2_9.getTag() + ".");
                }
                throw new IOException("Error decoding SignedData.  Unknown tag " + var2_9.getTag() + ".");
            }
        }
        catch (CertificateException var4_6) {
            if (SignedData.debug != null) {
                SignedData.debug.exception(16384L, SignedData.className, "decode", var4_6);
            }
            throw new IOException("Error decoding certificates.  " + var4_6.toString());
        }
        catch (CRLException var4_7) {
            if (SignedData.debug != null) {
                SignedData.debug.exception(16384L, SignedData.className, "decode", var4_7);
            }
            throw new IOException("Error decoding CRLs.  " + var4_7.toString());
        }
        var4_8 = new DerInputStream(var2_9.toByteArray());
        var3_2 = var4_8.getSet(1, true);
        this.signers = new SignerInfo[var3_2.length];
        for (var5_10 = 0; var5_10 < var3_2.length; ++var5_10) {
            this.signers[var5_10] = new SignerInfo(var3_2[var5_10].toByteArray(), this.provider);
        }
        if (this.orig_signers == null) {
            this.orig_signers = this.signers;
        }
        if (SignedData.debug != null) {
            SignedData.debug.exit(16384L, SignedData.className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof SignedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((SignedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    private void removeSignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeSignedAttribute", objectIdentifier);
        }
        if (objectIdentifier != null && this.signers != null && this.signers.length != 0) {
            int n = this.signers.length;
            for (int i = 0; i < n; ++i) {
                this.signers[i].removeSignedAttribute(objectIdentifier);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "removeSignedAttribute");
        }
    }

    private void removeUnsignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeUnsignedAttribute", objectIdentifier);
        }
        if (objectIdentifier != null && this.signers != null && this.signers.length != 0) {
            int n = this.signers.length;
            for (int i = 0; i < n; ++i) {
                this.signers[i].removeUnsignedAttribute(objectIdentifier);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "removeUnsignedAttribute");
        }
    }

    public void writeBASE64(String string) throws IOException {
        boolean bl = this.hasCertificatesOnly();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        if (bl) {
            try {
                fileOutputStream.write(BEGIN_CERTIFICATE.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                fileOutputStream.write(BEGIN_CERTIFICATE.getBytes());
            }
        }
        bASE64Encoder.encode(byArray, (OutputStream)fileOutputStream);
        if (bl) {
            try {
                fileOutputStream.write(END_CERTIFICATE.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                fileOutputStream.write(END_CERTIFICATE.getBytes());
            }
        }
        fileOutputStream.close();
    }

    public String toString() {
        int n;
        this.calculateVersion();
        int n2 = 0;
        String string = "PKCS7 SignedData:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        n2 = 0;
        if (this.digestAlgorithms != null) {
            n2 = this.digestAlgorithms.length;
        }
        string = string + "\r\n\tdigestAlgorithms (" + n2 + "): ";
        if (this.digestAlgorithms == null || this.digestAlgorithms.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.digestAlgorithms.length; ++n) {
                string = string + "\r\n\tdigestAlgorithms[" + n + "]: " + this.digestAlgorithms[n];
            }
        }
        string = string + "\r\n\tencapsulatedContentInfo:\r\n";
        string = string + this.encapsulatedContentInfo;
        n2 = 0;
        if (this.certs != null) {
            n2 = this.certs.length;
        }
        string = string + "\r\n\tcertificates (" + n2 + "): ";
        if (this.certs == null || this.certs.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.certs.length; ++n) {
                string = string + "\r\n\tcerts[" + n + "]: " + this.certs[n];
            }
        }
        n2 = 0;
        if (this.crls != null) {
            n2 = this.crls.length;
        }
        string = string + "\r\n\tcertificate revocation lists (" + n2 + "): ";
        if (this.crls == null || this.crls.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.crls.length; ++n) {
                string = string + "\r\n\tcrls[" + n + "]: " + this.crls[n];
            }
        }
        n2 = 0;
        if (this.signers != null) {
            n2 = this.signers.length;
        }
        string = string + "\r\n\tsigners (" + n2 + "): ";
        if (this.signers == null || this.signers.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.signers.length; ++n) {
                string = string + "\r\n\tsigner[" + n + "]: " + this.signers[n];
            }
        }
        return string;
    }

    private void calculateVersion() {
        this.version = BigInteger.ONE;
    }
}

