/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer MAYFLY = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final String[] objclassNames = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY", "HW_FEATURE"};
    private static final int[] attrtypeList = new int[]{0, 1, 2, 3, 16, 768, 18, 17, 128, 129, 130, 131, 132, 133, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 352, 353, 354, 355, 356, 357, 368, 384, 385, 512, 513, 769, 770};
    private static final String[] attrtypeNames = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "HW_FEATURE_TYPE", "OBJECT_ID", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "AC_ISSUER", "OWNER", "ATTR_TYPES", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "MODIFIABLE", "ECDSA_PARAMS", "EC_POINT", "SECONDARY_AUTH", "AUTH_PIN_FLAGS", "RESET_ON_INIT", "HAS_RESET"};
    private static final Class[] attrValueClasses = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$("java.util.Date")) : class$java$util$Date, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$("java.util.Date")) : class$java$util$Date, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static final Integer[] keytypeList = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
    private static final String[] keytypeNames = new String[]{"RSA", "DSA", "DH", "ECDSA", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF"};
    private static final int[] pinflagList = new int[]{65536, 131072, 262144, 524288};
    static final String[] pinflagNames = new String[]{"USER_PIN_COUNT_LOW", "USER_PIN_FINAL_TRY", "USER_PIN_LOCKED", "USER_PIN_TO_BE_CHANGED"};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getAttributeValue(nArray[i]);
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n);
    }

    public int getIntAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n);
    }

    public String getStringAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$("java.lang.String")) : class$java$lang$String)) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n);
    }

    public byte[] getByteArrayAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (array$B == null ? (array$B = PKCS11Object.class$("[B")) : array$B)) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n);
    }

    public Date getDateAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$("java.util.Date")) : class$java$util$Date)) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n);
    }

    public BigInteger getBigIntegerAttributeValue(int n) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n, boolean bl) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n, new Boolean(bl));
    }

    public void setIntAttributeValue(int n, int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n, new Integer(n2));
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = "                    ";
        stringBuffer.append("object:\n");
        for (n = 0; n < attrtypeList.length; ++n) {
            String string2;
            String string3;
            block5: {
                int n2 = attrtypeList[n];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block5;
                    string2 = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (string2 == null) continue;
            stringBuffer.append("\t").append(string3).append(":");
            stringBuffer.append(string.substring(string3.length()));
            stringBuffer.append(string2).append("\n");
        }
        try {
            n = this.size();
            stringBuffer.append("\tSIZE:").append(string.substring(4)).append(n).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static Class valueClass(int n) {
        for (int i = 0; i < attrtypeList.length; ++i) {
            if (attrtypeList[i] != n) continue;
            return attrValueClasses[i];
        }
        return null;
    }

    public static String typeToString(int n) {
        for (int i = 0; i < attrtypeList.length; ++i) {
            if (attrtypeList[i] != n) continue;
            return attrtypeNames[i];
        }
        return "0x" + Integer.toString(n, 16);
    }

    public static String classToString(Integer n) {
        int n2 = n;
        if (n2 >= 0 && n2 < objclassNames.length) {
            return objclassNames[n2];
        }
        return "0x" + Integer.toString(n2, 16);
    }

    public static String keyToString(Integer n) {
        int n2 = n;
        for (int i = 0; i < keytypeList.length; ++i) {
            if (keytypeList[i] != n2) continue;
            return keytypeNames[i];
        }
        return "0x" + Integer.toHexString(n2);
    }

    public static String certToString(Integer n) {
        if (n.equals(X_509)) {
            return "X_509";
        }
        if (n.equals(X_509_ATTR_CERT)) {
            return "X_509_ATTR_CERT";
        }
        return "0x" + Integer.toHexString(n);
    }

    public static String hwfeatureToString(Integer n) {
        if (n.equals(MONOTONIC_COUNTER)) {
            return "MONOTONIC_COUNTER";
        }
        if (n.equals(CLOCK)) {
            return "CLOCK";
        }
        return "0x" + Integer.toHexString(n);
    }

    public static String pinflagsToString(Integer n) {
        return PKCS11.flagsToString(n, pinflagList, pinflagNames, " | ");
    }

    public static String attrToString(int n, Object object) {
        if (object == null) {
            return "null";
        }
        switch (n) {
            case 0: {
                return PKCS11Object.classToString((Integer)object);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)object);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)object);
            }
            case 513: {
                return PKCS11Object.pinflagsToString((Integer)object);
            }
            case 768: {
                return PKCS11Object.hwfeatureToString((Integer)object);
            }
            case 17: 
            case 18: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])object, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)object).toString(16);
            }
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (n != 0 && n3 > n) {
                stringBuffer.append(" ... (").append(byArray.length).append(" bytes)");
                break;
            }
            if (n2 == 16) {
                stringBuffer.append('\n');
                n2 = 0;
            }
            if (n2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("0123456789abcdef".charAt(byArray[n3] >> 4 & 0xF));
            stringBuffer.append("0123456789abcdef".charAt(byArray[n3] & 0xF));
            ++n3;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        stringBuffer.append("  * <TR> <TH> attribute type     <TH> object type\n");
        for (int i = 0; i < attrtypeList.length; ++i) {
            String string = attrValueClasses[i].getName();
            string = string.endsWith("[B") ? "byte[]" : string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append("  * <TR> <TD> <TT>").append(attrtypeNames[i]);
            stringBuffer.append("</TT> <TD> <TT>").append(string).append("</TT>\n");
        }
        stringBuffer.append("  * </TABLE> <P>\n");
        System.out.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

