/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.CEFormatException;
import com.ibm.misc.CEStreamExhausted;
import com.ibm.misc.CharacterDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BASE64Decoder
extends CharacterDecoder {
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;
    byte[] decode_buffer = new byte[4];

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72;
    }

    protected void decodeAtom(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        if (n < 2) {
            throw new CEFormatException("BASE64Decoder: Not enough bytes for an atom.");
        }
        int n6 = this.readFully(inputStream, this.decode_buffer, 0, n);
        if (n6 == -1) {
            throw new CEStreamExhausted();
        }
        if (n > 3 && this.decode_buffer[3] == 61) {
            n = 3;
        }
        if (n > 2 && this.decode_buffer[2] == 61) {
            n = 2;
        }
        switch (n) {
            case 4: {
                n5 = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                n4 = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                n3 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                n2 = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        switch (n) {
            case 2: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                break;
            }
            case 3: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                break;
            }
            case 4: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                outputStream.write((byte)(n4 << 6 & 0xC0 | n5 & 0x3F));
            }
        }
    }

    protected int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            if (n3 == 13 || n3 == 10 || n3 == 32 || n3 == 9) {
                --i;
                continue;
            }
            byArray[i + n] = (byte)n3;
        }
        return n2;
    }

    static {
        int n;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (n = 0; n < 255; ++n) {
            BASE64Decoder.pem_convert_array[n] = -1;
        }
        for (n = 0; n < pem_array.length; ++n) {
            BASE64Decoder.pem_convert_array[BASE64Decoder.pem_array[n]] = (byte)n;
        }
    }
}

