/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.WSRdbRecord;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSRdbRecordImpl
implements WSRdbRecord {
    private static final long serialVersionUID = 4414887319863033619L;
    private static final TraceComponent tc = Tr.register((Class)WSRdbRecordImpl.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final String currClassName = WSRdbRecordImpl.class.getName();
    private String ivRecordName;
    private String ivRecordShortDescription;
    private CallableStatement cstmt;
    private StatementCacheKey statementCacheKey;
    private WSRdbConnectionImpl rdbConn;
    private WSRdbResultSetImpl[] rsetWrappers;
    private int numRSetWrappers;
    private static final int MAX_NUM_RSET = 5;
    private static final int INCREMNT_SIZE_RSET = 10;

    public WSRdbRecordImpl(CallableStatement callableStatement, Object object, StatementCacheKey statementCacheKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{AdapterUtil.toString((Object)callableStatement), AdapterUtil.toString((Object)object), statementCacheKey});
        }
        this.cstmt = callableStatement;
        try {
            this.rdbConn = (WSRdbConnectionImpl)object;
            this.rdbConn.addRdbRecord(this);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.<init>", (String)"129", (Object)this);
            Tr.error((TraceComponent)tc, (String)"CAST_EXCEPTION", (Object)new Object[]{object.getClass().getName(), "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl"});
            throw classCastException;
        }
        this.statementCacheKey = statementCacheKey;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init", (Object)this);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSet", (Object)this);
        }
        try {
            Object object;
            ResultSet resultSet = this.cstmt.getResultSet();
            if (resultSet == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResultSet", null);
                }
                return null;
            }
            if (this.rsetWrappers == null) {
                this.rsetWrappers = new WSRdbResultSetImpl[5];
            } else if (this.numRSetWrappers >= this.rsetWrappers.length) {
                object = this.rsetWrappers;
                this.rsetWrappers = new WSRdbResultSetImpl[this.numRSetWrappers + 10];
                System.arraycopy(object, 0, this.rsetWrappers, 0, ((Object)object).length);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Get more result sets than expected, increased array size to " + this.rsetWrappers.length));
                }
            }
            object = new WSRdbResultSetImpl(resultSet, true);
            ((WSRdbResultSetImpl)object).initialize(this.rdbConn);
            this.rsetWrappers[this.numRSetWrappers++] = object;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getResultSet", (String)"136", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResultSet", (Object)"Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSet", (Object)this.rsetWrappers[this.numRSetWrappers - 1]);
        }
        return this.rsetWrappers[this.numRSetWrappers - 1];
    }

    public int getUpdateCount() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getUpdateCount");
        }
        try {
            return this.cstmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getUpdateCount", (String)"163", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMoreResults", (Object)this);
        }
        try {
            if (this.numRSetWrappers > 0 && !this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                this.rsetWrappers[this.numRSetWrappers - 1].close();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getMoreResults", (String)"201", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{AdapterUtil.toString((Object)this.rsetWrappers[this.numRSetWrappers - 1]), sQLException});
        }
        try {
            bl = this.cstmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getMoreResults", (String)"213", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMoreResults", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object)this);
        }
        if (this.numRSetWrappers > 0) {
            if (!this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                try {
                    this.rsetWrappers[this.numRSetWrappers - 1].close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.close", (String)"255", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{AdapterUtil.toString((Object)this.rsetWrappers[this.numRSetWrappers - 1]), sQLException});
                }
            }
            int n = this.numRSetWrappers;
            while (n > 0) {
                this.rsetWrappers[--n].setStatementCallable(false);
                this.rsetWrappers[n] = null;
            }
            this.numRSetWrappers = 0;
        }
        this.cstmt = null;
        this.ivRecordName = null;
        this.ivRecordShortDescription = null;
        this.rdbConn = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public final WSRdbRecordImpl recycle(CallableStatement callableStatement, Object object, StatementCacheKey statementCacheKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"recycle", (Object)new Object[]{AdapterUtil.toString((Object)callableStatement), AdapterUtil.toString((Object)object), statementCacheKey});
        }
        this.cstmt = callableStatement;
        try {
            this.rdbConn = (WSRdbConnectionImpl)object;
            this.rdbConn.addRdbRecord(this);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.<init>", (String)"402", (Object)this);
            Tr.error((TraceComponent)tc, (String)"CAST_EXCEPTION", (Object)new Object[]{object.getClass().getName(), currClassName});
            throw classCastException;
        }
        this.statementCacheKey = statementCacheKey;
        this.ivRecordName = null;
        this.ivRecordShortDescription = null;
        return this;
    }

    public Array getArray(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getArray", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getArray", (String)"433", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Array getArray(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getArray", (Object)string);
        }
        try {
            return this.cstmt.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getArray", (String)"442", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBigDecimal", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", (String)"473", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBigDecimal", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        try {
            return this.cstmt.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", (String)"499", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBigDecimal", (Object)string);
        }
        try {
            return this.cstmt.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", (String)"508", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBlob", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBlob", (String)"537", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBlob", (Object)string);
        }
        try {
            return this.cstmt.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBlob", (String)"546", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBoolean", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBoolean", (String)"576", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBoolean", (Object)string);
        }
        try {
            return this.cstmt.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBoolean", (String)"585", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte getByte(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getByte", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getByte", (String)"613", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte getByte(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getByte", (Object)string);
        }
        try {
            return this.cstmt.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getByte", (String)"622", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBytes", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBytes", (String)"650", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBytes", (Object)string);
        }
        try {
            return this.cstmt.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBytes", (String)"659", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getClob", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getClob", (String)"688", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getClob", (Object)string);
        }
        try {
            return this.cstmt.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getClob", (String)"697", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDate", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", (String)"729", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDate", (Object)new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", (String)"755", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDate", (Object)string);
        }
        try {
            return this.cstmt.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", (String)"764", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDate", (Object)new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", (String)"773", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public double getDouble(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDouble", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDouble", (String)"809", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public double getDouble(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getDouble", (Object)string);
        }
        try {
            return this.cstmt.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDouble", (String)"818", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public float getFloat(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getFloat", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getFloat", (String)"846", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public float getFloat(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getFloat", (Object)string);
        }
        try {
            return this.cstmt.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getFloat", (String)"855", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public int getInt(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInt", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getInt", (String)"885", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public int getInt(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInt", (Object)string);
        }
        try {
            return this.cstmt.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getInt", (String)"894", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public long getLong(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLong", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getLong", (String)"923", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public long getLong(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLong", (Object)string);
        }
        try {
            return this.cstmt.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getLong", (String)"931", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getObject", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", (String)"966", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getObject", (Object)new Object[]{new Integer(n), map});
        }
        try {
            return this.cstmt.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", (String)"994", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getObject", (Object)string);
        }
        try {
            return this.cstmt.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", (String)"1003", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getObject", (Object)new Object[]{string, map});
        }
        try {
            return this.cstmt.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", (String)"1012", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRef", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getRef", (String)"1059", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRef", (Object)string);
        }
        try {
            return this.cstmt.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getRef", (String)"1068", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public short getShort(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getShort", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getShort", (String)"1098", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public short getShort(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getShort", (Object)string);
        }
        try {
            return this.cstmt.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getShort", (String)"1107", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public String getString(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getString", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getString", (String)"1139", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public String getString(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getString", (Object)string);
        }
        try {
            return this.cstmt.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getString", (String)"1148", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTime", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", (String)"1181", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTime", (Object)new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", (String)"1206", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTime", (Object)string);
        }
        try {
            return this.cstmt.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", (String)"1215", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTime", (Object)new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", (String)"1224", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTimestamp", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", (String)"1261", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTimestamp", (Object)new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", (String)"1288", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTimestamp", (Object)string);
        }
        try {
            return this.cstmt.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", (String)"1297", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTimestamp", (Object)new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", (String)"1306", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public URL getURL(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getURL", (Object)new Integer(n));
        }
        try {
            return this.cstmt.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getURL", (String)"1315", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public URL getURL(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getURL", (Object)string);
        }
        try {
            return this.cstmt.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getURL", (String)"1324", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean wasNull() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"wasNull");
        }
        try {
            return this.cstmt.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.wasNull", (String)"1386", (Object)this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public final void setRecordName(String string) {
        this.ivRecordName = string;
    }

    public final String getRecordName() {
        return this.ivRecordName;
    }

    public final void setRecordShortDescription(String string) {
        this.ivRecordShortDescription = string;
    }

    public final String getRecordShortDescription() {
        return this.ivRecordShortDescription;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(AdapterUtil.getNLSMessage((String)"OBJECT_CANNOT_BE_CLONED", (Object)"com.ibm.websphere.rsadapter.WSRdbRecord"));
    }
}

