/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.ProxyDataSource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionSpecImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResourceAdapterMetaDataImpl;
import com.ibm.ws.rsadapter.cci.WSRecordFactoryImpl;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class WSRdbConnectionFactoryImpl
implements ConnectionFactory {
    private static final long serialVersionUID = 3520140975323933254L;
    private static final TraceComponent tc = Tr.register((Class)WSRdbConnectionFactoryImpl.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private RecordFactory ivRecordFactory;
    private Reference ivReference;
    private WSRdbResourceAdapterMetaDataImpl ivResourceAdapterMetaData;
    WSManagedConnectionFactoryImpl mcf;
    DataStoreHelper helper;
    InternalDataStoreHelper internalHelper;
    private ConnectionManager connMgr;
    private int defaultIsolationLevel;
    private boolean supportIsolvlSwitching;
    private int dsHelperType = -2;
    private String jndiName = null;
    ProxyDataSource proxyDataSource = null;
    private static final ConnectionRequestInfo[] defaultCRIs;
    private static final ConnectionRequestInfo[] defaultCRIsWithSwitch;
    private static final ConnectionRequestInfo[] defaultCRIsWithIW_CMPShare;
    private static final ConnectionRequestInfo[] defaultCRIsWithCMPShare;

    public WSRdbConnectionFactoryImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebSphere code should never call this method.");
        }
    }

    public WSRdbConnectionFactoryImpl(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, ConnectionManager connectionManager) {
        this.mcf = wSManagedConnectionFactoryImpl;
        this.connMgr = connectionManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSManagedConnectionFactoryImpl, connectionManager});
        }
        this.helper = wSManagedConnectionFactoryImpl.getDataStoreHelper();
        this.internalHelper = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper();
        this.dsHelperType = this.helper.getMetaData().getHelperType();
        this.jndiName = wSManagedConnectionFactoryImpl.getJndiName();
        if (this.dsHelperType == 20) {
            this.proxyDataSource = (ProxyDataSource)wSManagedConnectionFactoryImpl.getUnderlyingDataSource(29497789L, 0);
        }
        CMConfigData cMConfigData = WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCMConfigData(connectionManager);
        try {
            if (cMConfigData != null) {
                this.defaultIsolationLevel = cMConfigData.getIsolationLevel();
                if (this.defaultIsolationLevel == 0) {
                    this.defaultIsolationLevel = this.helper.getIsolationLevel(null);
                }
            } else {
                this.defaultIsolationLevel = this.helper.getIsolationLevel(null);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl.<init>", (String)"68", (Object)this);
            String string = System.getProperty("line.separator");
            Tr.warning((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{"Unable to determine the WebSphere default isolation level from the DataStoreHelper" + string + "Defaulting to READ COMMITTED." + string + this.helper + string + AdapterUtil.stackTraceToString((Throwable)resourceException)});
            this.defaultIsolationLevel = 2;
        }
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public final boolean equals(Object object) {
        try {
            WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl = (WSRdbConnectionFactoryImpl)object;
            return this.mcf.equals((Object)wSRdbConnectionFactoryImpl.mcf) && this.connMgr.equals(wSRdbConnectionFactoryImpl.connMgr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final Connection getConnection() throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConnection", (Object)this);
            Tr.debug((TraceComponent)tc, (String)("Using isolation level: " + AdapterUtil.getIsolationLevelString((int)this.defaultIsolationLevel)));
            Tr.debug((TraceComponent)tc, (String)("support IsolationLevel switching : " + this.supportIsolvlSwitching));
            Tr.debug((TraceComponent)tc, (String)"ShareWithCMPOnly flag is set to :", (Object)new Boolean(this.mcf.jmsOnePhaseOptimization));
        }
        ConnectionRequestInfo connectionRequestInfo = this.supportIsolvlSwitching ? (this.mcf.jmsOnePhaseOptimization ? defaultCRIsWithIW_CMPShare[this.defaultIsolationLevel] : defaultCRIsWithSwitch[this.defaultIsolationLevel]) : (this.mcf.jmsOnePhaseOptimization ? defaultCRIsWithCMPShare[this.defaultIsolationLevel] : defaultCRIs[this.defaultIsolationLevel]);
        return ((WSRdbConnectionImpl)this.connMgr.allocateConnection((ManagedConnectionFactory)this.mcf, connectionRequestInfo)).initialize(this.connMgr, null);
    }

    public final Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        int n;
        WSRdbConnectionSpecImpl wSRdbConnectionSpecImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{this, connectionSpec});
        }
        try {
            wSRdbConnectionSpecImpl = (WSRdbConnectionSpecImpl)connectionSpec;
        }
        catch (ClassCastException classCastException) {
            throw new ResourceException("Must pass in a WSRdbConnectionSpecImpl for the ConnectionSpec. You sent in " + connectionSpec);
        }
        AccessIntent accessIntent = wSRdbConnectionSpecImpl.ivAccessIntent;
        try {
            n = accessIntent == null || (n = this.helper.getIsolationLevel(accessIntent)) == 0 ? this.defaultIsolationLevel : n;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl.getConnection", (String)"223", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getConnection", (Object)"Exception");
            }
            throw resourceException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using isolation level: " + AdapterUtil.getIsolationLevelString((int)n)));
            Tr.debug((TraceComponent)tc, (String)("support isolation level switching: " + this.supportIsolvlSwitching));
        }
        ConnectionRequestInfo connectionRequestInfo = this.supportIsolvlSwitching ? (this.mcf.jmsOnePhaseOptimization ? defaultCRIsWithIW_CMPShare[n] : defaultCRIsWithSwitch[n]) : (this.mcf.jmsOnePhaseOptimization ? defaultCRIsWithCMPShare[n] : defaultCRIs[n]);
        return ((WSRdbConnectionImpl)this.connMgr.allocateConnection((ManagedConnectionFactory)this.mcf, connectionRequestInfo)).initialize(this.connMgr, accessIntent);
    }

    public final ResourceAdapterMetaData getMetaData() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData()");
        }
        if (this.ivResourceAdapterMetaData == null) {
            this.ivResourceAdapterMetaData = WSRdbResourceAdapterMetaDataImpl.createResourceAdapterMetaData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetaData()", (Object)this.ivResourceAdapterMetaData);
        }
        return this.ivResourceAdapterMetaData;
    }

    public final RecordFactory getRecordFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecordFactory()");
        }
        if (this.ivRecordFactory == null) {
            this.ivRecordFactory = WSRecordFactoryImpl.createRecordFactory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecordFactory()", (Object)this.ivRecordFactory);
        }
        return this.ivRecordFactory;
    }

    public final Reference getReference() throws NamingException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getReference()", (Object)this.ivReference);
        }
        return this.ivReference;
    }

    public final int hashCode() {
        return this.mcf.hashCode() + this.connMgr.hashCode();
    }

    public final void setReference(Reference reference) {
        this.ivReference = reference;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReference()", (Object)this.ivReference);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public int getDSHelperType() {
        return this.dsHelperType;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating default, reusable ConnectionRequestInfo instances.");
        }
        defaultCRIs = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIs[0] = new WSConnectionRequestInfoImpl(0, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[1] = new WSConnectionRequestInfoImpl(1, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[2] = new WSConnectionRequestInfoImpl(2, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[4] = new WSConnectionRequestInfoImpl(4, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[8] = new WSConnectionRequestInfoImpl(8, false);
        defaultCRIsWithSwitch = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[0] = new WSConnectionRequestInfoImpl(0, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[1] = new WSConnectionRequestInfoImpl(1, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[2] = new WSConnectionRequestInfoImpl(2, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[4] = new WSConnectionRequestInfoImpl(4, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[8] = new WSConnectionRequestInfoImpl(8, false, true, false);
        defaultCRIsWithIW_CMPShare = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[0] = new WSConnectionRequestInfoImpl(0, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[1] = new WSConnectionRequestInfoImpl(1, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[2] = new WSConnectionRequestInfoImpl(2, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[4] = new WSConnectionRequestInfoImpl(4, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[8] = new WSConnectionRequestInfoImpl(8, false, true, true);
        defaultCRIsWithCMPShare = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[0] = new WSConnectionRequestInfoImpl(0, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[1] = new WSConnectionRequestInfoImpl(1, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[2] = new WSConnectionRequestInfoImpl(2, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[4] = new WSConnectionRequestInfoImpl(4, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[8] = new WSConnectionRequestInfoImpl(8, false, false, true);
    }
}

