/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.resource;

import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.StatusMonitor;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceUtils;
import com.ibm.etools.webservice.context.ResourceContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileResourceOutputStream
extends OutputStream {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    IPath fFilePath;
    ResourceContext fResourceContext;
    ProgressMonitor fMonitor;
    StatusMonitor fStatusMonitor;
    ByteArrayOutputStream fByteArrayOutputStream;
    boolean fOpen;

    public FileResourceOutputStream(ResourceContext resourceContext, IPath filePath, ProgressMonitor monitor, StatusMonitor statusMonitor) {
        this.fFilePath = filePath;
        this.fResourceContext = resourceContext;
        this.fMonitor = monitor;
        this.fStatusMonitor = statusMonitor;
        this.fByteArrayOutputStream = new ByteArrayOutputStream();
        this.fOpen = true;
    }

    public void close() throws IOException {
        if (!this.fOpen) {
            return;
        }
        this.fOpen = false;
        this.fByteArrayOutputStream.close();
        byte[] buffer = this.fByteArrayOutputStream.toByteArray();
        ByteArrayInputStream tempInputStream = new ByteArrayInputStream(buffer);
        try {
            ResourceUtils.createFile(this.fResourceContext, this.fFilePath, tempInputStream, this.fMonitor, this.fStatusMonitor);
        }
        catch (ResourceException e) {
            throw new IOException(e.getMessage());
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void flush() throws IOException {
        this.fByteArrayOutputStream.flush();
    }

    public void write(byte[] b) throws IOException {
        this.fByteArrayOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fByteArrayOutputStream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.fByteArrayOutputStream.write(b);
    }
}

