/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.resource;

import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.NullEnvironment;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceManager;
import com.ibm.etools.environment.resource.URLFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;

public abstract class AbstractResourceManager
implements ResourceManager {
    protected URL url = null;
    private ResourceBundle resource = ResourceBundle.getBundle("com.ibm.etools.environment.environment");
    protected Environment environment = new NullEnvironment();

    public AbstractResourceManager() {
    }

    public AbstractResourceManager(Environment environment) {
        this.environment = environment;
    }

    public abstract void createFile(InputStream var1, URL var2) throws ResourceException;

    public abstract void createFolders(URL var1) throws ResourceException;

    public abstract void rename(URL var1, URL var2) throws ResourceException;

    public abstract void delete(URL var1) throws ResourceException;

    public abstract void touchFile(URL var1) throws ResourceException;

    public abstract void copy(URL var1, URL var2) throws ResourceException;

    public abstract boolean exists(URL var1) throws ResourceException;

    public abstract byte kind(URL var1) throws ResourceException;

    public abstract boolean isReadonly(URL var1) throws ResourceException;

    public abstract InputStream getInputStream(URL var1) throws ResourceException;

    public abstract OutputStream getOutputStream(URL var1) throws ResourceException;

    public abstract PrintWriter getPrintWriter(URL var1) throws ResourceException;

    public abstract char getSeparatorChar();

    public Environment getEnvironment() {
        return this.environment;
    }

    public URL appends(URL url, String appendString) throws ResourceException {
        try {
            URL newURL = url;
            if (url != null) {
                newURL = new URL(String.valueOf(url.toString()) + this.getSeparatorChar() + appendString);
            }
            return newURL;
        }
        catch (MalformedURLException e) {
            throw new ResourceException(new SimpleStatus("AbstractResourceManager", this.getMessage("MSG_ERROR_APPENDS_MALFORMEDURLEXCEPTION"), 4, e), url);
        }
    }

    public URL[] getChildren(URL url) throws ResourceException {
        return this.getChildren(url, null);
    }

    public abstract URL[] getChildren(URL var1, URLFilter var2) throws ResourceException;

    public Iterator getChildrenIterator(URL url) throws ResourceException {
        return this.getChildrenIterator(url, null);
    }

    public abstract Iterator getChildrenIterator(URL var1, URLFilter var2) throws ResourceException;

    private String getMessage(String messageId, String parm1) {
        String message = this.resource.getString(messageId);
        return MessageFormat.format(message, parm1);
    }

    public String getMessage(String key) {
        return this.resource.getString(key);
    }
}

