/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.terminal;

import com.ibm.ivj.eab.record.terminal.IDelimitedTerminalType;
import com.ibm.ivj.eab.record.terminal.IPaddedTerminalType;
import com.ibm.ivj.eab.record.terminal.ITerminalRecordType;
import com.ibm.ivj.eab.record.terminal.TerminalRecordConverterManager;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordFieldNameAlreadyExistsException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.TypeData;
import com.ibm.record.VariableLengthRecordType;
import java.io.Serializable;

public class VariableLengthTerminalRecordType
extends VariableLengthRecordType
implements ITerminalRecordType,
IDelimitedTerminalType,
IPaddedTerminalType,
Serializable {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -291041593610707058L;
    private int columns;
    private int paddingPolicy;
    private byte paddingByte;
    private byte delimiterByte;
    static /* synthetic */ Class class$0;

    public VariableLengthTerminalRecordType() {
        this(-1, 80);
    }

    public VariableLengthTerminalRecordType(int size, int columns) {
        this(size, columns, 1, 32, 44);
    }

    public VariableLengthTerminalRecordType(int size, int columns, int paddingPolicy, byte paddingByte, byte delimiterByte) {
        super(size);
        this.columns = columns;
        this.paddingPolicy = paddingPolicy;
        this.paddingByte = paddingByte;
        this.delimiterByte = delimiterByte;
    }

    public void addField(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException {
        IAnyType type = field.getType();
        if (!(type instanceof IDelimitedTerminalType) || type.getSize() >= 0) {
            throw new RecordFieldTypeNotValidException();
        }
        super.addField(field);
    }

    public void addFieldAfter(IAnyField field, String fieldName) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException, RecordFieldNameAlreadyExistsException {
        IAnyType type = field.getType();
        if (!(type instanceof IDelimitedTerminalType) || type.getSize() >= 0) {
            throw new RecordFieldTypeNotValidException();
        }
        super.addFieldAfter(field, fieldName);
    }

    public void addFieldAsFirst(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException {
        IAnyType type = field.getType();
        if (!(type instanceof IDelimitedTerminalType) || type.getSize() >= 0) {
            throw new RecordFieldTypeNotValidException();
        }
        super.addFieldAsFirst(field);
    }

    public Object clone() {
        VariableLengthTerminalRecordType newType = (VariableLengthTerminalRecordType)super.clone();
        return newType;
    }

    public int getColumns() {
        return this.columns;
    }

    public byte getDelimiterByte() {
        return this.delimiterByte;
    }

    public byte getPaddingByte() {
        return this.paddingByte;
    }

    public int getPaddingPolicy() {
        return this.paddingPolicy;
    }

    public Class getRecordAttributesClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.ivj.eab.record.terminal.TerminalRecordAttributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getRows() {
        return this.getSize() > 0 && this.getColumns() > 0 ? (this.getSize() + this.getColumns() - 1) / this.getColumns() : 1;
    }

    public byte[] packageBytes(IRecord record, byte[] byteArray) {
        byte[] result;
        if (this.hasFixedSize()) {
            result = new byte[this.getSize()];
            try {
                TerminalRecordConverterManager.injectByteArray(byteArray, result, 0, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte());
                result[byteArray.length - 1] = this.getPaddingByte();
            }
            catch (RecordConversionFailureException recordConversionFailureException) {
                System.arraycopy(byteArray, 0, result, 0, this.getSize());
            }
        } else {
            result = byteArray.length > 0 ? byteArray : new byte[1];
            result[result.length - 1] = this.getDelimiterByte();
        }
        return result;
    }

    public TypeData retrieveBytes(IRecord record, byte[] byteArray, int offset) {
        byte[] bytes;
        boolean isDelimited;
        if (this.hasFixedSize()) {
            isDelimited = false;
            try {
                bytes = TerminalRecordConverterManager.extractByteArray(byteArray, offset, this.getSize(), this.getPaddingPolicy(), this.getPaddingByte());
            }
            catch (RecordConversionFailureException recordConversionFailureException) {
                throw new InternalError();
            }
        } else {
            int delimiterOffset = offset;
            while (delimiterOffset < byteArray.length && byteArray[delimiterOffset] != this.getDelimiterByte()) {
                ++delimiterOffset;
            }
            isDelimited = delimiterOffset < byteArray.length;
            int length = delimiterOffset - offset;
            bytes = new byte[length];
            System.arraycopy(byteArray, offset, bytes, 0, length);
        }
        return new TypeData(bytes, isDelimited ? bytes.length + 1 : bytes.length);
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDelimiterByte(byte delimiterByte) {
        this.delimiterByte = delimiterByte;
    }

    public void setPaddingByte(byte paddingByte) {
        this.paddingByte = paddingByte;
    }

    public void setPaddingPolicy(int paddingPolicy) {
        this.paddingPolicy = paddingPolicy;
    }
}

