/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.cobol;

import com.ibm.ivj.eab.record.cobol.CobolInitialValueObject;
import com.ibm.ivj.eab.record.cobol.CobolRecordAttributes;
import com.ibm.ivj.eab.record.cobol.CobolRecordException;
import com.ibm.ivj.eab.record.cobol.CobolRecordResource;
import com.ibm.ivj.eab.record.cobol.TypeConversionException;
import com.ibm.record.AnyType;
import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class CobolType
extends FixedLengthType
implements Serializable {
    private static String copyrights = "Licensed Material - Property of IBM IBM(R) VisualAge(TM) for Java(TM) Version 3.0 (C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -1801369549487272413L;
    private transient Class preferredType = null;
    boolean inDBCS = false;
    private int cobolDataType = 10;
    private boolean sign = false;
    private boolean decimal = false;
    private boolean numeric = true;
    private int numberOfNines = 0;
    private int decimalPosition = 0;
    private int scale = 0;
    private String expandedPicField = new String();
    private int picFieldLength = 0;
    private boolean align = false;
    private boolean filler = false;
    protected String augIn = new String();
    protected String picIn = new String();
    private String level = new String();
    private boolean paddingRequired = false;
    private static final boolean DEBUG = false;
    private static final int MAX_STRING_LENGTH = 249;
    private static char[][] cobolPictureTable = new char[256][256];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        CobolType.cobolPictureTableInit();
    }

    public CobolType() {
    }

    public CobolType(String arg) throws RecordException {
        int index = arg.indexOf(58);
        if (index != 0) {
            this.setPic(arg.substring(0, index));
        }
        this.setAug(arg.substring(index + 1));
    }

    private final void aug(String token) throws RecordException {
        if (token.equals("DISPLAY")) {
            this.cobolDataType = this.numeric ? 8 : 9;
            return;
        }
        if (token.equals("COMP")) {
            if (!this.picIn.equals("") && !this.isPicNumeric(this.picIn)) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0245E"));
            }
            this.cobolDataType = 0;
            return;
        }
        if (token.equals("COMP1")) {
            if (!this.picIn.equals("")) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0246E"));
            }
            this.cobolDataType = 1;
            return;
        }
        if (token.equals("COMP2")) {
            if (!this.picIn.equals("")) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0246E"));
            }
            this.cobolDataType = 2;
            return;
        }
        if (token.equals("COMP3")) {
            if (!this.picIn.equals("") && !this.isPicNumeric(this.picIn)) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0245E"));
            }
            this.cobolDataType = 3;
            return;
        }
        if (!(!token.startsWith("SIGN") || this.picIn.equals("") || this.picIn.charAt(0) == 'S' && this.isPicNumeric(this.picIn))) {
            throw new RecordException(CobolRecordResource.instance().getString("IVJC0247E"));
        }
        if (token.equals("SIGN_LEADING")) {
            this.cobolDataType = 4;
            return;
        }
        if (token.equals("SIGN_TRAILING")) {
            this.cobolDataType = 5;
            return;
        }
        if (token.equals("SIGN_TRAILING_SEPARATE")) {
            this.cobolDataType = 7;
            return;
        }
        if (token.equals("SIGN_LEADING_SEPARATE")) {
            this.cobolDataType = 6;
            return;
        }
        if (token.equals("DISPLAY_NUMERIC")) {
            this.cobolDataType = 8;
            return;
        }
        if (token.equals("DISPLAY_NONNUMERIC")) {
            this.cobolDataType = 9;
            this.numeric = false;
            return;
        }
        if (token.equals("FILLER")) {
            this.filler = true;
            return;
        }
        if (token.equals("ALIGN")) {
            this.align = true;
            return;
        }
    }

    public final boolean canConvertFromBigDecimal() {
        return true;
    }

    public final boolean canConvertFromByte() {
        return true;
    }

    public final boolean canConvertFromChar() {
        return true;
    }

    public final boolean canConvertFromDouble() {
        return true;
    }

    public final boolean canConvertFromFloat() {
        return true;
    }

    public final boolean canConvertFromInt() {
        return true;
    }

    public final boolean canConvertFromLong() {
        return true;
    }

    public final boolean canConvertFromObject() {
        return true;
    }

    public final boolean canConvertFromShort() {
        return true;
    }

    public final boolean canConvertFromString() {
        return true;
    }

    public final boolean canConvertToBigDecimal() {
        return true;
    }

    public final boolean canConvertToByte() {
        return true;
    }

    public final boolean canConvertToChar() {
        return true;
    }

    public final boolean canConvertToDouble() {
        return true;
    }

    public final boolean canConvertToFloat() {
        return true;
    }

    public final boolean canConvertToInt() {
        return true;
    }

    public final boolean canConvertToLong() {
        return true;
    }

    public final boolean canConvertToObject() {
        return true;
    }

    public final boolean canConvertToShort() {
        return true;
    }

    public final boolean canConvertToString() {
        return true;
    }

    public final boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        boolean result = true;
        switch (this.getJavaEquivalentCobolType()) {
            case 3: {
                result = CobolType.testShortConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 4: {
                result = CobolType.testIntConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 5: {
                result = CobolType.testLongConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 6: {
                result = CobolType.testFloatConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 7: {
                result = CobolType.testDoubleConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 9: {
                result = CobolType.testBigDecimalConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 8: {
                result = CobolType.testStringConstantValue(record, fieldOffset, (String)constantValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
            }
        }
        return result;
    }

    public Object clone() {
        CobolType newType = (CobolType)super.clone();
        newType.preferredType = this.preferredType;
        newType.expandedPicField = new String(this.expandedPicField);
        newType.augIn = new String(this.augIn);
        newType.picIn = new String(this.picIn);
        return newType;
    }

    private static void cobolPictureTableInit() {
        CobolType.cobolPictureTable[66][66] = 17;
        CobolType.cobolPictureTable[66][44] = 17;
        CobolType.cobolPictureTable[66][48] = 17;
        CobolType.cobolPictureTable[66][47] = 17;
        CobolType.cobolPictureTable[66][46] = 17;
        CobolType.cobolPictureTable[66][67] = 17;
        CobolType.cobolPictureTable[66][68] = 17;
        CobolType.cobolPictureTable[66][69] = '\u0000';
        CobolType.cobolPictureTable[66][90] = 17;
        CobolType.cobolPictureTable[66][42] = 17;
        CobolType.cobolPictureTable[66][43] = 17;
        CobolType.cobolPictureTable[66][45] = 17;
        CobolType.cobolPictureTable[66][36] = 17;
        CobolType.cobolPictureTable[66][57] = 17;
        CobolType.cobolPictureTable[66][65] = 17;
        CobolType.cobolPictureTable[66][88] = 17;
        CobolType.cobolPictureTable[66][83] = '\u0000';
        CobolType.cobolPictureTable[66][86] = 17;
        CobolType.cobolPictureTable[66][80] = '\u0001';
        CobolType.cobolPictureTable[66][71] = 17;
        CobolType.cobolPictureTable[66][78] = '\u0000';
        CobolType.cobolPictureTable[67][66] = '\u0000';
        CobolType.cobolPictureTable[67][44] = '\u0000';
        CobolType.cobolPictureTable[67][48] = '\u0000';
        CobolType.cobolPictureTable[67][47] = '\u0000';
        CobolType.cobolPictureTable[67][46] = '\u0000';
        CobolType.cobolPictureTable[67][67] = '\u0000';
        CobolType.cobolPictureTable[67][68] = '\u0000';
        CobolType.cobolPictureTable[67][69] = '\u0000';
        CobolType.cobolPictureTable[67][90] = '\u0000';
        CobolType.cobolPictureTable[67][42] = '\u0000';
        CobolType.cobolPictureTable[67][43] = '\u0000';
        CobolType.cobolPictureTable[67][45] = '\u0000';
        CobolType.cobolPictureTable[67][36] = '\u0000';
        CobolType.cobolPictureTable[67][57] = '\u0000';
        CobolType.cobolPictureTable[67][65] = '\u0000';
        CobolType.cobolPictureTable[67][88] = '\u0000';
        CobolType.cobolPictureTable[67][83] = '\u0000';
        CobolType.cobolPictureTable[67][86] = '\u0000';
        CobolType.cobolPictureTable[67][80] = '\u0000';
        CobolType.cobolPictureTable[67][71] = '\u0000';
        CobolType.cobolPictureTable[67][78] = '\u0000';
        CobolType.cobolPictureTable[68][66] = '\u0000';
        CobolType.cobolPictureTable[68][44] = '\u0000';
        CobolType.cobolPictureTable[68][48] = '\u0000';
        CobolType.cobolPictureTable[68][47] = '\u0000';
        CobolType.cobolPictureTable[68][46] = '\u0000';
        CobolType.cobolPictureTable[68][67] = '\u0000';
        CobolType.cobolPictureTable[68][68] = '\u0000';
        CobolType.cobolPictureTable[68][69] = '\u0000';
        CobolType.cobolPictureTable[68][90] = '\u0000';
        CobolType.cobolPictureTable[68][42] = '\u0000';
        CobolType.cobolPictureTable[68][43] = '\u0000';
        CobolType.cobolPictureTable[68][45] = '\u0000';
        CobolType.cobolPictureTable[68][36] = '\u0000';
        CobolType.cobolPictureTable[68][57] = '\u0000';
        CobolType.cobolPictureTable[68][65] = '\u0000';
        CobolType.cobolPictureTable[68][88] = '\u0000';
        CobolType.cobolPictureTable[68][83] = '\u0000';
        CobolType.cobolPictureTable[68][86] = '\u0000';
        CobolType.cobolPictureTable[68][80] = '\u0000';
        CobolType.cobolPictureTable[68][71] = '\u0000';
        CobolType.cobolPictureTable[68][78] = '\u0000';
        CobolType.cobolPictureTable[48][66] = 17;
        CobolType.cobolPictureTable[48][44] = 17;
        CobolType.cobolPictureTable[48][48] = 17;
        CobolType.cobolPictureTable[48][47] = 17;
        CobolType.cobolPictureTable[48][46] = 17;
        CobolType.cobolPictureTable[48][67] = 17;
        CobolType.cobolPictureTable[48][68] = 17;
        CobolType.cobolPictureTable[48][69] = '\u0000';
        CobolType.cobolPictureTable[48][90] = 17;
        CobolType.cobolPictureTable[48][42] = 17;
        CobolType.cobolPictureTable[48][43] = 17;
        CobolType.cobolPictureTable[48][45] = 17;
        CobolType.cobolPictureTable[48][36] = 17;
        CobolType.cobolPictureTable[48][57] = 17;
        CobolType.cobolPictureTable[48][65] = 17;
        CobolType.cobolPictureTable[48][88] = 17;
        CobolType.cobolPictureTable[48][83] = '\u0000';
        CobolType.cobolPictureTable[48][86] = 17;
        CobolType.cobolPictureTable[48][80] = '\u0001';
        CobolType.cobolPictureTable[48][71] = '\u0000';
        CobolType.cobolPictureTable[48][78] = '\u0000';
        CobolType.cobolPictureTable[47][66] = 17;
        CobolType.cobolPictureTable[47][44] = 17;
        CobolType.cobolPictureTable[47][48] = 17;
        CobolType.cobolPictureTable[47][47] = 17;
        CobolType.cobolPictureTable[47][46] = 17;
        CobolType.cobolPictureTable[47][67] = 17;
        CobolType.cobolPictureTable[47][68] = 17;
        CobolType.cobolPictureTable[47][69] = '\u0000';
        CobolType.cobolPictureTable[47][90] = 17;
        CobolType.cobolPictureTable[47][42] = 17;
        CobolType.cobolPictureTable[47][43] = 17;
        CobolType.cobolPictureTable[47][45] = 17;
        CobolType.cobolPictureTable[47][36] = 17;
        CobolType.cobolPictureTable[47][57] = 17;
        CobolType.cobolPictureTable[47][65] = 17;
        CobolType.cobolPictureTable[47][88] = 17;
        CobolType.cobolPictureTable[47][83] = '\u0000';
        CobolType.cobolPictureTable[47][86] = 17;
        CobolType.cobolPictureTable[47][80] = '\u0001';
        CobolType.cobolPictureTable[47][71] = '\u0000';
        CobolType.cobolPictureTable[47][78] = '\u0000';
        CobolType.cobolPictureTable[44][66] = 17;
        CobolType.cobolPictureTable[44][44] = 17;
        CobolType.cobolPictureTable[44][48] = 17;
        CobolType.cobolPictureTable[44][47] = 17;
        CobolType.cobolPictureTable[44][46] = 17;
        CobolType.cobolPictureTable[44][67] = 17;
        CobolType.cobolPictureTable[44][68] = 17;
        CobolType.cobolPictureTable[44][69] = 17;
        CobolType.cobolPictureTable[44][90] = 17;
        CobolType.cobolPictureTable[44][42] = 17;
        CobolType.cobolPictureTable[44][43] = 17;
        CobolType.cobolPictureTable[44][45] = 17;
        CobolType.cobolPictureTable[44][36] = 17;
        CobolType.cobolPictureTable[44][57] = 17;
        CobolType.cobolPictureTable[44][65] = '\u0000';
        CobolType.cobolPictureTable[44][88] = '\u0000';
        CobolType.cobolPictureTable[44][83] = '\u0000';
        CobolType.cobolPictureTable[44][86] = 17;
        CobolType.cobolPictureTable[44][80] = '\u0001';
        CobolType.cobolPictureTable[44][71] = '\u0000';
        CobolType.cobolPictureTable[44][78] = '\u0000';
        CobolType.cobolPictureTable[46][66] = 17;
        CobolType.cobolPictureTable[46][44] = 17;
        CobolType.cobolPictureTable[46][48] = 17;
        CobolType.cobolPictureTable[46][47] = 17;
        CobolType.cobolPictureTable[46][46] = '\u0000';
        CobolType.cobolPictureTable[46][67] = 17;
        CobolType.cobolPictureTable[46][68] = 17;
        CobolType.cobolPictureTable[46][69] = 17;
        CobolType.cobolPictureTable[46][90] = 16;
        CobolType.cobolPictureTable[46][42] = 16;
        CobolType.cobolPictureTable[46][43] = 16;
        CobolType.cobolPictureTable[46][45] = 16;
        CobolType.cobolPictureTable[46][36] = 16;
        CobolType.cobolPictureTable[46][57] = 17;
        CobolType.cobolPictureTable[46][65] = '\u0000';
        CobolType.cobolPictureTable[46][88] = '\u0000';
        CobolType.cobolPictureTable[46][83] = '\u0000';
        CobolType.cobolPictureTable[46][86] = '\u0000';
        CobolType.cobolPictureTable[46][80] = '\u0000';
        CobolType.cobolPictureTable[46][71] = '\u0000';
        CobolType.cobolPictureTable[46][78] = '\u0000';
        CobolType.cobolPictureTable[43][66] = 17;
        CobolType.cobolPictureTable[43][44] = 17;
        CobolType.cobolPictureTable[43][48] = 17;
        CobolType.cobolPictureTable[43][47] = 17;
        CobolType.cobolPictureTable[43][46] = 17;
        CobolType.cobolPictureTable[43][67] = '\u0000';
        CobolType.cobolPictureTable[43][68] = '\u0000';
        CobolType.cobolPictureTable[43][69] = '\u0000';
        CobolType.cobolPictureTable[43][90] = 17;
        CobolType.cobolPictureTable[43][42] = 17;
        CobolType.cobolPictureTable[43][43] = 17;
        CobolType.cobolPictureTable[43][45] = '\u0000';
        CobolType.cobolPictureTable[43][36] = 17;
        CobolType.cobolPictureTable[43][57] = 17;
        CobolType.cobolPictureTable[43][65] = '\u0000';
        CobolType.cobolPictureTable[43][88] = '\u0000';
        CobolType.cobolPictureTable[43][83] = '\u0000';
        CobolType.cobolPictureTable[43][86] = 17;
        CobolType.cobolPictureTable[43][80] = 17;
        CobolType.cobolPictureTable[43][71] = '\u0000';
        CobolType.cobolPictureTable[43][78] = '\u0000';
        CobolType.cobolPictureTable[45][66] = 17;
        CobolType.cobolPictureTable[45][44] = 17;
        CobolType.cobolPictureTable[45][48] = 17;
        CobolType.cobolPictureTable[45][47] = 17;
        CobolType.cobolPictureTable[45][46] = 17;
        CobolType.cobolPictureTable[45][67] = '\u0000';
        CobolType.cobolPictureTable[45][68] = '\u0000';
        CobolType.cobolPictureTable[45][69] = '\u0000';
        CobolType.cobolPictureTable[45][90] = 17;
        CobolType.cobolPictureTable[45][42] = 17;
        CobolType.cobolPictureTable[45][43] = '\u0000';
        CobolType.cobolPictureTable[45][45] = 17;
        CobolType.cobolPictureTable[45][36] = 17;
        CobolType.cobolPictureTable[45][57] = 17;
        CobolType.cobolPictureTable[45][65] = '\u0000';
        CobolType.cobolPictureTable[45][88] = '\u0000';
        CobolType.cobolPictureTable[45][83] = '\u0000';
        CobolType.cobolPictureTable[45][86] = 17;
        CobolType.cobolPictureTable[45][80] = 17;
        CobolType.cobolPictureTable[45][71] = '\u0000';
        CobolType.cobolPictureTable[45][78] = '\u0000';
        CobolType.cobolPictureTable[69][66] = '\u0000';
        CobolType.cobolPictureTable[69][44] = '\u0000';
        CobolType.cobolPictureTable[69][48] = '\u0000';
        CobolType.cobolPictureTable[69][47] = '\u0000';
        CobolType.cobolPictureTable[69][46] = '\u0000';
        CobolType.cobolPictureTable[69][67] = '\u0000';
        CobolType.cobolPictureTable[69][68] = '\u0000';
        CobolType.cobolPictureTable[69][69] = '\u0000';
        CobolType.cobolPictureTable[69][90] = '\u0000';
        CobolType.cobolPictureTable[69][42] = '\u0000';
        CobolType.cobolPictureTable[69][43] = 16;
        CobolType.cobolPictureTable[69][45] = 16;
        CobolType.cobolPictureTable[69][36] = '\u0000';
        CobolType.cobolPictureTable[69][57] = '\u0000';
        CobolType.cobolPictureTable[69][65] = '\u0000';
        CobolType.cobolPictureTable[69][88] = '\u0000';
        CobolType.cobolPictureTable[69][83] = '\u0000';
        CobolType.cobolPictureTable[69][86] = '\u0000';
        CobolType.cobolPictureTable[69][80] = '\u0000';
        CobolType.cobolPictureTable[69][71] = '\u0000';
        CobolType.cobolPictureTable[69][78] = '\u0000';
        CobolType.cobolPictureTable[90][66] = 17;
        CobolType.cobolPictureTable[90][44] = 17;
        CobolType.cobolPictureTable[90][48] = 17;
        CobolType.cobolPictureTable[90][47] = 17;
        CobolType.cobolPictureTable[90][46] = 17;
        CobolType.cobolPictureTable[90][67] = 17;
        CobolType.cobolPictureTable[90][68] = 17;
        CobolType.cobolPictureTable[90][69] = '\u0000';
        CobolType.cobolPictureTable[90][90] = 17;
        CobolType.cobolPictureTable[90][42] = '\u0000';
        CobolType.cobolPictureTable[90][43] = 17;
        CobolType.cobolPictureTable[90][45] = 17;
        CobolType.cobolPictureTable[90][36] = '\u0000';
        CobolType.cobolPictureTable[90][57] = 17;
        CobolType.cobolPictureTable[90][65] = '\u0000';
        CobolType.cobolPictureTable[90][88] = '\u0000';
        CobolType.cobolPictureTable[90][83] = '\u0000';
        CobolType.cobolPictureTable[90][86] = 17;
        CobolType.cobolPictureTable[90][80] = '\u0001';
        CobolType.cobolPictureTable[90][71] = '\u0000';
        CobolType.cobolPictureTable[90][78] = '\u0000';
        CobolType.cobolPictureTable[42][66] = 17;
        CobolType.cobolPictureTable[42][44] = 17;
        CobolType.cobolPictureTable[42][48] = 17;
        CobolType.cobolPictureTable[42][47] = 17;
        CobolType.cobolPictureTable[42][46] = 17;
        CobolType.cobolPictureTable[42][67] = 17;
        CobolType.cobolPictureTable[42][68] = 17;
        CobolType.cobolPictureTable[42][69] = '\u0000';
        CobolType.cobolPictureTable[42][90] = '\u0000';
        CobolType.cobolPictureTable[42][42] = 17;
        CobolType.cobolPictureTable[42][43] = 17;
        CobolType.cobolPictureTable[42][45] = 17;
        CobolType.cobolPictureTable[42][36] = '\u0000';
        CobolType.cobolPictureTable[42][57] = 17;
        CobolType.cobolPictureTable[42][65] = '\u0000';
        CobolType.cobolPictureTable[42][88] = '\u0000';
        CobolType.cobolPictureTable[42][83] = '\u0000';
        CobolType.cobolPictureTable[42][86] = 17;
        CobolType.cobolPictureTable[42][80] = '\u0001';
        CobolType.cobolPictureTable[42][71] = '\u0000';
        CobolType.cobolPictureTable[42][78] = '\u0000';
        CobolType.cobolPictureTable[36][66] = 17;
        CobolType.cobolPictureTable[36][44] = 17;
        CobolType.cobolPictureTable[36][48] = 17;
        CobolType.cobolPictureTable[36][47] = 17;
        CobolType.cobolPictureTable[36][46] = 17;
        CobolType.cobolPictureTable[36][67] = 17;
        CobolType.cobolPictureTable[36][68] = 17;
        CobolType.cobolPictureTable[36][69] = '\u0000';
        CobolType.cobolPictureTable[36][90] = 17;
        CobolType.cobolPictureTable[36][42] = 17;
        CobolType.cobolPictureTable[36][43] = 17;
        CobolType.cobolPictureTable[36][45] = 17;
        CobolType.cobolPictureTable[36][36] = 17;
        CobolType.cobolPictureTable[36][57] = 17;
        CobolType.cobolPictureTable[36][65] = '\u0000';
        CobolType.cobolPictureTable[36][88] = '\u0000';
        CobolType.cobolPictureTable[36][83] = '\u0000';
        CobolType.cobolPictureTable[36][86] = 17;
        CobolType.cobolPictureTable[36][80] = 17;
        CobolType.cobolPictureTable[36][71] = '\u0000';
        CobolType.cobolPictureTable[36][78] = '\u0000';
        CobolType.cobolPictureTable[57][66] = 17;
        CobolType.cobolPictureTable[57][44] = 17;
        CobolType.cobolPictureTable[57][48] = 17;
        CobolType.cobolPictureTable[57][47] = 17;
        CobolType.cobolPictureTable[57][46] = 17;
        CobolType.cobolPictureTable[57][67] = 17;
        CobolType.cobolPictureTable[57][68] = 17;
        CobolType.cobolPictureTable[57][69] = 17;
        CobolType.cobolPictureTable[57][90] = '\u0000';
        CobolType.cobolPictureTable[57][42] = '\u0000';
        CobolType.cobolPictureTable[57][43] = 17;
        CobolType.cobolPictureTable[57][45] = 17;
        CobolType.cobolPictureTable[57][36] = '\u0000';
        CobolType.cobolPictureTable[57][57] = 17;
        CobolType.cobolPictureTable[57][65] = 17;
        CobolType.cobolPictureTable[57][88] = 17;
        CobolType.cobolPictureTable[57][83] = '\u0000';
        CobolType.cobolPictureTable[57][86] = 17;
        CobolType.cobolPictureTable[57][80] = '\u0001';
        CobolType.cobolPictureTable[57][71] = '\u0000';
        CobolType.cobolPictureTable[57][78] = '\u0000';
        CobolType.cobolPictureTable[65][66] = 17;
        CobolType.cobolPictureTable[65][44] = 17;
        CobolType.cobolPictureTable[65][48] = 17;
        CobolType.cobolPictureTable[65][47] = 17;
        CobolType.cobolPictureTable[65][46] = '\u0000';
        CobolType.cobolPictureTable[65][67] = '\u0000';
        CobolType.cobolPictureTable[65][68] = '\u0000';
        CobolType.cobolPictureTable[65][69] = '\u0000';
        CobolType.cobolPictureTable[65][90] = '\u0000';
        CobolType.cobolPictureTable[65][42] = '\u0000';
        CobolType.cobolPictureTable[65][43] = '\u0000';
        CobolType.cobolPictureTable[65][45] = '\u0000';
        CobolType.cobolPictureTable[65][36] = '\u0000';
        CobolType.cobolPictureTable[65][57] = 17;
        CobolType.cobolPictureTable[65][65] = 17;
        CobolType.cobolPictureTable[65][88] = 17;
        CobolType.cobolPictureTable[65][83] = '\u0000';
        CobolType.cobolPictureTable[65][86] = '\u0000';
        CobolType.cobolPictureTable[65][80] = '\u0000';
        CobolType.cobolPictureTable[65][71] = '\u0000';
        CobolType.cobolPictureTable[65][78] = '\u0000';
        CobolType.cobolPictureTable[88][66] = 17;
        CobolType.cobolPictureTable[88][44] = 17;
        CobolType.cobolPictureTable[88][48] = 17;
        CobolType.cobolPictureTable[88][47] = 17;
        CobolType.cobolPictureTable[88][46] = '\u0000';
        CobolType.cobolPictureTable[88][67] = '\u0000';
        CobolType.cobolPictureTable[88][68] = '\u0000';
        CobolType.cobolPictureTable[88][69] = '\u0000';
        CobolType.cobolPictureTable[88][90] = '\u0000';
        CobolType.cobolPictureTable[88][42] = '\u0000';
        CobolType.cobolPictureTable[88][43] = '\u0000';
        CobolType.cobolPictureTable[88][45] = '\u0000';
        CobolType.cobolPictureTable[88][36] = '\u0000';
        CobolType.cobolPictureTable[88][57] = 17;
        CobolType.cobolPictureTable[88][65] = 17;
        CobolType.cobolPictureTable[88][88] = 17;
        CobolType.cobolPictureTable[88][83] = '\u0000';
        CobolType.cobolPictureTable[88][86] = '\u0000';
        CobolType.cobolPictureTable[88][80] = '\u0000';
        CobolType.cobolPictureTable[88][71] = '\u0000';
        CobolType.cobolPictureTable[88][78] = '\u0000';
        CobolType.cobolPictureTable[83][66] = '\u0000';
        CobolType.cobolPictureTable[83][44] = '\u0000';
        CobolType.cobolPictureTable[83][48] = '\u0000';
        CobolType.cobolPictureTable[83][47] = '\u0000';
        CobolType.cobolPictureTable[83][46] = '\u0000';
        CobolType.cobolPictureTable[83][67] = '\u0000';
        CobolType.cobolPictureTable[83][68] = '\u0000';
        CobolType.cobolPictureTable[83][69] = '\u0000';
        CobolType.cobolPictureTable[83][90] = '\u0000';
        CobolType.cobolPictureTable[83][42] = '\u0000';
        CobolType.cobolPictureTable[83][43] = '\u0000';
        CobolType.cobolPictureTable[83][45] = '\u0000';
        CobolType.cobolPictureTable[83][36] = '\u0000';
        CobolType.cobolPictureTable[83][57] = 17;
        CobolType.cobolPictureTable[83][65] = '\u0000';
        CobolType.cobolPictureTable[83][88] = '\u0000';
        CobolType.cobolPictureTable[83][83] = '\u0000';
        CobolType.cobolPictureTable[83][86] = 17;
        CobolType.cobolPictureTable[83][80] = 17;
        CobolType.cobolPictureTable[83][71] = '\u0000';
        CobolType.cobolPictureTable[83][78] = '\u0000';
        CobolType.cobolPictureTable[86][66] = 17;
        CobolType.cobolPictureTable[86][44] = 17;
        CobolType.cobolPictureTable[86][48] = 17;
        CobolType.cobolPictureTable[86][47] = 17;
        CobolType.cobolPictureTable[86][46] = '\u0000';
        CobolType.cobolPictureTable[86][67] = 17;
        CobolType.cobolPictureTable[86][68] = 17;
        CobolType.cobolPictureTable[86][69] = 17;
        CobolType.cobolPictureTable[86][90] = 16;
        CobolType.cobolPictureTable[86][42] = 16;
        CobolType.cobolPictureTable[86][43] = 16;
        CobolType.cobolPictureTable[86][45] = 16;
        CobolType.cobolPictureTable[86][36] = 16;
        CobolType.cobolPictureTable[86][57] = 17;
        CobolType.cobolPictureTable[86][65] = '\u0000';
        CobolType.cobolPictureTable[86][88] = '\u0000';
        CobolType.cobolPictureTable[86][83] = '\u0000';
        CobolType.cobolPictureTable[86][86] = '\u0000';
        CobolType.cobolPictureTable[86][80] = 16;
        CobolType.cobolPictureTable[86][71] = '\u0000';
        CobolType.cobolPictureTable[86][78] = '\u0000';
        CobolType.cobolPictureTable[80][66] = 17;
        CobolType.cobolPictureTable[80][44] = 17;
        CobolType.cobolPictureTable[80][48] = 17;
        CobolType.cobolPictureTable[80][47] = 17;
        CobolType.cobolPictureTable[80][46] = '\u0000';
        CobolType.cobolPictureTable[80][67] = 17;
        CobolType.cobolPictureTable[80][68] = 17;
        CobolType.cobolPictureTable[80][69] = '\u0000';
        CobolType.cobolPictureTable[80][90] = 16;
        CobolType.cobolPictureTable[80][42] = 16;
        CobolType.cobolPictureTable[80][43] = 16;
        CobolType.cobolPictureTable[80][45] = 16;
        CobolType.cobolPictureTable[80][36] = 16;
        CobolType.cobolPictureTable[80][57] = 16;
        CobolType.cobolPictureTable[80][65] = '\u0000';
        CobolType.cobolPictureTable[80][88] = '\u0000';
        CobolType.cobolPictureTable[80][83] = '\u0000';
        CobolType.cobolPictureTable[80][86] = 17;
        CobolType.cobolPictureTable[80][80] = 17;
        CobolType.cobolPictureTable[80][71] = '\u0000';
        CobolType.cobolPictureTable[80][78] = '\u0000';
        CobolType.cobolPictureTable[71][66] = 17;
        CobolType.cobolPictureTable[71][44] = '\u0000';
        CobolType.cobolPictureTable[71][48] = '\u0000';
        CobolType.cobolPictureTable[71][47] = '\u0000';
        CobolType.cobolPictureTable[71][46] = '\u0000';
        CobolType.cobolPictureTable[71][67] = '\u0000';
        CobolType.cobolPictureTable[71][68] = '\u0000';
        CobolType.cobolPictureTable[71][69] = '\u0000';
        CobolType.cobolPictureTable[71][90] = '\u0000';
        CobolType.cobolPictureTable[71][42] = '\u0000';
        CobolType.cobolPictureTable[71][43] = '\u0000';
        CobolType.cobolPictureTable[71][45] = '\u0000';
        CobolType.cobolPictureTable[71][36] = '\u0000';
        CobolType.cobolPictureTable[71][57] = '\u0000';
        CobolType.cobolPictureTable[71][65] = '\u0000';
        CobolType.cobolPictureTable[71][88] = '\u0000';
        CobolType.cobolPictureTable[71][83] = '\u0000';
        CobolType.cobolPictureTable[71][86] = '\u0000';
        CobolType.cobolPictureTable[71][80] = '\u0000';
        CobolType.cobolPictureTable[71][71] = 17;
        CobolType.cobolPictureTable[71][78] = '\u0000';
        CobolType.cobolPictureTable[78][66] = '\u0000';
        CobolType.cobolPictureTable[78][44] = '\u0000';
        CobolType.cobolPictureTable[78][48] = '\u0000';
        CobolType.cobolPictureTable[78][47] = '\u0000';
        CobolType.cobolPictureTable[78][46] = '\u0000';
        CobolType.cobolPictureTable[78][67] = '\u0000';
        CobolType.cobolPictureTable[78][68] = '\u0000';
        CobolType.cobolPictureTable[78][69] = '\u0000';
        CobolType.cobolPictureTable[78][90] = '\u0000';
        CobolType.cobolPictureTable[78][42] = '\u0000';
        CobolType.cobolPictureTable[78][43] = '\u0000';
        CobolType.cobolPictureTable[78][45] = '\u0000';
        CobolType.cobolPictureTable[78][36] = '\u0000';
        CobolType.cobolPictureTable[78][57] = '\u0000';
        CobolType.cobolPictureTable[78][65] = '\u0000';
        CobolType.cobolPictureTable[78][88] = '\u0000';
        CobolType.cobolPictureTable[78][83] = '\u0000';
        CobolType.cobolPictureTable[78][86] = '\u0000';
        CobolType.cobolPictureTable[78][80] = '\u0000';
        CobolType.cobolPictureTable[78][71] = '\u0000';
        CobolType.cobolPictureTable[78][78] = 17;
    }

    protected final boolean convertCodePage() {
        return this.cobolDataType == 9;
    }

    protected final boolean convertCompiler() {
        return this.cobolDataType == 0;
    }

    protected final boolean convertEndian() {
        return this.cobolDataType == 0 || this.cobolDataType == 1 || this.cobolDataType == 2;
    }

    protected final boolean convertFloatingPoint() {
        switch (this.cobolDataType) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected final boolean convertIntEndian() {
        return this.cobolDataType == 0 && this.numberOfNines < 10;
    }

    protected final boolean convertMachine() {
        switch (this.cobolDataType) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CobolType)) {
            return false;
        }
        if (!this.augIn.equals(((CobolType)obj).augIn)) {
            return false;
        }
        if (!this.picIn.equals(((CobolType)obj).picIn)) {
            return false;
        }
        return this.preferredType == null || ((CobolType)obj).preferredType == null || this.preferredType.equals(((CobolType)obj).preferredType);
    }

    public static void fromBigDecimal(IRecord record, int fieldOffset, BigDecimal value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        try {
            byte[] buf = dd.convertToCobol(value);
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromBigDecimalInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        BigDecimal bd = null;
        if (figValue == null && (initValue == "" || initValue == null)) {
            throw new RecordConversionUnsupportedException();
        }
        try {
            if (figValue != null) {
                bd = new BigDecimal(figValue);
            } else {
                int expfieldOffset;
                if (initValue.charAt(0) == '+') {
                    initValue = initValue.substring(1);
                }
                if ((expfieldOffset = (initValue = initValue.toUpperCase()).indexOf(69)) != -1) {
                    BigInteger bi = null;
                    bd = new BigDecimal(initValue.substring(0, expfieldOffset));
                    bi = initValue.charAt(expfieldOffset + 1) == '+' ? new BigInteger(initValue.substring(expfieldOffset + 2, initValue.length())) : new BigInteger(initValue.substring(expfieldOffset + 1, initValue.length()));
                    bd = bd.movePointRight(bi.intValue());
                } else {
                    bd = new BigDecimal(initValue);
                }
            }
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromBigDecimal(record, fieldOffset, bd, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromByte(IRecord record, int fieldOffset, byte value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 6: {
                    buf = dd.convertToByte(new Byte(value).floatValue());
                    break;
                }
                case 7: {
                    buf = dd.convertToByte(new Byte(value).doubleValue());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] tb = CobolRecordAttributes.convertToByte(new Byte(value).shortValue());
                    buf = dd.convertJavaToCobol(3, tb, value);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(Byte.toString(value));
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Byte.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromByteInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        byte aByte = 0;
        try {
            aByte = figValue != null ? new Byte(figValue).byteValue() : new Byte(initValue).byteValue();
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromByte(record, fieldOffset, aByte, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromChar(IRecord record, int fieldOffset, char value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 6: {
                    float f = new Float(new Character(value).toString()).floatValue();
                    buf = dd.convertToByte(f);
                    break;
                }
                case 7: {
                    double d = new Double(new Character(value).toString());
                    buf = dd.convertToByte(d);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    long l = new Long(new Character(value).toString());
                    byte[] tb = CobolRecordAttributes.convertToByte(l);
                    buf = dd.convertJavaToCobol(5, tb, value);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(new Character(value).toString());
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = new Character(value).toString();
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromCharInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        char aChar = 'a';
        try {
            aChar = figValue != null ? (char)figValue.charAt(0) : (char)initValue.charAt(0);
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromChar(record, fieldOffset, aChar, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromDouble(IRecord record, int fieldOffset, double value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 7: {
                    buf = dd.convertToByte(value);
                    break;
                }
                case 6: {
                    buf = dd.convertToByte((float)value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    long l = new Double(value).longValue();
                    byte[] tb = CobolRecordAttributes.convertToByte(l);
                    buf = dd.convertJavaToCobol(5, tb, l);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(value);
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Double.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromDoubleInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double aDouble;
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        try {
            aDouble = figValue != null ? new Double(figValue).doubleValue() : new Double(initValue).doubleValue();
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromDouble(record, fieldOffset, aDouble, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromFloat(IRecord record, int fieldOffset, float value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 7: {
                    buf = dd.convertToByte(new Double(Float.toString(value)));
                    break;
                }
                case 6: {
                    buf = dd.convertToByte(value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    long l = new Double(Float.toString(value)).longValue();
                    byte[] tb = CobolRecordAttributes.convertToByte(l);
                    buf = dd.convertJavaToCobol(5, tb, l);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(new Double(Float.toString(value)));
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Float.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromFloatInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float aFloat;
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        try {
            aFloat = figValue != null ? new Float(figValue).floatValue() : new Float(initValue).floatValue();
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromFloat(record, fieldOffset, aFloat, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromInt(IRecord record, int fieldOffset, int value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 6: {
                    buf = dd.convertToByte(value);
                    break;
                }
                case 7: {
                    buf = dd.convertToByte((double)value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] tb = CobolRecordAttributes.convertToByte(value);
                    buf = dd.convertJavaToCobol(4, tb, value);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(Integer.toString(value));
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Integer.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromIntInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int aInt;
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        try {
            if (figValue != null) {
                aInt = new BigInteger(figValue).intValue();
            } else {
                if (initValue.charAt(0) == '+') {
                    initValue = initValue.substring(1);
                }
                aInt = new BigInteger(initValue).intValue();
            }
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromInt(record, fieldOffset, aInt, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromLong(IRecord record, int fieldOffset, long value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 7: {
                    buf = dd.convertToByte((double)value);
                    break;
                }
                case 6: {
                    buf = dd.convertToByte(value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] tb = CobolRecordAttributes.convertToByte(value);
                    buf = dd.convertJavaToCobol(5, tb, value);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(Long.toString(value));
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Long.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromLongInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long aLong;
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        try {
            if (figValue != null) {
                aLong = new BigInteger(figValue).longValue();
            } else {
                if (initValue.charAt(0) == '+') {
                    initValue = initValue.substring(1);
                }
                aLong = new BigInteger(initValue).longValue();
            }
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromLong(record, fieldOffset, aLong, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromObject(IRecord record, int fieldOffset, Object value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        if (value instanceof BigDecimal) {
            CobolType.fromBigDecimal(record, fieldOffset, (BigDecimal)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof String) {
            CobolType.fromString(record, fieldOffset, (String)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Double) {
            CobolType.fromDouble(record, fieldOffset, (Double)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Float) {
            CobolType.fromFloat(record, fieldOffset, ((Float)value).floatValue(), aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Long) {
            CobolType.fromLong(record, fieldOffset, (Long)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Integer) {
            CobolType.fromInt(record, fieldOffset, (Integer)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Short) {
            CobolType.fromShort(record, fieldOffset, (Short)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        } else if (value instanceof Byte) {
            CobolType.fromByte(record, fieldOffset, (Byte)value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        }
    }

    public static void fromObjectInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int type = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        if (type == -1) {
            throw new RecordConversionFailureException();
        }
        switch (type) {
            case 9: {
                CobolType.fromBigDecimalInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 8: {
                CobolType.fromStringInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 7: {
                CobolType.fromDoubleInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 6: {
                CobolType.fromFloatInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 5: {
                CobolType.fromLongInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 4: {
                CobolType.fromIntInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 3: {
                CobolType.fromShortInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            case 2: {
                CobolType.fromByteInitialValue(record, fieldOffset, value, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void fromShort(IRecord record, int fieldOffset, short value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 6: {
                    buf = dd.convertToByte(value);
                    break;
                }
                case 7: {
                    buf = dd.convertToByte((double)value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] tb = CobolRecordAttributes.convertToByte(value);
                    buf = dd.convertJavaToCobol(3, tb, value);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(Short.toString(value));
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    String str = Short.toString(value);
                    if (!aInDBCS && str.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && str.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(str);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromShortInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short aShort;
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        try {
            if (figValue != null) {
                aShort = (short)new BigInteger(figValue).intValue();
            } else {
                if (initValue.charAt(0) == '+') {
                    initValue = initValue.substring(1);
                }
                aShort = (short)new BigInteger(initValue).intValue();
            }
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        CobolType.fromShort(record, fieldOffset, aShort, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
    }

    public static void fromString(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
        dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
        int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        try {
            byte[] buf;
            switch (javaType) {
                case 7: {
                    double d = new Double(value);
                    buf = dd.convertToByte(d);
                    break;
                }
                case 6: {
                    float f = new Float(value).floatValue();
                    buf = dd.convertToByte(f);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    long l = new Long(value);
                    byte[] tb = CobolRecordAttributes.convertToByte(l);
                    buf = dd.convertJavaToCobol(5, tb, l);
                    break;
                }
                case 9: {
                    BigDecimal bd = new BigDecimal(value);
                    buf = dd.convertToCobol(bd);
                    break;
                }
                case 8: {
                    if (!aInDBCS && value.length() > dd.picFieldLength) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength)));
                    }
                    if (aInDBCS && value.length() > dd.picFieldLength / 2) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(dd.picFieldLength / 2)));
                    }
                    buf = dd.convertFromStringToByteArray(value);
                    break;
                }
                default: {
                    buf = new byte[1];
                }
            }
            System.arraycopy(buf, 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static void fromStringInitialValue(IRecord record, int fieldOffset, CobolInitialValueObject value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String initValue = value.initialValue_;
        String figValue = value.figurativeValue_;
        String aString = null;
        try {
            if (figValue != null) {
                char firstFigChar = figValue.charAt(0);
                if (figValue.length() == 1 && (firstFigChar == '0' || firstFigChar == '\"' || firstFigChar == '\'' || firstFigChar == ' ')) {
                    CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
                    dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
                    System.arraycopy(dd.fillBytes(figValue), 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
                } else {
                    StringBuffer strBuf = null;
                    strBuf = aInDBCS ? new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign) / 2) : new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
                    int figValueIndex = 0;
                    int figIndex = 0;
                    while (figIndex < strBuf.capacity()) {
                        strBuf.append(figValue.charAt(figValueIndex));
                        figValueIndex = figValueIndex < figValue.length() - 1 ? ++figValueIndex : 0;
                        ++figIndex;
                    }
                    aString = new String(strBuf);
                }
            } else {
                char firstInitChar = initValue.charAt(0);
                if (initValue.length() == 1 && firstInitChar == ' ') {
                    CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
                    dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
                    System.arraycopy(dd.fillBytes(" "), 0, record.getBytes(), fieldOffset, CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
                } else {
                    aString = initValue;
                }
            }
        }
        catch (Exception exception) {
            throw new RecordConversionUnsupportedException();
        }
        if (aString != null) {
            CobolType.fromString(record, fieldOffset, aString, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        }
    }

    public final int getAlignmentHint() {
        if (!this.align) {
            return 1;
        }
        switch (this.cobolDataType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 0: {
                if (this.numberOfNines >= 5) {
                    return 4;
                }
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
        }
        return -1;
    }

    public final String getAttributesString() {
        return new String(String.valueOf(this.cobolDataType) + "," + this.numberOfNines + "," + this.picFieldLength + "," + this.sign + "," + this.decimal + "," + this.numeric + "," + this.decimalPosition + "," + this.scale + ",\"" + this.expandedPicField + "\"," + this.inDBCS + "," + this.paddingRequired);
    }

    public final String getAug() {
        return this.augIn;
    }

    public final BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToBigDecimal()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0237E"));
        }
        return CobolType.toBigDecimal(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final byte getByte(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToByte()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0231E"));
        }
        return CobolType.toByte(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final char getChar(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToChar()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0233E"));
        }
        return CobolType.toChar(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToDouble()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0235E"));
        }
        return CobolType.toDouble(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToFloat()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0237E"));
        }
        return CobolType.toFloat(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToInt()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0239E"));
        }
        return CobolType.toInt(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public boolean getIsBidiTransformable() {
        switch (this.cobolDataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    protected final int getJavaEquivalentCobolType() {
        return CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal);
    }

    protected static int getJavaEquivalentCobolType(int cobolDataType, int numberOfNines, boolean decimal) {
        switch (cobolDataType) {
            case 9: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 1: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (decimal) {
                    return 9;
                }
                if (numberOfNines > 9) {
                    return 5;
                }
                if (numberOfNines > 4) {
                    return 4;
                }
                return 3;
            }
            case 0: {
                if (decimal) {
                    return 9;
                }
                if (numberOfNines > 9) {
                    return 5;
                }
                if (numberOfNines > 4) {
                    return 4;
                }
                return 3;
            }
        }
        return -1;
    }

    protected static int getJavaEquivalentCobolType(int cobolDataType, int numberOfNines, boolean decimal, boolean newVersion) {
        switch (cobolDataType) {
            case 9: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 1: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (decimal) {
                    if (newVersion) {
                        return 9;
                    }
                    return 7;
                }
                if (numberOfNines > 9) {
                    return 5;
                }
                if (numberOfNines > 4) {
                    return 4;
                }
                return 3;
            }
            case 0: {
                if (decimal) {
                    if (newVersion) {
                        return 9;
                    }
                    return 7;
                }
                if (numberOfNines > 9) {
                    return 5;
                }
                if (numberOfNines > 4) {
                    return 4;
                }
                return 3;
            }
        }
        return -1;
    }

    protected final int getJavaEquivalentCobolType(boolean newVersion) {
        return CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal, newVersion);
    }

    public String getLevel() {
        return this.level;
    }

    public final long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToLong()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0241E"));
        }
        return CobolType.toLong(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final int getNumberOfNines() {
        return this.numberOfNines;
    }

    private static int getNumberOfReps(String picString, int index) {
        int i = index;
        while (i < picString.length() && Character.isDigit(picString.charAt(i))) {
            ++i;
        }
        StringBuffer sb = new StringBuffer(i -= index);
        sb.append(picString.toCharArray(), index, i);
        return Integer.parseInt(sb.toString());
    }

    public final Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToObject()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0229E"));
        }
        int pType = 8;
        this.getPreferredType();
        if (this.preferredType == Character.TYPE) {
            pType = 0;
        } else if (this.preferredType == Byte.TYPE) {
            pType = 2;
        } else if (this.preferredType == Short.TYPE) {
            pType = 3;
        } else if (this.preferredType == Integer.TYPE) {
            pType = 4;
        } else if (this.preferredType == Long.TYPE) {
            pType = 5;
        } else if (this.preferredType == Float.TYPE) {
            pType = 6;
        } else if (this.preferredType == Double.TYPE) {
            pType = 7;
        } else {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.preferredType == clazz) {
                pType = 8;
            } else {
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.preferredType == clazz2) {
                    pType = 9;
                } else {
                    throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0229E"));
                }
            }
        }
        return CobolType.toObject(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired, pType);
    }

    public int getPaddingHint() {
        return this.getAlignmentHint();
    }

    public final String getPic() {
        return this.picIn;
    }

    public final Class getPreferredType() {
        block20: {
            if (this.preferredType != null) break block20;
            switch (CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal)) {
                case 0: {
                    this.preferredType = Character.TYPE;
                    break;
                }
                case 2: {
                    this.preferredType = Byte.TYPE;
                    break;
                }
                case 3: {
                    this.preferredType = Short.TYPE;
                    break;
                }
                case 4: {
                    this.preferredType = Integer.TYPE;
                    break;
                }
                case 5: {
                    this.preferredType = Long.TYPE;
                    break;
                }
                case 6: {
                    this.preferredType = Float.TYPE;
                    break;
                }
                case 7: {
                    this.preferredType = Double.TYPE;
                    break;
                }
                case 8: {
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                    break;
                }
                case 9: {
                    Class<?> clazz = class$8;
                    if (clazz == null) {
                        try {
                            clazz = class$8 = Class.forName("java.math.BigDecimal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                    break;
                }
                default: {
                    Class<?> clazz = class$9;
                    if (clazz == null) {
                        try {
                            clazz = class$9 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                }
            }
        }
        return this.preferredType;
    }

    public final Class getPreferredType(boolean newVersion) {
        block20: {
            if (this.preferredType != null) break block20;
            switch (CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal, newVersion)) {
                case 0: {
                    this.preferredType = Character.TYPE;
                    break;
                }
                case 2: {
                    this.preferredType = Byte.TYPE;
                    break;
                }
                case 3: {
                    this.preferredType = Short.TYPE;
                    break;
                }
                case 4: {
                    this.preferredType = Integer.TYPE;
                    break;
                }
                case 5: {
                    this.preferredType = Long.TYPE;
                    break;
                }
                case 6: {
                    this.preferredType = Float.TYPE;
                    break;
                }
                case 7: {
                    this.preferredType = Double.TYPE;
                    break;
                }
                case 8: {
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                    break;
                }
                case 9: {
                    Class<?> clazz = class$8;
                    if (clazz == null) {
                        try {
                            clazz = class$8 = Class.forName("java.math.BigDecimal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                    break;
                }
                default: {
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.preferredType = clazz;
                }
            }
        }
        return this.preferredType;
    }

    public final short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToShort()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0243E"));
        }
        return CobolType.toShort(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final int getSize() {
        return CobolType.getSize(this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign);
    }

    private static int getSize(int cobolDataType, int numberOfNines, int picFieldLength, boolean sign) {
        int length;
        switch (cobolDataType) {
            case 4: 
            case 5: 
            case 8: {
                length = numberOfNines;
                break;
            }
            case 6: 
            case 7: {
                if (sign) {
                    length = numberOfNines + 1;
                    break;
                }
                length = numberOfNines;
                break;
            }
            case 0: {
                if (numberOfNines > 9) {
                    length = 8;
                    break;
                }
                if (numberOfNines > 4) {
                    length = 4;
                    break;
                }
                length = 2;
                break;
            }
            case 1: {
                length = 4;
                break;
            }
            case 2: {
                length = 8;
                break;
            }
            case 3: {
                length = numberOfNines / 2 + 1;
                break;
            }
            case 9: {
                length = picFieldLength;
                break;
            }
            default: {
                length = -1;
            }
        }
        return length;
    }

    public Method getStaticConstantValueMethod() {
        String baseType = null;
        Class[] cl = new Class[14];
        try {
            switch (CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal)) {
                case 0: {
                    baseType = "char";
                    break;
                }
                case 1: {
                    baseType = "boolean";
                    break;
                }
                case 2: {
                    baseType = "byte";
                    break;
                }
                case 3: {
                    baseType = "short";
                    break;
                }
                case 4: {
                    baseType = "int";
                    break;
                }
                case 5: {
                    baseType = "long";
                    break;
                }
                case 6: {
                    baseType = "float";
                    break;
                }
                case 7: {
                    baseType = "double";
                    break;
                }
                case 8: {
                    baseType = "String";
                    break;
                }
                case 9: {
                    baseType = "BigDecimal";
                }
            }
            cl[0] = Class.forName("com.ibm.record.IRecord");
            cl[1] = Integer.TYPE;
            cl[2] = Class.forName("java.lang.String");
            cl[3] = Integer.TYPE;
            cl[4] = Integer.TYPE;
            cl[5] = Integer.TYPE;
            cl[6] = Boolean.TYPE;
            cl[7] = Boolean.TYPE;
            cl[8] = Boolean.TYPE;
            cl[9] = Integer.TYPE;
            cl[10] = Integer.TYPE;
            cl[11] = Class.forName("java.lang.String");
            cl[12] = Boolean.TYPE;
            cl[13] = Boolean.TYPE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found exception thrown");
        }
        String methName = "test" + Character.toUpperCase(baseType.charAt(0)) + baseType.substring(1) + "ConstantValue";
        try {
            return this.getClass().getMethod(methName, cl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("No such method exception thrown");
            return null;
        }
    }

    public Method getStaticGetterMethod() {
        String baseType = null;
        Class baseTypeClass = this.getPreferredType();
        if (baseTypeClass == Character.TYPE) {
            baseType = "char";
        } else if (baseTypeClass == Byte.TYPE) {
            baseType = "byte";
        } else if (baseTypeClass == Short.TYPE) {
            baseType = "short";
        } else if (baseTypeClass == Integer.TYPE) {
            baseType = "int";
        } else if (baseTypeClass == Long.TYPE) {
            baseType = "long";
        } else if (baseTypeClass == Float.TYPE) {
            baseType = "float";
        } else if (baseTypeClass == Double.TYPE) {
            baseType = "double";
        } else {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (baseTypeClass == clazz) {
                baseType = "String";
            } else {
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (baseTypeClass == clazz2) {
                    baseType = "BigDecimal";
                }
            }
        }
        Class[] cl = new Class[13];
        try {
            cl[0] = Class.forName("com.ibm.record.IRecord");
            cl[1] = Integer.TYPE;
            cl[2] = Integer.TYPE;
            cl[3] = Integer.TYPE;
            cl[4] = Integer.TYPE;
            cl[5] = Boolean.TYPE;
            cl[6] = Boolean.TYPE;
            cl[7] = Boolean.TYPE;
            cl[8] = Integer.TYPE;
            cl[9] = Integer.TYPE;
            cl[10] = Class.forName("java.lang.String");
            cl[11] = Boolean.TYPE;
            cl[12] = Boolean.TYPE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found exception thrown");
        }
        String methName = "to" + Character.toUpperCase(baseType.charAt(0)) + baseType.substring(1);
        try {
            return this.getClass().getMethod(methName, cl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("no such method exception thrown");
            return null;
        }
    }

    public Method getStaticInitialValueMethod() {
        String baseType = null;
        Class[] cl = new Class[14];
        try {
            switch (CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal)) {
                case 0: {
                    baseType = "char";
                    break;
                }
                case 1: {
                    baseType = "boolean";
                    break;
                }
                case 2: {
                    baseType = "byte";
                    break;
                }
                case 3: {
                    baseType = "short";
                    break;
                }
                case 4: {
                    baseType = "int";
                    break;
                }
                case 5: {
                    baseType = "long";
                    break;
                }
                case 6: {
                    baseType = "float";
                    break;
                }
                case 7: {
                    baseType = "double";
                    break;
                }
                case 8: {
                    baseType = "String";
                    break;
                }
                case 9: {
                    baseType = "BigDecimal";
                }
            }
            cl[0] = Class.forName("com.ibm.record.IRecord");
            cl[1] = Integer.TYPE;
            cl[2] = Class.forName("com.ibm.ivj.eab.record.cobol.CobolInitialValueObject");
            cl[3] = Integer.TYPE;
            cl[4] = Integer.TYPE;
            cl[5] = Integer.TYPE;
            cl[6] = Boolean.TYPE;
            cl[7] = Boolean.TYPE;
            cl[8] = Boolean.TYPE;
            cl[9] = Integer.TYPE;
            cl[10] = Integer.TYPE;
            cl[11] = Class.forName("java.lang.String");
            cl[12] = Boolean.TYPE;
            cl[13] = Boolean.TYPE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found exception thrown");
        }
        String methName = "from" + Character.toUpperCase(baseType.charAt(0)) + baseType.substring(1) + "InitialValue";
        try {
            return this.getClass().getMethod(methName, cl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("no such method exception thrown");
            return null;
        }
    }

    public Method getStaticSetterMethod() {
        String baseType = null;
        Class[] cl = new Class[14];
        try {
            Class baseTypeClass = this.getPreferredType();
            if (baseTypeClass == Character.TYPE) {
                baseType = "char";
                cl[2] = Character.TYPE;
            } else if (baseTypeClass == Byte.TYPE) {
                baseType = "byte";
                cl[2] = Byte.TYPE;
            } else if (baseTypeClass == Short.TYPE) {
                baseType = "short";
                cl[2] = Short.TYPE;
            } else if (baseTypeClass == Integer.TYPE) {
                baseType = "int";
                cl[2] = Integer.TYPE;
            } else if (baseTypeClass == Long.TYPE) {
                baseType = "long";
                cl[2] = Long.TYPE;
            } else if (baseTypeClass == Float.TYPE) {
                baseType = "float";
                cl[2] = Float.TYPE;
            } else if (baseTypeClass == Double.TYPE) {
                baseType = "double";
                cl[2] = Double.TYPE;
            } else {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (baseTypeClass == clazz) {
                    baseType = "String";
                    cl[2] = Class.forName("java.lang.String");
                } else {
                    Class<?> clazz2 = class$8;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$8 = Class.forName("java.math.BigDecimal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (baseTypeClass == clazz2) {
                        baseType = "BigDecimal";
                        cl[2] = Class.forName("java.math.BigDecimal");
                    }
                }
            }
            cl[0] = Class.forName("com.ibm.record.IRecord");
            cl[1] = Integer.TYPE;
            cl[3] = Integer.TYPE;
            cl[4] = Integer.TYPE;
            cl[5] = Integer.TYPE;
            cl[6] = Boolean.TYPE;
            cl[7] = Boolean.TYPE;
            cl[8] = Boolean.TYPE;
            cl[9] = Integer.TYPE;
            cl[10] = Integer.TYPE;
            cl[11] = Class.forName("java.lang.String");
            cl[12] = Boolean.TYPE;
            cl[13] = Boolean.TYPE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found exception thrown");
        }
        String methName = "from" + Character.toUpperCase(baseType.charAt(0)) + baseType.substring(1);
        try {
            return this.getClass().getMethod(methName, cl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("no such method exception thrown");
            return null;
        }
    }

    public final String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        if (!this.canConvertToString()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0229E"));
        }
        return CobolType.toString(record, fieldOffset, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final boolean isPicNumeric(String picString) {
        int i = 0;
        while (i < picString.length()) {
            char c = picString.charAt(i);
            if (c == '(') {
                ++i;
                while (i < picString.length()) {
                    c = picString.charAt(i);
                    if (c != ')') {
                        if (!Character.isDigit(c)) {
                            return false;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (c != 'S' && c != 'V' && c != '9' && c != 'P') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final boolean paddingRequired() {
        return this.paddingRequired;
    }

    private void pic(String inpicString) throws RecordException {
        String s;
        if (inpicString == null) {
            return;
        }
        this.inDBCS = false;
        this.sign = false;
        this.decimal = false;
        this.numeric = true;
        this.numberOfNines = 0;
        this.decimalPosition = 0;
        this.scale = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.paddingRequired = false;
        if (this.cobolDataType == 10 || this.cobolDataType == 9) {
            this.cobolDataType = 8;
        }
        if (inpicString.equals("")) {
            return;
        }
        if (!this.augIn.equals("")) {
            if (this.augIn.startsWith("COMP1") || this.augIn.startsWith("COMP2")) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0246E"));
            }
            if (this.augIn.startsWith("COMP") || this.augIn.startsWith("COMP3")) {
                if (!this.isPicNumeric(inpicString)) {
                    throw new RecordException(CobolRecordResource.instance().getString("IVJC0245E"));
                }
            } else if (this.augIn.startsWith("SIGN") && (inpicString.charAt(0) != 'S' || !this.isPicNumeric(inpicString))) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0247E"));
            }
        }
        if (inpicString.length() > 50) {
            throw new RecordException(CobolRecordResource.instance().getString("IVJC0201E"));
        }
        StringBuffer inpicStrBuf = new StringBuffer(inpicString.toUpperCase());
        String picString = inpicStrBuf.toString();
        StringBuffer expandedPicBuf = new StringBuffer(0);
        int[] occurrances = new int[256];
        int decimal_indicator = 1;
        int toIndex = 0;
        int fromIndex = 0;
        while (fromIndex < picString.length()) {
            int repetitions = 1;
            char c = picString.charAt(fromIndex);
            occurrances[c] = occurrances[c] + 1;
            toIndex = expandedPicBuf.length();
            if (toIndex > 1 && (expandedPicBuf.charAt(toIndex - 2) == 'C' && expandedPicBuf.charAt(toIndex - 1) == 'R' || expandedPicBuf.charAt(toIndex - 2) == 'D' && expandedPicBuf.charAt(toIndex - 1) == 'B') && (cobolPictureTable[expandedPicBuf.charAt(toIndex - 2)][picString.charAt(fromIndex)] & decimal_indicator) == 0) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0212E"));
            }
            if (toIndex > 0 && (cobolPictureTable[expandedPicBuf.charAt(toIndex - 1)][picString.charAt(fromIndex)] & decimal_indicator) == 0) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0212E"));
            }
            if (picString.charAt(fromIndex) != 'S' && picString.charAt(fromIndex) != 'V' && picString.charAt(fromIndex) != '9' && picString.charAt(fromIndex) != 'P') {
                this.numeric = false;
            }
            if (picString.charAt(fromIndex) == '.' || picString.charAt(fromIndex) == 'V') {
                this.decimal = true;
                this.decimalPosition = toIndex;
                decimal_indicator = 16;
            }
            switch (picString.charAt(fromIndex)) {
                case 'G': 
                case 'N': {
                    this.inDBCS = true;
                }
                case '$': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case '0': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'P': 
                case 'X': 
                case 'Z': {
                    if (picString.length() > fromIndex + 1 && picString.charAt(fromIndex + 1) == '(') {
                        repetitions = CobolType.getNumberOfReps(picString, fromIndex + 2);
                        int totalLength = expandedPicBuf.length() + repetitions;
                        if (totalLength > 249 && picString.charAt(fromIndex) != 'G' && picString.charAt(fromIndex) != 'N' && picString.charAt(fromIndex) != 'A' && picString.charAt(fromIndex) != 'X') {
                            throw new RecordException(CobolRecordResource.instance().getString("IVJC0202E", expandedPicBuf.toString()));
                        }
                        int r = 0;
                        while (r < repetitions) {
                            expandedPicBuf.append(picString.charAt(fromIndex));
                            ++r;
                        }
                        toIndex += repetitions;
                        occurrances[picString.charAt((int)fromIndex)] = occurrances[picString.charAt(fromIndex)] + (repetitions - 1);
                        if (picString.charAt(fromIndex) == 'P') {
                            this.decimal = true;
                            this.decimalPosition = expandedPicBuf.length() - 1;
                            decimal_indicator = 16;
                            this.scale += repetitions;
                        } else if (picString.charAt(fromIndex) == '9') {
                            this.numberOfNines += repetitions;
                        }
                        fromIndex += 2;
                        while (picString.charAt(fromIndex) != ')') {
                            if (!Character.isDigit(picString.charAt(fromIndex))) {
                                throw new RecordException(CobolRecordResource.instance().getString("IVJC0203E", expandedPicBuf.toString()));
                            }
                            ++fromIndex;
                        }
                        break;
                    }
                    expandedPicBuf.append(picString.charAt(fromIndex));
                    ++toIndex;
                    if (picString.charAt(fromIndex) == 'P') {
                        this.decimal = true;
                        this.decimalPosition = expandedPicBuf.length() - 1;
                        decimal_indicator = 16;
                        ++this.scale;
                        break;
                    }
                    if (picString.charAt(fromIndex) != '9') break;
                    ++this.numberOfNines;
                    break;
                }
                case '.': 
                case 'E': 
                case 'S': 
                case 'V': {
                    if (occurrances[picString.charAt(fromIndex)] > 1) {
                        throw new RecordException(CobolRecordResource.instance().getString("IVJC0204E", expandedPicBuf.toString()));
                    }
                    expandedPicBuf.append(picString.charAt(fromIndex));
                    ++toIndex;
                    break;
                }
                case 'C': {
                    if (occurrances[picString.charAt(fromIndex)] > 1) {
                        throw new RecordException(CobolRecordResource.instance().getString("IVJC0205E", expandedPicBuf.toString()));
                    }
                    if (picString.charAt(fromIndex + 1) != 'R') {
                        throw new RecordException(CobolRecordResource.instance().getString("IVJC0206E", expandedPicBuf.toString()));
                    }
                    expandedPicBuf.append('C');
                    expandedPicBuf.append('R');
                    ++fromIndex;
                    toIndex += 2;
                    break;
                }
                case 'D': {
                    if (occurrances[picString.charAt(fromIndex)] > 1) {
                        throw new RecordException(CobolRecordResource.instance().getString("IVJC0207E", expandedPicBuf.toString()));
                    }
                    if (picString.charAt(fromIndex + 1) != 'B') {
                        throw new RecordException(CobolRecordResource.instance().getString("IVJC0208E", expandedPicBuf.toString()));
                    }
                    expandedPicBuf.append('D');
                    expandedPicBuf.append('B');
                    ++fromIndex;
                    toIndex += 2;
                    break;
                }
                default: {
                    throw new RecordException(CobolRecordResource.instance().getString("IVJC0209E", expandedPicBuf.toString()));
                }
            }
            if (this.scale + this.numberOfNines > 31) {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0210E"));
            }
            if (toIndex > 249 && expandedPicBuf.charAt(toIndex - 1) != 'G' && expandedPicBuf.charAt(toIndex - 1) != 'N' && expandedPicBuf.charAt(toIndex - 1) != 'A' && expandedPicBuf.charAt(toIndex - 1) != 'X') {
                throw new RecordException(CobolRecordResource.instance().getString("IVJC0211E", Integer.toString(249)));
            }
            ++fromIndex;
        }
        if (occurrances[65] <= 0 && occurrances[88] <= 0 && occurrances[71] <= 0 && occurrances[78] <= 0 && occurrances[90] <= 0 && occurrances[57] <= 0 && occurrances[42] <= 0 && occurrances[45] <= 1 && occurrances[43] <= 1 && occurrances[36] <= 1) {
            throw new RecordException(CobolRecordResource.instance().getString("IVJC0212E"));
        }
        if (occurrances[80] > 0 && (occurrances[86] > 0 || occurrances[46] > 0) && (s = expandedPicBuf.toString()).indexOf("VP") == -1 && s.indexOf("PV") == -1) {
            throw new RecordException(CobolRecordResource.instance().getString("IVJC0212E"));
        }
        if (occurrances[86] > 0 && occurrances[46] > 0) {
            throw new RecordException(CobolRecordResource.instance().getString("IVJC0212E"));
        }
        if (expandedPicBuf.charAt(0) == 'S') {
            this.sign = true;
        }
        this.picFieldLength = occurrances[86] == 1 ? expandedPicBuf.length() - 1 : expandedPicBuf.length();
        if (this.inDBCS) {
            this.picFieldLength *= 2;
        }
        this.decimalPosition = this.decimalPosition - expandedPicBuf.length() + 1;
        this.expandedPicField = new String(picString);
        if (this.decimalPosition < 0) {
            this.scale *= -1;
        }
        if (occurrances[65] > 0 || occurrances[71] > 0 || occurrances[88] > 0 || occurrances[78] > 0) {
            this.paddingRequired = true;
        }
        if (this.numeric) {
            if (this.cobolDataType == 10 || this.cobolDataType == 9) {
                this.cobolDataType = 8;
            }
        } else if (this.cobolDataType == 10 || this.cobolDataType == 8) {
            this.cobolDataType = 9;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String prefType = (String)in.readObject();
        if (prefType == null) {
            this.preferredType = null;
        } else if (prefType.equals("char")) {
            this.preferredType = Character.TYPE;
        } else if (prefType.equals("byte")) {
            this.preferredType = Byte.TYPE;
        } else if (prefType.equals("short")) {
            this.preferredType = Short.TYPE;
        } else if (prefType.equals("int")) {
            this.preferredType = Integer.TYPE;
        } else if (prefType.equals("long")) {
            this.preferredType = Long.TYPE;
        } else if (prefType.equals("float")) {
            this.preferredType = Float.TYPE;
        } else if (prefType.equals("double")) {
            this.preferredType = Double.TYPE;
        } else if (prefType.indexOf("java.lang.String") != -1) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.preferredType = clazz;
        } else if (prefType.indexOf("java.math.BigDecimal") != -1) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.preferredType = clazz;
        } else {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.preferredType = clazz;
        }
    }

    public final void setAug(String arg) {
        StringTokenizer args = new StringTokenizer(arg, ":");
        String oldAug = new String(this.augIn);
        this.augIn = arg;
        while (args.hasMoreTokens()) {
            this.aug(args.nextToken());
        }
        if (this.cobolDataType == 10) {
            this.cobolDataType = this.numeric ? 8 : 9;
        }
        if (((AnyType)this).changes_ != null) {
            ((AnyType)this).changes_.firePropertyChange("aug", oldAug, this.augIn);
        }
    }

    public final void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromBigDecimal()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0236E"));
        }
        CobolType.fromBigDecimal(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromByte()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0230E"));
        }
        CobolType.fromByte(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromChar()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0232E"));
        }
        CobolType.fromChar(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setDouble(IRecord record, int fieldOffset, double value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromDouble()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0234E"));
        }
        CobolType.fromDouble(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromFloat()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0236E"));
        }
        CobolType.fromFloat(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        switch (this.getJavaEquivalentCobolType()) {
            case 3: {
                CobolType.fromShortInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 4: {
                CobolType.fromIntInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 5: {
                CobolType.fromLongInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 6: {
                CobolType.fromFloatInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 7: {
                CobolType.fromDoubleInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 9: {
                CobolType.fromBigDecimalInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
                break;
            }
            case 8: {
                CobolType.fromStringInitialValue(record, fieldOffset, (CobolInitialValueObject)initialValue, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired());
            }
        }
    }

    public final void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        CobolType.fromInt(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public void setLevel(int levelNumber) {
        this.level = new Integer(levelNumber).toString();
        if (this.level.length() == 1) {
            this.level = "0" + this.level;
        }
    }

    public final void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromLong()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0240E"));
        }
        CobolType.fromLong(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromObject()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0228E"));
        }
        CobolType.fromObject(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setPic(String aPic) throws RecordException {
        this.pic(aPic);
        String oldPic = new String(this.picIn);
        this.picIn = aPic;
        if (((AnyType)this).changes_ != null) {
            ((AnyType)this).changes_.firePropertyChange("pic", oldPic, this.picIn);
        }
    }

    public final void setPreferredType(Class preferredType) {
        if (preferredType != Character.TYPE && preferredType != Byte.TYPE && preferredType != Short.TYPE && preferredType != Integer.TYPE && preferredType != Long.TYPE && preferredType != Float.TYPE && preferredType != Double.TYPE) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (preferredType != clazz) {
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (preferredType != clazz2) {
                    throw new TypeConversionException();
                }
            }
        }
        Class oldValue = this.preferredType;
        this.preferredType = preferredType;
        if (((AnyType)this).changes_ != null) {
            ((AnyType)this).changes_.firePropertyChange("preferredType", oldValue, preferredType);
        }
    }

    public final void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromShort()) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0242E"));
        }
        CobolType.fromShort(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public final void setString(IRecord record, int fieldOffset, String value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (!this.canConvertFromObject()) {
            throw new RecordConversionFailureException(CobolRecordResource.instance().getString("IVJC0228E"));
        }
        CobolType.fromString(record, fieldOffset, value, this.cobolDataType, this.numberOfNines, this.picFieldLength, this.sign, this.decimal, this.numeric, this.decimalPosition, this.scale, this.expandedPicField, this.inDBCS, this.paddingRequired);
    }

    public static boolean testBigDecimalConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        BigDecimal bd = null;
        try {
            int expfieldOffset;
            if (value.charAt(0) == '+') {
                value = value.substring(1);
            }
            if ((expfieldOffset = (value = value.toUpperCase()).indexOf(69)) != -1) {
                BigInteger bi = null;
                bd = new BigDecimal(value.substring(0, expfieldOffset));
                bi = value.charAt(expfieldOffset + 1) == '+' ? new BigInteger(value.substring(expfieldOffset + 2, value.length())) : new BigInteger(value.substring(expfieldOffset + 1, value.length()));
                bd = bd.movePointRight(bi.intValue());
            } else {
                bd = new BigDecimal(value);
            }
        }
        catch (Exception exception) {
            return false;
        }
        BigDecimal typeValue = CobolType.toBigDecimal(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        boolean result = typeValue.equals(bd);
        return result;
    }

    public static boolean testByteConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        byte aByte = 0;
        try {
            aByte = new Byte(value);
        }
        catch (Exception exception) {
            return false;
        }
        byte typeValue = CobolType.toByte(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aByte;
    }

    public static boolean testCharConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        char aChar = 'a';
        try {
            aChar = value.charAt(0);
        }
        catch (Exception exception) {
            return false;
        }
        char typeValue = CobolType.toChar(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aChar;
    }

    public static boolean testDoubleConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        double aDouble;
        try {
            aDouble = new Double(value);
        }
        catch (Exception exception) {
            return false;
        }
        double typeValue = CobolType.toDouble(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aDouble;
    }

    public static boolean testFloatConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        float aFloat;
        try {
            aFloat = new Float(value).floatValue();
        }
        catch (Exception exception) {
            return false;
        }
        float typeValue = CobolType.toFloat(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aFloat;
    }

    public static boolean testIntConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        int aInt;
        try {
            if (value.charAt(0) == '+') {
                value = value.substring(1);
            }
            aInt = new BigInteger(value).intValue();
        }
        catch (Exception exception) {
            return false;
        }
        int typeValue = CobolType.toInt(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aInt;
    }

    public static boolean testLongConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        long aLong;
        try {
            if (value.charAt(0) == '+') {
                value = value.substring(1);
            }
            aLong = new BigInteger(value).longValue();
        }
        catch (Exception exception) {
            return false;
        }
        long typeValue = CobolType.toLong(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aLong;
    }

    public static boolean testShortConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        short aShort;
        try {
            if (value.charAt(0) == '+') {
                value = value.substring(1);
            }
            aShort = (short)new BigInteger(value).intValue();
        }
        catch (Exception exception) {
            return false;
        }
        short typeValue = CobolType.toShort(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue == aShort;
    }

    public static boolean testStringConstantValue(IRecord record, int fieldOffset, String value, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) {
        String aString;
        try {
            char firstInitChar = value.charAt(0);
            if (value.length() == 1 && firstInitChar == ' ') {
                StringBuffer strBuf = null;
                strBuf = aInDBCS ? new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign) / 2) : new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
                int initIndex = 0;
                while (initIndex < strBuf.capacity()) {
                    strBuf.append(firstInitChar);
                    ++initIndex;
                }
                aString = new String(strBuf);
            } else if (paddingRequired) {
                StringBuffer strBuf = null;
                strBuf = aInDBCS ? new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign) / 2) : new StringBuffer(CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign));
                strBuf.append(value);
                int initIndex = value.length();
                while (initIndex < strBuf.capacity()) {
                    strBuf.append(' ');
                    ++initIndex;
                }
                aString = new String(strBuf);
            } else {
                aString = value;
            }
        }
        catch (Exception exception) {
            return false;
        }
        String typeValue = CobolType.toString(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
        return typeValue.equals(aString);
    }

    public static BigDecimal toBigDecimal(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            return dd.convertFromCobol(sb);
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static byte toByte(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            long l;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    l = new Double(d).longValue();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    l = CobolRecordAttributes.convertFromByteToLong(buf);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    l = new Float(f).longValue();
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    l = bd.longValue();
                    break;
                }
                default: {
                    String s = dd.convertFromByteArrayToString(sb);
                    l = Long.parseLong(s.trim());
                }
            }
            return (byte)l;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static char toChar(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            String s;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    s = Double.toString(d);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    long l = CobolRecordAttributes.convertFromByteToLong(buf);
                    s = Long.toString(l);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    s = Float.toString(f);
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    s = bd.toString();
                    break;
                }
                default: {
                    s = dd.convertFromByteArrayToString(sb);
                }
            }
            return s.charAt(0);
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static double toDouble(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            double d;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    d = dd.convertFromByteToDouble(sb);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    long l = CobolRecordAttributes.convertFromByteToLong(buf);
                    d = new Long(l).doubleValue();
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    d = new Double(Float.toString(f));
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    d = bd.doubleValue();
                    break;
                }
                default: {
                    String s = dd.convertFromByteArrayToString(sb);
                    d = Double.valueOf(s);
                }
            }
            return d;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static float toFloat(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            float f;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    f = new Double(d).floatValue();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    long l = CobolRecordAttributes.convertFromByteToLong(buf);
                    f = new Long(l).floatValue();
                    break;
                }
                case 6: {
                    f = dd.convertFromByteToFloat(sb);
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    f = bd.floatValue();
                    break;
                }
                default: {
                    String s = dd.convertFromByteArrayToString(sb);
                    f = Float.valueOf(s).floatValue();
                }
            }
            return f;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static int toInt(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            int i;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    i = new Double(d).intValue();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    i = (int)CobolRecordAttributes.convertFromByteToLong(buf);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    i = new Float(f).intValue();
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    i = bd.intValue();
                    break;
                }
                default: {
                    String s = dd.convertFromByteArrayToString(sb);
                    i = Integer.parseInt(s.trim());
                }
            }
            return i;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static long toLong(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            long l;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    l = new Double(d).longValue();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    l = CobolRecordAttributes.convertFromByteToLong(buf);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    l = new Float(f).longValue();
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    l = bd.longValue();
                    break;
                }
                default: {
                    String s = dd.convertFromByteArrayToString(sb);
                    l = Long.parseLong(s.trim());
                }
            }
            return l;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static Object toObject(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int type = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
        if (type == -1) {
            throw new RecordConversionFailureException();
        }
        switch (type) {
            case 9: {
                return CobolType.toBigDecimal(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
            }
            case 8: {
                return CobolType.toString(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
            }
            case 7: {
                return new Double(CobolType.toDouble(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 6: {
                return new Float(CobolType.toFloat(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 5: {
                return new Long(CobolType.toLong(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 4: {
                return new Integer(CobolType.toInt(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 3: {
                return new Short(CobolType.toShort(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 2: {
                return new Byte(CobolType.toByte(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
        }
        return null;
    }

    public static Object toObject(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired, int preferredType) throws RecordConversionFailureException {
        switch (preferredType) {
            case 9: {
                return CobolType.toBigDecimal(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
            }
            case 8: {
                return CobolType.toString(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired);
            }
            case 7: {
                return new Double(CobolType.toDouble(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 6: {
                return new Float(CobolType.toFloat(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 5: {
                return new Long(CobolType.toLong(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 4: {
                return new Integer(CobolType.toInt(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 3: {
                return new Short(CobolType.toShort(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
            case 2: {
                return new Byte(CobolType.toByte(record, fieldOffset, aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS, paddingRequired));
            }
        }
        return null;
    }

    public static short toShort(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            short s;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    s = new Double(d).shortValue();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    s = (short)CobolRecordAttributes.convertFromByteToLong(buf);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    s = new Float(f).shortValue();
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    s = bd.shortValue();
                    break;
                }
                default: {
                    String str = dd.convertFromByteArrayToString(sb);
                    s = Short.parseShort(str.trim());
                }
            }
            return s;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    public static String toString(IRecord record, int fieldOffset, int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInDBCS, boolean paddingRequired) throws RecordConversionFailureException {
        int size = CobolType.getSize(aCobolDataType, aNumberNines, aPicFieldLength, aSign);
        try {
            String s;
            byte[] sb = new byte[size];
            System.arraycopy(record.getBytes(), fieldOffset, sb, 0, size);
            CobolRecordAttributes dd = (CobolRecordAttributes)record.getRecordAttributes();
            dd.updateCicsDataDescriptor(aCobolDataType, aNumberNines, aPicFieldLength, aSign, aDecimal, aNumeric, aDecPos, aScale, aExpandedPicField, aInDBCS);
            int javaType = CobolType.getJavaEquivalentCobolType(aCobolDataType, aNumberNines, aDecimal);
            switch (javaType) {
                case 7: {
                    double d = dd.convertFromByteToDouble(sb);
                    s = Double.toString(d);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    byte[] buf = dd.convertCobolToJava(5, sb);
                    long l = CobolRecordAttributes.convertFromByteToLong(buf);
                    s = Long.toString(l);
                    break;
                }
                case 6: {
                    float f = dd.convertFromByteToFloat(sb);
                    s = Float.toString(f);
                    break;
                }
                case 9: {
                    BigDecimal bd = dd.convertFromCobol(sb);
                    s = bd.toString();
                    break;
                }
                default: {
                    s = dd.convertFromByteArrayToString(sb);
                }
            }
            return s;
        }
        catch (Exception e) {
            throw new RecordConversionFailureException(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.preferredType == null) {
            out.writeObject(null);
        } else {
            out.writeObject(this.preferredType.toString());
        }
    }
}

