/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.Command;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.ICommandPrimitive;
import com.ibm.ivj.eab.command.InvalidTriggerStateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class CommandObjectTransferPrimitive
implements ICommandPrimitive,
Serializable {
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000.";
    static final long serialVersionUID = 4284179536953833235L;
    private Object fieldInput = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private Object fieldOutput = null;
    private boolean fieldInternalBeforeAfter = false;
    private Command fieldParentCommand = null;
    private PrintWriter logWriter;

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public void afterExecute(CommandEvent commandEvent) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [" + this.toString() + ".afterExecute(CommandEvent)]");
        }
        Object obj = null;
        obj = this.getInternalBeforeAfter() ? this.getInput() : this.getOutput();
        if (obj != null) {
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Object", obj);
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [" + this.toString() + ".afterExecute(CommandEvent)]");
        }
    }

    public void beforeExecute(CommandEvent commandEvent) {
        Object obj;
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [" + this.toString() + ".beforeExecute(CommandEvent)]");
        }
        if ((obj = commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Object")) != null) {
            if (!this.getInternalBeforeAfter()) {
                try {
                    this.getParentCommand().checkTriggerState(obj);
                    if (this.getInput() == null) {
                        this.setInput(obj);
                    }
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                Object currentOutput = this.getOutput();
                if (currentOutput == null) {
                    try {
                        this.setOutput(obj);
                    }
                    catch (ClassCastException classCastException) {
                        throw new InvalidTriggerStateException();
                    }
                }
            }
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [" + this.toString() + ".beforeExecute(CommandEvent)]");
        }
    }

    public void execute() {
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public int getCurrentTraceLevel() {
        if (this.fieldParentCommand.isCcf2Command()) {
            return this.fieldParentCommand.getCurrentTraceLevel();
        }
        return RuntimeContext.getCurrent().getRASService().getTraceLevel();
    }

    public Object getInput() {
        return this.fieldInput;
    }

    public boolean getInternalBeforeAfter() {
        return this.fieldInternalBeforeAfter;
    }

    protected PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public Object getOutput() {
        return this.fieldOutput;
    }

    public Command getParentCommand() {
        return this.fieldParentCommand;
    }

    private void logError(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logError(msg);
        }
    }

    private void logTraceInfo(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setInput(Object input) {
        if (input != null && this.fieldInput != null) {
            if (input.getClass() == this.fieldInput.getClass()) {
                Object oldValue = this.fieldInput;
                this.fieldInput = input;
                this.firePropertyChange("input", oldValue, input);
            }
        } else {
            Object oldValue = this.fieldInput;
            this.fieldInput = input;
            this.firePropertyChange("input", oldValue, input);
        }
    }

    public void setInternalBeforeAfter(boolean internalBeforeAfter) {
        boolean oldValue = this.fieldInternalBeforeAfter;
        this.fieldInternalBeforeAfter = internalBeforeAfter;
        this.firePropertyChange("firstLevel", new Boolean(oldValue), new Boolean(this.fieldInternalBeforeAfter));
    }

    protected void setLogWriter(PrintWriter newLogWriter) {
        this.logWriter = newLogWriter;
    }

    public void setOutput(Object output) {
        Object oldValue = this.fieldOutput;
        this.fieldOutput = output;
        this.firePropertyChange("output", oldValue, output);
    }

    public void setParentCommand(Command parentCommand) {
        Command oldValue = this.fieldParentCommand;
        this.fieldParentCommand = parentCommand;
        this.firePropertyChange("parentCommand", oldValue, parentCommand);
    }
}

