/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.AfterInternalExecutionListener;
import com.ibm.ivj.eab.command.BeforeInternalExecutionListener;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.CommandException;
import com.ibm.ivj.eab.command.ExecutionException;
import com.ibm.ivj.eab.command.ExecutionSuccessfulListener;
import com.ibm.ivj.eab.command.ExecutionUnsuccessfulListener;
import com.ibm.ivj.eab.command.ICommand;
import com.ibm.ivj.eab.command.InternalExecutionStartingListener;
import com.ibm.ivj.eab.command.InvalidInputStateException;
import com.ibm.ivj.eab.command.InvalidOutputStateException;
import com.ibm.ivj.eab.command.InvalidTriggerStateException;
import com.ibm.ivj.eab.command.SelectorRecord;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Command
implements ICommand,
Serializable {
    private static ResourceBundle resCommandResourceBundle = ResourceBundle.getBundle("com.ibm.ivj.eab.command.CommandResourceBundle");
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000";
    static final long serialVersionUID = -3210982693516570991L;
    protected transient Vector aBeforeInternalExecutionListener = null;
    protected transient Vector aAfterInternalExecutionListener = null;
    protected transient Vector aExecutionSuccessfulListener = null;
    protected transient Vector aExecutionUnsuccessfulListener = null;
    protected transient Vector aInternalExecutionStartingListener = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private Object fieldInput = null;
    private Object fieldOutput = null;
    private Class fieldExpectedTriggerClass = null;
    public static final String aInput = "input";
    public static final String aOutput = "output";
    public static final String aMappedObjects = "mappedObjects";
    public static final String aConnectionSpec = "connectionSpec";
    public static final String aCommunication = "communication";
    public static final String aInteractionSpec = "interactionSpec";
    public static final String aDisconnectCommunication = "disconnectCommunication";
    public static final String aInteraction = "interaction";
    public static final String aManagedConnectionFactory = "managedConnectionFactory";
    public static final String emptyString = "";
    protected boolean ccf2Command = false;
    private PrintWriter logWriter = null;
    public static int CCF2TRACELEVEL = 0;

    public void addAfterInternalExecutionListener(AfterInternalExecutionListener newListener) {
        if (this.aAfterInternalExecutionListener == null) {
            this.aAfterInternalExecutionListener = new Vector();
        }
        this.aAfterInternalExecutionListener.addElement(newListener);
    }

    public void addBeforeInternalExecutionListener(BeforeInternalExecutionListener newListener) {
        if (this.aBeforeInternalExecutionListener == null) {
            this.aBeforeInternalExecutionListener = new Vector();
        }
        this.aBeforeInternalExecutionListener.addElement(newListener);
    }

    public void addExecutionSuccessfulListener(ExecutionSuccessfulListener newListener) {
        if (this.aExecutionSuccessfulListener == null) {
            this.aExecutionSuccessfulListener = new Vector();
        }
        this.aExecutionSuccessfulListener.addElement(newListener);
    }

    public void addExecutionUnsuccessfulListener(ExecutionUnsuccessfulListener newListener) {
        if (this.aExecutionUnsuccessfulListener == null) {
            this.aExecutionUnsuccessfulListener = new Vector();
        }
        this.aExecutionUnsuccessfulListener.addElement(newListener);
    }

    public void addInternalExecutionStartingListener(InternalExecutionStartingListener newListener) {
        if (this.aInternalExecutionStartingListener == null) {
            this.aInternalExecutionStartingListener = new Vector();
        }
        this.aInternalExecutionStartingListener.addElement(newListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public abstract void checkInputState() throws InvalidInputStateException;

    public void checkTriggerState(Object transferObject) throws InvalidTriggerStateException {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".checkTriggerState()]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        Object currentInput = this.getInput();
        if (this.getExpectedTriggerClass() != null && currentInput != null && transferObject.getClass() != this.getExpectedTriggerClass()) {
            throw new InvalidTriggerStateException();
        }
        if (currentInput == null) {
            try {
                this.setInput(transferObject);
                this.setInput(null);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                throw new InvalidTriggerStateException();
            }
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".checkTriggerState()]");
        }
    }

    private String dumpBytes(byte[] theBytes) {
        StringBuffer stream = new StringBuffer();
        int bufSize = 0;
        if (theBytes != null) {
            bufSize = theBytes.length;
        }
        int size = bufSize;
        char[] buf = new char[16];
        while (size % 16 != 0) {
            ++size;
        }
        if (theBytes == null) {
            return null;
        }
        int j = 0;
        int i = 1;
        while (i <= size) {
            int k;
            if (i > bufSize) {
                stream.append(Integer.toHexString(0));
                stream.append(Integer.toHexString(0));
                buf[j] = '\u0000';
            } else {
                k = (theBytes[i - 1] & 0xF0) >> 4;
                int l = theBytes[i - 1] & 0xF;
                stream.append(Integer.toHexString(k));
                stream.append(Integer.toHexString(l));
                buf[j] = (char)theBytes[i - 1];
            }
            if (i % 4 == 0) {
                stream.append(" ");
            }
            if (i % 16 == 0) {
                stream.append(" |");
                k = 0;
                while (k < 16) {
                    if (Character.isIdentifierIgnorable(buf[k])) {
                        stream.append(".");
                    } else {
                        stream.append(buf[k]);
                    }
                    ++k;
                }
                stream.append("|");
                stream.append("\n");
                j = 0;
            } else {
                ++j;
            }
            ++i;
        }
        stream.append("\n");
        return stream.toString();
    }

    public void execute() throws InvalidInputStateException, ExecutionException, InvalidOutputStateException {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute()]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        CommandEvent commandEvent = new CommandEvent(this);
        this.execute(commandEvent);
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute()]");
        }
    }

    public final void execute(CommandEvent event) throws InvalidInputStateException, ExecutionException, InvalidOutputStateException {
        CommandEvent commandEvent;
        int currentTrace;
        block15: {
            currentTrace = this.getCurrentTraceLevel();
            if (currentTrace >= 2) {
                this.logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent)]");
            }
            if (currentTrace == 3) {
                this.logTraceInfo(this.toStringShort());
            }
            if (currentTrace >= 4) {
                this.logTraceInfo(this.toString());
            }
            commandEvent = new CommandEvent(this);
            commandEvent.setPropertyTable(event.getPropertyTable());
            try {
                this.fireBeforeInternalExecution(commandEvent);
            }
            catch (InvalidTriggerStateException invalidTriggerStateException) {
                if (currentTrace >= 1) {
                    this.logTraceInfo("command.exectue(CommandEvent): InvalidTriggerStateException");
                }
                return;
            }
            try {
                this.internalExecute();
            }
            catch (RuntimeException e) {
                commandEvent = new CommandEvent(this);
                commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Exception", e);
                this.fireAfterInternalExecution(commandEvent);
                this.fireExecutionUnsuccessful(commandEvent);
                if (!commandEvent.existsPropertyNamed("__ComIbmIvjEabCommand_Exception")) break block15;
                throw e;
            }
        }
        if (this.getOutput() instanceof SelectorRecord) {
            this.logError(resCommandResourceBundle.getString("IVJC0850__No_output_candid"));
            if (currentTrace >= 1) {
                this.logTraceInfo("   [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent) error: No output candidate matches data returned from the connector.]");
            }
            InvalidOutputStateException e = new InvalidOutputStateException();
            e.setInvalidOutput(((SelectorRecord)this.getOutput()).getInvalidOutput());
            if (currentTrace >= 1) {
                this.logTraceInfo("   [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent) error: No output candidate matches data returned from the connector.]");
                this.logTraceInfo("   Returned byte array:");
                this.logTraceInfo(this.dumpBytes((byte[])e.getInvalidOutput().firstElement()));
            }
            commandEvent = new CommandEvent(this);
            this.fireAfterInternalExecution(commandEvent);
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Exception", e);
            this.fireExecutionUnsuccessful(commandEvent);
            if (commandEvent.existsPropertyNamed("__ComIbmIvjEabCommand_Exception")) {
                throw e;
            }
        }
        commandEvent = new CommandEvent(this);
        this.fireAfterInternalExecution(commandEvent);
        this.fireExecutionSuccessful(commandEvent);
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent)]");
        }
    }

    protected void fireAfterInternalExecution(CommandEvent event) {
        if (this.aAfterInternalExecutionListener == null) {
            return;
        }
        int currentSize = this.aAfterInternalExecutionListener.size();
        AfterInternalExecutionListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (AfterInternalExecutionListener)this.aAfterInternalExecutionListener.elementAt(index);
            if (tempListener != null) {
                tempListener.afterInternalExecution(event);
            }
            ++index;
        }
    }

    protected void fireBeforeInternalExecution(CommandEvent event) {
        if (this.aBeforeInternalExecutionListener == null) {
            return;
        }
        int currentSize = this.aBeforeInternalExecutionListener.size();
        BeforeInternalExecutionListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (BeforeInternalExecutionListener)this.aBeforeInternalExecutionListener.elementAt(index);
            if (tempListener != null) {
                tempListener.beforeInternalExecution(event);
            }
            ++index;
        }
    }

    protected void fireExecutionSuccessful(CommandEvent event) {
        if (this.aExecutionSuccessfulListener == null) {
            return;
        }
        int currentSize = this.aExecutionSuccessfulListener.size();
        ExecutionSuccessfulListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (ExecutionSuccessfulListener)this.aExecutionSuccessfulListener.elementAt(index);
            if (tempListener != null) {
                tempListener.executionSuccessful(event);
            }
            ++index;
        }
    }

    protected void fireExecutionUnsuccessful(CommandEvent event) {
        if (this.aExecutionUnsuccessfulListener == null) {
            return;
        }
        int currentSize = this.aExecutionUnsuccessfulListener.size();
        ExecutionUnsuccessfulListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (ExecutionUnsuccessfulListener)this.aExecutionUnsuccessfulListener.elementAt(index);
            if (tempListener != null) {
                tempListener.executionUnsuccessful(event);
            }
            ++index;
        }
    }

    protected void fireInternalExecutionStarting(CommandEvent event) {
        if (this.aInternalExecutionStartingListener == null) {
            return;
        }
        int currentSize = this.aInternalExecutionStartingListener.size();
        InternalExecutionStartingListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (InternalExecutionStartingListener)this.aInternalExecutionStartingListener.elementAt(index);
            if (tempListener != null) {
                tempListener.internalExecutionStarting(event);
            }
            ++index;
        }
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public int getCurrentTraceLevel() {
        if (this.ccf2Command) {
            return CCF2TRACELEVEL;
        }
        return RuntimeContext.getCurrent().getRASService().getTraceLevel();
    }

    public Class getExpectedTriggerClass() {
        return this.fieldExpectedTriggerClass;
    }

    public Object getInput() {
        return this.fieldInput;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public Object getOutput() {
        return this.fieldOutput;
    }

    public void internalExceptionHandler(Throwable exception) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".internalExceptionHandler()]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteOutput);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = byteOutput.toString();
        throw new CommandException("An error occured, please check stack trace for details.\n" + stackTrace);
    }

    protected abstract void internalExecute() throws ExecutionException;

    public boolean isCcf2Command() {
        return this.ccf2Command;
    }

    protected void logError(String msg) {
        if (this.ccf2Command) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logError(msg);
        }
    }

    protected void logTraceInfo(String msg) {
        if (this.ccf2Command) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public void removeAfterInternalExecutionListener(AfterInternalExecutionListener newListener) {
        if (this.aAfterInternalExecutionListener != null) {
            this.aAfterInternalExecutionListener.removeElement(newListener);
        }
    }

    public void removeBeforeInternalExecutionListener(BeforeInternalExecutionListener newListener) {
        if (this.aBeforeInternalExecutionListener != null) {
            this.aBeforeInternalExecutionListener.removeElement(newListener);
        }
    }

    public void removeExecutionSuccessfulListener(ExecutionSuccessfulListener newListener) {
        if (this.aExecutionSuccessfulListener != null) {
            this.aExecutionSuccessfulListener.removeElement(newListener);
        }
    }

    public void removeExecutionUnsuccessfulListener(ExecutionUnsuccessfulListener newListener) {
        if (this.aExecutionUnsuccessfulListener != null) {
            this.aExecutionUnsuccessfulListener.removeElement(newListener);
        }
    }

    public void removeInternalExecutionStartingListener(InternalExecutionStartingListener newListener) {
        if (this.aInternalExecutionStartingListener != null) {
            this.aInternalExecutionStartingListener.removeElement(newListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setCcf2Command(boolean newCcf2Command) {
        this.ccf2Command = newCcf2Command;
    }

    public void setExpectedTriggerClass(Class expectedTriggerClass) {
        Class oldValue = this.fieldExpectedTriggerClass;
        this.fieldExpectedTriggerClass = expectedTriggerClass;
        this.firePropertyChange("expectedTriggerClass", oldValue, expectedTriggerClass);
    }

    public void setInput(Object input) {
        this.fieldInput = input;
        this.firePropertyChange(aInput, null, input);
    }

    public void setLogWriter(PrintWriter newLogWriter) {
        this.logWriter = newLogWriter;
        CCF2TRACELEVEL = 4;
    }

    public void setOutput(Object output) {
        Object oldValue = this.fieldOutput;
        this.fieldOutput = output;
        if (this.fieldOutput == oldValue) {
            return;
        }
        this.firePropertyChange(aOutput, null, output);
    }

    public String toStringShort() {
        return emptyString;
    }
}

