/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.infrastructure;

import com.ibm.connector.infrastructure.Coordinator;
import com.ibm.connector.infrastructure.DefaultLogonInfo;
import com.ibm.connector.infrastructure.DefaultRASService;
import com.ibm.connector.infrastructure.Identifier;
import com.ibm.connector.infrastructure.LogonInfo;
import com.ibm.connector.infrastructure.NullCoordinator;
import com.ibm.connector.infrastructure.NullID;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.internal.ConnectionManager;
import com.ibm.connector.internal.DefaultConnectionManager;
import java.util.Hashtable;

public class RuntimeContext {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private static Hashtable values = new Hashtable();
    private LogonInfo fieldLogonInfo = null;
    private RASService fieldRASService = null;
    private Coordinator fieldCoordinator = null;
    private ConnectionManager fieldConnectionManager = null;
    private Identifier fieldSessionID = null;

    public RuntimeContext() {
        if (this.fieldConnectionManager == null) {
            this.setConnectionManager(new DefaultConnectionManager());
        }
        this.setCoordinator(new NullCoordinator());
        this.setLogonInfo(new DefaultLogonInfo());
        if (this.fieldRASService == null) {
            this.setRASService(new DefaultRASService());
        }
        this.fieldSessionID = new NullID();
    }

    public void close() {
        if (this.fieldRASService.getTraceLevel() >= 2) {
            this.fieldRASService.logTraceInfo("<->[" + this.toString() + ".close()]");
        }
        this.fieldCoordinator.clearAllRegistered();
        this.fieldConnectionManager.clearForSessionID(this.fieldSessionID);
        RuntimeContext.removeCurrent();
    }

    public ConnectionManager getConnectionManager() {
        return this.fieldConnectionManager;
    }

    public Coordinator getCoordinator() {
        return this.fieldCoordinator;
    }

    public static RuntimeContext getCurrent() {
        RuntimeContext current = (RuntimeContext)values.get(Thread.currentThread());
        if (current == null) {
            current = new RuntimeContext();
            RuntimeContext.setCurrent(current);
        }
        return current;
    }

    public LogonInfo getLogonInfo() {
        return this.fieldLogonInfo;
    }

    public RASService getRASService() {
        return this.fieldRASService;
    }

    public Identifier getSessionID() {
        return this.fieldSessionID;
    }

    public static boolean isCurrentSet() {
        RuntimeContext current = (RuntimeContext)values.get(Thread.currentThread());
        return current != null;
    }

    public static void removeCurrent() {
        if (values.containsKey(Thread.currentThread())) {
            values.remove(Thread.currentThread());
        }
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.fieldConnectionManager = connectionManager;
    }

    public void setCoordinator(Coordinator coordinator) {
        this.fieldCoordinator = coordinator;
    }

    public static void setCurrent(RuntimeContext value) {
        values.put(Thread.currentThread(), value);
    }

    public void setLogonInfo(LogonInfo value) {
        this.fieldLogonInfo = value;
    }

    public void setRASService(RASService rASService) {
        this.fieldRASService = rASService;
    }

    public void setSessionID(Identifier value) {
        this.fieldSessionID = value;
    }
}

