/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.connectionmanager;

import com.ibm.connector.connectionmanager.ConnectionTimestampAssociation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public class UserConnections {
    static final String copyright = "(c) Copyright IBM Corporation 1999.";
    private Vector connections = new Vector();
    private int count = 0;

    public UserConnections() {
        ++this.count;
    }

    public void addConnection(ConnectionTimestampAssociation cta) {
        this.connections.addElement(cta);
    }

    public boolean decreaseCount() {
        --this.count;
        return this.count == 0;
    }

    public int getCount() {
        return this.count;
    }

    public void increaseCount() {
        ++this.count;
    }

    public boolean removeConnection(ConnectionTimestampAssociation cta) {
        boolean removed = this.connections.removeElement(cta);
        if (removed) {
            --this.count;
        }
        return this.count == 0;
    }

    public String toString() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println(" Unused Connections:");
            if (this.connections != null) {
                pwrtr.println("                    [" + this.connections.toString() + "]");
            } else {
                pwrtr.println("                    [null]");
            }
            pwrtr.println("                        Number of All Connections: " + this.count);
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }
}

