/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.connectionmanager;

import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.ConnectionSpecManagementProperties;
import com.ibm.connector.connectionmanager.CConnectionOrganizer;
import com.ibm.connector.connectionmanager.ConnectionManager;
import com.ibm.connector.connectionmanager.ConnectionTimestampAssociation;
import com.ibm.connector.connectionmanager.Task;
import com.ibm.connector.connectionmanager.UserConnections;
import com.ibm.connector.connectionmanager.UserDataOrganizer;
import com.ibm.connector.infrastructure.Identifier;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.Managed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UConnectionOrganizer
extends CConnectionOrganizer
implements Task {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    protected ConnectionSpecManagementProperties csProperties = null;
    private Hashtable coordinatedTable = null;
    protected Hashtable userDataTable = null;
    private int connectionCount = 0;
    private ConnectionManager parent = null;
    private int collectorCount = 0;
    private Object countLock = new Object();
    private Object gcCounterLock = new Object();

    public UConnectionOrganizer() {
    }

    public UConnectionOrganizer(ConnectionSpecManagementProperties connectionSpec, ConnectionManager cm) {
        this.csProperties = connectionSpec;
        this.coordinatedTable = new Hashtable();
        this.parent = cm;
    }

    public void addUserConnection(Object key, ConnectionTimestampAssociation connection) {
        ((UserConnections)this.userDataTable.get(key)).addConnection(connection);
    }

    public void addUserDataAssociation(Object key, Object value) {
        this.userDataTable.put(key, value);
    }

    public synchronized void decreaseConnectionCount() {
        if (this.connectionCount > 0) {
            --this.connectionCount;
        }
    }

    public boolean decreaseUserConnectionCount(Object userData) {
        return ((UserConnections)this.userDataTable.get(userData)).decreaseCount();
    }

    /*
     * Exception decompiling
     */
    public void executeTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean existsUserDataAssociation(Object key) {
        return this.userDataTable.containsKey(key);
    }

    public void garbageCollector() {
        int currentTraceLevel = RuntimeContext.getCurrent().getRASService().getTraceLevel();
        boolean collected = false;
        Enumeration recycledElements = null;
        UConnectionOrganizer uConnectionOrganizer = this;
        synchronized (uConnectionOrganizer) {
            if (currentTraceLevel >= 2) {
                this.parent.trace("->[[com.ibm.connector.connectionmanager.UConnectionOrganizer]@" + this.hashCode() + ".garbageCollector()]");
            }
            if (this.getUnusedSize() == 0) {
                if (currentTraceLevel >= 2) {
                    this.parent.trace("<-[[com.ibm.connector.connectionmanager.UConnectionOrganizer]@" + this.hashCode() + ".garbageCollector()]");
                }
                return;
            }
            long minConnections = this.csProperties.getMinConnections();
            if ((long)this.getUnusedSize() < minConnections) {
                if (currentTraceLevel >= 2) {
                    this.parent.trace("<-[[com.ibm.connector.connectionmanager.UConnectionOrganizer]@" + this.hashCode() + ".garbageCollector()]");
                }
                return;
            }
            long unusedTimeout = this.csProperties.getUnusedTimeout();
            long currentT = System.currentTimeMillis();
            ConnectionTimestampAssociation ct = null;
            Enumeration elements = this.getUnusedElements();
            Vector unusedConnectionsVector = new Vector();
            while (elements.hasMoreElements()) {
                unusedConnectionsVector.addElement(elements.nextElement());
            }
            if (currentTraceLevel >= 3) {
                this.parent.trace("  >>> garbageCollector() starting collection");
            }
            int i = 0;
            while (i < unusedConnectionsVector.size()) {
                ct = (ConnectionTimestampAssociation)unusedConnectionsVector.elementAt(i);
                if (currentT - ct.getTime() > unusedTimeout && (long)this.getUnusedSize() > minConnections) {
                    if (currentTraceLevel >= 3) {
                        this.parent.trace("  >>> garbageCollector() removing connection" + ct.toString());
                    }
                    this.removeUnused(ct);
                    ((Managed)ct.getValue()).destroyManaged();
                    this.decreaseConnectionCount();
                    collected = true;
                    if (this.userDataTable != null) {
                        ConnectionSpec connectionSpec = ((Managed)ct.getValue()).getConnectionSpec();
                        UserDataOrganizer organizer = new UserDataOrganizer(connectionSpec);
                        if (this.existsUserDataAssociation(organizer)) {
                            if (this.removeUserConnection(organizer, ct)) {
                                this.removeUserDataAssociation(organizer);
                            }
                        } else if (currentTraceLevel >= 1) {
                            this.parent.trace("Error userData hashcode:" + organizer.toString() + " does not exist in the table");
                        }
                    }
                }
                ++i;
            }
            if (collected) {
                if (this.coordinatedTable != null) {
                    recycledElements = this.coordinatedTable.elements();
                }
                this.notifyAll();
            }
        }
        if (collected) {
            if (currentTraceLevel >= 3) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo(this.parent.toString());
            }
            if (recycledElements != null) {
                CConnectionOrganizer co = null;
                while (recycledElements.hasMoreElements()) {
                    CConnectionOrganizer cConnectionOrganizer = co = (CConnectionOrganizer)recycledElements.nextElement();
                    synchronized (cConnectionOrganizer) {
                        if (co.getWaitCounter() > 0) {
                            co.notifyAll();
                        }
                    }
                }
            }
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-[[com.ibm.connector.connectionmanager.UConnectionOrganizer]@" + this.hashCode() + ".garbageCollector()]");
        }
    }

    public synchronized int getConnectionCount() {
        return this.connectionCount;
    }

    public synchronized CConnectionOrganizer getConnectionOrganizer(Identifier id) {
        return (CConnectionOrganizer)this.coordinatedTable.get(id.toString());
    }

    public Hashtable getCoordinatedTable() {
        return this.coordinatedTable;
    }

    public Hashtable getUserDataTable() {
        return this.userDataTable;
    }

    public synchronized void increaseConnectionCount() {
        ++this.connectionCount;
    }

    public void increaseUserConnectionCount(Object userData) {
        ((UserConnections)this.userDataTable.get(userData)).increaseCount();
    }

    public boolean limitReached(ConnectionSpec connectionSpec, Class connectionClass) {
        Object object = this.countLock;
        synchronized (object) {
            UserConnections uc;
            if (this.userDataTable == null) {
                if (this.csProperties == null) {
                    ++this.connectionCount;
                    return false;
                }
                long maxConnections = this.csProperties.getMaxConnections();
                if (maxConnections > 0L && maxConnections <= (long)this.connectionCount) {
                    return true;
                }
                ++this.connectionCount;
                return false;
            }
            Object userData = null;
            Object userMaxConn = null;
            boolean returnValue = true;
            UserDataOrganizer organizer = new UserDataOrganizer(connectionSpec);
            try {
                Method methodHashcode = connectionClass.getMethod("getUserDataHashCode", new Class[0]);
                userData = methodHashcode.invoke((Object)connectionSpec, new Object[0]);
                Method methodMaxConn = connectionClass.getMethod("getMaxConnectionsPerUserDataHashCode", new Class[0]);
                userMaxConn = methodMaxConn.invoke((Object)connectionSpec, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            returnValue = userData == null || userMaxConn == null ? false : ((uc = (UserConnections)this.userDataTable.get(organizer)) == null || (Integer)userMaxConn == 0 ? false : (Integer)userMaxConn <= uc.getCount());
            if (returnValue) {
                return true;
            }
            if (this.csProperties == null) {
                ++this.connectionCount;
                return false;
            }
            long maxConnections = this.csProperties.getMaxConnections();
            if (maxConnections > 0L && maxConnections <= (long)this.connectionCount) {
                return true;
            }
            ++this.connectionCount;
            return false;
        }
    }

    public synchronized void removeConnectionOrganizer(Identifier id) {
        if (this.coordinatedTable.containsKey(id.toString())) {
            this.coordinatedTable.remove(id.toString());
        }
    }

    public boolean removeUserConnection(Object key, ConnectionTimestampAssociation connection) {
        return ((UserConnections)this.userDataTable.get(key)).removeConnection(connection);
    }

    public void removeUserDataAssociation(Object key) {
        this.userDataTable.remove(key);
    }

    public synchronized void setConnectionOrganizer(Identifier id, CConnectionOrganizer helper) {
        this.coordinatedTable.put(id.toString(), helper);
    }

    public void setUserDataTable() {
        this.userDataTable = new Hashtable();
    }

    public String toString() {
        String dumpString = "";
        try {
            Enumeration elements;
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.connector.connectionmanager.UConnectionOrganizer]@" + this.hashCode());
            pwrtr.println("      Number of connections:" + this.connectionCount);
            if (this.coordinatedTable != null) {
                pwrtr.println("            Unsessioned Connections:");
            }
            pwrtr.println(super.toString());
            if (this.userDataTable != null) {
                pwrtr.println("                 [UserDataTable ");
                elements = this.userDataTable.elements();
                Enumeration keys = this.userDataTable.keys();
                while (elements.hasMoreElements()) {
                    UserConnections uc = (UserConnections)elements.nextElement();
                    UserDataOrganizer uk = (UserDataOrganizer)keys.nextElement();
                    if (uc == null) {
                        pwrtr.println("                 [null]");
                        continue;
                    }
                    pwrtr.println("                 UserHashCode: " + uk.toString());
                    pwrtr.println("                 [" + uc.toString() + "                 ]");
                }
                pwrtr.println("                 ]");
            }
            if (this.coordinatedTable != null) {
                pwrtr.println("                [Sessioned Connections:");
                elements = this.coordinatedTable.elements();
                while (elements.hasMoreElements()) {
                    CConnectionOrganizer co = (CConnectionOrganizer)elements.nextElement();
                    if (co == null) {
                        pwrtr.println("                 [null]");
                        continue;
                    }
                    pwrtr.println("                 [com.ibm.connector.connectionmanager.CConnectionOrganizer]@" + co.hashCode());
                    pwrtr.println("                  Outstanding connection requests: " + co.getWaitCounter());
                    pwrtr.println(co.toString());
                }
                pwrtr.println("                ]");
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }
}

