/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.connectionmanager;

import com.ibm.connector.connectionmanager.Task;
import com.ibm.connector.infrastructure.RuntimeContext;
import java.util.Enumeration;
import java.util.Vector;

public class TaskTimer
extends Thread
implements Task {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private RuntimeContext runtimeContext = null;
    private Vector m_tasks = new Vector();
    private long m_interval;

    public TaskTimer(long interval, RuntimeContext aRuntimeContext) {
        this.m_interval = interval;
        this.setDaemon(true);
        this.runtimeContext = aRuntimeContext;
        this.start();
    }

    public void addTask(Task task) {
        this.m_tasks.addElement(task);
    }

    public void executeTask() {
        Enumeration enumeration = this.m_tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task t = (Task)enumeration.nextElement();
            t.executeTask();
        }
    }

    public long getInterval() {
        return this.m_interval;
    }

    public void removeTask(Task task) {
        this.m_tasks.removeElement(task);
    }

    public void run() {
        RuntimeContext.setCurrent(this.runtimeContext);
        try {
            while (true) {
                Thread.sleep(this.m_interval * 1000L);
                this.executeTask();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }
}

