/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpLogLevel;

public final class DisabledHTTPLogger
implements HTTPLoggingService {
    private static HTTPLoggingService myInstance = null;

    private DisabledHTTPLogger() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new DisabledHTTPLogger();
        }
    }

    public static final HTTPLoggingService getRef() {
        if (null == myInstance) {
            DisabledHTTPLogger.createSingleton();
        }
        return myInstance;
    }

    public boolean enableAccessLogging() {
        return false;
    }

    public boolean enableErrorLogging() {
        return false;
    }

    public boolean startAccessLogging() {
        return false;
    }

    public boolean startErrorLogging() {
        return false;
    }

    public boolean disableAccessLogging() {
        return true;
    }

    public boolean disableErrorLogging() {
        return true;
    }

    public boolean stopAccessLogging() {
        return true;
    }

    public boolean stopErrorLogging() {
        return true;
    }

    public void log(HttpLogLevel httpLogLevel, String string, HttpServiceContext httpServiceContext) {
    }

    public void log(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
    }

    public void logAccess(byte[] byArray, HttpServiceContext httpServiceContext) {
    }

    public HttpLogLevel getLogLevel() {
        return HttpConstants.LOG_DISABLED;
    }

    public boolean isLoggingLevelEnabled(HttpLogLevel httpLogLevel) {
        return HttpConstants.LOG_DISABLED.equals(httpLogLevel);
    }

    public boolean isAccessLoggingEnabled() {
        return false;
    }

    public boolean isErrorLoggingEnabled() {
        return false;
    }

    public int getAccessFormat() {
        return 0;
    }

    public boolean setAccessFormat(int n) {
        return false;
    }

    public boolean setAccessLogMaximumSize(int n) {
        return true;
    }

    public boolean setErrorLogMaximumSize(int n) {
        return true;
    }
}

