/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannel;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundLink
extends OutboundProtocolLink {
    private static final TraceComponent tc = Tr.register((Class)HttpOutboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private HttpOutboundServiceContextImpl myInterface = null;
    private HttpOutboundChannel myChannel = null;
    private boolean bAllowReconnect = true;
    private boolean bEnableReconnect = true;
    private HttpAddress targetAddress = null;
    private boolean bIsActive = false;
    private boolean reconnecting = false;
    private IOException reconnectException = null;
    private boolean earlyReconnectDestroy = false;

    public HttpOutboundLink(HttpOutboundChannel httpOutboundChannel, VirtualConnection virtualConnection) {
        this.init(virtualConnection, httpOutboundChannel);
    }

    public void init(VirtualConnection virtualConnection, HttpOutboundChannel httpOutboundChannel) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Init on link: " + (Object)((Object)this) + " " + virtualConnection));
        }
        super.init(virtualConnection);
        this.setChannel(httpOutboundChannel);
        this.setActive(true);
        this.setEnableReconnect(this.getChannel().getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying this outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()));
        }
        if (!this.reconnecting) {
            HttpOutboundLink httpOutboundLink = this;
            synchronized (httpOutboundLink) {
                if (!this.isActive()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Ignoring destroy on an inactive object");
                    }
                    return;
                }
                this.setActive(false);
            }
            super.destroy(exception);
            if (null != this.getHSC()) {
                this.getHSC().destroy();
                this.setHSC(null);
            }
        } else {
            this.earlyReconnectDestroy = true;
            IOException iOException = this.reconnectException;
            this.reconnectException = null;
            this.reconnecting = false;
            this.getHSC().callErrorCallback(this.getVirtualConnection(), iOException);
        }
    }

    private boolean isActive() {
        return this.bIsActive;
    }

    private void setActive(boolean bl) {
        this.bIsActive = bl;
    }

    private HttpOutboundServiceContextImpl getHSC() {
        return this.myInterface;
    }

    private void setHSC(HttpOutboundServiceContextImpl httpOutboundServiceContextImpl) {
        this.myInterface = httpOutboundServiceContextImpl;
    }

    private HttpOutboundServiceContextImpl getInterface(VirtualConnection virtualConnection) {
        if (null == this.getHSC()) {
            this.setHSC(new HttpOutboundServiceContextImpl((TCPConnectionContext)this.getDeviceLink().getChannelAccessor(), this, virtualConnection, this.getChannel().getHttpConfig()));
        }
        return this.getHSC();
    }

    public final Object getChannelAccessor() {
        return this.getInterface(this.getVirtualConnection());
    }

    protected void postConnectProcessing(VirtualConnection virtualConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Finished connecting to target: " + (Object)((Object)this) + " " + virtualConnection));
        }
        this.getInterface(virtualConnection);
    }

    public void ready(VirtualConnection virtualConnection) {
        if (!this.reconnecting) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Outbound ready for " + (Object)((Object)this) + " " + virtualConnection));
            }
            super.ready(virtualConnection);
        } else {
            this.reconnecting = false;
            this.reconnectException = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Outbound reconnect finished for " + (Object)((Object)this) + " " + virtualConnection));
            }
            this.getHSC().nowReconnectedAsync();
        }
    }

    protected void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing the outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()));
        }
        this.setEnableReconnect(this.getChannel().getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
        this.reconnecting = false;
        this.reconnectException = null;
        this.earlyReconnectDestroy = false;
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing this outbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()));
        }
        this.setAllowReconnect(false);
        if (!this.earlyReconnectDestroy) {
            super.close(virtualConnection, exception);
        } else {
            this.destroy(exception);
        }
    }

    public void connect(Object object) throws Exception {
        this.setTargetAddress((HttpAddress)object);
        if (null != this.getHSC() && this.isReconnectAllowed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing existing OSC on connect");
            }
            this.getHSC().clear();
        }
        super.connect(object);
    }

    public void connectAsynch(Object object) {
        this.setTargetAddress((HttpAddress)object);
        if (null != this.getHSC() && this.isReconnectAllowed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing existing OSC on connectAsynch");
            }
            this.getHSC().clear();
        }
        super.connectAsynch(object);
    }

    protected void reConnectSync(IOException iOException) throws IOException {
        this.setAllowReconnect(false);
        try {
            this.connect(this.getTargetAddress());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Sync reconnect failed, throwing original exception");
            }
            throw iOException;
        }
    }

    protected void reConnectAsync(IOException iOException) {
        this.setAllowReconnect(false);
        this.reconnecting = true;
        this.reconnectException = iOException;
        this.connectAsynch(this.getTargetAddress());
    }

    protected final boolean isReconnectAllowed() {
        return this.bAllowReconnect;
    }

    private boolean isReconnectEnabled() {
        return this.bEnableReconnect;
    }

    private void setEnableReconnect(boolean bl) {
        this.bEnableReconnect = bl;
    }

    protected final void setAllowReconnect(boolean bl) {
        this.bAllowReconnect = bl & this.isReconnectEnabled();
    }

    protected final boolean disallowRewrites() {
        this.setEnableReconnect(false);
        this.setAllowReconnect(false);
        return !this.isReconnectAllowed();
    }

    protected final boolean allowRewrites() {
        this.setAllowReconnect(true);
        return this.isReconnectAllowed();
    }

    public final HttpAddress getTargetAddress() {
        return this.targetAddress;
    }

    private void setTargetAddress(HttpAddress httpAddress) {
        this.targetAddress = httpAddress;
    }

    public final HttpObjectFactory getObjectFactory() {
        return null == this.getChannel() ? null : this.getChannel().getObjectFactory();
    }

    private HttpOutboundChannel getChannel() {
        return this.myChannel;
    }

    private void setChannel(HttpOutboundChannel httpOutboundChannel) {
        this.myChannel = httpOutboundChannel;
    }

    public boolean isConnected() {
        if (!this.getHSC().isIncomingMessageFullyRead()) {
            return true;
        }
        try {
            if (null == this.getHSC().getReadSC().getBuffer()) {
                this.getHSC().getReadSC().setJITAllocateSize(this.getHSC().getHttpConfig().getIncomingHdrBufferSize());
            }
            this.getHSC().getReadSC().read(0L, 0);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

