/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpOSCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpOSCWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCWriteCallback myInstance = null;

    private HttpOSCWriteCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCWriteCallback();
        }
    }

    public static final HttpOSCWriteCallback getRef() {
        if (null == myInstance) {
            HttpOSCWriteCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in complete()");
            }
            return;
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
        if (httpOutboundServiceContextImpl.isHeadersSentState() && httpOutboundServiceContextImpl.shouldReadResponseImmediately()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Sent headers, reading for response");
            }
            httpOutboundServiceContextImpl.startResponseRead();
            return;
        }
        if (!httpOutboundServiceContextImpl.isMessageSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling write complete callback of app channel.");
            }
            httpOutboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
        } else if (httpOutboundServiceContextImpl.shouldReadResponseImmediately()) {
            httpOutboundServiceContextImpl.readAsyncResponse();
        } else {
            httpOutboundServiceContextImpl.startResponseRead();
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in error()");
            }
            return;
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
        httpOutboundServiceContextImpl.setPersistent(false);
        httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
    }
}

