/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCBodyReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpOSCBodyReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCBodyReadCallback myInstance = null;

    private HttpOSCBodyReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCBodyReadCallback();
        }
    }

    public static final HttpOSCBodyReadCallback getRef() {
        if (null == myInstance) {
            HttpOSCBodyReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null != v) {
            ((HttpOutboundServiceContextImpl)v).continueRead();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in complete()");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null != v) {
            HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Socket closure, signaling close.");
            }
            if (!httpOutboundServiceContextImpl.isChunkedEncoding() && !httpOutboundServiceContextImpl.isContentLength()) {
                httpOutboundServiceContextImpl.prepareClosure();
                httpOutboundServiceContextImpl.getAppReadCallback().complete(virtualConnection);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IOException during body read");
                }
                httpOutboundServiceContextImpl.setPersistent(false);
                httpOutboundServiceContextImpl.getAppReadCallback().error(virtualConnection, (Throwable)iOException);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in error()");
        }
    }
}

