/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSC100ReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpOSC100ReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSC100ReadCallback myInstance = null;

    private HttpOSC100ReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSC100ReadCallback();
        }
    }

    public static final HttpOSC100ReadCallback getRef() {
        if (null == myInstance) {
            HttpOSC100ReadCallback.createSingleton();
        }
        return myInstance;
    }

    private boolean handleNewData(HttpOutboundServiceContextImpl httpOutboundServiceContextImpl, VirtualConnection virtualConnection) {
        if (!httpOutboundServiceContextImpl.headersParsed()) {
            try {
                return httpOutboundServiceContextImpl.parseMessage();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".handleNewData"), (String)"73", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught exception: " + exception.getMessage()));
                }
                httpOutboundServiceContextImpl.setPersistent(false);
                httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null != v) {
            HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
            boolean bl = false;
            while (!bl && null != virtualConnection) {
                bl = this.handleNewData(httpOutboundServiceContextImpl, virtualConnection);
                if (bl) continue;
                virtualConnection = tCPReadRequestContext.read(1L, this, false, httpOutboundServiceContextImpl.getReadTimeout());
            }
            if (bl) {
                StatusCodes statusCodes = httpOutboundServiceContextImpl.getResponse().getStatusCode();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("100-continue scenario received " + statusCodes));
                }
                if (statusCodes.equals(HttpConstants.STATUS_CONTINUE)) {
                    httpOutboundServiceContextImpl.resetRead();
                    httpOutboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
                } else {
                    httpOutboundServiceContextImpl.setPersistent(false);
                    httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)new ExpectationFailedException(statusCodes.getIntCode() + " " + httpOutboundServiceContextImpl.getResponse().getReasonPhrase()));
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in complete()");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null != v) {
            HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
            httpOutboundServiceContextImpl.setPersistent(false);
            httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in error()");
        }
    }
}

