/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.channel.impl.HttpFactoryConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.Http100ContWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCBodyReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpISCWriteErrorCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.values.impl.ReturnCodes;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class HttpInboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpInboundServiceContext {
    private static final TraceComponent tc = Tr.register((Class)HttpInboundServiceContextImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String CLASS_NAME = HttpInboundServiceContextImpl.class.getName();
    private static final String HTTP_ERROR_IDENTIFIER = "Http Error ID";
    private static final String LOG_INIT = " - - [";
    private static final String LOG_DATEEND = "] \"";
    private static final String DASH = "-";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private HttpInboundLink myLink = null;
    private boolean bCheckedAcceptEncoding = false;
    private boolean bCompressionAllowed = false;
    private boolean bIsRequestFormData = false;
    private boolean bContainsLargeMessage = false;

    public HttpInboundServiceContextImpl(TCPConnectionContext tCPConnectionContext, HttpInboundLink httpInboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        this.init(tCPConnectionContext, (ConnectionLink)httpInboundLink, virtualConnection, httpChannelConfig);
    }

    public void init(TCPConnectionContext tCPConnectionContext, ConnectionLink connectionLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing ISC: " + this));
        }
        super.init(tCPConnectionContext, httpChannelConfig);
        this.setBodyRC(HttpISCBodyReadCallback.getRef());
        this.setLink((HttpInboundLink)connectionLink);
        this.setVC(virtualConnection);
        this.getVC().getStateMap().put(CallbackIDs.CALLBACK_HTTPISC, this);
        this.getRequestImpl().initScheme();
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying ISC: " + this));
        }
        super.destroy();
    }

    public void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing ISC: " + this));
        }
        super.clear();
        this.bCheckedAcceptEncoding = false;
        this.bIsRequestFormData = false;
        this.bContainsLargeMessage = false;
    }

    protected void updatePersistence(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (this.getLink().maxRequestsServed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Max requests already processed on this connection");
            }
            this.setPersistent(false);
        } else {
            super.updatePersistence(httpBaseMessageImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePersistence(inbound) updated: " + this.isPersistent()));
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessage httpBaseMessage) {
        if (!this.getRequestImpl().getMethodValue().equals(HttpConstants.METHOD_HEAD)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Body not valid on response, fixing headers");
            }
            if (0 < httpBaseMessage.getContentLength()) {
                httpBaseMessage.setContentLength(-1);
            }
            httpBaseMessage.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_NOTSET);
        }
    }

    private void setCheckedEncoding(boolean bl) {
        this.bCheckedAcceptEncoding = bl;
    }

    private boolean haveCheckedEncoding() {
        return this.bCheckedAcceptEncoding;
    }

    private void setCompressionAllowedFlag(boolean bl) {
        this.bCompressionAllowed = bl;
    }

    private boolean getCompressionAllowedFlag() {
        return this.bCompressionAllowed;
    }

    private ReturnCodes parseQValue(byte[] byArray, int n) {
        ReturnCodes returnCodes = new ReturnCodes(false);
        if (n >= byArray.length || 113 != byArray[n] && 81 != byArray[n]) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non qvalue found");
            }
        } else if (++n >= byArray.length || 61 != byArray[n]) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid qvalue found (missing equals)");
            }
        } else if (++n < byArray.length) {
            if (49 == byArray[n]) {
                returnCodes.setBooleanValue(true);
            } else if (48 == byArray[n]) {
                if (++n < byArray.length && 46 == byArray[n]) {
                    for (int i = 0; ++n < byArray.length && i < 3; ++i) {
                        if (48 == byArray[n]) continue;
                        if (49 <= byArray[n] && 57 >= byArray[n]) {
                            returnCodes.setBooleanValue(true);
                            break;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Non-digit qvalue decimal: " + (char)byArray[n]));
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Non-digit qvalue found: " + (char)byArray[n]));
            }
        }
        returnCodes.setIntValue(n);
        return returnCodes;
    }

    protected boolean isCompressionAllowed() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCompressionAllowed");
        }
        if (this.haveCheckedEncoding()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isCompressionAllowed");
            }
            return this.getCompressionAllowedFlag();
        }
        boolean bl = false;
        byte[] byArray = null;
        if (this.isGZipEncoded() || this.isXGZipEncoded()) {
            byArray = HttpConstants.CONTENT_ENCODING_GZIP.getByteArray();
        } else if (this.isZlibEncoded()) {
            byArray = HttpConstants.CONTENT_ENCODING_DEFLATE.getByteArray();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected compression flag, return false");
            }
            this.setCheckedEncoding(true);
            this.setCompressionAllowedFlag(false);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isCompressionAllowed");
            }
            return false;
        }
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = this.getRequest().getHeaderAsByteArray(HttpConstants.HDR_ACCEPT_ENCODING);
        if (null != byArray2) {
            while (n < byArray2.length) {
                int n2;
                ReturnCodes returnCodes;
                if (32 == byArray2[n] && (n = GenericUtils.skipWhiteSpace(byArray2, n)) >= byArray2.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Ran out of data");
                    }
                    break;
                }
                if (42 == byArray2[n]) {
                    bl2 = true;
                    if (++n < byArray2.length && 59 == byArray2[n]) {
                        returnCodes = this.parseQValue(byArray2, ++n);
                        bl3 = returnCodes.getBooleanValue();
                        n = GenericUtils.skipToChar(byArray2, returnCodes.getIntValue(), (byte)44) + 1;
                        continue;
                    }
                    bl3 = true;
                    continue;
                }
                if (n < byArray2.length && (120 == byArray2[n] || 88 == byArray2[n])) {
                    if (++n < byArray2.length && 45 == byArray2[n]) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"skipping past [x-]");
                        }
                        ++n;
                    } else {
                        --n;
                    }
                }
                for (n2 = 0; n2 < byArray.length && n < byArray2.length && (byArray[n2] == byArray2[n] || GenericUtils.reverseCase(byArray[n2]) == byArray2[n]); ++n2, ++n) {
                }
                if (n2 != byArray.length) {
                    n = GenericUtils.skipToChar(byArray2, n, (byte)44) + 1;
                    continue;
                }
                if (n < byArray2.length && 32 == byArray2[n]) {
                    n = GenericUtils.skipWhiteSpace(byArray2, n);
                }
                if (n < byArray2.length && 44 == byArray2[n]) {
                    bl = true;
                    break;
                }
                if (n < byArray2.length && 59 == byArray2[n]) {
                    returnCodes = this.parseQValue(byArray2, ++n);
                    bl = returnCodes.getBooleanValue();
                    break;
                }
                if (n >= byArray2.length) {
                    bl = true;
                    break;
                }
                n = GenericUtils.skipToChar(byArray2, n, (byte)44) + 1;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Accept-Encoding header not present");
            }
            bl = true;
        }
        if (!bl && bl2 && bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No explicit match, but wildcard was found");
            }
            bl = true;
        }
        this.setCheckedEncoding(true);
        this.setCompressionAllowedFlag(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCompressionAllowed: " + bl));
        }
        return bl;
    }

    public boolean isIncomingMessageFullyRead() {
        if (!this.isBodyComplete()) {
            return !super.isIncomingBodyExpected();
        }
        return true;
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    protected final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    protected final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setResponse(HttpResponseMessage httpResponseMessage) throws IllegalResponseObjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setResponse");
        }
        if (null == httpResponseMessage) {
            throw new IllegalResponseObjectException("Illegal null message");
        }
        HttpResponseMessageImpl httpResponseMessageImpl = null;
        try {
            httpResponseMessageImpl = (HttpResponseMessageImpl)httpResponseMessage;
        }
        catch (ClassCastException classCastException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non msg impl passed to setResponse");
            }
            throw new IllegalResponseObjectException("Invalid message provided");
        }
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            this.getMyResponse().destroy();
        }
        this.setMyResponse(httpResponseMessageImpl);
        this.getMyResponse().init(this);
        this.updatePersistence(this.getMyResponse());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setResponse");
        }
    }

    public void sendResponseHeaders() throws IOException, MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseHeaders(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".sendResponseHeaders"), (String)"594");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.sendHeaders(this.getResponseImpl());
        if (this.getResponseImpl().isTemporaryStatusCode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
    }

    public VirtualConnection sendResponseHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendResponseHeaders(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".sendResponseHeaders"), (String)"639");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sendReponseHeaders(async): no request");
            }
            return null;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendHeaders(this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != virtualConnection && this.getResponseImpl().isTemporaryStatusCode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags.");
            }
            this.resetWrite();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendResponseHeaders(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void sendResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseBody(body)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".sendResponseBody"), (String)"684");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendBody() setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.sendOutgoing(wsByteBufferArray, this.getResponseImpl());
    }

    public VirtualConnection sendResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendResponseBody(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".sendResponseBody"), (String)"746");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendBody(cb) setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        return this.sendOutgoing(wsByteBufferArray, this.getResponseImpl(), HttpISCWriteCallback.getRef());
    }

    public void sendRawResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawResponseBody(sync)");
        }
        this.setRawBody(true);
        this.sendResponseBody(wsByteBufferArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRawResponseBody(sync)");
        }
    }

    public VirtualConnection sendRawResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawResponseBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.sendResponseBody(wsByteBufferArray, interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRawResponseBody(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    protected HttpInvalidMessageException checkResponseValidity() {
        if (!HttpConstants.METHOD_HEAD.equals(this.getRequest().getMethodValue())) {
            int n = this.getResponse().getContentLength();
            int n2 = this.getNumBytesWritten();
            if (-1 != n && n2 != n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Response had content-length of " + n + " but sent " + n2));
                }
                if (this.getHttpConfig().isErrorLoggingEnabled()) {
                    this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_ERROR, "Mismatch in content-length and bytes written: " + n + " but sent " + n2, (HttpServiceContext)this);
                }
                this.setPersistent(false);
                return new HttpInvalidMessageException("Response length: " + n + SPACE + n2);
            }
        }
        return null;
    }

    protected void logFinalResponse() {
        if (!this.getHttpConfig().isAccessLoggingEnabled()) {
            return;
        }
        if (HttpConstants.METHOD_UNDEF.equals(this.getRequest().getMethodValue())) {
            return;
        }
        HttpRequestMessage httpRequestMessage = this.getRequest();
        HttpResponseMessage httpResponseMessage = this.getResponse();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.getRemoteAddr().getHostAddress());
        stringBuffer.append(LOG_INIT);
        stringBuffer.append(HttpDateFormat.getRef().getNCSATime());
        stringBuffer.append(LOG_DATEEND);
        stringBuffer.append(httpRequestMessage.getMethodValue().getName());
        stringBuffer.append(SPACE);
        stringBuffer.append(httpRequestMessage.getRequestURI());
        stringBuffer.append(SPACE);
        stringBuffer.append(this.getRequestVersion().getName());
        stringBuffer.append(QUOTE);
        stringBuffer.append(SPACE);
        stringBuffer.append(httpResponseMessage.getStatusCodeAsInt());
        stringBuffer.append(SPACE);
        stringBuffer.append(this.getNumBytesWritten());
        if (this.getHttpConfig().isNCSACombinedFormat()) {
            String string = httpRequestMessage.getHeaderAsString(HttpConstants.HDR_REFERER);
            stringBuffer.append(SPACE);
            if (null == string) {
                stringBuffer.append(DASH);
            } else {
                stringBuffer.append(QUOTE);
                stringBuffer.append(string);
                stringBuffer.append(QUOTE);
            }
            string = httpRequestMessage.getHeaderAsString(HttpConstants.HDR_USER_AGENT);
            stringBuffer.append(SPACE);
            if (null == string) {
                stringBuffer.append(DASH);
            } else {
                stringBuffer.append(QUOTE);
                stringBuffer.append(string);
                stringBuffer.append(QUOTE);
            }
            stringBuffer.append(SPACE);
            int n = httpRequestMessage.getNumberOfHeaderInstances(HttpConstants.HDR_COOKIE);
            if (0 == n) {
                stringBuffer.append(DASH);
            } else {
                stringBuffer.append(QUOTE);
                stringBuffer.append(httpRequestMessage.getHeaderAsString(HttpConstants.HDR_COOKIE, 0));
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(httpRequestMessage.getHeaderAsString(HttpConstants.HDR_COOKIE, i));
                }
                stringBuffer.append(QUOTE);
            }
        }
        this.getHttpConfig().getHttpLogger().logAccess(GenericUtils.getBytes(stringBuffer), this);
    }

    public void finishResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finishResponseMessage(body)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".finishResponseMessage"), (String)"941");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            throw iOException;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"finishMessage() setting partial body false");
            }
            this.setPartialBody(false);
        }
        this.sendFullOutgoing(wsByteBufferArray, this.getResponseImpl());
        this.logFinalResponse();
        HttpInvalidMessageException httpInvalidMessageException = this.checkResponseValidity();
        if (null != httpInvalidMessageException) {
            throw httpInvalidMessageException;
        }
    }

    public VirtualConnection finishResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finishResponseMessage(body,cb)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".finishResponseMessage"), (String)"1010");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            return null;
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getResponseImpl().isChunkedEncodingSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"finishMessage(cb) setting partial body false");
            }
            this.setPartialBody(false);
        }
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendFullOutgoing(wsByteBufferArray, this.getResponseImpl(), HttpISCWriteCallback.getRef());
        if (null != virtualConnection) {
            this.logFinalResponse();
            HttpInvalidMessageException httpInvalidMessageException = this.checkResponseValidity();
            if (null != httpInvalidMessageException) {
                interChannelCallback.error(virtualConnection, (Throwable)httpInvalidMessageException);
                return null;
            }
        }
        return virtualConnection;
    }

    public void finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawResponseMessage(sync)");
        }
        this.setRawBody(true);
        this.finishResponseMessage(wsByteBufferArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawResponseMessage(sync)");
        }
    }

    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawResponseMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.finishResponseMessage(wsByteBufferArray, interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finishRawResponseMessage(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void sendError(HttpError httpError) throws MessageSentException {
        VirtualConnection virtualConnection;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Called sendError with: " + httpError));
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".sendError"), (String)"1116");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to send response without a request msg");
            }
            this.finishSendError(iOException);
            return;
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (null == httpError) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reset null error to Internal Server Error");
            }
            httpError = HttpConstants.STATUS_INTERNAL_ERROR.getHttpError();
        }
        this.setPersistent(false);
        this.getResponse().setStatusCode(httpError.getErrorCode());
        this.getVC().getStateMap().put(HTTP_ERROR_IDENTIFIER, httpError);
        this.getResponseImpl().setConnection(HttpConstants.CONN_CLOSE);
        if (this.getHttpConfig().isErrorLoggingEnabled()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_ERROR, "Sending an error status code: " + httpError.getErrorCode(), (HttpServiceContext)this);
        }
        if (null != (virtualConnection = this.finishResponseMessage(httpError.getErrorBody(), HttpISCWriteErrorCallback.getRef(), false))) {
            this.finishSendError(httpError.getClosingException());
        }
    }

    protected void finishSendError() {
        HttpError httpError;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finishSendError: " + this.getVC()));
        }
        if (null != (httpError = (HttpError)this.getVC().getStateMap().get(HTTP_ERROR_IDENTIFIER))) {
            this.getLink().close(this.getVC(), httpError.getClosingException());
        } else {
            this.getLink().close(this.getVC(), null);
        }
    }

    protected void finishSendError(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finishSendError(exception): " + this.getVC()));
        }
        this.getLink().close(this.getVC(), exception);
    }

    protected boolean check100Continue() {
        if (!this.getRequest().isExpect100Continue()) {
            return true;
        }
        if (this.getLink().getChannel().isStopped()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped, sending error instead of 100-continue");
            }
            try {
                this.sendError(HttpConstants.STATUS_UNAVAILABLE.getHttpError());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + ".check100Continue"), (String)"1206");
            }
            return false;
        }
        if (this.getHttpConfig().isServantRegion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"100 continue not sent on SR");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request contains [Expect: 100-continue]");
        }
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Request contains the Expect: 100 Continues header", (HttpServiceContext)this);
        }
        HttpResponseMessageImpl httpResponseMessageImpl = this.getResponseImpl();
        httpResponseMessageImpl.setStatusCode(HttpConstants.STATUS_CONTINUE);
        httpResponseMessageImpl.setContentLength(0);
        VirtualConnection virtualConnection = this.sendHeaders(httpResponseMessageImpl, Http100ContWriteCallback.getRef());
        if (null == virtualConnection) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Async write of 100 continue still going");
            }
            return false;
        }
        this.resetMsgSentState();
        httpResponseMessageImpl.setStatusCode(HttpConstants.STATUS_OK);
        httpResponseMessageImpl.setContentLength(-1);
        return true;
    }

    public boolean isFormData() {
        return this.bIsRequestFormData;
    }

    protected boolean checkFormData() {
        return false;
    }

    protected void finishFormDataReads() {
        if (!this.isBodyComplete()) {
            try {
                this.getNextReadBuffer();
                if (this.readBodyBuffers(this.getRequestImpl(), true)) {
                    return;
                }
            }
            catch (BodyCompleteException bodyCompleteException) {
            }
            catch (Exception exception) {
                this.formDataError(exception);
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Body fully read: " + this.isBodyComplete()));
        }
        this.getLink().handleDiscrimination();
    }

    protected void formDataError(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing the connection due to exception: " + exception));
        }
        if (this.getHttpConfig().isErrorLoggingEnabled()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "Closing connection to client: " + exception, (HttpServiceContext)this);
        }
        if (exception instanceof SocketTimeoutException) {
            try {
                this.sendError(HttpConstants.STATUS_REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException messageSentException) {
                this.getLink().getDeviceLink().close(this.getVC(), (Exception)messageSentException);
            }
        } else {
            this.getLink().getDeviceLink().close(this.getVC(), exception);
        }
    }

    public void purgeBodyBuffers(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Discarding body buffers...");
        }
        super.clearStorage();
        super.clearTempStorage();
        if (bl) {
            this.getLink().close(this.getVC(), null);
        }
    }

    public WsByteBuffer[] getRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffers(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".getRequestBodyBuffers"), (String)"1281");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers");
            }
            throw iOException;
        }
        if (!this.isIncomingBodyValid()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(sync): No body allowed");
            }
            return null;
        }
        WsByteBuffer[] wsByteBufferArray = null;
        this.setMultiRead(true);
        if (!this.isBodyComplete()) {
            try {
                this.readBodyBuffers(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException bodyCompleteException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(sync): BodyCompleteException");
                }
                return null;
            }
        }
        wsByteBufferArray = this.getAllStorageBuffers();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffers(sync): " + (null == wsByteBufferArray ? 0 : wsByteBufferArray.length)));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffers(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".getRequestBodyBuffers"), (String)"1355");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): read not needed");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): prebody finished");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getRequestImpl(), true)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): illegal body");
            }
            interChannelCallback.error(this.getVC(), (Throwable)illegalHttpBodyException);
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffer(sync)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".getRequestBodyBuffer"), (String)"1436");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers");
            }
            throw iOException;
        }
        if (!this.isIncomingBodyValid()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer wsByteBuffer = this.getNextBuffer();
        if (null == wsByteBuffer && !this.isBodyComplete()) {
            try {
                this.readBodyBuffer(this.getRequestImpl(), false);
            }
            catch (BodyCompleteException bodyCompleteException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(sync): BodyCompleteException");
                }
                return null;
            }
            wsByteBuffer = this.getNextBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRequestBodyBuffer(sync): " + wsByteBuffer));
        }
        return wsByteBuffer;
    }

    public VirtualConnection getRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRequestBodyBuffer(async)");
        }
        if (!this.headersParsed()) {
            IOException iOException = new IOException("Request not read yet");
            FFDCFilter.processException((Throwable)iOException, (String)(CLASS_NAME + ".getRequestBodyBuffer"), (String)"1511");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read a body without headers");
            }
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): no hdrs yet");
            }
            return null;
        }
        if (!this.isIncomingBodyValid() || this.incomingBuffersReady()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): read not needed");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): prebody finished");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getRequestImpl(), true)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): illegal body");
            }
            interChannelCallback.error(this.getVC(), (Throwable)illegalHttpBodyException);
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRequestBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawRequestBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer wsByteBuffer = this.getRequestBodyBuffer();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffer(sync): " + wsByteBuffer));
        }
        return wsByteBuffer;
    }

    public WsByteBuffer[] getRawRequestBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] wsByteBufferArray = this.getRequestBodyBuffers();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffers(sync): " + wsByteBufferArray));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getRequestBodyBuffer(interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffer(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawRequestBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getRequestBodyBuffers(interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawRequestBodyBuffers(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getRequestImpl();
    }

    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.getResponseImpl();
    }

    protected final void parsingComplete() throws Exception {
        super.parsingComplete();
        if (super.isContentLength()) {
            this.checkIncomingMessageLimit(super.getContentLength());
        }
    }

    protected final boolean containsLargeMessage() {
        return this.bContainsLargeMessage;
    }

    protected final void checkIncomingMessageLimit(int n) throws MessageTooLargeException {
        int n2;
        super.addToIncomingMsgSize(n);
        HttpFactoryConfig httpFactoryConfig = this.getLink().getChannel().getFactory().getConfig();
        if (!httpFactoryConfig.areMessagesLimited()) {
            return;
        }
        boolean bl = false;
        int n3 = super.queryIncomingMsgSize();
        if (this.containsLargeMessage()) {
            n2 = httpFactoryConfig.getLargerBufferSize();
            if (n2 < n3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Message hit the higher size limit: " + this));
                }
                bl = true;
            }
        } else {
            n2 = httpFactoryConfig.getMessageSize();
            if (n2 < n3) {
                if (this.getLink().getChannel().getFactory().allowLargeMessage(n3)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Large message allowed in: " + n3 + SPACE + this));
                    }
                    this.bContainsLargeMessage = true;
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Message too large: " + n3 + "/" + n2));
            }
            throw new MessageTooLargeException("Size: " + n3 + " Limit: " + n2);
        }
    }

    public final HttpInboundLink getLink() {
        return this.myLink;
    }

    private void setLink(HttpInboundLink httpInboundLink) {
        this.myLink = httpInboundLink;
    }

    protected boolean reconnectAllowed() {
        return false;
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.getLink() ? null : this.getLink().getObjectFactory();
    }

    public boolean isInboundConnection() {
        return true;
    }
}

