/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpICLReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpIgnoreBodyCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannel;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.impl.BaseConnectionLink;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HttpInboundLink
extends BaseConnectionLink
implements InterChannelCallback,
InboundConnectionLink {
    private static final TraceComponent tc = Tr.register((Class)HttpInboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private HttpInboundServiceContextImpl myInterface = null;
    private HttpInboundChannel myChannel = null;
    private TCPConnectionContext myTSC = null;
    private boolean bPartialParsedRequest = false;
    private int numRequestsProcessed = 0;
    private boolean filterExceptions = false;
    private boolean bIsActive = false;
    private List appSides = new ArrayList(5);

    public HttpInboundLink(HttpInboundChannel httpInboundChannel, VirtualConnection virtualConnection) {
        this.init(virtualConnection, httpInboundChannel);
        this.setHTTPContext(new HttpInboundServiceContextImpl(null, this, this.getVirtualConnection(), this.getChannel().getHttpConfig()));
    }

    public void init(VirtualConnection virtualConnection, HttpInboundChannel httpInboundChannel) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Init on link: " + (Object)((Object)this) + " " + virtualConnection));
        }
        super.init(virtualConnection);
        this.setChannel(httpInboundChannel);
        if (null != this.getHTTPContext()) {
            this.getHTTPContext().setHttpConfig(httpInboundChannel.getHttpConfig());
        }
        this.getVirtualConnection().getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, this);
        this.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying inbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()));
        }
        HttpInboundLink httpInboundLink = this;
        synchronized (httpInboundLink) {
            if (!this.isActive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignoring destroy on an inactive object");
                }
                return;
            }
            this.setActive(false);
        }
        super.destroy();
        for (int i = this.appSides.size() - 1; i >= 0; --i) {
            httpInboundLink = (ConnectionReadyCallback)this.appSides.remove(i);
            httpInboundLink.destroy(exception);
        }
        this.getHTTPContext().clear();
        this.getHTTPContext().destroy();
    }

    private boolean isActive() {
        return this.bIsActive;
    }

    private void setActive(boolean bl) {
        this.bIsActive = bl;
    }

    public final Object getChannelAccessor() {
        return this.myInterface;
    }

    protected HttpInboundServiceContextImpl getHTTPContext() {
        return this.myInterface;
    }

    private void setHTTPContext(HttpInboundServiceContextImpl httpInboundServiceContextImpl) {
        this.myInterface = httpInboundServiceContextImpl;
    }

    private void setChannel(HttpInboundChannel httpInboundChannel) {
        this.myChannel = httpInboundChannel;
    }

    protected final HttpInboundChannel getChannel() {
        return this.myChannel;
    }

    protected boolean maxRequestsServed() {
        if (this.getChannel().isStopping()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped, disabling keep-alive request");
            }
            return true;
        }
        if (!this.getChannel().getHttpConfig().isKeepAliveEnabled()) {
            return true;
        }
        int n = this.getChannel().getHttpConfig().getMaximumPersistentRequests();
        if (0 <= n) {
            return this.numRequestsProcessed >= n;
        }
        return false;
    }

    protected boolean isFirstRequest() {
        return 0 == this.numRequestsProcessed || 1 == this.numRequestsProcessed && this.getHTTPContext().headersParsed();
    }

    protected final boolean isPartiallyParsed() {
        return this.bPartialParsedRequest;
    }

    protected final void setPartiallyParsed(boolean bl) {
        this.bPartialParsedRequest = bl;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("ready: " + (Object)((Object)this) + " " + virtualConnection));
        }
        this.setTCPContext((TCPConnectionContext)this.getDeviceLink().getChannelAccessor());
        this.getHTTPContext().init(this.getTCPContext(), (ConnectionLink)this, virtualConnection, this.getChannel().getHttpConfig());
        if (this.getChannel().getHttpConfig().isErrorLoggingEnabled()) {
            this.getChannel().getHttpConfig().getHttpLogger().log(HttpConstants.LOG_INFO, "Received new connection ", (HttpServiceContext)this.getHTTPContext());
        }
        this.handleNewInformation();
        VirtualConnection virtualConnection2 = null;
        while (this.isPartiallyParsed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Partial request, reading more");
            }
            if (null == (virtualConnection2 = this.getReadSC().read(1L, HttpICLReadCallback.getRef(), false, this.getHTTPContext().getReadTimeout()))) break;
            this.handleNewInformation();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    void handleNewInformation() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing new information: " + this.getVirtualConnection()));
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
        if (!this.isPartiallyParsed() && this.getChannel().isStopped()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped during initial read");
            }
            httpInboundServiceContextImpl.setHeadersParsed();
            httpInboundServiceContextImpl.getResponse().setVersion(HttpConstants.HTTP_VERSION_10);
            this.sendErrorMessage(HttpConstants.STATUS_UNAVAILABLE);
            return;
        }
        boolean bl = false;
        try {
            bl = httpInboundServiceContextImpl.parseMessage();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(unsupportedMethodException);
            this.setPartiallyParsed(false);
            return;
        }
        catch (UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(unsupportedProtocolVersionException);
            this.setPartiallyParsed(false);
            return;
        }
        catch (MessageTooLargeException messageTooLargeException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(HttpConstants.STATUS_ENTITY_TOO_LARGE);
            this.setPartiallyParsed(false);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"HttpInboundLink.handleNewInformation", (String)"1", (Object)((Object)this));
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(exception);
            this.setPartiallyParsed(false);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"HttpInboundLink.handleNewInformation", (String)"2", (Object)((Object)this));
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(throwable);
            this.setPartiallyParsed(false);
            return;
        }
        this.setPartiallyParsed(!bl);
        if (this.isPartiallyParsed()) {
            httpInboundServiceContextImpl.setupReadBuffers(httpInboundServiceContextImpl.getHttpConfig().getIncomingHdrBufferSize(), false);
            return;
        }
        httpInboundServiceContextImpl.setRequestVersion(httpInboundServiceContextImpl.getRequest().getVersionValue());
        httpInboundServiceContextImpl.setRequestMethod(httpInboundServiceContextImpl.getRequest().getMethodValue());
        httpInboundServiceContextImpl.getResponseImpl().init(httpInboundServiceContextImpl);
        ++this.numRequestsProcessed;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Received request number " + this.numRequestsProcessed + " on link " + (Object)((Object)this)));
        }
        if (!httpInboundServiceContextImpl.check100Continue()) {
            return;
        }
        this.handleDiscrimination();
    }

    protected void handleDiscrimination() {
        if (this.getHTTPContext().checkFormData()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Discrimination will be called");
        }
        ConnectionReadyCallback connectionReadyCallback = this.getApplicationCallback();
        DiscriminationProcess discriminationProcess = this.getChannel().getDiscriminationProcess();
        int n = 0;
        try {
            n = discriminationProcess.discriminate(this.getVirtualConnection(), (Object)this.getHTTPContext().getRequest(), (ConnectionLink)this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during discriminate: " + exception));
            }
            this.setPartiallyParsed(false);
            this.sendErrorMessage(exception);
            return;
        }
        if (1 == n) {
            if (null == connectionReadyCallback) {
                this.appSides.add(this.getApplicationCallback());
            } else if (!this.getApplicationCallback().equals(connectionReadyCallback)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received new appside connlink: " + connectionReadyCallback + " vs " + this.getApplicationCallback()));
                }
                if (!this.appSides.contains(this.getApplicationCallback())) {
                    this.appSides.add(this.getApplicationCallback());
                }
            }
            try {
                this.getApplicationCallback().ready(this.getVirtualConnection());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"HttpInboundLink.handleDiscrimination", (String)"1", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("App side ready() threw exception: " + throwable));
                }
                if (!this.isActive()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Link not active, returning out.");
                    }
                    return;
                }
                if (this.getHTTPContext().headersSent()) {
                    this.getDeviceLink().close(this.getVirtualConnection(), new Exception(throwable));
                    return;
                }
                this.sendErrorMessage(HttpConstants.STATUS_UNAVAILABLE);
                return;
            }
        } else {
            this.setPartiallyParsed(false);
            this.sendErrorMessage(new Exception("Discrimination failed"));
        }
    }

    private void sendErrorMessage(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending a 400 for [" + exception + "]"));
        }
        this.sendErrorMessage(HttpConstants.STATUS_BAD_REQUEST);
    }

    private void sendErrorMessage(Throwable throwable) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending a 400 for throwable [" + throwable + "]"));
        }
        this.sendErrorMessage(HttpConstants.STATUS_BAD_REQUEST);
    }

    private void sendErrorMessage(UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending 505 for " + unsupportedProtocolVersionException.getMessage()));
        }
        this.sendErrorMessage(HttpConstants.STATUS_VERSION);
    }

    private void sendErrorMessage(UnsupportedMethodException unsupportedMethodException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending 501 for " + unsupportedMethodException.getMessage()));
        }
        this.sendErrorMessage(HttpConstants.STATUS_NOT_IMPLEMENTED);
    }

    private void sendErrorMessage(StatusCodes statusCodes) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending an error page back [code: " + statusCodes + "]"));
        }
        try {
            this.getHTTPContext().sendError(statusCodes.getHttpError());
        }
        catch (MessageSentException messageSentException) {
            this.close(this.getVirtualConnection(), new Exception("HTTP Message failure"));
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        Object object;
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() called: " + (Object)((Object)this) + " " + virtualConnection));
        }
        boolean bl2 = bl = null != exception || null == this.getHTTPContext();
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() in error state, " + exception));
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
        HttpChannelConfig httpChannelConfig = httpInboundServiceContextImpl.getHttpConfig();
        if (httpInboundServiceContextImpl.containsLargeMessage()) {
            this.getChannel().getFactory().releaseLargeMessage();
        }
        if (!bl && !httpInboundServiceContextImpl.isMessageSent()) {
            try {
                object = httpInboundServiceContextImpl.finishResponseMessage(null, this, false);
                if (null == object) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"finishing response msg async");
                    }
                    return;
                }
            }
            catch (MessageSentException messageSentException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error: message sent exception when flag doesn't agree");
                }
                this.getDeviceLink().close(virtualConnection, (Exception)messageSentException);
                return;
            }
        }
        if (!bl && !httpInboundServiceContextImpl.isIncomingMessageFullyRead()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incoming request body never read.");
            }
            try {
                object = httpInboundServiceContextImpl.getRequestBodyBuffers(HttpIgnoreBodyCallback.getRef(), false);
                if (null == object) {
                    return;
                }
                httpInboundServiceContextImpl.purgeBodyBuffers(false);
            }
            catch (BodyCompleteException bodyCompleteException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received bodycomplete, error condition");
                }
                bl = true;
            }
        }
        if (!bl && httpInboundServiceContextImpl.isPersistent() && this.getChannel().isRunning()) {
            if (httpChannelConfig.isErrorLoggingEnabledAtDebug()) {
                httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_DEBUG, "Reading for another request", (HttpServiceContext)httpInboundServiceContextImpl);
            }
            this.getWriteSC().setBuffers(null);
            if (httpInboundServiceContextImpl.isReadDataAvailable()) {
                object = httpInboundServiceContextImpl.returnLastBuffer();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Pipelined request found: " + object));
                }
                httpInboundServiceContextImpl.clear();
                httpInboundServiceContextImpl.addToCreatedBuffer((WsByteBuffer)object);
                httpInboundServiceContextImpl.disableBufferModification();
                this.ready(virtualConnection);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading for another request...");
            }
            httpInboundServiceContextImpl.clear();
            httpInboundServiceContextImpl.setReadBuffer(null);
            httpInboundServiceContextImpl.setupJITRead(httpChannelConfig.getIncomingHdrBufferSize());
            if (httpChannelConfig.isKeepThread()) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"keepThread says to block read");
                    }
                    this.getReadSC().read(1L, httpChannelConfig.getPersistTimeout());
                    this.ready(virtualConnection);
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"IOException while reading data.");
                    }
                    if (httpChannelConfig.isErrorLoggingEnabled()) {
                        httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_WARN, "Read for another request failed", (HttpServiceContext)httpInboundServiceContextImpl);
                    }
                    this.getWriteSC().setBuffer(null);
                    this.getReadSC().setBuffer(null);
                    this.getDeviceLink().close(virtualConnection, null);
                }
                return;
            }
            this.getReadSC().read(1L, HttpICLReadCallback.getRef(), true, httpChannelConfig.getPersistTimeout());
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Closing connection");
            }
            if (httpChannelConfig.isErrorLoggingEnabled()) {
                httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_INFO, "Closing connection to client", (HttpServiceContext)httpInboundServiceContextImpl);
            }
            if (this.filterExceptions) {
                exception = null;
            }
            this.getWriteSC().setBuffer(null);
            this.getReadSC().setBuffer(null);
            this.getDeviceLink().close(virtualConnection, exception);
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        this.close(virtualConnection, null);
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called on " + (Object)((Object)this) + " " + virtualConnection));
        }
        try {
            this.close(virtualConnection, (Exception)throwable);
        }
        catch (ClassCastException classCastException) {
            this.close(virtualConnection, new Exception("Problem when finishing response"));
        }
    }

    protected final void setFilterCloseExceptions(boolean bl) {
        this.filterExceptions = bl;
    }

    private void setTCPContext(TCPConnectionContext tCPConnectionContext) {
        this.myTSC = tCPConnectionContext;
    }

    private TCPConnectionContext getTCPContext() {
        return this.myTSC;
    }

    private TCPReadRequestContext getReadSC() {
        return this.getTCPContext().getReadInterface();
    }

    private TCPWriteRequestContext getWriteSC() {
        return this.getTCPContext().getWriteInterface();
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.getChannel().getObjectFactory();
    }
}

