/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpISCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpISCWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpISCWriteCallback myInstance = null;

    private HttpISCWriteCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpISCWriteCallback();
        }
    }

    public static final HttpISCWriteCallback getRef() {
        if (null == myInstance) {
            HttpISCWriteCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ISC in complete()");
            }
            return;
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)v;
        if (null != tCPWriteRequestContext) {
            tCPWriteRequestContext.setBuffers(null);
        }
        if (httpInboundServiceContextImpl.isMessageSent()) {
            httpInboundServiceContextImpl.logFinalResponse();
            HttpInvalidMessageException httpInvalidMessageException = httpInboundServiceContextImpl.checkResponseValidity();
            if (null != httpInvalidMessageException) {
                httpInboundServiceContextImpl.setPersistent(false);
                if (null != httpInboundServiceContextImpl.getAppWriteCallback()) {
                    httpInboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)httpInvalidMessageException);
                }
                return;
            }
        }
        if (null != httpInboundServiceContextImpl.getAppWriteCallback()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling write complete callback of app channel.");
            }
            if (httpInboundServiceContextImpl.getResponseImpl().isTemporaryStatusCode()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Temp response sent, resetting send flags");
                }
                httpInboundServiceContextImpl.resetWrite();
            }
            httpInboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No available app channel callback");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ISC in error()");
            }
            return;
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)v;
        if (httpInboundServiceContextImpl.getHttpConfig().isErrorLoggingEnabled()) {
            httpInboundServiceContextImpl.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)httpInboundServiceContextImpl);
        }
        httpInboundServiceContextImpl.setPersistent(false);
        if (null != httpInboundServiceContextImpl.getAppWriteCallback()) {
            httpInboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)iOException);
        } else {
            httpInboundServiceContextImpl.getLink().getDeviceLink().close(virtualConnection, (Exception)iOException);
        }
    }
}

