/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpICLReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpICLReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpICLReadCallback myInstance = null;

    private HttpICLReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpICLReadCallback();
        }
    }

    public static final HttpICLReadCallback getRef() {
        if (null == myInstance) {
            HttpICLReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ICL in complete()");
            }
            return;
        }
        do {
            httpInboundLink.handleNewInformation();
            if (httpInboundLink.isPartiallyParsed()) continue;
            return;
        } while (null != (virtualConnection = tCPReadRequestContext.read(1L, this, false, httpInboundLink.getHTTPContext().getReadTimeout())));
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null ICL in error()");
            }
            return;
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = httpInboundLink.getHTTPContext();
        httpInboundServiceContextImpl.setPersistent(false);
        httpInboundLink.setFilterCloseExceptions(true);
        if (httpInboundLink.isFirstRequest() || httpInboundLink.isPartiallyParsed()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error, sending 408 timeout back");
                }
                if (httpInboundServiceContextImpl.getHttpConfig().isErrorLoggingEnabled()) {
                    httpInboundServiceContextImpl.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "A read during the connection failed due to a socket exception.", (HttpServiceContext)httpInboundServiceContextImpl);
                }
                httpInboundServiceContextImpl.setHeadersParsed();
                httpInboundServiceContextImpl.sendError(HttpConstants.STATUS_REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException messageSentException) {
                FFDCFilter.processException((Throwable)messageSentException, (String)(this.getClass().getName() + ".error"), (String)"152");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MessageSent error during ICL read error");
                }
                httpInboundLink.close(virtualConnection, iOException);
            }
        } else {
            httpInboundLink.close(virtualConnection, iOException);
        }
    }
}

