/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class Http100ContWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)Http100ContWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static Http100ContWriteCallback myInstance = null;

    private Http100ContWriteCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new Http100ContWriteCallback();
        }
    }

    public static final Http100ContWriteCallback getRef() {
        if (null == myInstance) {
            Http100ContWriteCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        HttpInboundLink httpInboundLink;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called for " + virtualConnection));
        }
        if (null == (httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null link object");
            }
            return;
        }
        httpInboundLink.getHTTPContext().resetMsgSentState();
        HttpResponseMessage httpResponseMessage = httpInboundLink.getHTTPContext().getResponse();
        httpResponseMessage.setStatusCode(HttpConstants.STATUS_OK);
        httpResponseMessage.setContentLength(-1);
        httpInboundLink.handleDiscrimination();
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        HttpInboundServiceContextImpl httpInboundServiceContextImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called for " + virtualConnection));
        }
        if (null == (httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null ISC, unable to continue");
            }
            return;
        }
        if (httpInboundServiceContextImpl.getHttpConfig().isErrorLoggingEnabled()) {
            httpInboundServiceContextImpl.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)httpInboundServiceContextImpl);
        }
        httpInboundServiceContextImpl.getLink().close(virtualConnection, iOException);
    }
}

