/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericMessageImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.cookies.impl.CookieCacheData;
import com.ibm.ws.http.channel.cookies.impl.CookieHeaderByteParser;
import com.ibm.ws.http.channel.cookies.impl.CookieUtils;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.matcher.impl.ConnectionMatcher;
import com.ibm.ws.http.channel.matcher.impl.ContentEncodingMatcher;
import com.ibm.ws.http.channel.matcher.impl.ExpectMatcher;
import com.ibm.ws.http.channel.matcher.impl.HttpHeaderMatcher;
import com.ibm.ws.http.channel.matcher.impl.TransferEncodingMatcher;
import com.ibm.ws.http.channel.matcher.impl.VersionMatcher;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.ws.http.channel.srt.HttpDate;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

public abstract class HttpBaseMessageImpl
extends GenericMessageImpl
implements HttpBaseMessage {
    private static final TraceComponent tc = Tr.register((Class)HttpBaseMessageImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String HDR_LIST_SEPARATOR = ", ";
    private static final int GROWTH_SIZE = 2;
    private static final int DEFAULT_SIZE = 5;
    private static final byte QUOTE = 34;
    private static Charset DEF_CHARSET = null;
    private static final String CHARSET_ID = "charset";
    private static final String CHARSET_EQUALS_ID = "charset=";
    private static final String DEFAULT_MIMETYPE = "text/html";
    private transient int myAge = -1;
    private transient int myContentLength = -1;
    private transient int myMaxForwards = -1;
    private transient ConnectionValues[] myConnectionVals = null;
    private transient int indexConnection = 0;
    private transient TransferEncodingValues[] myTransferVals = null;
    private transient int indexTransfer = 0;
    private transient List myContentEncoding = new LinkedList();
    private transient boolean bIsIncoming = false;
    private transient boolean bIsKeepAliveSet = true;
    private transient boolean bIsCloseSet = false;
    private transient boolean bIsChunkedEncodingSet = false;
    private transient boolean bIs100Continue = false;
    private transient boolean bIsCommitted = false;
    private HttpTrailersImpl myTrailers = null;
    private VersionValues myVersion = HttpConstants.HTTP_VERSION_11;
    private transient HttpServiceContextImpl myHSC = null;
    private transient CookieCacheData cookieCache = null;
    private transient CookieCacheData cookie2Cache = null;
    private transient CookieCacheData setCookieCache = null;
    private transient CookieCacheData setCookie2Cache = null;
    private transient CookieHeaderByteParser cookieParser;

    protected HttpBaseMessageImpl() {
        super(HttpHeaderMatcher.getRef(), HttpConstants.NUM_HDRS);
        this.myConnectionVals = new ConnectionValues[5];
        this.myTransferVals = new TransferEncodingValues[5];
        this.cookieParser = new CookieHeaderByteParser();
    }

    protected void init(HttpServiceContext httpServiceContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing message: " + this + " with " + httpServiceContext));
        }
        if (null == httpServiceContext) {
            return;
        }
        this.setMyHSC((HttpServiceContextImpl)httpServiceContext);
        HttpChannelConfig httpChannelConfig = this.getServiceContext().getHttpConfig();
        super.init(httpChannelConfig.isDirectBufferType(), httpChannelConfig.getOutgoingHdrBufferSize(), httpChannelConfig.getIncomingHdrBufferSize(), httpChannelConfig.getByteCacheSize());
        this.setLimitOfTokenSize(httpChannelConfig.getLimitOfFieldSize());
        this.setLimitOnNumberOfHeaders(httpChannelConfig.getLimitOnNumberOfHeaders());
    }

    public void clear() {
        super.clear();
        this.setMyAge(-1);
        this.setMyContentLength(-1);
        this.setMyMaxForwards(-1);
        this.setMyVersion(HttpConstants.HTTP_VERSION_11);
        this.removeLocalConnection();
        this.removeLocalTransferEncoding();
        this.removeLocalContentEncoding();
        this.setExpect100Continue(false);
        this.cookieCache = null;
        this.cookie2Cache = null;
        this.setCookieCache = null;
        this.setCookie2Cache = null;
        this.bIsCommitted = false;
        this.setBinaryParseState(14);
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    public void destroy() {
        super.destroy();
        this.setMyHSC(null);
        this.setIncoming(false);
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    public void debug() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Version: " + this.getVersion()));
            Tr.debug((TraceComponent)tc, (String)("Age: " + this.getAge()));
            Tr.debug((TraceComponent)tc, (String)("MaxForwards: " + this.getMaxForwards()));
            Tr.debug((TraceComponent)tc, (String)("ContentLength: " + this.getContentLength()));
            Tr.debug((TraceComponent)tc, (String)("CookieCache:  " + this.getCookieCache(HttpConstants.HDR_COOKIE)));
            Tr.debug((TraceComponent)tc, (String)("Cookie2Cache:  " + this.getCookieCache(HttpConstants.HDR_COOKIE2)));
            Tr.debug((TraceComponent)tc, (String)("SetCookieCache:  " + this.getCookieCache(HttpConstants.HDR_SET_COOKIE)));
            Tr.debug((TraceComponent)tc, (String)("Set2CookieCache:  " + this.getCookieCache(HttpConstants.HDR_SET_COOKIE2)));
            Tr.debug((TraceComponent)tc, (String)("isIncoming: " + this.isIncoming()));
            Tr.debug((TraceComponent)tc, (String)("isKeepAliveSet: " + this.isKeepAliveSet()));
            Tr.debug((TraceComponent)tc, (String)("isConnectionSet: " + this.isConnectionSet()));
            Tr.debug((TraceComponent)tc, (String)("isChunkedEncodingSet: " + this.isChunkedEncodingSet()));
            Tr.debug((TraceComponent)tc, (String)("Trailers: " + this.getTrailersImpl()));
            if (null != this.getTrailersImpl()) {
                this.getTrailersImpl().debug();
            }
            super.debug();
        }
    }

    private void duplicateCookieCaches(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (null != this.cookieCache) {
            httpBaseMessageImpl.cookieCache = this.cookieCache.duplicate();
        }
        if (null != this.cookie2Cache) {
            httpBaseMessageImpl.cookie2Cache = this.cookie2Cache.duplicate();
        }
        if (null != this.setCookieCache) {
            httpBaseMessageImpl.setCookieCache = this.setCookieCache.duplicate();
        }
        if (null != this.setCookie2Cache) {
            httpBaseMessageImpl.setCookie2Cache = this.setCookie2Cache.duplicate();
        }
    }

    protected void duplicate(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (null == httpBaseMessageImpl) {
            throw new NullPointerException("Null message");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Duplicating the base message");
        }
        super.duplicate(httpBaseMessageImpl);
        httpBaseMessageImpl.setVersion(this.getVersionValue());
        if (null != this.getTrailersImpl()) {
            httpBaseMessageImpl.myTrailers = this.getTrailersImpl().duplicate();
        }
        this.duplicateCookieCaches(httpBaseMessageImpl);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.setHeaderMatcher(HttpHeaderMatcher.getRef());
        super.readExternal(objectInput);
        String string = (String)objectInput.readObject();
        try {
            this.setVersion(string);
        }
        catch (UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown HTTP version: " + string));
            }
            throw new IOException("Failed parse of version: " + string);
        }
        if (1 == objectInput.readByte()) {
            this.myTrailers = (HttpTrailersImpl)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getVersion());
        if (null != this.getTrailersImpl()) {
            objectOutput.writeByte(1);
            objectOutput.writeObject(this.getTrailersImpl());
        } else {
            objectOutput.writeByte(0);
        }
    }

    public final boolean isIncoming() {
        return this.bIsIncoming;
    }

    public final void setIncoming(boolean bl) {
        this.bIsIncoming = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Incoming flag now " + bl + " on " + this));
        }
    }

    public final boolean isCommitted() {
        return this.bIsCommitted;
    }

    public final void setCommitted() {
        this.bIsCommitted = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Committed flag set on " + this));
        }
    }

    protected final void setCommitted(boolean bl) {
        this.bIsCommitted = bl;
    }

    public boolean isBodyExpected() {
        if (this.isChunkedEncodingSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says chunked encoding: " + this));
            }
            return true;
        }
        if (0 < this.getContentLength()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says content-length: " + this.getContentLength() + " " + this));
            }
            return true;
        }
        if (this.isBodyEncoded()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Msg contains Content-Encoding header");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No body expected at base layer: " + this));
        }
        return false;
    }

    public boolean isBodyAllowed() {
        return 0 != this.getContentLength();
    }

    public boolean shouldUpdateBodyHeaders() {
        return true;
    }

    protected void setMyHSC(HttpServiceContextImpl httpServiceContextImpl) {
        this.myHSC = httpServiceContextImpl;
    }

    public final HttpServiceContextImpl getServiceContext() {
        return this.myHSC;
    }

    public final HttpOutboundServiceContextImpl getOutboundSC() {
        return (HttpOutboundServiceContextImpl)this.getServiceContext();
    }

    public final HttpInboundServiceContextImpl getInboundSC() {
        return (HttpInboundServiceContextImpl)this.getServiceContext();
    }

    protected final HttpObjectFactory getObjectFactory() {
        if (null == this.getServiceContext()) {
            return null;
        }
        return this.getServiceContext().getObjectFactory();
    }

    public final HttpTrailersImpl getTrailersImpl() {
        return this.myTrailers;
    }

    public HttpTrailersImpl createTrailers() {
        if (null == this.myTrailers) {
            this.myTrailers = null == this.getObjectFactory() ? new HttpTrailersImpl() : this.getObjectFactory().getTrailers();
            this.myTrailers.init(this.shouldAllocateDirectBuffer(), this.getOutgoingBufferSize(), this.getIncomingBufferSize(), this.getByteCacheSize());
        }
        return this.myTrailers;
    }

    public HttpTrailers getTrailers() {
        if (null == this.getTrailersImpl() && this.containsHeader(HttpConstants.HDR_TRAILER)) {
            this.createTrailers();
        }
        return this.getTrailersImpl();
    }

    public final VersionValues getVersionValue() {
        return this.myVersion;
    }

    public final String getVersion() {
        return null != this.getVersionValue() ? this.getVersionValue().getName() : null;
    }

    private void setMyVersion(VersionValues versionValues) {
        this.myVersion = versionValues;
    }

    public void setVersion(VersionValues versionValues) {
        if (null == versionValues) {
            throw new NullPointerException("Version");
        }
        this.setMyVersion(versionValues);
        if (!this.isConnectionSet() && this.getVersionValue().equals(HttpConstants.HTTP_VERSION_10)) {
            this.setKeepAliveSetFlag(false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setVersion(v): set version to " + this.getVersion()));
        }
    }

    public void setVersion(String string) throws UnsupportedProtocolVersionException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Called setVersion(S): " + string));
        }
        if (null == string) {
            throw new NullPointerException("Version");
        }
        VersionValues versionValues = VersionMatcher.getRef().matchVersion(string);
        if (null == versionValues) {
            try {
                versionValues = VersionValues.makeUndefinedValue(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedProtocolVersionException("Unsupported: " + string);
            }
        }
        this.setVersion(versionValues);
    }

    public void setVersion(byte[] byArray) throws UnsupportedProtocolVersionException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Called setVersion(b): " + HttpChannelUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            throw new NullPointerException("Version");
        }
        VersionValues versionValues = VersionMatcher.getRef().matchVersion(byArray);
        if (null == versionValues) {
            try {
                versionValues = VersionValues.makeUndefinedValue(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedProtocolVersionException("Unsupported: " + GenericUtils.getEnglishString(byArray));
            }
        }
        this.setVersion(versionValues);
    }

    public final void setCurrentDate() {
        HttpDate httpDate = new HttpDate();
        httpDate.setTime(QuickApproxTime.getRef().getApproxTime());
        byte[] byArray = new byte[HttpDate.DATELEN];
        httpDate.getBytes(byArray, 0, byArray.length);
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_DATE, byArray);
    }

    private void setMyAge(int n) {
        this.myAge = n;
    }

    public final void setAge(int n) {
        if (-1 > n) {
            throw new IllegalArgumentException("Age: " + n);
        }
        this.setMyAge(n);
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_AGE, GenericUtils.asByteArray(n));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_AGE);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAge(i) set to " + n));
        }
    }

    public final boolean setAge(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAge(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.setMyAge(-1);
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_AGE);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (-1 > n) {
                return false;
            }
            if (this.getAge() == n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Age already " + n));
                }
                return true;
            }
            this.setMyAge(n);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_AGE, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getAge() {
        return this.myAge;
    }

    private void setMyContentLength(int n) {
        this.myContentLength = n;
    }

    public final void setContentLength(int n) {
        if (-1 > n) {
            throw new IllegalArgumentException("Length: " + n);
        }
        if (this.getContentLength() == n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ContentLength already set to " + this.getContentLength()));
            }
            return;
        }
        this.setMyContentLength(n);
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LENGTH, GenericUtils.asByteArray(this.getContentLength()));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_LENGTH);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ContentLength set to " + this.getContentLength()));
        }
    }

    public final boolean setContentLength(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setContentLength(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.setMyContentLength(-1);
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONTENT_LENGTH);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (-1 > n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid Content-Length: " + n));
                }
                return false;
            }
            if (-1 != this.getContentLength()) {
                if (this.getContentLength() == n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setContentLength(b,b) already: " + n));
                    }
                    return true;
                }
                this.getServiceContext().setPersistent(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setContentLength(b,b) mismatch: " + this.getContentLength()));
                }
                return false;
            }
            this.setMyContentLength(n);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LENGTH, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getContentLength() {
        return this.myContentLength;
    }

    private void setMyMaxForwards(int n) {
        this.myMaxForwards = n;
    }

    public final void setMaxForwards(int n) {
        if (-1 > n) {
            throw new IllegalArgumentException("MaxForwards: " + n);
        }
        this.setMyMaxForwards(n);
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_MAX_FORWARDS, GenericUtils.asByteArray(n));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_MAX_FORWARDS);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MaxForwards set to " + n));
        }
    }

    public final boolean setMaxForwards(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMaxForwards(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.setMyMaxForwards(-1);
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_MAX_FORWARDS);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (-1 > n) {
                return false;
            }
            if (this.getMaxForwards() == n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Max-Forwards already " + n));
                }
                return true;
            }
            this.setMyMaxForwards(n);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_MAX_FORWARDS, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getMaxForwards() {
        return this.myMaxForwards;
    }

    private void setupConnectionClose() {
        if (this.isKeepAliveSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Replacing Keep-Alive with Close in msg");
            }
            this.replaceConnection(HttpConstants.CONN_KEEPALIVE, HttpConstants.CONN_CLOSE);
            this.setKeepAliveSetFlag(false);
        } else if (!HttpConstants.HTTP_VERSION_10.equals(this.getVersionValue())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding Close to non-persistent msg");
            }
            this.addConnection(HttpConstants.CONN_CLOSE);
            this.commitConnection();
        }
        this.removeHeader(HttpConstants.HDR_KEEP_ALIVE);
        this.setCloseSetFlag(true);
    }

    private void replaceConnection(ConnectionValues connectionValues, ConnectionValues connectionValues2) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (null == this.myConnectionVals[i]) continue;
            if (this.myConnectionVals[i].equals(connectionValues)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Replacing " + connectionValues.getName() + " with " + connectionValues2.getName()));
                }
                this.myConnectionVals[i] = connectionValues2;
                this.commitConnection();
                return;
            }
            if (!this.myConnectionVals[i].equals(connectionValues2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(connectionValues2.getName() + " already present"));
            }
            return;
        }
        this.addConnection(connectionValues2);
        this.commitConnection();
    }

    private void addConnection(ConnectionValues connectionValues) {
        if (null == connectionValues) {
            return;
        }
        if (this.indexConnection == this.myConnectionVals.length) {
            ConnectionValues[] connectionValuesArray = this.myConnectionVals;
            this.myConnectionVals = new ConnectionValues[connectionValuesArray.length + 2];
            System.arraycopy(connectionValuesArray, 0, this.myConnectionVals, 0, connectionValuesArray.length);
        }
        if (connectionValues.equals(HttpConstants.CONN_KEEPALIVE)) {
            this.setKeepAliveSetFlag(true);
            this.setCloseSetFlag(false);
        } else if (connectionValues.equals(HttpConstants.CONN_CLOSE)) {
            this.setKeepAliveSetFlag(false);
            this.setCloseSetFlag(true);
        }
        this.myConnectionVals[this.indexConnection] = connectionValues;
        ++this.indexConnection;
    }

    public final void setConnection(ConnectionValues connectionValues) {
        this.removeLocalConnection();
        if (null == connectionValues || connectionValues.equals(HttpConstants.CONN_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing Connection(v) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
        } else {
            this.addConnection(connectionValues);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, connectionValues.getByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setConnection(v) set to " + connectionValues));
            }
        }
    }

    public final void setConnection(ConnectionValues[] connectionValuesArray) {
        this.removeLocalConnection();
        if (null == connectionValuesArray || 0 == connectionValuesArray.length || connectionValuesArray[0].equals(HttpConstants.CONN_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing Connection(v[]) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
        } else {
            for (int i = 0; i < connectionValuesArray.length; ++i) {
                this.addConnection(connectionValuesArray[i]);
            }
            this.commitConnection();
        }
    }

    void removeConnection(ConnectionValues connectionValues) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (!connectionValues.equals(this.myConnectionVals[i])) continue;
            this.myConnectionVals[i] = null;
            if (HttpConstants.CONN_CLOSE.equals(connectionValues)) {
                this.setCloseSetFlag(false);
            } else if (HttpConstants.CONN_KEEPALIVE.equals(connectionValues)) {
                this.setKeepAliveSetFlag(this.getVersionValue().equals(HttpConstants.HTTP_VERSION_11));
            }
            return;
        }
    }

    private void removeLocalConnection() {
        this.setKeepAliveSetFlag(this.getVersionValue().equals(HttpConstants.HTTP_VERSION_11));
        this.setCloseSetFlag(false);
        for (int i = 0; i < this.indexConnection; ++i) {
            this.myConnectionVals[i] = null;
        }
        this.indexConnection = 0;
    }

    private void commitConnection() {
        if (0 == this.indexConnection || HttpConstants.CONN_NOTSET.equals(this.myConnectionVals[0])) {
            this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
            return;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indexConnection; ++i) {
            ConnectionValues connectionValues = this.myConnectionVals[i];
            if (null == connectionValues || HttpConstants.CONN_NOTSET.equals(connectionValues)) continue;
            if (!bl) {
                stringBuffer.append(HDR_LIST_SEPARATOR);
            } else {
                bl = false;
            }
            stringBuffer.append(this.myConnectionVals[i].getName());
        }
        if (bl) {
            this.removeLocalConnection();
            this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Committing Connection: " + stringBuffer.toString()));
        }
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, stringBuffer.toString());
    }

    public final boolean setConnection(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConnection(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalConnection();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
            }
        } else {
            this.matchAndParseConnection(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, byArray);
            }
        }
        return true;
    }

    public final void removeConnectionHeader(byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing connection header: " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalConnection();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ConnectionValues connectionValues = (ConnectionValues)ConnectionMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == connectionValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                connectionValues = ConnectionValues.makeUndefinedValue(byArray2);
            }
            this.removeConnection(connectionValues);
        }
    }

    private boolean findToken(byte[] byArray, TokenDelimiter tokenDelimiter) {
        int n;
        int n2;
        int n3 = n2 = -1 == tokenDelimiter.next ? 0 : tokenDelimiter.next;
        if (n2 >= byArray.length) {
            return false;
        }
        while (32 == byArray[n2]) {
            if (++n2 >= byArray.length) {
                return false;
            }
            if (44 != byArray[n2] || ++n2 < byArray.length) continue;
            return false;
        }
        int n4 = n = n2 + 1;
        while (n < byArray.length && 44 != byArray[n]) {
            if (32 == byArray[n]) {
                n4 = GenericUtils.skipWhiteSpace(byArray, n);
                if (n4 >= byArray.length || 44 == byArray[n4]) break;
                n = n4;
            }
            ++n;
            ++n4;
        }
        tokenDelimiter.start = n2;
        tokenDelimiter.next = n4 + 1;
        tokenDelimiter.length = n - n2;
        return true;
    }

    private void matchAndParseConnection(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ConnectionValues connectionValues = (ConnectionValues)ConnectionMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == connectionValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                connectionValues = ConnectionValues.makeUndefinedValue(byArray2);
            }
            this.addConnection(connectionValues);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsed out " + this.indexConnection + " Connection header values"));
        }
    }

    public final ConnectionValues[] getConnection() {
        int n = 0;
        for (int i = 0; i < this.indexConnection; ++i) {
            if (null == this.myConnectionVals[i]) continue;
            ++n;
        }
        if (0 == n) {
            return new ConnectionValues[]{HttpConstants.CONN_NOTSET};
        }
        ConnectionValues[] connectionValuesArray = new ConnectionValues[n];
        int n2 = 0;
        for (int i = 0; i < this.indexConnection; ++i) {
            if (null == this.myConnectionVals[i]) continue;
            connectionValuesArray[n2] = this.myConnectionVals[i];
            ++n2;
        }
        return connectionValuesArray;
    }

    public final boolean isKeepAliveSet() {
        return this.bIsKeepAliveSet;
    }

    private void setKeepAliveSetFlag(boolean bl) {
        this.bIsKeepAliveSet = bl;
    }

    public final boolean isCloseSet() {
        return this.bIsCloseSet;
    }

    private void setCloseSetFlag(boolean bl) {
        this.bIsCloseSet = bl;
    }

    public final boolean isConnectionSet() {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (null == this.myConnectionVals[i]) continue;
            return true;
        }
        return false;
    }

    public final ContentEncodingValues getOutermostEncoding() {
        int n = this.myContentEncoding.size() - 1;
        if (0 > n) {
            return null;
        }
        return (ContentEncodingValues)this.myContentEncoding.get(n);
    }

    public final void removeOutermostEncoding() {
        int n = this.myContentEncoding.size() - 1;
        if (0 > n) {
            return;
        }
        ContentEncodingValues contentEncodingValues = (ContentEncodingValues)this.myContentEncoding.get(n);
        if (0 == n) {
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
            this.removeLocalContentEncoding();
        } else {
            this.myContentEncoding.remove(n);
            Iterator iterator = this.myContentEncoding.iterator();
            ContentEncodingValues contentEncodingValues2 = (ContentEncodingValues)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(contentEncodingValues2.getName());
            while (iterator.hasNext()) {
                stringBuffer.append(HDR_LIST_SEPARATOR);
                contentEncodingValues2 = (ContentEncodingValues)iterator.next();
                stringBuffer.append(contentEncodingValues2.getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Storing [" + stringBuffer.toString() + "]"));
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, stringBuffer.toString());
        }
        if (HttpConstants.CONTENT_ENCODING_GZIP.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        } else if (HttpConstants.CONTENT_ENCODING_XGZIP.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        } else if (HttpConstants.CONTENT_ENCODING_DEFLATE.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        }
    }

    public final boolean isBodyEncoded() {
        return 0 < this.myContentEncoding.size();
    }

    public final boolean isDeflateOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_DEFLATE.equals(this.getOutermostEncoding());
    }

    public final boolean isGZipOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_GZIP.equals(this.getOutermostEncoding());
    }

    public final boolean isXGZipOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_XGZIP.equals(this.getOutermostEncoding());
    }

    private void addContentEncoding(ContentEncodingValues contentEncodingValues) {
        this.myContentEncoding.add(contentEncodingValues);
    }

    private void removeContentEncoding(ContentEncodingValues contentEncodingValues) {
        this.myContentEncoding.remove(contentEncodingValues);
    }

    private byte[] getCommaSeparatedValues(HeaderKeys headerKeys) {
        int n = this.getNumberOfHeaderInstances(headerKeys);
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            return this.getHeaderAsByteArray(headerKeys);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHeaderAsString(headerKeys));
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(HDR_LIST_SEPARATOR);
            stringBuffer.append(this.getHeaderAsString(headerKeys, i));
        }
        return GenericUtils.getBytes(stringBuffer);
    }

    protected final void appendContentEncoding(ContentEncodingValues contentEncodingValues) {
        byte[] byArray = this.getCommaSeparatedValues(HttpConstants.HDR_CONTENT_ENCODING);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Appending Content-Encoding " + contentEncodingValues.getName() + " to " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            byArray = contentEncodingValues.getByteArray();
        } else {
            byte[] byArray2 = new byte[byArray.length + contentEncodingValues.getByteArray().length + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 44;
            byArray2[byArray.length + 1] = 32;
            System.arraycopy(contentEncodingValues.getByteArray(), 0, byArray2, byArray.length + 2, contentEncodingValues.getByteArray().length);
            byArray = byArray2;
        }
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, byArray);
        this.addContentEncoding(contentEncodingValues);
    }

    public final void setContentEncoding(ContentEncodingValues contentEncodingValues) {
        this.removeLocalContentEncoding();
        if (null == contentEncodingValues || contentEncodingValues.equals(HttpConstants.CONTENT_ENCODING_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing ContentEncoding(v) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
        } else {
            this.addContentEncoding(contentEncodingValues);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, contentEncodingValues.getByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ContentEncoding(v) set to " + contentEncodingValues));
            }
        }
    }

    public final void setContentEncoding(ContentEncodingValues[] contentEncodingValuesArray) {
        this.removeLocalContentEncoding();
        if (null == contentEncodingValuesArray || 0 == contentEncodingValuesArray.length || contentEncodingValuesArray[0].equals(HttpConstants.CONTENT_ENCODING_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing ContentEncoding(v[]) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
        } else {
            this.addContentEncoding(contentEncodingValuesArray[0]);
            StringBuffer stringBuffer = new StringBuffer(contentEncodingValuesArray[0].getName());
            for (int i = 1; i < contentEncodingValuesArray.length; ++i) {
                stringBuffer.append(HDR_LIST_SEPARATOR);
                stringBuffer.append(contentEncodingValuesArray[i].getName());
                this.addContentEncoding(contentEncodingValuesArray[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Committing Content-Encoding: " + stringBuffer.toString()));
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, stringBuffer.toString());
        }
    }

    public final boolean setContentEncoding(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setContentEncoding(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalContentEncoding();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
            }
        } else {
            this.matchAndParseContent(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, byArray);
            }
        }
        return true;
    }

    public final void removeContentEncodingHeader(byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing content-encoding header: " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalContentEncoding();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ContentEncodingValues contentEncodingValues = (ContentEncodingValues)ContentEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == contentEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                contentEncodingValues = ContentEncodingValues.makeUndefinedValue(byArray2);
            }
            this.removeContentEncoding(contentEncodingValues);
        }
    }

    private void removeLocalContentEncoding() {
        this.myContentEncoding.clear();
    }

    private void matchAndParseContent(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ContentEncodingValues contentEncodingValues = (ContentEncodingValues)ContentEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == contentEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                contentEncodingValues = ContentEncodingValues.makeUndefinedValue(byArray2);
            }
            this.addContentEncoding(contentEncodingValues);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsed out " + this.myContentEncoding.size() + " Content-Encoding header values"));
        }
    }

    public final ContentEncodingValues[] getContentEncoding() {
        if (0 == this.myContentEncoding.size()) {
            return new ContentEncodingValues[]{HttpConstants.CONTENT_ENCODING_NOTSET};
        }
        ContentEncodingValues[] contentEncodingValuesArray = new ContentEncodingValues[this.myContentEncoding.size()];
        this.myContentEncoding.toArray(contentEncodingValuesArray);
        return contentEncodingValuesArray;
    }

    private void addTransferEncoding(TransferEncodingValues transferEncodingValues) {
        if (this.indexTransfer == this.myTransferVals.length) {
            TransferEncodingValues[] transferEncodingValuesArray = this.myTransferVals;
            this.myTransferVals = new TransferEncodingValues[transferEncodingValuesArray.length + 2];
            System.arraycopy(transferEncodingValuesArray, 0, this.myTransferVals, 0, transferEncodingValuesArray.length);
        }
        if (!this.isChunkedEncodingSet()) {
            this.bIsChunkedEncodingSet = transferEncodingValues.equals(HttpConstants.TRANSFER_ENCODING_CHUNKED);
        }
        this.myTransferVals[this.indexTransfer] = transferEncodingValues;
        ++this.indexTransfer;
    }

    protected void appendTransferEncoding(TransferEncodingValues transferEncodingValues) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Appending Transfer-Encoding: " + transferEncodingValues));
        }
        this.addTransferEncoding(transferEncodingValues);
        this.commitTransferEncoding();
    }

    public final void setTransferEncoding(TransferEncodingValues transferEncodingValues) {
        this.removeLocalTransferEncoding();
        if (null == transferEncodingValues || transferEncodingValues.equals(HttpConstants.TRANSFER_ENCODING_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing TransferEncoding(v) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
        } else {
            this.addTransferEncoding(transferEncodingValues);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, transferEncodingValues.getByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TransferEncoding(v) set to " + transferEncodingValues));
            }
        }
    }

    public final void setTransferEncoding(TransferEncodingValues[] transferEncodingValuesArray) {
        this.removeLocalTransferEncoding();
        if (null == transferEncodingValuesArray || 0 == transferEncodingValuesArray.length || transferEncodingValuesArray[0].equals(HttpConstants.TRANSFER_ENCODING_NOTSET)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing TransferEncoding(v[]) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
        } else {
            for (int i = 0; i < transferEncodingValuesArray.length; ++i) {
                this.addTransferEncoding(transferEncodingValuesArray[i]);
            }
            this.commitTransferEncoding();
        }
    }

    private void commitTransferEncoding() {
        if (0 == this.indexTransfer || HttpConstants.TRANSFER_ENCODING_NOTSET.equals(this.myTransferVals[0])) {
            this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
            return;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indexTransfer; ++i) {
            TransferEncodingValues transferEncodingValues = this.myTransferVals[i];
            if (null == transferEncodingValues || HttpConstants.TRANSFER_ENCODING_NOTSET.equals(transferEncodingValues)) continue;
            if (!bl) {
                stringBuffer.append(HDR_LIST_SEPARATOR);
            } else {
                bl = false;
            }
            stringBuffer.append(this.myTransferVals[i].getName());
        }
        if (bl) {
            this.removeLocalTransferEncoding();
            this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Committing Transfer-Encoding: " + stringBuffer.toString()));
        }
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, stringBuffer.toString());
    }

    protected final void removeTransferEncoding(TransferEncodingValues transferEncodingValues) {
        for (int i = 0; i < this.indexTransfer; ++i) {
            if (!transferEncodingValues.equals(this.myTransferVals[i])) continue;
            this.myTransferVals[i] = null;
            this.commitTransferEncoding();
            if (transferEncodingValues.equals(HttpConstants.TRANSFER_ENCODING_CHUNKED)) {
                this.bIsChunkedEncodingSet = false;
            }
            return;
        }
    }

    private void removeLocalTransferEncoding() {
        this.bIsChunkedEncodingSet = false;
        for (int i = 0; i < this.indexTransfer; ++i) {
            this.myTransferVals[i] = null;
        }
        this.indexTransfer = 0;
    }

    public final boolean setTransferEncoding(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTransferEncoding(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalTransferEncoding();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
            }
        } else {
            this.matchAndParseTransfer(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, byArray);
            }
        }
        return true;
    }

    public final void removeTransferEncodingHeader(byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing transfer-encoding header: " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.removeLocalTransferEncoding();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        block0: while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            TransferEncodingValues transferEncodingValues = (TransferEncodingValues)TransferEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == transferEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                transferEncodingValues = TransferEncodingValues.makeUndefinedValue(byArray2);
            } else if (HttpConstants.TRANSFER_ENCODING_CHUNKED.equals(transferEncodingValues)) {
                this.bIsChunkedEncodingSet = false;
            }
            for (int i = 0; i < this.indexTransfer; ++i) {
                if (!transferEncodingValues.equals(this.myTransferVals[i])) continue;
                this.myTransferVals[i] = null;
                continue block0;
            }
        }
    }

    private void matchAndParseTransfer(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            TransferEncodingValues transferEncodingValues = (TransferEncodingValues)TransferEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == transferEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                transferEncodingValues = TransferEncodingValues.makeUndefinedValue(byArray2);
            }
            this.addTransferEncoding(transferEncodingValues);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsed out " + this.indexTransfer + " Transfer-Encoding header values"));
        }
    }

    public final TransferEncodingValues[] getTransferEncoding() {
        int n = 0;
        for (int i = 0; i < this.indexTransfer; ++i) {
            if (null == this.myTransferVals[i]) continue;
            ++n;
        }
        if (0 == n) {
            return new TransferEncodingValues[]{HttpConstants.TRANSFER_ENCODING_NOTSET};
        }
        TransferEncodingValues[] transferEncodingValuesArray = new TransferEncodingValues[n];
        int n2 = 0;
        for (int i = 0; i < this.indexTransfer; ++i) {
            if (null == this.myTransferVals[i]) continue;
            transferEncodingValuesArray[n2] = this.myTransferVals[i];
            ++n2;
        }
        return transferEncodingValuesArray;
    }

    public final boolean isChunkedEncodingSet() {
        return this.bIsChunkedEncodingSet;
    }

    private void addExpect(ExpectValues expectValues) {
        if (HttpConstants.EXPECT_100CONTINUE.equals(expectValues)) {
            this.setExpect100Continue(true);
        }
    }

    private void matchAndParseExpect(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ExpectValues expectValues = (ExpectValues)ExpectMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == expectValues) continue;
            this.addExpect(expectValues);
        }
    }

    public final void setExpect(byte[] byArray) {
        this.setExpect100Continue(false);
        if (null == byArray) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing Expect(b) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(byArray);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setExpect(b): 100-continue is " + this.isExpect100Continue()));
            }
        }
    }

    public final void setExpect(String string) {
        this.setExpect100Continue(false);
        if (null == string) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing Expect(s) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(GenericUtils.getEnglishBytes(string));
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setExpect(s): 100-continue is " + this.isExpect100Continue()));
            }
        }
    }

    public final void setExpect(ExpectValues expectValues) {
        this.setExpect100Continue(false);
        if (null == expectValues) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing Expect(v) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.addExpect(expectValues);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, expectValues.getByteArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setExpect(v): 100-continue is " + this.isExpect100Continue()));
            }
        }
    }

    public final boolean setExpect(byte[] byArray, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setExpect(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.setExpect100Continue(false);
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
            }
        } else {
            this.matchAndParseExpect(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, byArray);
            }
        }
        return true;
    }

    public final void removeExpectHeader(byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing expect header: " + GenericUtils.getEnglishString(byArray)));
        }
        if (null == byArray) {
            this.bIs100Continue = false;
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ExpectValues expectValues = (ExpectValues)ExpectMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == expectValues || !HttpConstants.EXPECT_100CONTINUE.equals(expectValues)) continue;
            this.bIs100Continue = false;
        }
    }

    public final byte[] getExpect() {
        return this.getCommaSeparatedValues(HttpConstants.HDR_EXPECT);
    }

    public final boolean isExpect100Continue() {
        return this.bIs100Continue;
    }

    private void setExpect100Continue(boolean bl) {
        this.bIs100Continue = bl;
    }

    public final String getMIMEType() {
        return this.parseMIMEType();
    }

    private String parseMIMEType() {
        if (!this.containsHeader(HttpConstants.HDR_CONTENT_TYPE)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parseMIMEType: no Content-Type header present");
            }
            return null;
        }
        byte[] byArray = this.getHeaderAsByteArray(HttpConstants.HDR_CONTENT_TYPE);
        int n = byArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (59 != byArray[i]) continue;
            n2 = i;
            break;
        }
        if (-1 == n2) {
            n2 = n;
        }
        return HttpChannelUtils.getEnglishString(byArray, 0, n2);
    }

    public final void setMIMEType(String string) {
        int n = string.indexOf(";");
        if (-1 != n) {
            string = string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(";");
        stringBuffer.append(CHARSET_EQUALS_ID);
        stringBuffer.append(this.parseCharset());
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, stringBuffer.toString());
    }

    public final Charset getCharset() {
        return this.parseCharset();
    }

    private Charset parseCharset() {
        privCharsetLookup privCharsetLookup2;
        block4: {
            String string = this.parseCharacterEncoding(this.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE));
            if (null != string) {
                privCharsetLookup2 = new privCharsetLookup(string);
                try {
                    return (Charset)AccessController.doPrivileged(privCharsetLookup2);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("Unknown charset name: " + string));
                }
            }
        }
        if (null == DEF_CHARSET) {
            privCharsetLookup2 = new privCharsetLookup("ISO-8859-1");
            DEF_CHARSET = (Charset)AccessController.doPrivileged(privCharsetLookup2);
        }
        return DEF_CHARSET;
    }

    private String parseCharacterEncoding(String string) {
        int n;
        boolean bl;
        if (null == string) {
            return null;
        }
        int n2 = string.indexOf(CHARSET_EQUALS_ID);
        if (-1 == n2) {
            return null;
        }
        boolean bl2 = bl = '\"' == string.charAt(n2 += CHARSET_EQUALS_ID.length());
        if (bl) {
            ++n2;
        }
        if (-1 == (n = string.indexOf(59, n2))) {
            n = string.length();
        }
        if (bl && '\"' == string.charAt(n - 1)) {
            --n;
        }
        return string.substring(n2, n).trim();
    }

    public final void setCharset(Charset charset) {
        if (null == charset) {
            throw new NullPointerException(CHARSET_ID);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parseMIMEType();
        if (null == string) {
            string = DEFAULT_MIMETYPE;
        }
        stringBuffer.append(string);
        stringBuffer.append(";");
        stringBuffer.append(CHARSET_EQUALS_ID);
        stringBuffer.append(charset.toString());
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void headerComplianceCheck() throws MessageSentException {
        HttpServiceContextImpl httpServiceContextImpl = this.getServiceContext();
        if (httpServiceContextImpl.headersSent()) {
            throw new MessageSentException("Headers already sent.");
        }
        try {
            try {
                if (this.getVersionValue().equals(HttpConstants.HTTP_VERSION_11)) {
                    if (-1 == this.getContentLength() && !this.isChunkedEncodingSet()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Partial bodied 1.1 output");
                        }
                        if (httpServiceContextImpl.isOutgoingBodyValid()) {
                            this.addTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
                            this.commitTransferEncoding();
                        }
                    }
                    if (!httpServiceContextImpl.isPersistent() && !this.isCloseSet()) {
                        this.setupConnectionClose();
                    }
                } else if (this.getVersionValue().equals(HttpConstants.HTTP_VERSION_10)) {
                    if (this.isChunkedEncodingSet()) {
                        this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
                        this.removeLocalTransferEncoding();
                        httpServiceContextImpl.setPersistent(false);
                    }
                    if (!httpServiceContextImpl.isPersistent() || -1 == this.getContentLength()) {
                        if (!this.isCloseSet()) {
                            this.setupConnectionClose();
                        }
                        httpServiceContextImpl.setPersistent(false);
                    } else if (httpServiceContextImpl.isPersistent() && !this.isKeepAliveSet() && !this.isCloseSet()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding Keep-Alive to persistent 1.0 msg");
                        }
                        this.addConnection(HttpConstants.CONN_KEEPALIVE);
                        this.commitConnection();
                    }
                }
                if (!this.containsHeader(HttpConstants.HDR_DATE)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating a missing Date header");
                    }
                    this.setCurrentDate();
                }
                this.removeSpecialHeader(HttpConstants.HDR_$WSZIP);
                this.removeSpecialHeader(HttpConstants.HDR_$WSORIGCL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)(this.getClass().getName() + ".headerComplianceCheck"), (String)"1996", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Too many headers in message for compliance to finish");
                }
                Object var4_3 = null;
                if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) return;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent()));
                }
                httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
                httpServiceContextImpl.setPersistent(false);
                return;
            }
            Object var4_2 = null;
            if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) throw throwable;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent()));
            }
            httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
            httpServiceContextImpl.setPersistent(false);
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent()));
        }
        httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
        httpServiceContextImpl.setPersistent(false);
    }

    protected void parsingComplete() throws MalformedMessageException {
    }

    public abstract WsByteBuffer[] marshallBinaryFirstLine();

    public WsByteBuffer[] marshallBinaryMessage() throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallBinaryMessage");
        }
        this.preMarshallMessage();
        WsByteBuffer[] wsByteBufferArray = this.marshallBinaryFirstLine();
        this.headerComplianceCheck();
        wsByteBufferArray = this.marshallBinaryHeaders(wsByteBufferArray);
        this.postMarshallMessage();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallBinaryMessage");
        }
        return wsByteBufferArray;
    }

    public boolean parseMessage(WsByteBuffer wsByteBuffer, boolean bl) throws Exception {
        int n;
        boolean bl2;
        this.getServiceContext().checkIncomingMessageLimit(wsByteBuffer.remaining());
        boolean bl3 = bl2 = this.getServiceContext().getHttpConfig().isBinaryTransportEnabled() ? this.parseBinaryMessage(wsByteBuffer) : super.parseMessage(wsByteBuffer, bl);
        if (bl2 && 0 < (n = wsByteBuffer.remaining())) {
            this.getServiceContext().addToIncomingMsgSize(-n);
        }
        return bl2;
    }

    public boolean parseLineDiscrim(WsByteBuffer wsByteBuffer) throws Exception {
        this.getServiceContext().checkIncomingMessageLimit(wsByteBuffer.remaining());
        if (this.getServiceContext().getHttpConfig().isBinaryTransportEnabled()) {
            return this.parseBinaryFirstLine(wsByteBuffer);
        }
        return this.parseLine(wsByteBuffer);
    }

    public abstract boolean parseBinaryFirstLine(WsByteBuffer var1) throws MalformedMessageException;

    public boolean parseBinaryMessage(WsByteBuffer wsByteBuffer) throws Exception {
        boolean bl = false;
        if (!this.isFirstLineComplete()) {
            bl = this.parseBinaryFirstLine(wsByteBuffer);
        }
        if (this.isFirstLineComplete()) {
            bl = this.parseBinaryHeaders(wsByteBuffer, HttpConstants.HDR_$WSAT);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseBinaryMessage returning " + bl));
        }
        return bl;
    }

    private void marshallCookieCache(CookieCacheData cookieCacheData) {
        if (null != cookieCacheData && cookieCacheData.isDirty()) {
            List list = this.getAllCookies(cookieCacheData.getHeaderType());
            this.removeSpecialHeader(cookieCacheData.getHeaderType());
            this.marshallCookies(list, cookieCacheData.getHeaderType());
            cookieCacheData.setIsDirty(false);
        }
    }

    protected void preMarshallMessage() throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preMarshallMessage");
        }
        super.preMarshallMessage();
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preMarshallMessage");
        }
    }

    protected void postMarshallMessage() {
        super.postMarshallMessage();
    }

    protected final byte[] getCookieValue(String string, HeaderKeys headerKeys) {
        int n = this.getNumberOfHeaderInstances(headerKeys);
        if (0 == n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Header not present (" + headerKeys.getName() + ")"));
            }
            return null;
        }
        if ('\"' == string.charAt(0) && '\"' == string.charAt(string.length() - 1)) {
            string = string.substring(1, string.length() - 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCookieValue: [" + string + "] num: " + n));
        }
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = this.getHeaderAsByteArray(headerKeys, i);
            while (n2 < byArray.length) {
                int n3;
                if (32 == byArray[n2] && (n2 = GenericUtils.skipWhiteSpace(byArray, n2)) >= byArray.length) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Ran out of data");
                    continue;
                }
                boolean bl2 = bl = 34 == byArray[n2];
                if (bl) {
                    ++n2;
                }
                for (n3 = 0; n3 < string.length() && string.charAt(n3) == byArray[n2]; ++n3) {
                    if (++n2 < byArray.length) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Only the cookie name found");
                    }
                    return null;
                }
                if (n3 != string.length()) {
                    n2 = GenericUtils.skipToChar(byArray, n2, (byte)59) + 1;
                    continue;
                }
                if (bl) {
                    if (34 != byArray[n2]) {
                        n2 = GenericUtils.skipToChar(byArray, n2, (byte)59) + 1;
                        continue;
                    }
                    ++n2;
                }
                if (n2 < byArray.length && 32 == byArray[n2]) {
                    n2 = GenericUtils.skipWhiteSpace(byArray, n2);
                }
                if (n2 < byArray.length && 61 != byArray[n2]) {
                    n2 = GenericUtils.skipToChar(byArray, n2, (byte)59) + 1;
                    continue;
                }
                if (++n2 >= byArray.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cookie name found but no value after =");
                    }
                    return null;
                }
                if (32 == byArray[n2] && (n2 = GenericUtils.skipWhiteSpace(byArray, n2)) >= byArray.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cookie name with just whitespace val");
                    }
                    return null;
                }
                bl = 34 == byArray[n2];
                int n4 = n2++;
                if (bl) {
                    while (n2 < byArray.length && 34 != byArray[n2] && 59 != byArray[n2]) {
                        ++n2;
                    }
                    if (34 == byArray[n2]) {
                        ++n2;
                    }
                } else {
                    while (n2 < byArray.length && 59 != byArray[n2]) {
                        if (32 == byArray[n2]) {
                            int n5 = GenericUtils.skipWhiteSpace(byArray, n2);
                            if (n5 >= byArray.length || 59 == byArray[n5]) break;
                            n2 = n5;
                        }
                        ++n2;
                    }
                }
                if (n4 >= n2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No actual value found");
                    }
                    return null;
                }
                byte[] byArray2 = new byte[n2 - n4];
                System.arraycopy(byArray, n4, byArray2, 0, byArray2.length);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getCookieValue: returning [" + GenericUtils.getEnglishString(byArray2) + "]"));
                }
                return byArray2;
            }
            n2 = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cookie name not found");
        }
        return null;
    }

    protected final Cookie getCookie(String string, HeaderKeys headerKeys) {
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        Cookie cookie = cookieCacheData.getCookie(string);
        if (null != cookie) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found " + string + " in cache"));
            }
            return cookie;
        }
        int n = this.getNumberOfHeaderInstances(headerKeys);
        for (int i = cookieCacheData.getHeaderIndex(); i < n; ++i) {
            List list = this.getCookieParser().parse(this.getHeaderAsByteArray(headerKeys, i), headerKeys);
            cookieCacheData.addParsedCookies(list);
            cookieCacheData.incrementHeaderIndex();
            Iterator iterator = list.iterator();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                cookie = (Cookie)iterator.next();
                if (!cookie.getName().equals(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found parsed Cookie-->" + string));
                }
                return cookie;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCookie --> " + string + " of type " + headerKeys.getName() + " not found"));
        }
        return null;
    }

    private void parseAllCookies(CookieCacheData cookieCacheData, HeaderKeys headerKeys) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing all cookies for " + headerKeys.getName()));
        }
        int n = this.getNumberOfHeaderInstances(headerKeys);
        for (int i = cookieCacheData.getHeaderIndex(); i < n; ++i) {
            List list = this.getCookieParser().parse(this.getHeaderAsByteArray(headerKeys, i), headerKeys);
            cookieCacheData.addParsedCookies(list);
            cookieCacheData.incrementHeaderIndex();
        }
    }

    protected final List getAllCookies(HeaderKeys headerKeys) {
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null == cookieCacheData.getParsedList()) {
            return new LinkedList();
        }
        return new LinkedList(cookieCacheData.getParsedList());
    }

    protected final List getAllCookies(HeaderKeys headerKeys, HeaderKeys headerKeys2) {
        LinkedList linkedList = new LinkedList();
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null != cookieCacheData.getParsedList()) {
            linkedList.addAll(cookieCacheData.getParsedList());
        }
        cookieCacheData = this.getCookieCache(headerKeys2);
        this.parseAllCookies(cookieCacheData, headerKeys2);
        if (null != cookieCacheData.getParsedList()) {
            linkedList.addAll(cookieCacheData.getParsedList());
        }
        return linkedList;
    }

    protected final boolean addCookie(Cookie cookie, HeaderKeys headerKeys) {
        if (this.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not adding cookie to committed message: " + cookie.getName() + " " + headerKeys.getName()));
            }
            return false;
        }
        this.getCookieCache(headerKeys).addNewCookie((Cookie)cookie.clone());
        return true;
    }

    private CookieHeaderByteParser getCookieParser() {
        if (null == this.cookieParser) {
            this.cookieParser = new CookieHeaderByteParser();
        }
        return this.cookieParser;
    }

    private synchronized CookieCacheData getCookieCache(HeaderKeys headerKeys) {
        if (headerKeys.equals(HttpConstants.HDR_COOKIE)) {
            if (null == this.cookieCache) {
                this.cookieCache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookieCache, headerKeys);
                }
            }
            return this.cookieCache;
        }
        if (headerKeys.equals(HttpConstants.HDR_COOKIE2)) {
            if (null == this.cookie2Cache) {
                this.cookie2Cache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookie2Cache, headerKeys);
                }
            }
            return this.cookie2Cache;
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE)) {
            if (null == this.setCookieCache) {
                this.setCookieCache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookieCache, headerKeys);
                }
            }
            return this.setCookieCache;
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE2)) {
            if (null == this.setCookie2Cache) {
                this.setCookie2Cache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookie2Cache, headerKeys);
                }
            }
            return this.setCookie2Cache;
        }
        throw new IllegalArgumentException(headerKeys.getName());
    }

    protected final boolean deleteCookie(String string, HeaderKeys headerKeys) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("deleteCookie: " + string));
        }
        boolean bl = false;
        if (this.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not removing committed cookie: " + string));
            }
        } else {
            Cookie cookie = this.getCookie(string, headerKeys);
            if (null != cookie) {
                bl = this.getCookieCache(headerKeys).removeCookie(cookie);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("deleteCookie: " + bl));
        }
        return bl;
    }

    public final boolean containsCookie(String string, HeaderKeys headerKeys) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        if (null == headerKeys) {
            throw new NullPointerException("Header");
        }
        return null != this.getCookie(string, headerKeys);
    }

    private void marshallCookies(List list, HeaderKeys headerKeys) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallCookies");
        }
        Iterator iterator = list.iterator();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.appendHeader(headerKeys, CookieUtils.toString((Cookie)iterator.next(), headerKeys));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallCookies");
        }
    }

    private class privCharsetLookup
    implements PrivilegedAction {
        private String encoding;

        public privCharsetLookup(String string) {
            this.encoding = string;
        }

        public Object run() {
            return Charset.forName(this.encoding);
        }
    }

    private class TokenDelimiter {
        protected int start = -1;
        protected int length = -1;
        protected int next = -1;

        private TokenDelimiter() {
        }
    }
}

