/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.GenericStreamServiceContext;
import java.net.InetAddress;

public abstract class GenericStreamServiceContextImpl
implements GenericStreamServiceContext {
    private static final TraceComponent tc = Tr.register((Class)GenericStreamServiceContextImpl.class, (String)"GenericBNF", (String)"com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int DEFAULT_REMOTE_PORT = 1024;
    private static final int DEFAULT_LOCAL_PORT = 9080;
    private static final int BUFFERS_INITIAL_SIZE = 10;
    private static final int BUFFERS_MIN_GROWTH = 5;
    private InetAddress myRemoteAddr = null;
    private InetAddress myLocalAddr = null;
    private int myRemotePort = 1024;
    private int myLocalPort = 9080;
    private WsByteBuffer[] myBuffers = new WsByteBuffer[10];
    private int myBuffersIndex = -1;

    public final InetAddress getRemoteAddr() {
        return this.myRemoteAddr;
    }

    public final void setRemoteAddr(InetAddress inetAddress) {
        this.myRemoteAddr = inetAddress;
    }

    public final InetAddress getLocalAddr() {
        return this.myLocalAddr;
    }

    public final void setLocalAddr(InetAddress inetAddress) {
        this.myLocalAddr = inetAddress;
    }

    public final int getRemotePort() {
        return this.myRemotePort;
    }

    public final void setRemotePort(int n) {
        this.myRemotePort = n;
    }

    public final int getLocalPort() {
        return this.myLocalPort;
    }

    public final void setLocalPort(int n) {
        this.myLocalPort = n;
    }

    public void clear() {
        int n = this.myBuffersIndex;
        for (int i = 0; i <= n; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing " + this.myBuffers[i]));
            }
            this.myBuffers[i].release();
            this.myBuffers[i] = null;
        }
        this.myBuffersIndex = -1;
    }

    public void destroy() {
        int n = this.myBuffersIndex;
        for (int i = 0; i <= n; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing " + this.myBuffers[i]));
            }
            this.myBuffers[i].release();
            this.myBuffers[i] = null;
        }
        this.myBuffersIndex = -1;
    }

    public void addToCreatedBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        if ((n = ++this.myBuffersIndex) == this.myBuffers.length) {
            int n2 = n + 5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing buffer array size to " + n2));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n2];
            System.arraycopy(this.myBuffers, 0, wsByteBufferArray, 0, n);
            this.myBuffers = wsByteBufferArray;
        }
        this.myBuffers[n] = wsByteBuffer;
    }

    protected void addToCreatedBuffer(WsByteBuffer[] wsByteBufferArray) {
        int n = this.myBuffersIndex + 1;
        int n2 = wsByteBufferArray.length + n - this.myBuffers.length;
        if (0 < n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Increasing the buffer array (list)");
            }
            int n3 = this.myBuffers.length + (n2 > 5 ? n2 : 5);
            WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n3];
            if (0 < n) {
                System.arraycopy(this.myBuffers, 0, wsByteBufferArray2, 0, n);
            }
            this.myBuffers = wsByteBufferArray2;
        }
        System.arraycopy(wsByteBufferArray, 0, this.myBuffers, n, wsByteBufferArray.length);
        this.myBuffersIndex += wsByteBufferArray.length;
    }

    public WsByteBuffer returnLastBuffer() {
        int n;
        WsByteBuffer wsByteBuffer = null;
        if (-1 != (n = this.myBuffersIndex--)) {
            wsByteBuffer = this.myBuffers[n];
            this.myBuffers[n] = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning " + wsByteBuffer));
        }
        return wsByteBuffer;
    }
}

