/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.ws.genericbnf.impl.TokenCodes;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.GenericMessage;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class GenericMessageImpl
extends BNFHeadersImpl
implements GenericMessage {
    private static final TraceComponent tc = Tr.register((Class)GenericMessageImpl.class, (String)"GenericBNF", (String)"com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private transient boolean completedFirstLine = false;
    private transient int numFirstLineTokensRead = 0;

    protected GenericMessageImpl(QuickHeaderMatcher quickHeaderMatcher, int n) {
        super(quickHeaderMatcher, n);
    }

    protected abstract void setParsedFirstToken(byte[] var1) throws Exception;

    protected abstract void setParsedSecondToken(byte[] var1) throws Exception;

    protected abstract void setParsedThirdToken(byte[] var1) throws Exception;

    protected abstract void parsingComplete() throws MalformedMessageException;

    protected abstract byte[] getMarshalledFirstToken();

    protected abstract byte[] getMarshalledSecondToken();

    protected abstract byte[] getMarshalledThirdToken();

    protected void setFirstLineComplete(boolean bl) {
        this.completedFirstLine = bl;
    }

    protected final boolean isFirstLineComplete() {
        return this.completedFirstLine;
    }

    private void setNumberFirstLineTokens(int n) {
        this.numFirstLineTokensRead = n;
    }

    protected final int getNumberFirstLineTokens() {
        return this.numFirstLineTokensRead;
    }

    public boolean parseLine(WsByteBuffer wsByteBuffer) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseLine called for " + this));
        }
        boolean bl = false;
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        while (!bl) {
            if (0 == this.getNumberFirstLineTokens()) {
                tokenCodes = this.skipCRLFs(wsByteBuffer);
                if (TokenCodes.TOKEN_RC_DELIM.equals(tokenCodes)) {
                    tokenCodes = this.parseTokenExtract(wsByteBuffer, (byte)32, false);
                    if (!tokenCodes.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                        this.setParsedFirstToken(this.getParsedToken());
                    }
                } else {
                    if (TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes)) break;
                    if (TokenCodes.TOKEN_RC_CRLF.equals(tokenCodes)) {
                        throw new MalformedMessageException("Too many leading CRLFs");
                    }
                }
            } else if (1 == this.getNumberFirstLineTokens()) {
                tokenCodes = this.parseTokenExtract(wsByteBuffer, (byte)32, true);
                if (!tokenCodes.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedSecondToken(this.getParsedToken());
                    if (tokenCodes.equals(TokenCodes.TOKEN_RC_CRLF)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Received CRLF after second token");
                        }
                        bl = true;
                    }
                }
            } else if (2 == this.getNumberFirstLineTokens()) {
                tokenCodes = this.parseCRLFTokenExtract(wsByteBuffer);
                if (!tokenCodes.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedThirdToken(this.getParsedToken());
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (tokenCodes.equals(TokenCodes.TOKEN_RC_MOREDATA)) break;
            this.setParsedToken(null);
            ++this.numFirstLineTokensRead;
        }
        if (bl) {
            this.parsingComplete();
            this.setFirstLineComplete(true);
            this.decrementBytePositionIgnoringLFs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseLine returning " + bl + " for " + this));
        }
        return bl;
    }

    public WsByteBuffer[] marshallLine() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallLine");
        }
        this.setBytePosition(0);
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        wsByteBufferArray = this.putBytes(this.getMarshalledFirstToken(), wsByteBufferArray);
        wsByteBufferArray = this.putByte((byte)32, wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getMarshalledSecondToken(), wsByteBufferArray);
        wsByteBufferArray = this.putByte((byte)32, wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getMarshalledThirdToken(), wsByteBufferArray);
        wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallLine");
        }
        return wsByteBufferArray;
    }

    public boolean parseMessage(WsByteBuffer wsByteBuffer, boolean bl) throws Exception {
        boolean bl2 = false;
        if (!this.isFirstLineComplete()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Parsing First Line");
            }
            bl2 = this.parseLine(wsByteBuffer);
        }
        if (this.isFirstLineComplete()) {
            bl2 = this.parseHeaders(wsByteBuffer, bl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseMessage returning " + bl2));
        }
        return bl2;
    }

    public WsByteBuffer[] marshallMessage() throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallMessage");
        }
        this.preMarshallMessage();
        WsByteBuffer[] wsByteBufferArray = this.marshallLine();
        this.headerComplianceCheck();
        wsByteBufferArray = this.marshallHeaders(wsByteBufferArray);
        this.postMarshallMessage();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got marshalled object " + wsByteBufferArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallMessage");
        }
        return wsByteBufferArray;
    }

    protected abstract void headerComplianceCheck() throws MessageSentException;

    protected void preMarshallMessage() throws MessageSentException {
        super.resetByteCache();
    }

    protected void postMarshallMessage() {
    }

    public void clear() {
        super.clear();
        this.setFirstLineComplete(false);
        this.setNumberFirstLineTokens(0);
    }

    protected void destroy() {
        super.destroy();
    }

    public void debug() {
        super.debug();
    }

    public void duplicate(GenericMessageImpl genericMessageImpl) {
        if (null == genericMessageImpl) {
            throw new NullPointerException("Null message passed to duplicate");
        }
        super.duplicate(genericMessageImpl);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }
}

