/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog;

import com.tivoli.pd.jras.pdjlog.jlog.Formatter;
import com.tivoli.pd.jras.pdjlog.jlog.Gate;
import com.tivoli.pd.jras.pdjlog.jlog.IConstants;
import com.tivoli.pd.jras.pdjlog.jlog.IFormatter;
import com.tivoli.pd.jras.pdjlog.jlog.IHandler;
import com.tivoli.pd.jras.pdjlog.jlog.ILogRecord;
import com.tivoli.pd.jras.pdjlog.jlog.LogObject;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.NestedException;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.b;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.c;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.e;
import com.tivoli.pd.jras.pdjlog.jlog.utilities.f;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Handler
extends Gate
implements IConstants,
IHandler,
Runnable {
    private static final String o = "(C) Copyright IBM Corp. 1998, 2000.";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    private transient b p;
    private transient boolean q;
    public transient boolean r;
    private transient boolean s;
    private transient boolean t;
    protected Hashtable u;
    private int v;
    protected transient int w;
    private transient int x;
    private int y;
    private int z;
    protected transient Object A;
    protected transient Object B;
    protected transient Object C;
    protected transient Object D;
    protected transient PrintWriter E = null;
    private transient c F;
    private transient c G;
    private String H;
    protected transient Thread I;

    public Handler() {
        this(null, null);
    }

    public Handler(String string) {
        this(string, null);
    }

    public Handler(String string, String string2) {
        super(string, string2);
        this.start();
    }

    public void init() {
        block8: {
            block7: {
                super.init();
                if (this.A == null) {
                    this.A = new Object();
                }
                if (this.B == null) {
                    this.B = new Object();
                }
                if (this.C == null) {
                    this.C = new Object();
                }
                if (this.D == null) {
                    this.D = new Object();
                }
                this.I = null;
                this.w = 0;
                this.x = 0;
                this.r = false;
                this.s = false;
                this.t = false;
                this.setBackupEnabled(false);
                this.setBackupCapacity(50000);
                this.setMaxRetries(5);
                this.setRetryInterval(5000);
                if (this.u != null) break block7;
                this.u = new Hashtable();
                if (!LogObject.i) break block8;
            }
            this.u.clear();
        }
        this.addFormatter(new Formatter());
        this.H = "";
        this.E = null;
        this.G = this.F = new e(10000);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("queueCapacity", new Integer(this.getQueueCapacity()).toString());
        properties.put("isBackupEnabled", new Boolean(this.isBackupEnabled()).toString());
        properties.put("backupCapacity", new Integer(this.getBackupCapacity()).toString());
        properties.put("isCircular", new Boolean(this.isCircular()).toString());
        properties.put("maxRetries", new Integer(this.getMaxRetries()).toString());
        properties.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        if (!this.H.equals("")) {
            properties.put("formatterNames", this.H);
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("queueCapacity");
        if (string != null) {
            this.setQueueCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("isBackupEnabled")) != null) {
            this.setBackupEnabled(new Boolean(string));
        }
        if ((string = properties.getProperty("backupCapacity")) != null) {
            this.setBackupCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("maxRetries")) != null) {
            this.setMaxRetries(new Integer(string));
        }
        if ((string = properties.getProperty("retryInterval")) != null) {
            this.setRetryInterval(new Integer(string));
        }
        if ((string = properties.getProperty("isCircular")) != null) {
            this.setCircular(new Boolean(string));
        }
        if ((string = properties.getProperty("formatterNames")) != null) {
            this.H = string;
        }
    }

    public Thread getThread() {
        return this.I;
    }

    public int getQueueCount() {
        int n2;
        block3: {
            block2: {
                if (!this.isCircular()) break block2;
                n2 = this.F.a() + this.G.a();
                if (!LogObject.i) break block3;
            }
            n2 = this.F.a();
        }
        return n2;
    }

    public int getQueueCapacity() {
        return this.F.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueCapacity(int n2) throws IllegalStateException {
        if (n2 >= 0) {
            Object object = this.B;
            synchronized (object) {
                Object object2 = this.C;
                synchronized (object2) {
                    if (n2 != this.getQueueCapacity()) {
                        if (this.F.a() != 0 || this.G.a() != 0) {
                            throw new IllegalStateException(LogUtil.getLogMessage("ERR_QUEUE_STATE"));
                        }
                        this.a(n2, this.F.e());
                    }
                }
            }
        }
    }

    public boolean isBackupEnabled() {
        return this.q;
    }

    public void setBackupEnabled(boolean bl2) {
        block6: {
            block7: {
                boolean bl3;
                block9: {
                    block8: {
                        bl3 = LogObject.i;
                        if (!bl2) break block7;
                        if (this.p != null) break block8;
                        this.p = new b(this.getBackupCapacity());
                        if (!bl3) break block9;
                    }
                    this.p.i();
                }
                try {
                    this.p.g();
                    this.q = true;
                    break block6;
                }
                catch (IOException iOException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    iOException.printStackTrace();
                    if (!bl3) break block6;
                }
            }
            if (this.p != null) {
                this.p.i();
            }
            this.p = null;
            this.q = false;
        }
    }

    public int getBackupCapacity() {
        return this.v;
    }

    public void setBackupCapacity(int n2) {
        if (n2 >= 0) {
            this.v = n2;
        }
    }

    public int getMaxRetries() {
        return this.y;
    }

    public void setMaxRetries(int n2) {
        if (n2 >= 0) {
            this.y = n2;
        }
    }

    public int getRetryInterval() {
        return this.z;
    }

    public void setRetryInterval(int n2) {
        if (n2 >= 0) {
            this.z = n2;
        }
    }

    public boolean isCircular() {
        return this.F.e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircular(boolean bl2) throws IllegalStateException {
        Object object = this.B;
        synchronized (object) {
            Object object2 = this.C;
            synchronized (object2) {
                if (this.F.e() != bl2) {
                    if (this.F.a() != 0 || this.G.a() != 0) {
                        throw new IllegalStateException(LogUtil.getLogMessage("ERR_QUEUE_STATE"));
                    }
                    this.a(this.getQueueCapacity(), bl2);
                }
            }
        }
    }

    protected void a(int n2, boolean bl2) {
        block3: {
            block2: {
                if (!bl2) break block2;
                this.F = new f(n2);
                this.G = new e(0);
                if (!LogObject.i) break block3;
            }
            this.G = this.F = new e(n2);
        }
    }

    public void addFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.u.put(string, iFormatter);
                if (!LogObject.i) continue;
            }
        }
    }

    public void removeFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.u.remove(string);
                if (!LogObject.i) continue;
            }
        }
    }

    public Enumeration getFormatters() {
        return this.u.elements();
    }

    public abstract void openDevice() throws NestedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.A;
        synchronized (object) {
            if (this.E != null) {
                this.E.flush();
                this.E.close();
            }
            this.E = null;
            this.r = false;
        }
    }

    public void start() {
        if (this.I == null) {
            this.s = false;
            this.t = false;
            String string = this.getClass().getName() + ":" + this.getName();
            this.I = new Thread((Runnable)this, string);
            this.I.setDaemon(true);
            this.I.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean bl2 = LogObject.i;
        while (!this.s) {
            ILogRecord iLogRecord;
            block16: {
                object = this.B;
                synchronized (object) {
                    block17: {
                        iLogRecord = this.G.f();
                        if (iLogRecord != null) break block16;
                        if (!this.t) break block17;
                        this.s = true;
                        if (!bl2) break block16;
                    }
                    try {
                        this.B.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (iLogRecord == null) continue;
            object = this.C;
            synchronized (object) {
                this.C.notifyAll();
            }
            this.a(iLogRecord);
            if (!bl2) continue;
        }
        this.closeDevice();
        if (this.p != null) {
            this.p.i();
        }
        object = this.B;
        synchronized (object) {
            this.B.notify();
            this.I = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.dumpQueue();
        Object object = this.B;
        synchronized (object) {
            this.t = true;
            this.B.notify();
        }
        object = this.B;
        synchronized (object) {
            while (!this.s) {
                try {
                    this.B.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!LogObject.i) continue;
                }
            }
            this.t = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRecord(ILogRecord iLogRecord, boolean bl2) {
        block17: {
            boolean bl3;
            block18: {
                bl3 = LogObject.i;
                if (iLogRecord == null || this.t) break block17;
                if (!bl2) break block18;
                this.a(iLogRecord);
                if (!bl3) break block17;
            }
            boolean bl4 = false;
            while (!bl4) {
                Object object;
                if (this.F.a(iLogRecord)) {
                    bl4 = true;
                    if (this.F.e()) continue;
                    object = this.B;
                    synchronized (object) {
                        this.B.notify();
                        continue;
                    }
                }
                if (!Thread.currentThread().equals(this.I)) {
                    object = this.C;
                    synchronized (object) {
                        Object object2 = this.D;
                        synchronized (object2) {
                            this.D.notify();
                        }
                        try {
                            this.C.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (this.x == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_QUEUE_FULL", this.getName()));
                }
                ++this.x;
                bl4 = true;
                if (!bl3) continue;
            }
        }
    }

    private void a(ILogRecord iLogRecord) {
        block11: {
            boolean bl2 = LogObject.i;
            boolean bl3 = true;
            try {
                block12: {
                    block14: {
                        block13: {
                            if (this.isBackupEnabled() && this.p.b() != 0) {
                                bl3 = this.a();
                            }
                            if (!bl3) break block12;
                            this.b(iLogRecord);
                            this.w = 0;
                            ++this.l;
                            if (this.x == 0) break block11;
                            if (this.x != 1) break block13;
                            LogUtil.errorMsg(LogUtil.getLogMessage("HANDLER_OK_1", this.getName()));
                            if (!bl2) break block14;
                        }
                        LogUtil.errorMsg(LogUtil.getLogMessage("HANDLER_OK_2", this.getName(), new Integer(this.x)));
                    }
                    this.x = 0;
                    if (!bl2) break block11;
                }
                this.c(iLogRecord);
            }
            catch (NestedException nestedException) {
                if (this.w == 0) {
                    LogUtil.errorMsg(nestedException.getMessage());
                    if (nestedException.getNestedException() != null) {
                        nestedException.getNestedException().printStackTrace();
                    }
                }
                ++this.w;
                if (this.isBackupEnabled()) {
                    this.c(iLogRecord);
                    if (!bl2) break block11;
                }
                this.d(iLogRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void b(ILogRecord iLogRecord) throws NestedException {
        Object object = this.A;
        synchronized (object) {
            IFormatter iFormatter;
            if (!this.r) {
                this.openDevice();
            }
            if (this.r && (iFormatter = this.e(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.E.println(string);
                if (this.E.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }

    private void c(ILogRecord iLogRecord) {
        block6: {
            if (this.w == 1) {
                LogUtil.errorMsg(LogUtil.getLogMessage("BACKUP_ATTEMPT", this.getName()));
            }
            if (!this.p.e()) {
                try {
                    this.p.a(iLogRecord);
                    break block6;
                }
                catch (IOException iOException) {
                    if (this.x == 0) {
                        LogUtil.errorMsg(LogUtil.getLogMessage("ERR_WRITE_BACKUP", this.getName()));
                    }
                    iOException.printStackTrace();
                    ++this.x;
                    if (!LogObject.i) break block6;
                }
            }
            if (this.x == 0) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_BACKUP_FULL", this.getName()));
            }
            ++this.x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(ILogRecord iLogRecord) {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.getMaxRetries();
        if (this.w == 1 && n3 > 0) {
            LogUtil.errorMsg(LogUtil.getLogMessage("RETRY_ATTEMPT", this.getName()));
        }
        while (!bl2 && n2 < n3 && !this.t) {
            block10: {
                try {
                    int n4 = this.getRetryInterval();
                    if (n4 == 0) break block10;
                    Object object = this.D;
                    synchronized (object) {
                        this.D.wait(n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.b(iLogRecord);
                bl2 = true;
                this.w = 0;
            }
            catch (NestedException nestedException) {
                ++n2;
                if (!LogObject.i) continue;
            }
        }
        if (!bl2) {
            ++this.x;
        }
    }

    private boolean a() throws NestedException {
        boolean bl2 = LogObject.i;
        ILogRecord iLogRecord = null;
        boolean bl3 = true;
        boolean bl4 = false;
        while (this.p.b() > 0 && !bl4) {
            try {
                iLogRecord = this.p.f();
            }
            catch (Exception exception) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_READ_BACKUP", this.p.a(), this.getName()));
                exception.printStackTrace();
                bl4 = true;
                this.p.h();
                try {
                    this.p.g();
                }
                catch (IOException iOException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    iOException.printStackTrace();
                    this.setBackupEnabled(false);
                }
            }
            try {
                this.b(iLogRecord);
            }
            catch (NestedException nestedException) {
                bl4 = true;
                ++this.w;
                b b2 = new b(this.getBackupCapacity());
                try {
                    b2.g();
                    b2.a(iLogRecord);
                    while (this.p.b() > 0) {
                        iLogRecord = this.p.f();
                        b2.a(iLogRecord);
                        if (!bl2) continue;
                    }
                    this.p.i();
                    this.p = b2;
                    bl3 = false;
                }
                catch (Exception exception) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                    exception.printStackTrace();
                    this.setBackupEnabled(false);
                }
                if (!bl2) continue;
            }
        }
        if (!bl4) {
            this.p.i();
            try {
                this.p.g();
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_BACKUP"));
                iOException.printStackTrace();
                this.setBackupEnabled(false);
            }
        }
        return bl3;
    }

    protected IFormatter e(ILogRecord iLogRecord) {
        boolean bl2 = LogObject.i;
        boolean bl3 = false;
        Class<?> clazz = iLogRecord.getClass();
        IFormatter iFormatter = null;
        while (!bl3 && clazz != null) {
            block4: {
                block3: {
                    String string = clazz.getName();
                    if (!this.u.containsKey(string)) break block3;
                    bl3 = true;
                    iFormatter = (IFormatter)this.u.get(string);
                    if (!bl2) break block4;
                }
                clazz = clazz.getSuperclass();
            }
            if (!bl2) continue;
        }
        return iFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpQueue() {
        block9: {
            boolean bl2 = LogObject.i;
            if (!this.isCircular()) break block9;
            boolean bl3 = false;
            Object object = this.B;
            synchronized (object) {
                Object object2 = this.C;
                synchronized (object2) {
                    while (!bl3) {
                        block11: {
                            ILogRecord iLogRecord;
                            block10: {
                                iLogRecord = this.F.f();
                                if (iLogRecord != null) break block10;
                                bl3 = true;
                                if (!bl2) break block11;
                            }
                            this.G.a(iLogRecord);
                        }
                        if (!bl2) continue;
                    }
                    this.C.notifyAll();
                }
                this.B.notifyAll();
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return string + ", deviceOpen=" + this.r;
    }
}

