/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jasn1;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.tivoli.pd.jasn1.PDASNBase;
import com.tivoli.pd.jasn1.UnsignedIntegerRangeException;
import java.io.IOException;
import java.math.BigInteger;

public class PDUnsignedInteger
extends PDASNBase {
    private static final String e = "$Id: @(#)30  1.4 src/com/tivoli/pd/jasn1/PDUnsignedInteger.java, pd.jasn1, am510, 031010a 03/07/21 16:17:39 $";
    private static final String f = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    public static final long MinRange = 0L;
    public static final long MaxRange = 0xFFFFFFFFL;
    private long g;

    public PDUnsignedInteger() {
        this.g = 0L;
    }

    public PDUnsignedInteger(long l2) throws UnsignedIntegerRangeException {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new UnsignedIntegerRangeException(l2);
        }
        this.g = l2;
    }

    public PDUnsignedInteger(Long l2) throws UnsignedIntegerRangeException {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new UnsignedIntegerRangeException(l2);
        }
        this.g = l2;
    }

    public long getVal() {
        return this.g;
    }

    public void setVal(long l2) throws UnsignedIntegerRangeException {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new UnsignedIntegerRangeException(l2);
        }
        this.g = l2;
    }

    protected void a(DerInputStream derInputStream) throws IOException {
        this.g = derInputStream.getBigInteger().longValue();
    }

    protected void a(DerOutputStream derOutputStream) throws IOException {
        block6: {
            block5: {
                int n2;
                boolean bl2 = PDASNBase.d;
                if (this.g <= Integer.MAX_VALUE) break block5;
                byte[] byArray = BigInteger.valueOf(this.g).toByteArray();
                int n3 = 0;
                while (byArray[n3] == 0) {
                    ++n3;
                    if (!bl2) continue;
                }
                if ((n2 = byArray.length - n3) > 4) {
                    String string = "The integer is too large";
                    throw new IOException(string);
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n3, byArray2, 0, n2);
                BigInteger bigInteger = new BigInteger(byArray2);
                derOutputStream.putInteger(bigInteger);
                if (!bl2) break block6;
            }
            derOutputStream.putInteger(BigInteger.valueOf(this.g));
        }
    }

    byte a() {
        return 2;
    }
}

