/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KRBError {
    public int pvno;
    public int msgType;
    public KerberosTime cTime;
    public Integer cuSec;
    public KerberosTime sTime;
    public Integer suSec;
    public int errorCode;
    public Realm crealm;
    public PrincipalName cname;
    public Realm realm;
    public PrincipalName sname;
    public String eText;
    public byte[] eData;
    public Checksum eCksum;

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n2, KerberosTime kerberosTime2, Integer n3, int n4, Realm realm, PrincipalName principalName, Realm realm2, PrincipalName principalName2, String string, byte[] byArray) {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n2;
        this.sTime = kerberosTime2;
        this.suSec = n3;
        this.errorCode = n4;
        this.crealm = realm;
        this.cname = principalName;
        this.realm = realm2;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n2, KerberosTime kerberosTime2, Integer n3, int n4, Realm realm, PrincipalName principalName, Realm realm2, PrincipalName principalName2, String string, byte[] byArray, Checksum checksum) {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n2;
        this.sTime = kerberosTime2;
        this.suSec = n3;
        this.errorCode = n4;
        this.crealm = realm;
        this.cname = principalName;
        this.realm = realm2;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.eCksum = checksum;
    }

    public KRBError(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.a(new DerValue(byArray));
    }

    public KRBError(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.a(derValue);
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(KRBError.a("N35ilw\u000e\u0005\u0016") + Thread.currentThread().getName() + KRBError.a("?A"));
            krb5Debug.out(9, KRBError.a(";_IgLG$\u0005^qw["));
            if (this.cTime != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0014xwh\u0004WEm%") + this.cTime.toDate().toString() + " " + this.cTime.toDate().getTime());
            }
            if (this.cuSec != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0014YM`\u0002WEm%") + this.cuSec);
            }
            krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0004xwh\u0004WEm%") + this.sTime.toDate().toString() + " " + this.sTime.toDate().getTime());
            krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0004YM`\u0002WEm%") + this.suSec);
            krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0012^lj\u0013WOqa\u0004WEm%") + this.errorCode);
            if (this.crealm != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0014^{d\r\u001a\fwvA") + this.crealm.toString());
            }
            if (this.cname != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0014B\u007fh\u0004WEm%") + this.cname.toString());
            }
            if (this.realm != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0005I\u007fi\fWEm%") + this.realm.toString());
            }
            if (this.sname != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0004B\u007fh\u0004WEm%") + this.sname.toString());
            }
            if (this.eText != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%A\u0012X{}\u0015WEm%") + this.eText);
            }
            if (this.eData != null) {
                krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>%AWIZd\u0015\u0016\fnw\u000e\u0001Ez`\u0005Y"));
                if (this.eCksum != null) {
                    krb5Debug.out(9, KRBError.a("%AW\f>%AW\f>f\t\u0012Ouv\u0014\u001a\fnw\u000e\u0001Ez`\u0005Y"));
                }
            }
        }
    }

    public final KerberosTime getServerTime() {
        return this.sTime;
    }

    public final KerberosTime getClientTime() {
        return this.cTime;
    }

    public final Integer getServerMicroSeconds() {
        return this.suSec;
    }

    public final Integer getClientMicroSeconds() {
        return this.cuSec;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorString() {
        return this.eText;
    }

    private void a(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 30 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != 30) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.cTime = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.cuSec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.cuSec = null;
        }
        this.sTime = KerberosTime.parse(derValue2.getData(), (byte)4, false);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 5) {
            throw new Asn1Exception(906);
        }
        this.suSec = new Integer(derValue3.getData().getBigInteger().intValue());
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 6) {
            throw new Asn1Exception(906);
        }
        this.errorCode = derValue3.getData().getBigInteger().intValue();
        this.crealm = Realm.parse(derValue2.getData(), (byte)7, true);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)8, true);
        this.realm = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)10, false);
        this.eText = null;
        this.eData = null;
        this.eCksum = null;
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 11) {
            derValue3 = derValue2.getData().getDerValue();
            this.eText = derValue3.getData().getGeneralString();
        }
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 12) {
            derValue3 = derValue2.getData().getDerValue();
            this.eData = derValue3.getData().getOctetString();
        }
        if (derValue2.getData().available() > 0) {
            this.eCksum = Checksum.parse(derValue2.getData(), (byte)13, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        if (this.cTime != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.cTime.asn1Encode());
        }
        if (this.cuSec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.cuSec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.sTime.asn1Encode());
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.suSec.intValue()));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.errorCode));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), derOutputStream);
        if (this.crealm != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.crealm.asn1Encode());
        }
        if (this.cname != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.cname.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.realm.asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.sname.asn1Encode());
        if (this.eText != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralString(this.eText);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream);
        }
        if (this.eData != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.eData);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)12), derOutputStream);
        }
        if (this.eCksum != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)13), this.eCksum.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)30), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 5;
                        break;
                    }
                    case 1: {
                        n5 = 97;
                        break;
                    }
                    case 2: {
                        n5 = 119;
                        break;
                    }
                    case 3: {
                        n5 = 44;
                        break;
                    }
                    default: {
                        n5 = 30;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

