/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostAddress
implements Cloneable {
    public int addrType;
    public byte[] address;
    private static byte[] a;

    private HostAddress(int n2) {
    }

    public Object clone() {
        HostAddress hostAddress = new HostAddress(0);
        hostAddress.addrType = this.addrType;
        if (this.address != null) {
            hostAddress.address = new byte[this.address.length];
            System.arraycopy(this.address, 0, hostAddress.address, 0, this.address.length);
        }
        return hostAddress;
    }

    public boolean equals(HostAddress hostAddress) {
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.address.length; ++i2) {
                if (this.address[i2] == hostAddress.address[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public static void refreshLocalInetAddress() throws UnknownHostException {
        a = InetAddress.getLocalHost().getAddress();
    }

    public static byte[] getLocalInetAddress() throws UnknownHostException {
        if (a == null) {
            HostAddress.refreshLocalInetAddress();
        }
        if (a == null) {
            throw new UnknownHostException();
        }
        byte[] byArray = new byte[a.length];
        System.arraycopy(a, 0, byArray, 0, a.length);
        return byArray;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType == 2 || this.addrType == 24) {
            return InetAddress.getByAddress(this.address);
        }
        return null;
    }

    private int a(InetAddress inetAddress) {
        int n2 = 0;
        if (inetAddress instanceof Inet4Address) {
            n2 = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n2 = 23;
        }
        return n2;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByAddress(HostAddress.getLocalInetAddress());
        this.addrType = this.a(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(int n2, byte[] byArray) throws KrbApErrException {
        switch (n2) {
            case 2: {
                if (byArray.length == 4) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\u00042'\u001e\u0003)80\u000f1>"));
            }
            case 5: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\u000e\u0014\u0003%\u0011\f8&\u0018'>/"));
            }
            case 7: {
                break;
            }
            case 6: {
                if (byArray.length == 6) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\u0015\u0012\u0011+&).'\u00191"));
            }
            case 16: {
                if (byArray.length == 3) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\t\u0018\u0012+&).'\u00191"));
            }
            case 12: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\t\u0019\u0001$'9\u001d&\u000e0(/1"));
            }
            case 24: {
                if (byArray.length == 16) break;
                throw new KrbApErrException(0, HostAddress.a("\u0000\u000b&\u0004\f4\\\u000b#96+&).'\u00191"));
            }
        }
        this.addrType = n2;
        this.address = byArray;
        if (Krb5Debug.on(5) && this.addrType == 2) {
            Krb5Debug krb5Debug = new Krb5Debug(HostAddress.a("\u0001\u0005,+5%P") + Thread.currentThread().getName() + HostAddress.a("xJ"));
            krb5Debug.out(5, HostAddress.a("\n\u000519|#\u000e&?91\u0019b$/b") + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.a(inetAddress);
        byte[] byArray = inetAddress.getAddress();
        this.address = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.address, 0, byArray.length);
    }

    public HostAddress(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.addrType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.address = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.addrType);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.address);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddress parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddress(derValue2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 66;
                        break;
                    }
                    case 1: {
                        n5 = 106;
                        break;
                    }
                    case 2: {
                        n5 = 66;
                        break;
                    }
                    case 3: {
                        n5 = 77;
                        break;
                    }
                    default: {
                        n5 = 92;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

