/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbAsRep;
import com.ibm.security.krb5.KrbAsReq;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.KrbTgsRep;
import com.ibm.security.krb5.KrbTgsReq;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.a;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.LoginOptions;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.ServiceName;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.krb5.internal.ccache.d;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.krb5.internal.ktab.KeyTabEntry;
import com.ibm.security.krb5.internal.ktab.g;
import com.ibm.security.krb5.internal.l;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey[] k;
    private static d l;
    private static boolean m;
    private static boolean n;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public Credentials(PrincipalName principalName, EncryptionKey encryptionKey) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbFD$A"));
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbC@0"));
        }
        this.b = principalName;
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001a.KW,@kfQ Eb{\u001fig|mD=Aj(f;AjmK=ModViSg|Mi\u0015.c@0\u0004an\u0005=]~m\u0005") + EncryptedData.encTypeToString(this.k[0].getEType()));
        }
    }

    public Credentials(String string, EncryptionKey encryptionKey) throws RealmException {
        this(new PrincipalName(string), encryptionKey);
    }

    public Credentials(String string, EncryptionKey[] encryptionKeyArray) throws RealmException {
        this(new PrincipalName(string), encryptionKeyArray);
    }

    public Credentials(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbFD$A"));
        }
        if (encryptionKeyArray == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbC@0"));
        }
        this.b = principalName;
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < encryptionKeyArray.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001a.KW,@kfQ Eb{\u001fig|mD=Aj(f;AjmK=ModViSg|Mi") + encryptionKeyArray.length + Credentials.b("\u0005\"Aw{\u000biokq\u0005=]~mVs"));
            for (int i3 = 0; i3 < encryptionKeyArray.length; ++i3) {
                krb5Debug.out(9, Credentials.b(",\u0012") + (i3 + 1) + Credentials.b("xi") + EncryptedData.encTypeToString(this.k[i3].getEType()));
            }
        }
    }

    public final PrincipalName getClient() {
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + ":");
            krb5Debug.out(9, Credentials.b("f%MkfQijoe@s") + this.b.toString());
        }
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    public EncryptionKey getSessionKey() {
        if (this.d == null) {
            Krb5Debug krb5Debug;
            if (Krb5Debug.on(9)) {
                krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + ":");
                krb5Debug.out(9, Credentials.b("v,W}aJ'\u0004Em\\iM}(c V}|\u0005\u001aA|~L*A.C@0"));
            }
            if (this.k != null) {
                return (EncryptionKey)this.k[0].clone();
            }
            if (Krb5Debug.on(9)) {
                krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + ":");
                krb5Debug.out(9, Credentials.b("d%H.C@0W.iW,\u0004@}I%"));
            }
            return null;
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
            krb5Debug.out(9, Credentials.b("v,W}aJ'\u0004Em\\iM}(j'Hw(v,VxaF,\u0004Em\\i"));
        }
        return this.d;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.a.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (Krb5Debug.on(6)) {
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                    krb5Debug.out(9, asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!Krb5Debug.on(6)) break block4;
                Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                krb5Debug.out(9, iOException);
            }
        }
        return byArray;
    }

    public boolean isRenewable() {
        return this.e.get(8);
    }

    public Ticket getTicket() {
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + ":");
            krb5Debug.out(9, Credentials.b("w,P{zK Ji(q GemQ"));
        }
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        boolean bl2 = false;
        try {
            bl2 = this.e.get(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        KrbTgsReq krbTgsReq = new KrbTgsReq(kDCOptions, this, this.c, null, null, null, null, this.j, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply(this);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.a(this.c.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply(this);
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, InputStream inputStream) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, inputStream);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    public static Credentials acquireTGT(PrincipalName principalName, EncryptionKey encryptionKey) throws KrbException, IOException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbFD$A"));
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(Credentials.b("k<HbC@0"));
        }
        KrbAsReq krbAsReq = new KrbAsReq(principalName, encryptionKey);
        String string = null;
        KrbAsRep krbAsRep = null;
        try {
            string = krbAsReq.send();
            krbAsRep = krbAsReq.getReply(encryptionKey);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.a(principalName.getRealmString(), string, true);
                krbAsRep = krbAsReq.getReply(encryptionKey);
            }
            throw krbException;
        }
        return krbAsRep.getCreds();
    }

    public static Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        if (l == null) {
            l = com.ibm.security.krb5.internal.ccache.d.a();
        }
        if (l != null) {
            Object object;
            if (Krb5Debug.on(9)) {
                object = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                ((Krb5Debug)object).out(9, Credentials.b("\u001bw\u001aEzG\nVklViBa}K-\u0004z`@i@knD<Hz(Q GemQiC|iK=M`o\u0005=Mmc@=\u0004gf\u0005*Vkl@'PgiIiGokM,\n"));
            }
            object = l.f();
            credentials = ((c)object).c();
        } else {
            credentials = Credentials.getDefaultNativeCreds();
        }
        return credentials;
    }

    static Credentials a(String string) {
        return Credentials.acquireCreds(string, null);
    }

    public static Credentials acquireCreds(String string, String string2) {
        Credentials credentials = null;
        try {
            PrincipalName principalName = new PrincipalName(string);
            String string3 = string2;
            if (string3 == null) {
                string3 = Config.getInstance().getDefaultRealm();
            }
            if (principalName.getRealm() == null) {
                if (string3 != null) {
                    principalName.setRealm(string3);
                }
            } else if (string3 == null) {
                string3 = principalName.getRealmString();
            }
            if (string3 != null) {
                credentials = Credentials.a(principalName, string3, null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    public static Credentials getServiceCreds(String string, File file) {
        block12: {
            Object object;
            Object var2_2 = null;
            PrincipalName principalName = null;
            PrincipalName principalName2 = null;
            if (string != null) {
                try {
                    principalName = new PrincipalName(string);
                    if (principalName.getRealm() == null) {
                        object = Config.getInstance().getDefaultRealm();
                        if (object == null) {
                            return null;
                        }
                        principalName.setRealm((String)object);
                    }
                }
                catch (Exception exception) {
                    if (Krb5Debug.on(6)) {
                        Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                        krb5Debug.out(9, Credentials.b("\u001bw\u001a.KW,@kfQ Eb{\u000b.Az[@;Rgk@\nVklViAvk@9PggKiG|mD=M`o\u0005:A|~L*A.fD$A.nJ;\u0004") + string + Credentials.b("\u001fi") + exception.toString());
                    }
                    return null;
                }
            }
            if ((object = file == null ? KeyTab.getInstance() : KeyTab.getInstance(file)) != null) {
                if (principalName == null) {
                    KeyTabEntry keyTabEntry = ((KeyTab)object).getEntry(principalName);
                    if (keyTabEntry == null) {
                        return null;
                    }
                    principalName2 = keyTabEntry.getService();
                    if (principalName2 == null || principalName2 != principalName) {
                        return null;
                    }
                }
                try {
                    return new Credentials(principalName, ((KeyTab)object).getAllKeys(principalName));
                }
                catch (Exception exception) {
                    if (!Krb5Debug.on(6)) break block12;
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                    krb5Debug.out(9, Credentials.b("\u001bw\u001a.KW,@kfQ Eb{\u000b.Az[@;Rgk@\nVklViAvk@9PggKs\u0004") + exception.toString());
                }
            }
        }
        return null;
    }

    public static Credentials getServiceCreds(PrincipalName principalName, InputStream inputStream) throws IOException, KrbException {
        g g2 = new g(inputStream);
        if (principalName == null) {
            KeyTabEntry keyTabEntry = g2.a(principalName);
            if (keyTabEntry == null) {
                return null;
            }
            principalName = keyTabEntry.getService();
            if (principalName == null) {
                return null;
            }
        }
        return new Credentials(principalName, g2.b(principalName));
    }

    private static Credentials a(PrincipalName principalName, String string, String string2, LoginOptions loginOptions) {
        Realm realm = null;
        PrincipalName principalName2 = null;
        Credentials credentials = null;
        try {
            if (principalName != null && string != null) {
                c c2;
                principalName2 = new PrincipalName(Credentials.b("N;FzoQf") + string + new Character('@') + string);
                realm = new Realm(string);
                if (l != null && !l.c().match(principalName)) {
                    l.g();
                    l = null;
                }
                if (l == null) {
                    l = string2 == null ? com.ibm.security.krb5.internal.ccache.d.a(principalName) : com.ibm.security.krb5.internal.ccache.d.a(principalName, string2);
                }
                if (l != null && l.e() != null && (c2 = l.a(loginOptions, principalName2, realm)) != null && c2.a()) {
                    if (Krb5Debug.on(9)) {
                        Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                        krb5Debug.out(9, Credentials.b("\u001bw\u001aEzG\nVklViBa}K-\u0004z`@iRodL-\u0004zaF\"Az(B;E`|L'C.|L*Ok|\u0005 J.kW,@kfQ Eb(F(Gfm\u000b"));
                    }
                    credentials = c2.c();
                }
            }
        }
        catch (Exception exception) {
            credentials = null;
        }
        if (credentials == null) {
            l = null;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws Exception {
        ServiceName serviceName = new ServiceName(string);
        return Credentials.acquireServiceCreds(serviceName, credentials, null, null);
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials) throws Exception {
        return Credentials.acquireServiceCreds(principalName, credentials, null, null);
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        Credentials credentials2 = com.ibm.security.krb5.internal.l.a(principalName, credentials, kDCOptions, hostAddresses);
        if (credentials2 != null && Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001aMz@-A`|L(H}&D*U{aW,wkzS GkKW,@}2\u0005;Az}W'M`o\u0005*VklVs"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001aMz@-A`|L(H}&D*U{aW,wkzS GkKW,@}2\u0005;Az}W'M`o\u0005*VklVs"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001aJMg\u001cc4(\bd\t#KW,@kfQ Eb{\bd\t#"));
            krb5Debug.out(9, Credentials.b(",*HgmK=\u001e.") + credentials2.b.toString());
            krb5Debug.out(9, Credentials.b(",:A|~@;\u001e.") + credentials2.c.toString());
            krb5Debug.out(9, Credentials.b(",=Mmc@=\u001e.z@(Hc2\u0005") + credentials2.a.getRealm().toString());
            krb5Debug.out(9, Credentials.b(",i\u0004.(\u0005i\u0004.{K(Ik2\u0005") + credentials2.a.getServer().toString());
            if (credentials2.g != null) {
                krb5Debug.out(9, Credentials.b(",:PozQ\u001dMcm\u001fi") + credentials2.g.getTime());
            } else {
                krb5Debug.out(9, Credentials.b(",:PozQ\u001dMcm\u001fij[Di"));
            }
            if (credentials2.h != null) {
                krb5Debug.out(9, Credentials.b(",,Jj\\L$A4(") + credentials2.h.getTime());
            } else {
                krb5Debug.out(9, Credentials.b(",,Jj\\L$A4(k\u001chB"));
            }
            krb5Debug.out(9, Credentials.b("\u0005i\u0004.(\u0005i\u0004#%\bdg|mA,JzaD%W.mK-\t#%\b"));
        }
        return credentials2;
    }

    public d getCache() {
        return l;
    }

    public EncryptionKey getServiceKey() {
        if (this.k != null) {
            return (EncryptionKey)this.k[0].clone();
        }
        return null;
    }

    public EncryptionKey getServiceKey(int n2) {
        if (this.k == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            if (this.k[i2].getEType() != n2) continue;
            return (EncryptionKey)this.k[i2].clone();
        }
        return null;
    }

    public EncryptionKey[] getServiceKeys() {
        if (this.k == null) {
            return null;
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.k.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            encryptionKeyArray[i2] = (EncryptionKey)this.k[i2].clone();
        }
        return encryptionKeyArray;
    }

    public void setServiceKey(EncryptionKey encryptionKey) throws Exception {
        if (encryptionKey == null) {
            I18NException.throwException(Credentials.b("k<HbC@0"));
        }
        if (this.k != null) {
            I18NException.throwException(Credentials.b("`1M}|L'CEm\\:"));
        }
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
    }

    public void setServiceKeys(EncryptionKey[] encryptionKeyArray) throws Exception {
        if (encryptionKeyArray == null) {
            I18NException.throwException(Credentials.b("k<HbC@0"));
        }
        if (this.k != null) {
            I18NException.throwException(Credentials.b("`1M}|L'CEm\\:"));
        }
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
    }

    private static void a(Credentials credentials) {
        System.out.println(Credentials.b("\u001bw\u001aJMg\u001cc4(\bd\t#KW,@kfQ Eb{\bd\t#"));
        System.out.println(Credentials.b(",*HgmK=\u001e.") + credentials.b.toString());
        System.out.println(Credentials.b(",:A|~@;\u001e.") + credentials.c.toString());
        System.out.println(Credentials.b(",=Mmc@=\u001e.z@(Hc2\u0005") + credentials.a.getRealm().toString());
        System.out.println(Credentials.b(",i\u0004.(\u0005i\u0004.{K(Ik2\u0005") + credentials.a.getServer().toString());
        if (credentials.g != null) {
            System.out.println(Credentials.b(",:PozQ\u001dMcm\u001fi") + credentials.g.getTime());
        } else {
            System.out.println(Credentials.b(",:PozQ\u001dMcm\u001fij[Di"));
        }
        if (credentials.h != null) {
            System.out.println(Credentials.b(",,Jj\\L$A4(") + credentials.h.getTime());
        } else {
            System.out.println(Credentials.b(",,Jj\\L$A4(k\u001chB"));
        }
        System.out.println(Credentials.b("\u0005i\u0004.(\u0005i\u0004#%\bdg|mA,JzaD%W.mK-\t#%\b"));
    }

    private static synchronized void a() {
        block5: {
            if (m || n) {
                return;
            }
            n = true;
            try {
                AccessController.doPrivileged(new a());
                m = true;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (Krb5Debug.on(6)) {
                    exception.printStackTrace();
                    Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                    krb5Debug.out(9, Credentials.b("`1GkxQ K`(I&EjaK.\u0004`iQ Rk(F&@k2\u0005") + exception);
                }
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(6)) break block5;
                exception.printStackTrace();
                Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
                krb5Debug.out(9, Credentials.b("`1GkxQ K`(I&EjaK.\u0004`iQ Rk(F&@k2\u0005") + exception);
            }
        }
    }

    public static Credentials getDefaultNativeCreds() {
        Credentials.a();
        if (m) {
            return Credentials.acquireDefaultNativeCreds();
        }
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(Credentials.b("f;AjmK=ModVs") + Thread.currentThread().getName() + Credentials.b("\u001fi"));
            krb5Debug.out(9, Credentials.b("\u001bw\u001aMz@-A`|L(H}2\u0005'K.fD=Mxm\u0005*Kjm\u0005%Kol@-"));
        }
        return null;
    }

    public Date getAuthTime() {
        if (this.f == null) {
            return null;
        }
        return this.f.toDate();
    }

    static {
        m = false;
        n = false;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 37;
                        break;
                    }
                    case 1: {
                        n5 = 73;
                        break;
                    }
                    case 2: {
                        n5 = 36;
                        break;
                    }
                    case 3: {
                        n5 = 14;
                        break;
                    }
                    default: {
                        n5 = 8;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

