/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.ClosableLocator;
import org.xml.sax.InputSource;

public class AuthenticatingProxyWSDLLocatorImpl
implements WSDLLocator,
ClosableLocator {
    private static final String PROXY_AUTH = "Proxy-Authorization";
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char BASE64_PAD_CHAR = '=';
    Reader baseReader = null;
    InputStream baseInputStream = null;
    InputStream importInputStream = null;
    String documentBase = "";
    String importBase = "";
    String wsdlLocation = "";
    PasswordAuthentication passwdAuth = null;
    String authString = null;

    public AuthenticatingProxyWSDLLocatorImpl(String wsdlLoc, String un, String passwd) throws WSDLException {
        this.wsdlLocation = wsdlLoc;
        if (passwd != null) {
            this.passwdAuth = new PasswordAuthentication(un, passwd.toCharArray());
        }
    }

    public AuthenticatingProxyWSDLLocatorImpl(String wsdlLoc, PasswordAuthentication pa) throws WSDLException {
        this.wsdlLocation = wsdlLoc;
        this.passwdAuth = pa;
    }

    public AuthenticatingProxyWSDLLocatorImpl(String docBaseURI, Reader docBaseReader, PasswordAuthentication pa) throws WSDLException {
        this.documentBase = docBaseURI;
        this.baseReader = docBaseReader;
        this.passwdAuth = pa;
    }

    public InputSource getBaseInputSource() {
        Trc.entry(this);
        if (this.baseReader != null) {
            return new InputSource(this.baseReader);
        }
        if (this.baseInputStream == null) {
            try {
                URL url = StringUtils.getURL(null, (String)this.wsdlLocation);
                if ("file".equals(url.getProtocol())) {
                    this.baseInputStream = this.getContentAsInputStreamSec(url);
                } else {
                    URLConnection con = url.openConnection();
                    this.createAuthString();
                    if (this.authString != null) {
                        con.setRequestProperty(PROXY_AUTH, this.authString);
                    }
                    this.baseInputStream = con.getInputStream();
                }
                if (url != null) {
                    this.documentBase = url.toString();
                }
            }
            catch (Exception e) {
                this.documentBase = this.wsdlLocation;
            }
        }
        Trc.exit();
        if (this.baseInputStream == null) {
            return null;
        }
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String base, String relativeLocation) {
        Trc.entry(this, base, relativeLocation);
        this.importInputStream = null;
        try {
            URL contextURL = base != null ? StringUtils.getURL(null, (String)base) : null;
            URL url = StringUtils.getURL((URL)contextURL, (String)relativeLocation);
            if ("file".equals(url.getProtocol())) {
                this.importInputStream = this.getContentAsInputStreamSec(url);
            } else {
                URLConnection con = url.openConnection();
                this.createAuthString();
                if (this.authString != null) {
                    con.setRequestProperty(PROXY_AUTH, this.authString);
                }
                this.importInputStream = con.getInputStream();
            }
            this.importBase = url == null ? relativeLocation : url.toString();
        }
        catch (Exception e2) {
            this.importBase = "unknownImportURI";
        }
        Trc.exit();
        if (this.importInputStream == null) {
            return null;
        }
        return new InputSource(this.importInputStream);
    }

    public Reader getBaseReader() {
        InputSource is = this.getBaseInputSource();
        if (is == null) {
            return null;
        }
        if (is.getCharacterStream() != null) {
            return is.getCharacterStream();
        }
        if (is.getByteStream() != null) {
            return new InputStreamReader(is.getByteStream());
        }
        return null;
    }

    public Reader getImportReader(String base, String relativeLocation) {
        InputSource is = this.getImportInputSource(base, relativeLocation);
        if (is == null) {
            return null;
        }
        if (is.getCharacterStream() != null) {
            return is.getCharacterStream();
        }
        if (is.getByteStream() != null) {
            return new InputStreamReader(is.getByteStream());
        }
        return null;
    }

    public String getBaseURI() {
        return this.documentBase;
    }

    public String getLatestImportURI() {
        return this.importBase;
    }

    private void createAuthString() {
        int i;
        if (this.authString != null) {
            return;
        }
        if (this.passwdAuth == null) {
            return;
        }
        String username = this.passwdAuth.getUserName();
        char[] passwd = this.passwdAuth.getPassword();
        if (username == null || passwd == null) {
            return;
        }
        byte[] data = null;
        try {
            String ps = new String(passwd);
            data = (username + ":" + ps).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            return;
        }
        int len = data.length;
        char[] out = new char[len / 3 * 4 + 4];
        int readIndex = 0;
        int writeIndex = 0;
        int remainingBytes = len;
        while (remainingBytes >= 3) {
            i = ((data[readIndex] & 0xFF) << 16) + ((data[readIndex + 1] & 0xFF) << 8) + (data[readIndex + 2] & 0xFF);
            out[writeIndex++] = BASE64_CHARS[i >> 18];
            out[writeIndex++] = BASE64_CHARS[i >> 12 & 0x3F];
            out[writeIndex++] = BASE64_CHARS[i >> 6 & 0x3F];
            out[writeIndex++] = BASE64_CHARS[i & 0x3F];
            readIndex += 3;
            remainingBytes -= 3;
        }
        if (remainingBytes == 1) {
            i = data[readIndex] & 0xFF;
            out[writeIndex++] = BASE64_CHARS[i >> 2];
            out[writeIndex++] = BASE64_CHARS[i << 4 & 0x3F];
            out[writeIndex++] = 61;
            out[writeIndex++] = 61;
        } else if (remainingBytes == 2) {
            i = ((data[readIndex] & 0xFF) << 8) + (data[readIndex + 1] & 0xFF);
            out[writeIndex++] = BASE64_CHARS[i >> 10];
            out[writeIndex++] = BASE64_CHARS[i >> 4 & 0x3F];
            out[writeIndex++] = BASE64_CHARS[i << 2 & 0x3F];
            out[writeIndex++] = 61;
        }
        String encoded = new String(out, 0, writeIndex);
        this.authString = "Basic " + encoded;
    }

    public void close() throws IOException {
        if (this.baseReader != null) {
            this.baseReader.close();
        }
        if (this.importInputStream != null) {
            this.importInputStream.close();
        }
        if (this.baseInputStream != null) {
            this.baseInputStream.close();
        }
    }

    private InputStream getContentAsInputStreamSec(URL url) throws Exception {
        Trc.entry((Object)this, url);
        InputStream returnIS = null;
        final URL finalUrl = url;
        try {
            returnIS = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalArgumentException, IOException {
                    return StringUtils.getContentAsInputStream((URL)finalUrl);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Trc.exception(ex);
            Exception e = ex.getException();
            throw e;
        }
        Trc.exit(returnIS);
        return returnIS;
    }
}

