/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.util.jms.WSIFJMSMessageProperties;
import org.apache.wsif.util.jms.WSIFJMSProperties;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public class WSIFJMSDestination {
    protected WSIFJMSFinder finder;
    protected QueueConnection connection = null;
    protected QueueSession session = null;
    protected Queue readQ = null;
    protected Queue writeQ = null;
    protected boolean asyncMode = false;
    protected Queue syncTempQueue = null;
    protected boolean oneWayMode = false;
    protected WSIFJMSProperties inProps;
    protected WSIFJMSMessageProperties lastMessageProps = null;
    protected long timeout;
    protected String replyToName = null;
    protected String altDestName = null;

    public WSIFJMSDestination(WSIFJMSFinder finder) throws WSIFException {
        this(finder, 0L);
        Trc.entry((Object)this, finder);
        Trc.exit();
    }

    public WSIFJMSDestination(WSIFJMSFinder finder, long timeout) throws WSIFException {
        this(finder, null, timeout);
        Trc.entry(this, finder, new Long(timeout));
        Trc.exit();
    }

    public WSIFJMSDestination(WSIFJMSFinder finder, String altDestName, long timeout) throws WSIFException {
        Trc.entry(this, finder, altDestName, new Long(timeout));
        this.inProps = new WSIFJMSProperties("in");
        this.lastMessageProps = new WSIFJMSMessageProperties();
        this.timeout = timeout;
        this.finder = finder;
        try {
            this.connection = finder.getFactory().createQueueConnection();
            Destination initDest = finder.getInitialDestination();
            if (initDest != null && altDestName != null) {
                throw new WSIFException("Both jndiDestinationName and jmsproviderDestinationName cannot be specified");
            }
            if (initDest == null && altDestName == null) {
                throw new WSIFException("Either jndiDestinationName or jmsproviderDestinationName must be specified");
            }
            this.altDestName = altDestName;
            if (initDest != null) {
                this.writeQ = (Queue)initDest;
            }
            this.readQ = null;
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        try {
            QueueSession sssn = this.session;
            QueueConnection cnnctn = this.connection;
            this.session = null;
            this.connection = null;
            if (sssn != null) {
                sssn.close();
            }
            if (cnnctn != null) {
                cnnctn.close();
            }
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        Trc.exit();
    }

    public void finalize() throws WSIFException {
        Trc.entry(this);
        this.close();
        Trc.exit();
    }

    public String send(String data) throws WSIFException {
        Trc.entry((Object)this, data);
        String s = this.send(data, null);
        Trc.exit(s);
        return s;
    }

    public String send(String data, String id) throws WSIFException {
        Trc.entry(this, data, id);
        this.areWeClosed();
        try {
            this.makeQueueSession();
            TextMessage msg = this.session.createTextMessage();
            msg.setText(data);
            String s = this.send((Message)msg, id, true);
            Trc.exit(s);
            return s;
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
    }

    public String send(Serializable data) throws WSIFException {
        Trc.entry((Object)this, data);
        String s = this.send(data, null);
        Trc.exit(s);
        return s;
    }

    public String send(Serializable data, String id) throws WSIFException {
        Trc.entry(this, data, id);
        this.areWeClosed();
        try {
            this.makeQueueSession();
            ObjectMessage msg = this.session.createObjectMessage();
            msg.setObject(data);
            String s = this.send((Message)msg, id, true);
            Trc.exit(s);
            return s;
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
    }

    protected void makeQueueSession() throws JMSException {
        Trc.entry((Object)this, this.session);
        if (this.session == null) {
            this.session = this.connection.createQueueSession(false, 1);
        }
        Trc.exit(this.session);
    }

    protected void getAltDestQueue() throws JMSException {
        Trc.entry(this);
        if (this.altDestName != null) {
            Trc.event(this, "setting writeQ to " + this.altDestName);
            this.writeQ = this.session.createQueue(this.altDestName);
        }
        Trc.exit();
    }

    public String send(Message msg, String id, boolean setReplyTo) throws WSIFException {
        Trc.entry(this, msg, id);
        this.areWeClosed();
        QueueSender sender = null;
        String msgId = null;
        boolean propsSet = true;
        if (this.oneWayMode) {
            this.timeout = 0L;
        }
        try {
            this.makeQueueSession();
            this.getAltDestQueue();
            this.connection.start();
            sender = this.session.createSender(this.writeQ);
            sender.setTimeToLive(this.timeout);
            if (this.inProps.containsKey("JMSReplyTo")) {
                String rto = (String)this.inProps.get("JMSReplyTo");
                this.setReplyToQueue(rto);
                this.inProps.remove("JMSReplyTo");
                msg.setJMSReplyTo((Destination)this.readQ);
            } else if (setReplyTo && !this.oneWayMode) {
                this.setReplyToQueue();
                msg.setJMSReplyTo((Destination)this.readQ);
            }
            if (id != null) {
                msg.setJMSCorrelationID(id);
            }
            propsSet = this.inProps.set((MessageProducer)sender, msg);
            if (!this.oneWayMode && sender.getTimeToLive() > this.timeout) {
                sender.setTimeToLive(this.timeout);
            }
            sender.send(msg);
            msgId = msg.getJMSMessageID();
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        finally {
            this.inProps.clear();
            try {
                if (sender != null) {
                    sender.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException je) {
                Trc.exception(je);
                throw WSIFJMSConstants.ToWsifException(je);
            }
            this.session = null;
        }
        Trc.exit(msgId);
        return msgId;
    }

    public String receive() throws WSIFException {
        Trc.entry(this);
        String s = this.receiveString(null);
        Trc.exit(s);
        return s;
    }

    public String receiveString(String id) throws WSIFException {
        Trc.entry((Object)this, id);
        String s = this.receiveString(id, this.timeout);
        Trc.exit(s);
        return s;
    }

    public String receiveString(String id, long timeout) throws WSIFException {
        Trc.entry((Object)this, id);
        Message msg = this.receive(id, timeout);
        String s = null;
        try {
            if (!(msg instanceof TextMessage)) {
                throw new WSIFException("Reply message was not a TextMessage:msg=" + (msg == null ? "null" : msg.toString()));
            }
            s = ((TextMessage)msg).getText();
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw WSIFJMSConstants.ToWsifException(e);
        }
        Trc.exit(s);
        return s;
    }

    public Message receive(String id) throws WSIFException {
        Trc.entry((Object)this, id);
        Message msg = this.receive(id, this.timeout);
        Trc.exit(msg);
        return msg;
    }

    public Message receive(String id, long timeout) throws WSIFException {
        Trc.entry((Object)this, id);
        this.areWeClosed();
        QueueReceiver rec = null;
        Message msg = null;
        try {
            this.makeQueueSession();
            this.connection.start();
            rec = id != null ? this.session.createReceiver(this.readQ, "JMSCorrelationID='" + id + "'") : this.session.createReceiver(this.readQ);
            msg = rec.receive(timeout);
            this.setLastMessage(msg);
            if (msg == null) {
                throw new WSIFException("Receive timed out on JMS queue " + this.readQ.getQueueName() + ", timeout " + timeout);
            }
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw WSIFJMSConstants.ToWsifException(e);
        }
        finally {
            try {
                if (rec != null) {
                    rec.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception ignored) {
                Trc.ignoredException(ignored);
            }
            this.session = null;
        }
        Trc.exit(msg);
        return msg;
    }

    public void setReplyToQueue() throws WSIFException {
        Trc.entry(this);
        this.areWeClosed();
        try {
            this.makeQueueSession();
            if (this.syncTempQueue == null) {
                this.syncTempQueue = this.session.createTemporaryQueue();
            }
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        this.readQ = this.syncTempQueue;
        this.replyToName = null;
        Trc.exit();
    }

    public void setReplyToQueue(String replyTo) throws WSIFException {
        Trc.entry((Object)this, replyTo);
        this.areWeClosed();
        if (replyTo == null || replyTo.length() == 0) {
            this.setReplyToQueue();
            Trc.exit();
            return;
        }
        if (replyTo.equals(this.replyToName)) {
            Trc.exit();
            return;
        }
        this.readQ = this.finder.findQueue(replyTo);
        this.replyToName = replyTo;
        Trc.exit();
    }

    public void setAsyncMode(boolean b) throws WSIFException {
        Trc.entry((Object)this, b);
        this.areWeClosed();
        if (this.asyncMode != b) {
            this.asyncMode = b;
        }
        Trc.exit();
    }

    public void setOneWayMode(boolean b) throws WSIFException {
        Trc.entry((Object)this, b);
        this.areWeClosed();
        this.oneWayMode = b;
        Trc.exit();
    }

    public boolean isOneWay() {
        return this.oneWayMode;
    }

    public void setProperty(String name, Object value) throws WSIFException {
        Trc.entry(this, name, value);
        if (name != null && value != null) {
            this.inProps.put(name, value);
        }
        Trc.exit();
    }

    public void setProperties(HashMap propMap) {
        Trc.entry((Object)this, propMap);
        if (propMap != null && !propMap.isEmpty()) {
            this.inProps.putAll(propMap);
        }
        Trc.exit();
    }

    public Object getProperty(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        Object prop = null;
        if (name != null) {
            prop = this.lastMessageProps.getProperty(name);
        }
        Trc.exit(prop);
        return prop;
    }

    public HashMap getProperties() throws WSIFException {
        Trc.entry(this);
        HashMap outProps = this.lastMessageProps.getProperties();
        Trc.exit(outProps);
        return outProps;
    }

    protected void areWeClosed() throws WSIFException {
        if (this.connection == null) {
            throw new WSIFException("Cannot use a closed destination");
        }
    }

    public static Message createMessage(Session session, int msgType) throws WSIFException {
        ObjectMessage jmsMsg;
        block4: {
            Trc.entry(null, session, new Integer(msgType));
            jmsMsg = null;
            try {
                if (msgType == 30) {
                    jmsMsg = session.createObjectMessage();
                    break block4;
                }
                if (msgType == 50) {
                    jmsMsg = session.createTextMessage();
                    break block4;
                }
                throw new WSIFException("Unable to support message type");
            }
            catch (JMSException je) {
                Trc.exception(je);
                throw WSIFJMSConstants.ToWsifException(je);
            }
        }
        Trc.exit(jmsMsg);
        return jmsMsg;
    }

    public Message createMessage(int msgType) throws WSIFException {
        Trc.entry((Object)this, msgType);
        try {
            this.makeQueueSession();
        }
        catch (JMSException ex) {
            Trc.exception(ex);
            throw WSIFJMSConstants.ToWsifException(ex);
        }
        Message m = WSIFJMSDestination.createMessage((Session)this.session, msgType);
        Trc.exit(m);
        return m;
    }

    public void setLastMessage(Message msg) {
        Trc.entry((Object)this, msg);
        this.lastMessageProps.setMessage(msg);
        Trc.exit();
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(this.toString() + "\n");
            buff = buff + "finder: " + this.finder;
            buff = buff + " connection: " + this.connection;
            buff = buff + " session: " + this.session;
            buff = buff + " readQ: " + this.readQ;
            buff = buff + " writeQ: " + this.writeQ;
            buff = buff + " asyncMode: " + this.asyncMode;
            buff = buff + " syncTempQueue: " + this.syncTempQueue;
            buff = buff + " inProps: " + this.inProps;
            buff = buff + " lastMessageProps: " + this.lastMessageProps;
            buff = buff + " timeout: " + this.timeout;
            buff = buff + " replyToName: " + this.replyToName;
            buff = buff + " altDestName: " + this.altDestName;
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff;
    }

    public static JMSAddress getJMSAddressFromURL(String url) throws WSIFException {
        String seperator;
        JMSAddress jmsAddress = new JMSAddress();
        if (!url.startsWith("jms:")) {
            throw new WSIFException("protocol must be 'jms:', url: " + url);
        }
        int queryStart = url.indexOf(63);
        if (queryStart < 1) {
            throw new WSIFException("URL must be a query, url: " + url);
        }
        String destinationStyle = url.substring("jms:".length(), queryStart);
        if (!"/queue".equals(destinationStyle) && !"/topic".equals(destinationStyle)) {
            throw new WSIFException("style must be /queue or /topic. found: " + destinationStyle);
        }
        jmsAddress.setDestStyle(destinationStyle.substring(1));
        if (queryStart >= url.length()) {
            throw new WSIFException("empty query string: " + url);
        }
        String queryString = url.substring(queryStart + 1);
        if (queryString.indexOf((seperator = "&").charAt(0)) < 0) {
            seperator = "|";
        }
        StringTokenizer st = new StringTokenizer(queryString, seperator);
        while (st.hasMoreTokens()) {
            JMSPropertyValue jpv;
            String property = st.nextToken();
            int delim = property.indexOf(61);
            if (delim < 1 || delim >= property.length()) {
                throw new WSIFException("property must be '=' seperated name value pair: " + property);
            }
            String propertyName = property.substring(0, delim);
            String propertyValue = property.substring(delim + 1);
            if (propertyName.equals("destination")) {
                jmsAddress.setJndiDestName(propertyValue);
                continue;
            }
            if (propertyName.equals("connectionFactory")) {
                jmsAddress.setJndiConnFactName(propertyValue);
                continue;
            }
            if (propertyName.equals("initialContextFactory")) {
                jmsAddress.setInitCxtFact(propertyValue);
                continue;
            }
            if (propertyName.equals("jndiProviderURL")) {
                jmsAddress.setJndiProvURL(propertyValue);
                continue;
            }
            if (propertyName.equals("deliveryMode")) {
                jpv = new JMSPropertyValue();
                jpv.setName("JMSDeliveryMode");
                jpv.setValue(propertyValue);
                jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
                jmsAddress.addJMSPropertyValue(jpv);
                continue;
            }
            if (propertyName.equals("timeToLive")) {
                jpv = new JMSPropertyValue();
                jpv.setName("JMSTimeToLive");
                jpv.setValue(propertyValue);
                jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
                jmsAddress.addJMSPropertyValue(jpv);
                continue;
            }
            if (propertyName.equals("priority")) {
                jpv = new JMSPropertyValue();
                jpv.setName("JMSPriority");
                jpv.setValue(propertyValue);
                jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
                jmsAddress.addJMSPropertyValue(jpv);
                continue;
            }
            if (propertyName.equals("userid")) {
                jpv = new JMSPropertyValue();
                jpv.setName("JMSUserid");
                jpv.setValue(propertyValue);
                jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
                jmsAddress.addJMSPropertyValue(jpv);
                continue;
            }
            if (propertyName.equals("password")) {
                jpv = new JMSPropertyValue();
                jpv.setName("JMSPassword");
                jpv.setValue(propertyValue);
                jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
                jmsAddress.addJMSPropertyValue(jpv);
                continue;
            }
            jpv = new JMSPropertyValue();
            jpv.setName(propertyName);
            jpv.setValue(propertyValue);
            jpv.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            jmsAddress.addJMSPropertyValue(jpv);
        }
        return jmsAddress;
    }
}

