/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFProperties;

public class WSIFPluggableProviders {
    private static boolean autoLoadProviders = true;
    private static ArrayList providersFromSPIFiles;
    private static HashMap defaultNSProviders;
    private static final String PLUGABLE_PROVIDER_FILENAME = "META-INF/services/org.apache.wsif.spi.WSIFProvider";

    public static WSIFProvider getProvider(String namespaceURI) {
        WSIFProvider provider;
        Trc.entry(null, namespaceURI);
        if (!namespaceURI.endsWith("/")) {
            namespaceURI = namespaceURI + "/";
        }
        if (defaultNSProviders == null) {
            defaultNSProviders = new HashMap();
        } else {
            provider = (WSIFProvider)defaultNSProviders.get(namespaceURI);
            if (provider != null) {
                return provider;
            }
        }
        ArrayList providers = WSIFPluggableProviders.getSupportingProviders(namespaceURI, true);
        if (providers.size() == 0) {
            return null;
        }
        provider = providers.size() == 1 ? (WSIFProvider)providers.get(0) : WSIFPluggableProviders.chooseProvider(providers, namespaceURI);
        defaultNSProviders.put(namespaceURI, provider);
        Trc.exit(provider);
        return provider;
    }

    public static void overrideDefaultProvider(String providerNamespaceURI, WSIFProvider provider) {
        Trc.entry(null, providerNamespaceURI, provider);
        if (defaultNSProviders == null) {
            defaultNSProviders = new HashMap();
        }
        if (!providerNamespaceURI.endsWith("/")) {
            providerNamespaceURI = providerNamespaceURI + "/";
        }
        if (provider == null) {
            WSIFProvider p = (WSIFProvider)defaultNSProviders.get(providerNamespaceURI);
            if (defaultNSProviders != null) {
                defaultNSProviders.remove(providerNamespaceURI);
            }
        } else {
            defaultNSProviders.put(providerNamespaceURI, provider);
            WSIFPluggableProviders.issueChosenProviderMsg(providerNamespaceURI, provider);
        }
        Trc.exit();
    }

    public static boolean isProviderAvailable(String ns1) {
        return WSIFPluggableProviders.isProviderAvailable(ns1, ns1);
    }

    public static boolean isProviderAvailable(String ns1, String ns2) {
        boolean supported = false;
        ArrayList ps = WSIFPluggableProviders.getSupportingProviders(ns1, false);
        if (ps.size() > 0) {
            if (ns2 == null || ns2.length() < 1 || ns2.equals(ns1)) {
                supported = true;
            } else {
                int i = 0;
                while (i < ps.size() && !supported) {
                    String[] supportedNS = ((WSIFProvider)ps.get(i)).getAddressNamespaceURIs();
                    int j = 0;
                    while (j < supportedNS.length && !supported) {
                        if (ns2.equals(supportedNS[j])) {
                            supported = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return supported;
    }

    public static void setAutoLoadProviders(boolean b) {
        Trc.entry(null, b);
        if (autoLoadProviders != b) {
            providersFromSPIFiles = null;
            defaultNSProviders = null;
            autoLoadProviders = b;
        }
        Trc.exit();
    }

    public static boolean isAutoLoadProviders() {
        Trc.entry(null);
        Trc.exit(autoLoadProviders);
        return autoLoadProviders;
    }

    private static ArrayList getSupportingProviders(String namespaceURI, boolean issueMessage) {
        Trc.entry(null, namespaceURI, new Boolean(issueMessage));
        if (providersFromSPIFiles == null) {
            providersFromSPIFiles = WSIFPluggableProviders.getAllDynamicWSIFProviders();
        }
        ArrayList<WSIFProvider> supportingProviders = new ArrayList<WSIFProvider>();
        Iterator i = providersFromSPIFiles.iterator();
        while (i.hasNext()) {
            WSIFProvider p = (WSIFProvider)i.next();
            String[] uris = p.getBindingNamespaceURIs();
            int j = 0;
            while (j < uris.length) {
                if (namespaceURI != null && namespaceURI.equals(uris[j])) {
                    Trc.event(null, "Adding provider " + p + " for namespace " + uris[j]);
                    supportingProviders.add(p);
                }
                ++j;
            }
        }
        if (defaultNSProviders != null && defaultNSProviders.get(namespaceURI) != null) {
            Trc.event(null, "Adding default provider " + defaultNSProviders.get(namespaceURI) + " for namespace " + namespaceURI);
            supportingProviders.add((WSIFProvider)defaultNSProviders.get(namespaceURI));
        }
        if (supportingProviders.size() > 1 && issueMessage) {
            WSIFPluggableProviders.issueMultipleProvidersMsg(namespaceURI, supportingProviders);
        }
        Trc.exit(supportingProviders);
        return supportingProviders;
    }

    private static ArrayList getAllDynamicWSIFProviders() {
        Trc.entry(null);
        if (!autoLoadProviders) {
            return new ArrayList();
        }
        ArrayList al = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WSIFPluggableProviders.findPlugableProviders();
            }
        });
        Trc.exit(al);
        return al;
    }

    private static ArrayList findPlugableProviders() {
        ArrayList classNames = new ArrayList();
        ArrayList<WSIFProvider> providers = new ArrayList<WSIFProvider>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> e = loader.getResources(PLUGABLE_PROVIDER_FILENAME);
            while (e.hasMoreElements()) {
                WSIFPluggableProviders.readMETAINFClassNames(e.nextElement(), classNames);
            }
        }
        catch (Exception ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0003W", ex.getMessage());
            return providers;
        }
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            try {
                Object o = Class.forName((String)i.next(), true, loader).newInstance();
                if (o instanceof WSIFProvider) {
                    WSIFProvider p = (WSIFProvider)o;
                    if (p.getBindingNamespaceURIs().length > 0) {
                        Trc.event(null, "Registering provider: " + p);
                        providers.add(p);
                        continue;
                    }
                    WSIFException ex = new WSIFException("Disabled WSIFProvider found:" + p.getClass().getName());
                    Trc.ignoredException(ex);
                    continue;
                }
                MessageLogger.log("WSIF.0003W", "The provider class specified," + (o == null ? null : o.getClass().getName()) + ", does not implement org.apache.wsif.spi.WSIFProvider");
            }
            catch (ClassNotFoundException ex) {
                Trc.exception(ex);
                MessageLogger.log("WSIF.0003W", ex.getMessage());
            }
            catch (Throwable ex) {
                Trc.exception(ex);
                MessageLogger.log("WSIF.0003W", ex.getMessage());
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void readMETAINFClassNames(URL u, ArrayList classNames) {
        Trc.entry(null, u);
        Trc.event(null, "Reading provider class names from URL: " + u.toString());
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(u.openStream()));
            while ((inputLine = in.readLine()) != null) {
                void var3_3;
                int i = var3_3.indexOf(35);
                if (i >= 0) {
                    inputLine = var3_3.substring(0, i);
                }
                if ((inputLine = inputLine.trim()).length() <= 0) continue;
                Trc.event(null, "Found provider class name: " + inputLine);
                if (classNames.contains(inputLine)) continue;
                classNames.add(inputLine);
            }
        }
        catch (IOException ex) {
            Trc.exception(ex);
            MessageLogger.log("WSIF.0003W", ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Trc.exception(ex);
                    MessageLogger.log("WSIF.0003W", ex.getMessage());
                }
            }
        }
        Trc.exit();
    }

    private static WSIFProvider chooseProvider(ArrayList providers, String uri) {
        if (providers == null || providers.size() < 1) {
            return null;
        }
        if (providers.size() == 1) {
            return (WSIFProvider)providers.get(0);
        }
        int i = providers.size() - 1;
        while (i > 0 && !WSIFPluggableProviders.isDefaultProvider((WSIFProvider)providers.get(i), uri)) {
            --i;
        }
        WSIFProvider p = (WSIFProvider)providers.get(i);
        WSIFPluggableProviders.issueChosenProviderMsg(uri, p);
        return p;
    }

    private static boolean isDefaultProvider(WSIFProvider provider, String uri) {
        String className = provider.getClass().getName();
        try {
            String key = "wsif.provider.default." + className;
            int n = Integer.parseInt(WSIFProperties.getProperty(key));
            int i = 1;
            while (i <= n) {
                key = "wsif.provider.uri." + i + "." + className;
                String defaultURI = WSIFProperties.getProperty(key);
                if (uri != null && uri.equals(defaultURI)) {
                    return true;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            Trc.ignoredException(e);
        }
        return false;
    }

    private static void issueMultipleProvidersMsg(String uri, ArrayList providers) {
        String providerNames = providers.get(0).getClass().getName();
        int i = 1;
        while (i < providers.size()) {
            providerNames = providerNames + ", " + providers.get(i).getClass().getName();
            ++i;
        }
        Trc.event(null, "- Multiple WSIFProvider found supporting the same namespace URI '" + uri + "'. Found ('" + providerNames + "')");
    }

    private static void issueChosenProviderMsg(String uri, WSIFProvider provider) {
        String provName = provider == null ? "null" : provider.getClass().getName();
        Trc.event(null, "- Using WSIFProvider '" + provName + "' for namespaceURI '" + uri + "'");
    }
}

