/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema
implements Serializable {
    static final long serialVersionUID = 1L;
    private String targetNamespace = "";
    private ArrayList types = new ArrayList();
    private ArrayList imports = new ArrayList();
    private ArrayList includes = new ArrayList();

    public Schema(Element el) {
        this.initialize(el, null);
    }

    public Schema(Element el, String parentTargetNamespace) {
        this.initialize(el, parentTargetNamespace);
    }

    private void initialize(Element el, String parentTargetNamespace) {
        this.targetNamespace = el.getAttribute("targetNamespace");
        if (parentTargetNamespace != null && !el.hasAttribute("targetNamespace")) {
            this.targetNamespace = parentTargetNamespace;
        }
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String loc;
                Element subEl = (Element)child;
                String elType = subEl.getLocalName();
                if (elType.equals("complexType")) {
                    this.types.add(new ComplexType(subEl, this.targetNamespace));
                } else if (elType.equals("simpleType")) {
                    this.types.add(new SimpleType(subEl, this.targetNamespace));
                } else if (elType.equals("element")) {
                    this.types.add(new ElementType(subEl, this.targetNamespace));
                } else if (elType.equals("import")) {
                    loc = subEl.getAttribute("schemaLocation");
                    if (loc != null && !loc.equals("")) {
                        this.imports.add(loc);
                    }
                } else if (elType.equals("include") && (loc = subEl.getAttribute("schemaLocation")) != null && !loc.equals("")) {
                    this.includes.add(loc);
                }
            }
            ++i;
        }
    }

    public List getTypes() {
        return this.types;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String[] getImportsAndIncludes() {
        int importsSize = this.imports.size();
        int includesSize = this.includes.size();
        String[] importsAndIncludes = new String[importsSize + includesSize];
        int i = 0;
        while (i < importsSize) {
            importsAndIncludes[i] = (String)this.imports.get(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < includesSize) {
            importsAndIncludes[i2 + importsSize] = (String)this.includes.get(i2);
            ++i2;
        }
        return importsAndIncludes;
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public String[] getIncludes() {
        return this.includes.toArray(new String[this.includes.size()]);
    }
}

