/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import com.ibm.wsdl.util.xml.QNameUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.ParserDelegate;
import org.apache.wsif.schema.Schema;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Parser {
    private static final QName schema1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    private static final QName schema2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    private static final QName schema2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    static /* synthetic */ Class class$org$apache$wsif$schema$ParserDelegate;

    public static void getTypeMappings(Definition def, Map table) throws WSIFException {
        Parser.getTypeMappings(def, table, true, null);
    }

    public static void getTypeMappings(Definition def, Map table, ClassLoader loader) throws WSIFException {
        WSIFWSDLLocatorImpl locator = new WSIFWSDLLocatorImpl((String)null, (String)null, loader);
        Parser.getTypeMappings(def, table, true, locator);
    }

    public static void getTypeMappings(Definition def, Map table, ClassLoader loader, boolean includeStandardMappings) throws WSIFException {
        WSIFWSDLLocatorImpl locator = new WSIFWSDLLocatorImpl((String)null, (String)null, loader);
        Parser.getTypeMappings(def, table, includeStandardMappings, locator);
    }

    public static void getTypeMappings(Definition def, Map table, WSDLLocator loc) throws WSIFException {
        Parser.getTypeMappings(def, table, true, loc);
    }

    public static void getTypeMappings(Definition def, Map table, boolean includeStandardMappings) throws WSIFException {
        Parser.getTypeMappings(def, table, includeStandardMappings, null);
    }

    public static void getTypeMappings(Definition def, Map table, boolean includeStandardMappings, WSDLLocator loc) throws WSIFException {
        int x;
        String extraDims;
        SchemaType st;
        Trc.entry(null, def, table, new Boolean(includeStandardMappings), loc);
        if (loc == null) {
            loc = new WSIFWSDLLocatorImpl((String)null, (String)null, null);
        }
        ArrayList schemaList = new ArrayList();
        Parser.getTypesSchemas(def, schemaList, loc);
        Hashtable standards = null;
        if (includeStandardMappings) {
            Parser.populateWithStandardMappings(table, "http://www.w3.org/1999/XMLSchema", true);
            Parser.populateWithStandardMappings(table, "http://www.w3.org/2000/10/XMLSchema", false);
            Parser.populateWithStandardMappings(table, "http://www.w3.org/2001/XMLSchema", false);
        } else {
            standards = new Hashtable();
            Parser.populateWithStandardMappings(standards, "http://www.w3.org/1999/XMLSchema", true);
            Parser.populateWithStandardMappings(standards, "http://www.w3.org/2000/10/XMLSchema", false);
            Parser.populateWithStandardMappings(standards, "http://www.w3.org/2001/XMLSchema", false);
        }
        ArrayList<SchemaType> arrays = new ArrayList<SchemaType>();
        ArrayList<SchemaType> elements = new ArrayList<SchemaType>();
        Iterator si = schemaList.iterator();
        while (si.hasNext()) {
            Schema ts = (Schema)si.next();
            if (ts == null) continue;
            List types = ts.getTypes();
            Iterator ti = types.iterator();
            while (ti.hasNext()) {
                QName typeName;
                st = (SchemaType)ti.next();
                if (st == null || (typeName = st.getTypeName()) == null) continue;
                if (st.isArray()) {
                    arrays.add(st);
                    continue;
                }
                if (st instanceof ElementType) {
                    QName baseType = ((ElementType)st).getElementType();
                    if (baseType != null) {
                        String wrapperClass;
                        if (((ElementType)st).isNillable() && (wrapperClass = Parser.getWrapperClassName(baseType)) != null) {
                            table.put(typeName, wrapperClass);
                            continue;
                        }
                        String baseClassName = (String)table.get(baseType);
                        if (baseClassName == null && !includeStandardMappings) {
                            baseClassName = (String)standards.get(baseType);
                        }
                        if (baseClassName != null) {
                            table.put(typeName, baseClassName);
                            continue;
                        }
                        elements.add(st);
                        continue;
                    }
                    String className = Parser.resolveClassName(typeName);
                    if ((className = className + "Element") == null) continue;
                    table.put(typeName, className);
                    continue;
                }
                String className = Parser.resolveClassName(typeName);
                if (className == null) continue;
                table.put(typeName, className);
            }
        }
        ArrayList<SchemaType> multiArrays = new ArrayList<SchemaType>();
        Iterator ai = arrays.iterator();
        while (ai.hasNext()) {
            String arrayOfBase;
            QName arrayType;
            SchemaType st2 = (SchemaType)ai.next();
            QName theType = st2.getTypeName();
            if (theType == null || (arrayType = st2.getArrayType()) == null || theType == null) continue;
            String baseClass = (String)table.get(arrayType);
            if (baseClass == null && standards != null) {
                baseClass = (String)standards.get(arrayType);
            }
            if (baseClass == null) {
                String lp = arrayType.getLocalPart();
                if (lp == null || !lp.startsWith("ArrayOf")) continue;
                multiArrays.add(st2);
                continue;
            }
            extraDims = "";
            x = 1;
            while (x < st2.getArrayDimension()) {
                extraDims = extraDims + "[";
                ++x;
            }
            if (baseClass == null) continue;
            if (baseClass.equals("int")) {
                table.put(theType, extraDims + "[I");
                continue;
            }
            if (baseClass.equals("float")) {
                table.put(theType, extraDims + "[F");
                continue;
            }
            if (baseClass.equals("long")) {
                table.put(theType, extraDims + "[J");
                continue;
            }
            if (baseClass.equals("double")) {
                table.put(theType, extraDims + "[D");
                continue;
            }
            if (baseClass.equals("boolean")) {
                table.put(theType, extraDims + "[Z");
                continue;
            }
            if (baseClass.equals("byte")) {
                table.put(theType, extraDims + "[B");
                continue;
            }
            if (baseClass.equals("short")) {
                table.put(theType, extraDims + "[S");
                continue;
            }
            if (baseClass.startsWith("[")) {
                arrayOfBase = "[" + baseClass;
                table.put(theType, arrayOfBase);
                continue;
            }
            arrayOfBase = extraDims + "[L" + baseClass + ";";
            table.put(theType, arrayOfBase);
        }
        Iterator mi = multiArrays.iterator();
        while (mi.hasNext()) {
            QName arrayType;
            st = (SchemaType)mi.next();
            QName theType = st.getTypeName();
            if (theType == null || (arrayType = st.getArrayType()) == null || theType == null) continue;
            extraDims = "";
            x = 1;
            while (x < st.getArrayDimension()) {
                extraDims = extraDims + "[";
                ++x;
            }
            String baseClass = (String)table.get(arrayType);
            if (baseClass == null || !baseClass.startsWith("[")) continue;
            String arrayOfBase = "[" + baseClass;
            table.put(theType, arrayOfBase);
        }
        Iterator ei = elements.iterator();
        while (ei.hasNext()) {
            String baseClassName;
            SchemaType st3 = (SchemaType)ei.next();
            QName theType = st3.getTypeName();
            if (theType == null) continue;
            QName baseType = null;
            if (st3 instanceof ElementType) {
                baseType = ((ElementType)st3).getElementType();
            }
            if (baseType == null || (baseClassName = (String)table.get(baseType)) == null) continue;
            table.put(theType, baseClassName);
        }
        Trc.exit();
    }

    public static void getAllSchemaTypes(Definition def, List schemaTypes, WSDLLocator loc) throws WSIFException {
        ArrayList schemas = new ArrayList();
        final String delegateName = WSIFProperties.getProperty("wsif.parser.delegate");
        try {
            Object delegate = null;
            if (delegateName != null) {
                try {
                    Class delegateClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Class<?> c = Class.forName(delegateName, true, Thread.currentThread().getContextClassLoader());
                                return c;
                            }
                            catch (ClassNotFoundException ignored) {
                                Trc.ignoredException(ignored);
                                return null;
                            }
                        }
                    });
                    if (delegateClass != null && (class$org$apache$wsif$schema$ParserDelegate == null ? (class$org$apache$wsif$schema$ParserDelegate = Parser.class$("org.apache.wsif.schema.ParserDelegate")) : class$org$apache$wsif$schema$ParserDelegate).isAssignableFrom(delegateClass)) {
                        delegate = (ParserDelegate)delegateClass.newInstance();
                    }
                }
                catch (Exception e) {
                    Trc.ignoredException(e);
                }
            }
            if (delegate != null) {
                Trc.event(null, "Using ParserDelegate: " + delegate.getClass().getName());
                delegate.getTypesSchemas(def, schemas, loc);
            } else {
                if (loc == null) {
                    loc = new WSIFWSDLLocatorImpl((String)null, (String)null, null);
                }
                Parser.getTypesSchemas(def, schemas, loc);
            }
            Iterator si = schemas.iterator();
            while (si.hasNext()) {
                Schema ts = (Schema)si.next();
                if (ts == null) continue;
                List types = ts.getTypes();
                Iterator ti = types.iterator();
                while (ti.hasNext()) {
                    SchemaType st = (SchemaType)ti.next();
                    if (st == null) continue;
                    schemaTypes.add(st);
                }
            }
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
    }

    private static void populateWithStandardMappings(Map t, String schemaURI, boolean oneTimeAdds) {
        t.put(new QName(schemaURI, "string"), "java.lang.String");
        t.put(new QName(schemaURI, "integer"), "java.math.BigInteger");
        t.put(new QName(schemaURI, "boolean"), "boolean");
        t.put(new QName(schemaURI, "float"), "float");
        t.put(new QName(schemaURI, "double"), "double");
        t.put(new QName(schemaURI, "base64Binary"), "[B");
        t.put(new QName(schemaURI, "hexBinary"), "[B");
        t.put(new QName(schemaURI, "long"), "long");
        t.put(new QName(schemaURI, "int"), "int");
        t.put(new QName(schemaURI, "short"), "short");
        t.put(new QName(schemaURI, "decimal"), "java.math.BigDecimal");
        t.put(new QName(schemaURI, "byte"), "byte");
        t.put(new QName(schemaURI, "QName"), "javax.xml.namespace.QName");
        if (schemaURI.equals("http://www.w3.org/2001/XMLSchema")) {
            t.put(new QName(schemaURI, "dateTime"), "java.util.Calendar");
        } else {
            t.put(new QName(schemaURI, "timeInstant"), "java.util.Calendar");
        }
        if (oneTimeAdds) {
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "string"), "java.lang.String");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), "java.lang.Boolean");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), "java.lang.Float");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), "java.lang.Double");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "decimal"), "java.math.BigDecimal");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), "java.lang.Integer");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), "java.lang.Short");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), "java.lang.Byte");
            t.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64"), "[B");
            t.put(new QName("http://xml.apache.org/xml-soap", "Map"), "java.util.Map");
            t.put(new QName("http://xml.apache.org/xml-soap", "Vector"), "java.util.Vector");
            t.put(new QName("http://xml.apache.org/xml-soap", "Hashtable"), "java.util.Hashtable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTypesSchemas(Definition def, List schemas, WSDLLocator loc) throws WSIFException {
        Definition definition = def;
        synchronized (definition) {
            Map imports;
            Types types = def.getTypes();
            if (types != null) {
                Iterator extEleIt = types.getExtensibilityElements().iterator();
                while (extEleIt.hasNext()) {
                    UnknownExtensibilityElement typesElement = (UnknownExtensibilityElement)extEleIt.next();
                    Element schemaEl = typesElement.getElement();
                    if (!QNameUtils.matches((QName)schema2001, (Node)schemaEl) && !QNameUtils.matches((QName)schema2000, (Node)schemaEl) && !QNameUtils.matches((QName)schema1999, (Node)schemaEl)) continue;
                    Schema sc = new Schema(schemaEl);
                    schemas.add(sc);
                    String docBase = def.getDocumentBaseURI();
                    if (docBase == null || loc == null) continue;
                    String[] importsAndIncludes = sc.getImportsAndIncludes();
                    int i = 0;
                    while (i < importsAndIncludes.length) {
                        String sl = importsAndIncludes[i];
                        Parser.getImportedSchemas(docBase, sl, loc, schemas);
                        ++i;
                    }
                }
            }
            if ((imports = def.getImports()) != null) {
                Iterator valueIterator = imports.values().iterator();
                while (valueIterator.hasNext()) {
                    List importList = (List)valueIterator.next();
                    if (importList == null) continue;
                    Iterator importIterator = importList.iterator();
                    while (importIterator.hasNext()) {
                        Import tempImport = (Import)importIterator.next();
                        if (tempImport == null) continue;
                        Definition importedDef = tempImport.getDefinition();
                        if (importedDef != null) {
                            Parser.getTypesSchemas(importedDef, schemas, loc);
                            continue;
                        }
                        String baseLoc = def.getDocumentBaseURI();
                        String importLoc = tempImport.getLocationURI();
                        if (baseLoc == null || importLoc == null || loc == null) continue;
                        Parser.getImportedSchemas(baseLoc, importLoc, loc, schemas);
                    }
                }
            }
        }
    }

    private static void getImportedSchemas(String base, String rel, WSDLLocator loc, List schemaList) throws WSIFException {
        try {
            InputSource inputSource = loc.getImportInputSource(base, rel);
            if (inputSource == null) {
                throw new WSIFException("Unable to read schema file " + rel + " relative to " + base);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            if (inputSource.getCharacterStream() != null) {
                inputSource.getCharacterStream().close();
            } else if (inputSource.getByteStream() != null) {
                inputSource.getByteStream().close();
            }
            Element el = doc.getDocumentElement();
            if (el != null && (QNameUtils.matches((QName)schema2001, (Node)el) || QNameUtils.matches((QName)schema2000, (Node)el) || QNameUtils.matches((QName)schema1999, (Node)el))) {
                Schema sc = new Schema(el);
                schemaList.add(sc);
                String[] importsAndIncludes = sc.getImportsAndIncludes();
                String lastURI = loc.getLatestImportURI();
                int i = 0;
                while (i < importsAndIncludes.length) {
                    String sl = importsAndIncludes[i];
                    Parser.getImportedSchemas(lastURI, sl, loc, schemaList);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Trc.exception(e);
            if (e instanceof WSIFException) {
                throw (WSIFException)e;
            }
            throw new WSIFException("Error when getting imported schemas", e);
        }
    }

    private static String resolveClassName(QName qn) {
        String namespace = qn.getNamespaceURI();
        String localPart = qn.getLocalPart();
        String packageName = WSIFUtils.getPackageNameFromNamespaceURI(namespace);
        String className = WSIFUtils.getJavaClassNameFromXMLName(localPart);
        if (packageName != null && !packageName.equals("") && className != null && !className.equals("")) {
            return packageName + "." + className;
        }
        return null;
    }

    private static String getWrapperClassName(QName qn) {
        if (qn == null) {
            return null;
        }
        String ns = qn.getNamespaceURI();
        if ("http://www.w3.org/1999/XMLSchema".equals(ns) || "http://www.w3.org/2000/10/XMLSchema".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns)) {
            String lp = qn.getLocalPart();
            if (lp == null) {
                return null;
            }
            if (lp.equals("int")) {
                return "java.lang.Integer";
            }
            if (lp.equals("long")) {
                return "java.lang.Long";
            }
            if (lp.equals("float")) {
                return "java.lang.Float";
            }
            if (lp.equals("short")) {
                return "java.lang.Short";
            }
            if (lp.equals("double")) {
                return "java.lang.Double";
            }
            if (lp.equals("boolean")) {
                return "java.lang.Boolean";
            }
            if (lp.equals("byte")) {
                return "java.lang.Byte";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

