/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import org.apache.wsif.format.jms.JMSFormatHandler;
import org.apache.wsif.logging.Trc;

public class PrimitiveTypeFormatHandler
implements JMSFormatHandler {
    private static final long serialVersionUID = 1L;
    protected static DateFormat GREGORIAN_CALENDAR_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat STANDARD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected static DateFormat PRECISE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    QName name;
    Object primitiveType;
    Class type;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$Date;

    public PrimitiveTypeFormatHandler(Class type) {
        this.type = type;
    }

    public Object getElement(String arg0) {
        return null;
    }

    public void setElement(String arg0, Object arg1) {
    }

    public Object getElement(String arg0, int arg1) {
        return null;
    }

    public void setElement(String arg0, int arg1, Object arg2) {
    }

    public Object getObjectPart() {
        return this.primitiveType;
    }

    public Object getObjectPart(Class arg0) {
        return null;
    }

    public char getCharPart() {
        return '\u0000';
    }

    public byte getBytePart() {
        return 0;
    }

    public short getShortPart() {
        return 0;
    }

    public int getIntPart() {
        return 0;
    }

    public long getLongPart() {
        return 0L;
    }

    public float getFloatPart() {
        return 0.0f;
    }

    public double getDoublePart() {
        return 0.0;
    }

    public QName getPartQName() {
        return this.name;
    }

    public void setObjectPart(Object arg0) {
        this.primitiveType = arg0;
    }

    public void setCharPart(char arg0) {
    }

    public void setBytePart(byte arg0) {
    }

    public void setShortPart(short arg0) {
    }

    public void setIntPart(int arg0) {
    }

    public void setLongPart(long arg0) {
    }

    public void setFloatPart(float arg0) {
    }

    public void setDoublePart(double arg0) {
    }

    public void setPartQName(QName name) {
        this.name = name;
    }

    public void write(Message message) {
        Trc.entry((Object)this, message);
        try {
            if (message instanceof TextMessage) {
                this.write((TextMessage)message);
            } else if (message instanceof ObjectMessage) {
                this.write((ObjectMessage)message);
            }
        }
        catch (Exception e) {
            Trc.exception(e);
        }
        Trc.exit();
    }

    public void read(Message message) {
        Trc.entry((Object)this, message);
        try {
            if (message instanceof TextMessage) {
                this.read((TextMessage)message);
            } else if (message instanceof ObjectMessage) {
                this.read((ObjectMessage)message);
            }
        }
        catch (Exception e) {
            Trc.exception(e);
        }
        Trc.exit();
    }

    private void write(TextMessage message) throws JMSException {
        String value = null;
        value = this.primitiveType == null ? "" : (this.primitiveType instanceof GregorianCalendar ? GREGORIAN_CALENDAR_DATE_FORMAT.format(((GregorianCalendar)this.primitiveType).getTime()) : (this.primitiveType instanceof Date ? STANDARD_DATE_FORMAT.format((Date)this.primitiveType) : (this.primitiveType instanceof byte[] ? new String((byte[])this.primitiveType) : this.primitiveType.toString())));
        if (value != null) {
            message.setText(value);
        }
    }

    private void write(ObjectMessage message) throws JMSException {
        if (this.primitiveType != null && this.primitiveType instanceof Serializable) {
            message.setObject((Serializable)this.primitiveType);
        }
    }

    private void read(TextMessage message) throws JMSException {
        block8: {
            String value = message.getText();
            Class cls = this.type;
            try {
                if (cls == (class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeFormatHandler.class$("java.lang.String")) : class$java$lang$String)) {
                    this.primitiveType = value;
                    break block8;
                }
                if (cls == (array$B == null ? (array$B = PrimitiveTypeFormatHandler.class$("[B")) : array$B)) {
                    this.primitiveType = value.getBytes();
                    break block8;
                }
                if ((class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = PrimitiveTypeFormatHandler.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar).isAssignableFrom(cls)) {
                    GregorianCalendar result = new GregorianCalendar();
                    result.setTime(GREGORIAN_CALENDAR_DATE_FORMAT.parse(value));
                    this.primitiveType = result;
                    break block8;
                }
                if ((class$java$util$Date == null ? (class$java$util$Date = PrimitiveTypeFormatHandler.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(cls)) {
                    Date result = new Date();
                    try {
                        result = STANDARD_DATE_FORMAT.parse(value);
                    }
                    catch (ParseException standardException) {
                        Trc.exception(standardException);
                        result = PRECISE_DATE_FORMAT.parse(value);
                    }
                    this.primitiveType = result;
                    break block8;
                }
                final Class clsFin = cls;
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return clsFin.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeFormatHandler.class$("java.lang.String")) : class$java$lang$String);
                    }
                });
                this.primitiveType = constructor.newInstance(value);
            }
            catch (Exception e) {
                Trc.exception(e);
                throw new JMSException("Unable to parse message");
            }
        }
    }

    private void read(ObjectMessage message) throws JMSException {
        this.primitiveType = message.getObject();
        if (!this.primitiveType.getClass().isAssignableFrom(this.type)) {
            throw new JMSException("Unable to parse message");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

