/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.format.jms.JMSFormatHandler;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.jms.PrimitiveTypeFormatHandler;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.TextSerializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JMSMessage
extends WSIFDefaultMessage {
    private static final long serialVersionUID = 1L;
    private static String XML_ENCODING = "XML";
    private static String JAVA_ENCODING = "Java";
    static String XML_SCHEMA_1999 = "http://www.w3.org/1999/XMLSchema";
    static String XML_SCHEMA_2000_10 = "http://www.w3.org/2000/10/XMLSchema";
    static String XML_SCHEMA_2001 = "http://www.w3.org/2001/XMLSchema";
    static final HashMap PRIMITIVE_JAVA_MAPPING = new HashMap();
    private Definition fieldDefinitionModel;
    private Binding fieldBindingModel;
    private javax.wsdl.Message fieldMessageModel;
    private List fieldMessageParts;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$Short;

    public JMSMessage(Definition definitionModel, Binding bindingModel, javax.wsdl.Message messageModel, List parts) {
        Trc.entry(this, definitionModel, bindingModel, messageModel, parts);
        this.fieldDefinitionModel = definitionModel;
        this.fieldBindingModel = bindingModel;
        this.fieldMessageModel = messageModel;
        this.fieldMessageParts = parts;
        Trc.exit();
    }

    public void write(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.write((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.write((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void write(TextMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        try {
            ArrayList al = new ArrayList();
            Iterator i = this.getPartNames();
            while (i.hasNext()) {
                al.add(i.next());
            }
            String[] partNames = al.toArray(new String[al.size()]);
            if (partNames.length == 1) {
                String partName = partNames[0];
                Part partModel = this.fieldMessageModel.getPart(partName);
                QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                JMSFormatHandler fh = this.getFormatHandler(partName);
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.setObjectPart(this.parts.get(partName));
                    fh.write((Message)message);
                } else {
                    Object part = this.parts.get(partName);
                    message.setText(part.toString());
                }
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(os);
                OutputFormat format = new OutputFormat();
                XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
                String namespace = "";
                serializer.startDocument();
                serializer.startElement(namespace, this.fieldMessageModel.getQName().getLocalPart(), "", (Attributes)new AttributesImpl());
                int i2 = 0;
                while (i2 < partNames.length) {
                    String partName = partNames[i2];
                    serializer.startElement(namespace, partName, "", (Attributes)new AttributesImpl());
                    Part partModel = this.fieldMessageModel.getPart(partName);
                    QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                    JMSFormatHandler fh = this.getFormatHandler(partName);
                    if (fh != null) {
                        fh.setPartQName(partQName);
                        fh.setObjectPart(this.parts.get(partName));
                        message.setText("");
                        fh.write((Message)message);
                        char[] c = message.getText().toCharArray();
                        serializer.characters(c, 0, c.length);
                    } else {
                        Object part = this.parts.get(partName);
                        char[] c = part.toString().toCharArray();
                        serializer.characters(c, 0, c.length);
                    }
                    serializer.endElement(partName);
                    ++i2;
                }
                serializer.endElement(this.fieldMessageModel.getQName().getLocalPart());
                serializer.endDocument();
                writer.flush();
                String msgContents = os.toString();
                message.setText(msgContents);
            }
            Trc.event(this, message.getText());
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw new WSIFException("Error in write.", e);
        }
        catch (IOException e) {
            Trc.exception(e);
            throw new WSIFException("Error in write.", e);
        }
        catch (SAXException e) {
            Trc.exception(e);
            throw new WSIFException("Error in write.", e);
        }
        Trc.exit();
    }

    private void write(ObjectMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            ArrayList al = new ArrayList();
            Iterator i = this.getPartNames();
            while (i.hasNext()) {
                al.add(i.next());
            }
            String[] partNames = al.toArray(new String[al.size()]);
            if (partNames.length == 1) {
                String partName = partNames[0];
                Part partModel = this.fieldMessageModel.getPart(partName);
                QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                JMSFormatHandler fh = this.getFormatHandler(partName);
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.setObjectPart(this.parts.get(partName));
                    fh.write((Message)message);
                } else {
                    Object part = this.parts.get(partName);
                    try {
                        message.setObject((Serializable)part);
                    }
                    catch (ClassCastException e) {
                        Trc.exception(e);
                        throw new WSIFException("Unable to serialize a part");
                    }
                }
            } else {
                HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                int i2 = 0;
                while (i2 < partNames.length) {
                    String partName = partNames[i2];
                    Part partModel = this.fieldMessageModel.getPart(partName);
                    QName partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                    JMSFormatHandler fh = this.getFormatHandler(partName);
                    if (fh != null) {
                        fh.setPartQName(partQName);
                        fh.setObjectPart(this.parts.get(partName));
                        fh.write((Message)message);
                        result.put(partName, message.getObject());
                    } else {
                        Object part = this.parts.get(partName);
                        try {
                            result.put(partName, (Serializable)part);
                        }
                        catch (ClassCastException e) {
                            Trc.exception(e);
                            throw new WSIFException("Unable to serialize a part");
                        }
                    }
                    ++i2;
                }
                message.setObject(result);
            }
            Trc.event(this, message.getObject());
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw new WSIFException("Error in write.", e);
        }
        Trc.exit();
    }

    public void read(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.read((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.read((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void read(TextMessage message) throws WSIFException {
        Object[] partNames;
        Trc.entry((Object)this, message);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        boolean wsifFormat = false;
        Object[] objectArray = partNames = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
        if (partNames.length > 1) {
            try {
                Trc.event(this, Integer.toString(partNames.length), message.getText());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(null);
                String text = message.getText();
                ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                Document doc = builder.parse(is);
                if (this.fieldMessageModel.getQName().getLocalPart().equals(doc.getDocumentElement().getLocalName())) {
                    wsifFormat = true;
                    message.clearBody();
                    Node n = doc.getDocumentElement().getFirstChild();
                    while (n != null) {
                        if (n.getNodeType() == 1) {
                            QName partQName;
                            String partName = n.getLocalName();
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            OutputFormat format = new OutputFormat();
                            TextSerializer serializer = new TextSerializer();
                            serializer.setOutputFormat(format);
                            serializer.setOutputByteStream((OutputStream)os);
                            format.setOmitXMLDeclaration(true);
                            serializer.serialize((Element)n);
                            os.flush();
                            String partText = os.toString();
                            Part partModel = this.fieldMessageModel.getPart(partName);
                            JMSFormatHandler fh = this.getFormatHandler(partName);
                            QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                            if (fh != null) {
                                fh.setPartQName(partQName);
                                message.setText(partText);
                                fh.read((Message)message);
                                this.setObjectPart(partName, fh.getObjectPart());
                            } else {
                                this.setObjectPart(partName, partText);
                            }
                        }
                        n = n.getNextSibling();
                    }
                    message.setText(text);
                }
            }
            catch (JMSException e) {
                Trc.exception(e);
                throw new WSIFException("Error in read.", e);
            }
            catch (ParserConfigurationException e) {
                Trc.exception(e);
                throw new WSIFException("Error in read.", e);
            }
            catch (Exception e) {
                Trc.exception(e);
            }
        }
        try {
            if (!wsifFormat) {
                QName partQName;
                Trc.event(this, Integer.toString(partNames.length), message.getText());
                if (partNames.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart());
                }
                String partName = partNames[0].toString();
                Part partModel = this.fieldMessageModel.getPart(partName);
                JMSFormatHandler fh = this.getFormatHandler(partName);
                QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.read((Message)message);
                    this.setObjectPart(partName, fh.getObjectPart());
                } else {
                    this.setObjectPart(partName, message.getText());
                }
            }
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw new WSIFException("Error in read.", e);
        }
        Trc.exit();
    }

    private void read(ObjectMessage message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            Object[] partNames;
            Trc.event(this, message.getObject());
            Serializable object = message.getObject();
            Object[] objectArray = partNames = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
            if (partNames.length == 0) {
                return;
            }
            if (object instanceof Map) {
                message.clearBody();
                Map map = (Map)((Object)object);
                int i = 0;
                while (i < partNames.length) {
                    String partName = partNames[i].toString();
                    if (map.containsKey(partName)) {
                        QName partQName;
                        Part partModel = this.fieldMessageModel.getPart(partName);
                        JMSFormatHandler fh = this.getFormatHandler(partName);
                        QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                        if (fh != null) {
                            fh.setPartQName(partQName);
                            message.setObject((Serializable)map.get(partName));
                            fh.read((Message)message);
                            this.setObjectPart(partName, fh.getObjectPart());
                        } else {
                            this.setObjectPart(partName, map.get(partName));
                        }
                    }
                    ++i;
                }
                message.setObject(object);
            } else {
                QName partQName;
                if (partNames.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart() + " or the JMS ObjectMessage should be a Map of " + "all the parts in the message");
                }
                String partName = partNames[0].toString();
                Part partModel = this.fieldMessageModel.getPart(partName);
                JMSFormatHandler fh = this.getFormatHandler(partName);
                QName qName = partQName = partModel.getElementName() != null ? partModel.getElementName() : partModel.getTypeName();
                if (fh != null) {
                    fh.setPartQName(partQName);
                    fh.read((Message)message);
                    this.setObjectPart(partName, fh.getObjectPart());
                } else {
                    this.setObjectPart(partName, message.getObject());
                }
            }
        }
        catch (JMSException e) {
            Trc.exception(e);
            throw new WSIFException("Error in read.", e);
        }
        Trc.exit();
    }

    private static String getFormatEncoding(Binding bindingModel) {
        Trc.entry(null, bindingModel);
        Iterator iterator = bindingModel.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (!(ee instanceof TypeMapping)) continue;
            TypeMapping typeMapping = (TypeMapping)ee;
            String s = typeMapping.getEncoding();
            Trc.exit(s);
            return s;
        }
        Trc.exit(null);
        return null;
    }

    private JMSFormatHandler getFormatHandler(String partName) {
        Trc.entry((Object)this, partName);
        Part partModel = this.fieldMessageModel.getPart(partName);
        JMSFormatHandler fh = null;
        QName partType = partModel.getTypeName();
        if (partType == null) {
            partType = partModel.getElementName();
        }
        try {
            fh = JMSMessage.isSchemaNamespace(partType.getNamespaceURI()) && JMSMessage.isXSDPrimitiveType(partType.getLocalPart()) ? new PrimitiveTypeFormatHandler((Class)PRIMITIVE_JAVA_MAPPING.get(partType.getLocalPart().toLowerCase())) : (JMSFormatHandler)WSIFUtils.getFormatHandler(partModel, this.fieldDefinitionModel, this.fieldBindingModel);
        }
        catch (Exception e) {
            Trc.exception(e);
        }
        Trc.exit(fh);
        return fh;
    }

    static boolean isSchemaNamespace(String namespaceURI) {
        return XML_SCHEMA_1999.equals(namespaceURI) || XML_SCHEMA_2000_10.equals(namespaceURI) || XML_SCHEMA_2001.equals(namespaceURI);
    }

    static boolean isXSDPrimitiveType(String type) {
        Trc.entry(null, type);
        Object[] types = PRIMITIVE_JAVA_MAPPING.keySet().toArray();
        int i = 0;
        while (i < types.length) {
            if (types[i].toString().equalsIgnoreCase(type)) {
                Trc.exit(true);
                return true;
            }
            ++i;
        }
        Trc.exit(false);
        return false;
    }

    private int getMessageType() {
        Trc.entry(this);
        Iterator iterator = this.fieldBindingModel.getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (!(ee instanceof JMSBinding)) continue;
            JMSBinding jmsBinding = (JMSBinding)ee;
            int type = jmsBinding.getJmsMessageType();
            Trc.exit(type);
            return type;
        }
        int type = 0;
        Trc.exit(type);
        return type;
    }

    private boolean isCorrectMessageType(Message message) {
        Trc.entry((Object)this, message);
        int type = this.getMessageType();
        boolean result = message instanceof TextMessage && type == 50 || message instanceof ObjectMessage && type == 30 || message instanceof StreamMessage && type == 40 || message instanceof BytesMessage && type == 10 || message instanceof MapMessage && type == 20;
        Trc.exit(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIMITIVE_JAVA_MAPPING.put("anySimpleType", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("anyURI", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("base64Binary", array$B == null ? (array$B = JMSMessage.class$("[B")) : array$B);
        PRIMITIVE_JAVA_MAPPING.put("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = JMSMessage.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        PRIMITIVE_JAVA_MAPPING.put("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = JMSMessage.class$("java.lang.Byte")) : class$java$lang$Byte);
        PRIMITIVE_JAVA_MAPPING.put("date", class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = JMSMessage.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar);
        PRIMITIVE_JAVA_MAPPING.put("dateTime", class$java$util$Date == null ? (class$java$util$Date = JMSMessage.class$("java.util.Date")) : class$java$util$Date);
        PRIMITIVE_JAVA_MAPPING.put("decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JMSMessage.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        PRIMITIVE_JAVA_MAPPING.put("double", class$java$lang$Double == null ? (class$java$lang$Double = JMSMessage.class$("java.lang.Double")) : class$java$lang$Double);
        PRIMITIVE_JAVA_MAPPING.put("duration", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("ENTITIES", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("ENTITY", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("float", class$java$lang$Float == null ? (class$java$lang$Float = JMSMessage.class$("java.lang.Float")) : class$java$lang$Float);
        PRIMITIVE_JAVA_MAPPING.put("gDay", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("gMonth", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("gMonthDay", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("gYear", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("gYearMonth", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("hexBinary", array$B == null ? (array$B = JMSMessage.class$("[B")) : array$B);
        PRIMITIVE_JAVA_MAPPING.put("ID", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("IDREF", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("IDREFS", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("int", class$java$lang$Integer == null ? (class$java$lang$Integer = JMSMessage.class$("java.lang.Integer")) : class$java$lang$Integer);
        PRIMITIVE_JAVA_MAPPING.put("integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("language", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("long", class$java$lang$Long == null ? (class$java$lang$Long = JMSMessage.class$("java.lang.Long")) : class$java$lang$Long);
        PRIMITIVE_JAVA_MAPPING.put("Name", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("NCName", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("negativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKEN", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKENS", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("nonNegativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("nonPositiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("normalizedString", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("NOTATION", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("positiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("QName", class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = JMSMessage.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        PRIMITIVE_JAVA_MAPPING.put("short", class$java$lang$Short == null ? (class$java$lang$Short = JMSMessage.class$("java.lang.Short")) : class$java$lang$Short);
        PRIMITIVE_JAVA_MAPPING.put("string", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("time", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("token", class$java$lang$String == null ? (class$java$lang$String = JMSMessage.class$("java.lang.String")) : class$java$lang$String);
        PRIMITIVE_JAVA_MAPPING.put("unsignedByte", class$java$lang$Short == null ? (class$java$lang$Short = JMSMessage.class$("java.lang.Short")) : class$java$lang$Short);
        PRIMITIVE_JAVA_MAPPING.put("unsignedInt", class$java$lang$Long == null ? (class$java$lang$Long = JMSMessage.class$("java.lang.Long")) : class$java$lang$Long);
        PRIMITIVE_JAVA_MAPPING.put("unsignedLong", class$java$math$BigInteger == null ? (class$java$math$BigInteger = JMSMessage.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        PRIMITIVE_JAVA_MAPPING.put("unsignedShort", class$java$lang$Integer == null ? (class$java$lang$Integer = JMSMessage.class$("java.lang.Integer")) : class$java$lang$Integer);
    }
}

