/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;

public class WSIFDynamicTypeMapping
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected QName xmlType;
    protected Class javaType;

    public WSIFDynamicTypeMapping() {
        this.xmlType = null;
        this.javaType = null;
    }

    public WSIFDynamicTypeMapping(QName xmlType, Class javaType) {
        Trc.entry(this, xmlType, javaType);
        this.xmlType = xmlType;
        this.javaType = javaType;
        Trc.exit();
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return "QName:" + this.xmlType + " Class:" + this.javaType;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.xmlType);
        if (this.javaType.isPrimitive()) {
            out.writeBoolean(true);
            out.writeObject(this.javaType.getName());
        } else {
            out.writeBoolean(false);
            out.writeObject(this.javaType);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xmlType = (QName)in.readObject();
        boolean primitive = in.readBoolean();
        if (primitive) {
            String primitiveClassName = (String)in.readObject();
            if (primitiveClassName.equals("int")) {
                this.javaType = Integer.TYPE;
            } else if (primitiveClassName.equals("float")) {
                this.javaType = Float.TYPE;
            } else if (primitiveClassName.equals("double")) {
                this.javaType = Double.TYPE;
            } else if (primitiveClassName.equals("boolean")) {
                this.javaType = Boolean.TYPE;
            } else if (primitiveClassName.equals("long")) {
                this.javaType = Long.TYPE;
            } else if (primitiveClassName.equals("short")) {
                this.javaType = Short.TYPE;
            } else if (primitiveClassName.equals("byte")) {
                this.javaType = Byte.TYPE;
            } else if (primitiveClassName.equals("void")) {
                this.javaType = Void.TYPE;
            }
        } else {
            this.javaType = (Class)in.readObject();
        }
    }
}

