/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ModelWSIFOperation;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMap;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;

public abstract class ModelWSIFPort
implements WSIFPort {
    protected Definition def;
    protected Service service;
    protected Port port;
    protected transient WSIFMessage context;
    protected WSIFDynamicTypeMap typeMap;
    protected ExtensibilityElement binding;
    protected boolean cacheOperations;
    protected transient HashMap cachedOperations;
    protected boolean autoTypeMappingSupported;
    protected boolean formatBindingSupported;
    protected HashMap formatBindingTypes;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Void;

    public ModelWSIFPort(Definition def, Port port, WSIFDynamicTypeMap typeMap) throws WSIFException {
        this(def, null, port, typeMap, null);
    }

    public ModelWSIFPort(Definition def, Service service, Port port, WSIFDynamicTypeMap typeMap, ExtensibilityElement binding) throws WSIFException {
        Trc.entry(this, def, service, port, typeMap, binding);
        this.def = def;
        this.service = service;
        this.port = port;
        this.binding = binding;
        this.typeMap = typeMap;
        this.autoTypeMappingSupported = true;
        this.cacheOperations = true;
        if (this.cacheOperations) {
            this.cachedOperations = new HashMap();
        }
        this.formatBindingSupported = false;
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String opName) throws WSIFException {
        Trc.entry((Object)this, opName);
        WSIFOperation op = this.createOperation(opName, null, null);
        Trc.exit(op);
        return op;
    }

    public WSIFOperation createOperation(String opName, String inputName, String outputName) throws WSIFException {
        BindingOperation wsdlBindingOperation;
        Trc.entry(this, opName, inputName, outputName);
        ModelWSIFOperation wsifOp = null;
        String cacheKey = null;
        if (this.cacheOperations) {
            cacheKey = opName + ":" + inputName + ":" + outputName;
            wsifOp = (ModelWSIFOperation)this.cachedOperations.get(cacheKey);
        }
        if (wsifOp == null && (wsdlBindingOperation = WSIFUtils.getBindingOperation(this.port.getBinding(), opName, inputName, outputName)) != null) {
            wsifOp = this.makeWSIFOperation(this, wsdlBindingOperation);
        }
        if (wsifOp == null) {
            throw new WSIFException("Could not create operation: " + opName + ":" + inputName + ":" + outputName);
        }
        if (this.cacheOperations) {
            this.cachedOperations.put(cacheKey, wsifOp);
        }
        wsifOp.initialise();
        Trc.exit(wsifOp);
        return wsifOp;
    }

    protected boolean isAutoTypeMappingSupported() {
        return this.autoTypeMappingSupported;
    }

    protected void setAutoTypeMappingSupported(boolean autoTypeMappingSupported) {
        this.autoTypeMappingSupported = autoTypeMappingSupported;
    }

    public boolean isCacheOperations() {
        return this.cacheOperations;
    }

    protected void setCacheOperations(boolean cacheOperations) {
        this.cacheOperations = cacheOperations;
    }

    public ExtensibilityElement getBinding() {
        return this.binding;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public Port getPort() {
        return this.port;
    }

    public Service getService() {
        return this.service;
    }

    public WSIFDynamicTypeMap getTypeMap() {
        return this.typeMap;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage contextCopy;
        Trc.entry(this);
        if (this.context == null) {
            this.context = new WSIFDefaultMessage();
        }
        try {
            contextCopy = (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WSIFException("CloneNotSupportedException cloning context: ", e);
        }
        Trc.exit(contextCopy);
        return contextCopy;
    }

    public void setContext(WSIFMessage context) {
        Trc.entry((Object)this, context);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = context;
        Trc.exit(null);
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(false);
        return false;
    }

    public boolean isFormatBindingSupported() {
        return this.formatBindingSupported;
    }

    protected void setFormatBindingSupported(boolean formatBindingSupported) {
        this.formatBindingSupported = formatBindingSupported;
    }

    public void finalize() throws Throwable {
        Trc.entry(this);
        try {
            this.close();
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        super.finalize();
        Trc.exit();
    }

    protected Class getClassForPart(Part p) throws WSIFException {
        QName partType = ProviderUtils.getPartType(p);
        Class partClass = null;
        if (partClass == null && this.isFormatBindingSupported()) {
            partClass = this.getFormatBindingType(partType);
        }
        if (!this.isFormatBindingSupported() || this.isAutoTypeMappingSupported()) {
            partClass = this.getDynamicTypeClass(partType);
            if (partClass == null) {
                partClass = this.getStandardType(partType);
            }
            if (partClass == null) {
                // empty if block
            }
        }
        if (partClass == null) {
            partClass = this.doNoClassForPart(partType, p);
        }
        return partClass;
    }

    protected Class doNoClassForPart(QName partType, Part p) throws WSIFException {
        throw new WSIFException("cannot determine class for type: " + partType);
    }

    protected Class getDynamicTypeClass(QName partType) {
        Class partClass = null;
        Iterator i = this.typeMap.iterator();
        while (partClass == null && i.hasNext()) {
            WSIFDynamicTypeMapping mapping = (WSIFDynamicTypeMapping)i.next();
            if (!partType.equals(mapping.getXmlType())) continue;
            partClass = mapping.javaType;
        }
        return partClass;
    }

    protected Class getFormatBindingType(QName partType) throws WSIFException {
        Class partClass = null;
        if (this.formatBindingTypes == null && this.isFormatBindingSupported()) {
            this.initializeFormatBindingTypes();
        }
        if (this.formatBindingTypes != null) {
            Iterator i = this.formatBindingTypes.keySet().iterator();
            while (partClass == null && i.hasNext()) {
                QName fbType = (QName)i.next();
                if (!fbType.equals(partType)) continue;
                partClass = (Class)this.formatBindingTypes.get(partType);
            }
        }
        return partClass;
    }

    protected Class getStandardType(QName partType) throws WSIFException {
        Class partClass = null;
        Map simpleTypes = WSIFUtils.getSimpleTypesMap();
        String className = (String)simpleTypes.get(partType);
        if (className != null && className.length() > 0) {
            char c = className.charAt(0);
            partClass = className.indexOf(46) < 0 && Character.isLowerCase(c) ? this.getPrimitiveClass(className) : ('[' == c ? this.getArrayClass(className) : this.getClassForType(className));
        }
        return partClass;
    }

    protected Class getPrimitiveClass(String primitiveName) {
        Class javaClass = null;
        if (primitiveName.equals("int")) {
            javaClass = class$java$lang$Integer == null ? (class$java$lang$Integer = ModelWSIFPort.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (primitiveName.equals("float")) {
            javaClass = class$java$lang$Float == null ? (class$java$lang$Float = ModelWSIFPort.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (primitiveName.equals("double")) {
            javaClass = class$java$lang$Double == null ? (class$java$lang$Double = ModelWSIFPort.class$("java.lang.Double")) : class$java$lang$Double;
        } else if (primitiveName.equals("boolean")) {
            javaClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ModelWSIFPort.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        } else if (primitiveName.equals("long")) {
            javaClass = class$java$lang$Long == null ? (class$java$lang$Long = ModelWSIFPort.class$("java.lang.Long")) : class$java$lang$Long;
        } else if (primitiveName.equals("short")) {
            javaClass = class$java$lang$Short == null ? (class$java$lang$Short = ModelWSIFPort.class$("java.lang.Short")) : class$java$lang$Short;
        } else if (primitiveName.equals("byte")) {
            javaClass = class$java$lang$Byte == null ? (class$java$lang$Byte = ModelWSIFPort.class$("java.lang.Byte")) : class$java$lang$Byte;
        } else if (primitiveName.equals("void")) {
            javaClass = class$java$lang$Void == null ? (class$java$lang$Void = ModelWSIFPort.class$("java.lang.Void")) : class$java$lang$Void;
        }
        return javaClass;
    }

    protected Class getArrayClass(String type) {
        Class typeClass = null;
        return typeClass;
    }

    protected Class getClassForType(String className) throws WSIFException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, cl);
        }
        catch (Throwable ex) {
            throw new WSIFException("exception getting class for simple type '" + clazz + "': " + ex);
        }
        return clazz;
    }

    protected void initializeFormatBindingTypes() throws WSIFException {
        Trc.entry(this);
        TypeMapping typeMapping = this.getFormatTypeMapping();
        if (typeMapping == null) {
            this.doMissingFormatTypeMapping();
        }
        this.formatBindingTypes = new HashMap();
        if (typeMapping != null) {
            List typeMaps = typeMapping.getMaps();
            Iterator i = typeMaps.iterator();
            while (i.hasNext()) {
                TypeMap typeMap = (TypeMap)i.next();
                QName typeName = typeMap.getTypeName();
                if (typeName == null) {
                    typeName = typeMap.getElementName();
                }
                String className = typeMap.getFormatType();
                Class typeClass = this.getNamedClass(className);
                if (typeName != null && typeClass != null) {
                    this.formatBindingTypes.put(typeName, typeClass);
                    continue;
                }
                throw new WSIFException("Error in binding TypeMap. Key or Value is null");
            }
        }
        Trc.exit();
    }

    protected TypeMapping getFormatTypeMapping() {
        TypeMapping typeMapping = null;
        Iterator bindingIterator = this.port.getBinding().getExtensibilityElements().iterator();
        while (bindingIterator.hasNext()) {
            Object next = bindingIterator.next();
            if (!(next instanceof TypeMapping)) continue;
            typeMapping = (TypeMapping)next;
            if ("Java".equals(typeMapping.getEncoding()) && "Java".equals(typeMapping.getStyle())) break;
            typeMapping = null;
        }
        return typeMapping;
    }

    protected void doMissingFormatTypeMapping() throws WSIFException {
    }

    protected Class getNamedClass(String className) throws WSIFException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, cl);
        }
        catch (Throwable ex) {
            Trc.exception(ex);
            this.doUnknownClassName(className);
        }
        return clazz;
    }

    protected void doUnknownClassName(String className) throws WSIFException {
        throw new WSIFException("can not find Java class for formatType: " + className);
    }

    protected void doInitialize() throws WSIFException {
    }

    protected abstract ModelWSIFOperation makeWSIFOperation(ModelWSIFPort var1, BindingOperation var2) throws WSIFException;

    protected abstract Class getImplementedAddressClass();

    protected abstract void validateAddress(ExtensibilityElement var1) throws WSIFException;

    public abstract void close() throws WSIFException;

    public String deep() {
        StringBuffer buff = new StringBuffer();
        buff.append(super.toString() + ":\n");
        buff.append("definition:");
        buff.append(Trc.brief(this.def));
        buff.append(" service:");
        buff.append(Trc.brief(this.service));
        buff.append(" portModel:");
        buff.append(Trc.brief(this.port));
        buff.append(" context:");
        buff.append(this.context);
        buff.append(" typeMap:");
        buff.append(this.typeMap);
        buff.append(" binding:");
        buff.append(this.binding);
        buff.append(" autoTypeMappingSupported:");
        buff.append(this.autoTypeMappingSupported);
        buff.append(" cacheOperations:");
        buff.append(this.cacheOperations);
        buff.append(" cachedOperations:");
        buff.append(this.cachedOperations);
        buff.append(" formatBindingSupported:");
        buff.append(this.formatBindingSupported);
        buff.append(" formatBindingTypes:");
        buff.append(this.formatBindingTypes);
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

