/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.schema.tools;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.wsif.compiler.schema.SchemaException;
import org.apache.wsif.compiler.schema.tools.ClassField;
import org.apache.wsif.compiler.schema.tools.ClassFile;
import org.apache.wsif.compiler.schema.tools.Conventions;
import org.apache.wsif.compiler.schema.tools.SchemaAny;
import org.apache.wsif.compiler.schema.tools.SchemaAnyAttribute;
import org.apache.wsif.compiler.schema.tools.SchemaAttribute;
import org.apache.wsif.compiler.schema.tools.SchemaAttributeGroup;
import org.apache.wsif.compiler.schema.tools.SchemaComplexType;
import org.apache.wsif.compiler.schema.tools.SchemaElement;
import org.apache.wsif.compiler.schema.tools.SchemaGroup;
import org.apache.wsif.compiler.schema.tools.SchemaMGS;
import org.apache.wsif.compiler.schema.tools.SchemaSimpleType;
import org.apache.wsif.compiler.schema.tools.SchemaType;
import org.apache.wsif.compiler.util.StreamFactory;
import org.apache.wsif.compiler.util.TypeMapping;
import org.apache.wsif.logging.Trc;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Schema2Java {
    private HashMap registry = new HashMap();
    private String workingDirectory;
    private HashMap namespaceRegistry = new HashMap();
    private HashMap undefinedRegistry = new HashMap();
    private Vector schemaElementList = new Vector();
    private String packageName = "";
    private boolean verbose = true;
    private boolean overwrite = false;
    private boolean javac = true;

    public Schema2Java(String schemaURI) {
        this.registry.put(new QName(schemaURI, "string"), "java.lang.String");
        this.registry.put(new QName(schemaURI, "integer"), "java.math.BigInteger");
        this.registry.put(new QName(schemaURI, "boolean"), "boolean");
        this.registry.put(new QName(schemaURI, "float"), "float");
        this.registry.put(new QName(schemaURI, "double"), "double");
        this.registry.put(new QName(schemaURI, "binary"), "[B");
        this.registry.put(new QName(schemaURI, "base64Binary"), "[B");
        this.registry.put(new QName(schemaURI, "hexBinary"), "[B");
        this.registry.put(new QName(schemaURI, "long"), "long");
        this.registry.put(new QName(schemaURI, "int"), "int");
        this.registry.put(new QName(schemaURI, "short"), "short");
        this.registry.put(new QName(schemaURI, "decimal"), "java.math.BigDecimal");
        this.registry.put(new QName(schemaURI, "QName"), "javax.xml.namespace.QName");
        if (schemaURI.equals("http://www.w3.org/2001/XMLSchema")) {
            this.registry.put(new QName(schemaURI, "dateTime"), "java.util.Calendar");
        } else {
            this.registry.put(new QName(schemaURI, "timeInstant"), "java.util.Calendar");
        }
        this.registry.put(new QName(schemaURI, "byte"), "byte");
        this.registry.put(new QName(schemaURI, "void"), "void");
        this.registry.put(new QName(schemaURI, "ur-type"), "java.lang.Object");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "string"), "java.lang.String");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), "java.lang.Boolean");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), "java.lang.Float");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), "java.lang.Double");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "decimal"), "java.math.BigDecimal");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), "java.lang.Integer");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), "java.lang.Short");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), "java.lang.Byte");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64"), "[B");
    }

    private ClassFile any2Field(SchemaAny any, ClassFile file) {
        if (any == null || file == null) {
            throw new IllegalArgumentException("Argument to 'any2Field' cannot be null.");
        }
        file.addField(new ClassField("byte[]", Conventions.schema2JavaName("any", null, false), any.isArray()));
        return file;
    }

    private ClassFile anyAttribute2Field(SchemaAnyAttribute anyAttr, ClassFile file) {
        if (anyAttr == null || file == null) {
            throw new IllegalArgumentException("Argument to 'anyAttribute2Field' cannot be null.");
        }
        file.addField(new ClassField("byte[]", Conventions.schema2JavaName("anyAttribute", null, false), false));
        return file;
    }

    private ClassFile attribute2Field(SchemaAttribute attr, ClassFile file) throws SchemaException {
        if (attr == null || file == null) {
            throw new IllegalArgumentException("Argument to 'attribute2Field' cannot be null.");
        }
        QName type = attr.getType();
        QName ref = attr.getRef();
        SchemaSimpleType simp = attr.getChild();
        String targetURI = attr.getTargetURI();
        if (ref != null) {
            ClassField field = new ClassField(this.getJavaType(ref, targetURI, "attribute"), Conventions.schema2JavaName("attribute", ref.getLocalPart(), false), false);
            file.addField(field);
        } else if (type != null) {
            ClassField field = new ClassField(this.getJavaType(type, targetURI, "simpleType"), Conventions.schema2JavaName("attribute", attr.getName(), false), false);
            file.addField(field);
        } else if (simp != null) {
            String name = Conventions.schema2JavaName("attribute", attr.getName(), false);
            file = this.simpleType2Field(name, false, simp, file);
        }
        return file;
    }

    private ClassFile attributeGroup2Class(SchemaAttributeGroup attrGp) throws SchemaException {
        if (attrGp == null) {
            throw new IllegalArgumentException("Argument to 'attributeGroup2Class' cannot be null.");
        }
        String className = Conventions.schema2JavaName("attributeGroup", attrGp.getName(), true);
        ClassFile file = new ClassFile(className);
        Vector children = attrGp.getChildren();
        int i = 0;
        while (i < children.size()) {
            SchemaType child = (SchemaType)children.elementAt(i);
            switch (child.getElementType()) {
                case 4: {
                    file = this.attributeGroup2Field((SchemaAttributeGroup)child, file);
                    break;
                }
                case 3: {
                    file = this.attribute2Field((SchemaAttribute)child, file);
                    break;
                }
            }
            ++i;
        }
        return file;
    }

    private ClassFile attributeGroup2Field(SchemaAttributeGroup attrGp, ClassFile file) throws SchemaException {
        if (attrGp == null || file == null) {
            throw new IllegalArgumentException("Argument to 'attributeGroup2Field' cannot be null.");
        }
        QName ref = attrGp.getRef();
        if (ref == null) {
            throw new SchemaException("Attribute group can only be defined at the top level.");
        }
        ClassField field = new ClassField(this.getJavaType(ref, attrGp.getTargetURI(), "attributeGroup"), Conventions.schema2JavaName("attributeGroup", ref.getLocalPart(), false), false);
        file.addField(field);
        return file;
    }

    private ClassFile complexType2Class(String className, SchemaComplexType elm) throws SchemaException {
        if (className == null || elm == null) {
            throw new IllegalArgumentException("Argument to 'complexType2Class' cannot be null.");
        }
        QName base = elm.getBase();
        ClassFile file = new ClassFile(className);
        if (base != null) {
            file.superClassName = this.getJavaType(base, elm.getTargetURI(), "complexType");
        }
        Vector children = elm.getChildren();
        int i = 0;
        while (i < children.size()) {
            SchemaType child = (SchemaType)children.elementAt(i);
            String name = child.getName();
            switch (child.getElementType()) {
                case 2: {
                    file = this.element2Field((SchemaElement)child, file);
                    break;
                }
                case 5: {
                    file = this.group2Field((SchemaGroup)child, file);
                    break;
                }
                case 3: {
                    file = this.attribute2Field((SchemaAttribute)child, file);
                    break;
                }
                case 4: {
                    file = this.attributeGroup2Field((SchemaAttributeGroup)child, file);
                    break;
                }
                case 6: {
                    file = this.any2Field((SchemaAny)child, file);
                    break;
                }
                case 7: {
                    file = this.anyAttribute2Field((SchemaAnyAttribute)child, file);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    file = this.mgs2Field((SchemaMGS)child, file);
                }
            }
            ++i;
        }
        return file;
    }

    public Map createJavaMapping(Element root, Map reg) throws SchemaException {
        if (root == null || reg == null) {
            throw new IllegalArgumentException("Argument to 'createJavaMapping' cannot be null.");
        }
        String targetURI = root.getAttribute("targetNamespace");
        Vector elements = this.parseSchemaRoot(root, targetURI);
        int i = 0;
        while (i < elements.size()) {
            this.schemaElementList.addElement(elements.elementAt(i));
            ++i;
        }
        this.updateRegistry(this.schemaElementList);
        return this.getRegistry(reg);
    }

    private ClassFile element2Field(SchemaElement elm, ClassFile file) throws SchemaException {
        if (elm == null || file == null) {
            throw new IllegalArgumentException("Argument to 'element2Field' cannot be null.");
        }
        String name = elm.getName();
        QName ref = elm.getRef();
        QName type = elm.getType();
        SchemaType child = elm.getChild();
        String targetURI = elm.getTargetURI();
        if (name != null) {
            name = Conventions.schema2JavaName("element", name, false);
        }
        if (ref != null) {
            String javaType = this.getJavaType(ref, targetURI, "element");
            file.addField(new ClassField(javaType, Conventions.schema2JavaName("element", ref.getLocalPart(), false), elm.isArray()));
        } else if (type != null) {
            String javaType = this.getJavaType(type, targetURI, "complexType");
            file.addField(new ClassField(javaType, name, elm.isArray()));
        } else {
            if (child == null) {
                throw new SchemaException("The type of this element is unknown: '" + name + "'.");
            }
            if (child.getElementType() == 1) {
                file = this.simpleType2Field(name, elm.isArray(), (SchemaSimpleType)child, file);
            } else if (child.getElementType() == 0) {
                throw new SchemaException("Inner complex-types are not supported: '" + name + "'.");
            }
        }
        return file;
    }

    private QName getAttributeQName(Element element, String attr) {
        if (element == null || attr == null) {
            throw new IllegalArgumentException("Argument to 'getAttrQName' cannot be null.");
        }
        String name = DOMUtils.getAttribute((Element)element, (String)attr);
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(":");
        String prefix = null;
        if (index != -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1);
        }
        String uri = DOMUtils.getNamespaceURIFromPrefix((Node)element, prefix);
        return new QName(uri, name);
    }

    private String getGenericJavaName(QName qName, String elementType) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument to 'getGenericJavaName' cannot be null.");
        }
        String javaName = (String)this.undefinedRegistry.get(qName);
        if (javaName != null) {
            return javaName;
        }
        String javaPath = this.getNamespaceURIMapping(qName.getNamespaceURI());
        String name = qName.getLocalPart();
        name = Conventions.schema2JavaName(elementType, name, true);
        javaName = javaPath.compareTo("") != 0 ? javaPath + "." + name : name;
        this.undefinedRegistry.put(qName, javaName);
        Trc.event(this, "Schema name ", qName, " is undefined, and so generic Java name ", javaName, " is used instead.");
        return javaName;
    }

    private String getJavaType(QName name, String targetURI, String elementType) throws SchemaException {
        if (name == null) {
            throw new IllegalArgumentException("Argument to 'getJavaType' cannot be null.");
        }
        String type = (String)this.registry.get(name);
        if (type == null) {
            throw new SchemaException("Basic type '" + name + "' not supported.");
        }
        String targetNS = this.getNamespaceURIMapping(targetURI);
        if (type.startsWith(targetNS)) {
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        return type;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getNamespaceURIMapping(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Argument to 'getNamespaceURIMapping' cannot be null.");
        }
        if (namespaceURI.compareTo("") == 0) {
            return "";
        }
        if (this.packageName != null && !this.packageName.equals("")) {
            return this.packageName;
        }
        String javaPath = (String)this.namespaceRegistry.get(namespaceURI);
        if (javaPath == null) {
            javaPath = Conventions.namespaceURI2JavaPath(namespaceURI);
            this.namespaceRegistry.put(namespaceURI, javaPath);
        }
        return javaPath;
    }

    public Map getRegistry(Map reg) {
        Iterator i = this.registry.keySet().iterator();
        while (i.hasNext()) {
            QName key = (QName)i.next();
            reg.put(key, new TypeMapping(key, (String)this.registry.get(key)));
        }
        return reg;
    }

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        return this.workingDirectory;
    }

    private ClassFile group2Class(SchemaGroup gp) throws SchemaException {
        if (gp == null) {
            throw new IllegalArgumentException("Argument to 'group2Class' cannot be null.");
        }
        SchemaMGS child = gp.getChild();
        String className = Conventions.schema2JavaName("group", gp.getName(), true);
        ClassFile file = new ClassFile(className);
        file = this.mgs2Field(child, file);
        return file;
    }

    private ClassFile group2Field(SchemaGroup gp, ClassFile file) throws SchemaException {
        if (gp == null || file == null) {
            throw new IllegalArgumentException("Argument to 'group2Field' cannot be null.");
        }
        QName ref = gp.getRef();
        if (ref != null) {
            String javaType = this.getJavaType(ref, gp.getTargetURI(), "group");
            file.addField(new ClassField(javaType, Conventions.schema2JavaName("group", ref.getLocalPart(), false), gp.isArray()));
        }
        return file;
    }

    private ClassFile mgs2Class(String className, SchemaMGS elm) throws SchemaException {
        if (className == null || elm == null) {
            throw new IllegalArgumentException("Argument to 'mgs2Class' cannot be null.");
        }
        ClassFile file = new ClassFile(className);
        Vector children = elm.getChildren();
        int i = 0;
        while (i < children.size()) {
            SchemaType child = (SchemaType)children.elementAt(i);
            switch (child.getElementType()) {
                case 2: {
                    this.element2Field((SchemaElement)child, file);
                    break;
                }
                case 5: {
                    this.group2Field((SchemaGroup)child, file);
                    break;
                }
                case 6: 
                case 9: 
                case 10: {
                    this.mgs2Field((SchemaMGS)child, file);
                }
            }
            ++i;
        }
        return file;
    }

    private ClassFile mgs2Field(SchemaMGS mgs, ClassFile file) throws SchemaException {
        String mgsType;
        if (mgs == null || file == null) {
            throw new IllegalArgumentException("Argument to 'mgs2Field' cannot be null.");
        }
        switch (mgs.getElementType()) {
            case 8: {
                mgsType = "all";
                break;
            }
            case 9: {
                mgsType = "choice";
                break;
            }
            case 10: {
                mgsType = "sequence";
                break;
            }
            default: {
                return file;
            }
        }
        String cname = Conventions.schema2JavaName(mgsType, null, true);
        String fname = Conventions.schema2JavaName(mgsType, null, false);
        file.addField(new ClassField(cname, fname, mgs.isArray()));
        file.addInnerClass(this.mgs2Class(cname, mgs));
        return file;
    }

    public void outputJavaMapping() throws SchemaException, IOException {
        Vector<ClassFile> classFileList = new Vector<ClassFile>();
        int i = 0;
        while (i < this.schemaElementList.size()) {
            SchemaType element = (SchemaType)this.schemaElementList.elementAt(i);
            ClassFile file = null;
            switch (element.getElementType()) {
                case 0: {
                    SchemaComplexType cmp = (SchemaComplexType)element;
                    String className = Conventions.schema2JavaName("complexType", cmp.getName(), true);
                    file = this.complexType2Class(className, cmp);
                    break;
                }
                case 5: {
                    file = this.group2Class((SchemaGroup)element);
                    break;
                }
                case 4: {
                    file = this.attributeGroup2Class((SchemaAttributeGroup)element);
                    break;
                }
                case 2: {
                    SchemaElement el = (SchemaElement)element;
                    SchemaType child = el.getChild();
                    if (child == null || child.getElementType() != 0) break;
                    String className = Conventions.schema2JavaName("element", el.getName(), true);
                    file = this.complexType2Class(className, (SchemaComplexType)el.getChild());
                }
            }
            if (file != null) {
                file.packageName = this.getNamespaceURIMapping(element.getTargetURI());
                classFileList.addElement(file);
            }
            ++i;
        }
        int classCount = classFileList.size();
        String[] fileNames = new String[classCount];
        StreamFactory streamFactory = new StreamFactory();
        int classIndex = 0;
        while (classIndex < classCount) {
            ClassFile classFile = (ClassFile)classFileList.elementAt(classIndex);
            String javaPathName = Conventions.getJavaPathName(this.getWorkingDirectory(), classFile.packageName);
            String javaFileName = classFile.className + ".java";
            OutputStream os = streamFactory.getOutputStream(javaPathName, javaFileName, this.overwrite);
            OutputStreamWriter classWriter = new OutputStreamWriter(os);
            classWriter.write("/*\n *This class is automatically generated by schema to Java program.\n");
            classWriter.write(" *Only a subset of schema is handled and some of the schema information\n");
            classWriter.write(" *may be lost during translation\n */\n\n");
            if (classFile.packageName != null) {
                classWriter.write("package " + classFile.packageName + ";\n\n");
            }
            this.printJavaFile(classWriter, classFile, null);
            ((Writer)classWriter).flush();
            ((Writer)classWriter).close();
            fileNames[classIndex] = new File(javaPathName, javaFileName).getAbsolutePath();
            ++classIndex;
        }
        if (this.javac) {
            int i2 = 0;
            while (i2 < classCount) {
                if (Conventions.JDKcompile(fileNames[i2], this.getWorkingDirectory()) && this.verbose) {
                    System.out.println("Compiled file '" + fileNames[i2] + "'.");
                }
                ++i2;
            }
        }
    }

    private Vector parseSchemaRoot(Element root, String targetURI) throws SchemaException {
        if (root == null) {
            throw new IllegalArgumentException("Argument to 'parseSchemaRoot' cannot be null.");
        }
        Node child = root.getFirstChild();
        Vector<SchemaType> elements = new Vector<SchemaType>();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element element = (Element)child;
                String elementType = element.getLocalName();
                if (elementType == null) {
                    return null;
                }
                String name = DOMUtils.getAttribute((Element)element, (String)"name");
                QName type = this.getAttributeQName(element, "type");
                boolean isArray = false;
                if (name == null || name.indexOf("ArrayOf_") < 0) {
                    if (elementType.equals("complexType")) {
                        boolean isFinal = false;
                        boolean isAbstract = false;
                        QName base = null;
                        Vector children = this.parseSchemaRoot(element, targetURI);
                        elements.addElement(new SchemaComplexType(name, base, isAbstract, isFinal, children, targetURI));
                    } else if (elementType.equals("simpleType")) {
                        QName base = null;
                        boolean isList = false;
                        elements.addElement(new SchemaSimpleType(name, base, isList, targetURI));
                    } else if (elementType.equals("element")) {
                        QName ref = null;
                        elements.addElement(new SchemaElement(name, ref, type, isArray, null, targetURI));
                    }
                }
            }
            child = child.getNextSibling();
        }
        return elements;
    }

    private void printJavaFile(Writer classWriter, ClassFile classFile, String tab) throws IOException {
        String className = classFile.className;
        String superClassName = classFile.superClassName;
        if (tab == null) {
            tab = "";
            classWriter.write("public ");
        } else {
            classWriter.write(tab);
        }
        if (classFile.isAbstract) {
            classWriter.write("abstract ");
        } else if (classFile.isFinal) {
            classWriter.write("final");
        }
        if (superClassName != null) {
            classWriter.write("class " + className + " extends " + superClassName + "{\n");
        } else {
            classWriter.write("class " + className + "{\n");
        }
        classWriter.write("\n" + tab + "\t//instance variables\n");
        int fieldLength = classFile.getFieldCount();
        int fieldIndex = 0;
        while (fieldIndex < fieldLength) {
            ClassField classField = classFile.getField(fieldIndex);
            classWriter.write(tab + "\tprivate " + classField.fieldType);
            if (classField.isArray) {
                classWriter.write("[]");
            }
            classWriter.write("\t" + classField.fieldName + ";\n");
            ++fieldIndex;
        }
        classWriter.write("\n" + tab + "\t//constructors\n");
        if (fieldLength > 0) {
            classWriter.write(tab + "\tpublic " + className + " () { }\n");
        }
        classWriter.write("\n" + tab + "\tpublic " + className + " (");
        int fieldIndex2 = 0;
        while (fieldIndex2 < fieldLength) {
            ClassField classField = classFile.getField(fieldIndex2);
            classWriter.write(classField.fieldType);
            if (classField.isArray) {
                classWriter.write("[]");
            }
            classWriter.write(" " + classField.fieldName);
            if (fieldIndex2 < fieldLength - 1) {
                classWriter.write(", ");
            }
            ++fieldIndex2;
        }
        classWriter.write(") {\n");
        int fieldIndex3 = 0;
        while (fieldIndex3 < fieldLength) {
            ClassField classField = classFile.getField(fieldIndex3);
            classWriter.write(tab + "\t\tthis." + classField.fieldName + "\t= " + classField.fieldName + ";\n");
            ++fieldIndex3;
        }
        classWriter.write(tab + "\t}\n");
        int fieldIndex4 = 0;
        while (fieldIndex4 < fieldLength) {
            ClassField classField = classFile.getField(fieldIndex4);
            String propertyName = Character.toUpperCase(classField.fieldName.charAt(0)) + classField.fieldName.substring(1);
            classWriter.write("\n" + tab + "\tpublic ");
            if (classField.isArray) {
                classWriter.write("[]");
            }
            classWriter.write(classField.fieldType + " get" + propertyName + "() {\n");
            classWriter.write(tab + "\t\treturn " + classField.fieldName + ";\n");
            classWriter.write(tab + "\t}\n");
            classWriter.write("\n" + tab + "\tpublic ");
            classWriter.write(" void set" + propertyName + "(" + classField.fieldType);
            if (classField.isArray) {
                classWriter.write("[]");
            }
            classWriter.write(" " + classField.fieldName + ") {\n");
            classWriter.write(tab + "\t\tthis." + classField.fieldName + "\t= " + classField.fieldName + ";\n");
            classWriter.write(tab + "\t}\n");
            ++fieldIndex4;
        }
        classWriter.write("\n\tpublic String toString() {\n");
        classWriter.write("\t\treturn ");
        int fieldIndex5 = 0;
        while (fieldIndex5 < fieldLength) {
            ClassField classField = classFile.getField(fieldIndex5);
            if (fieldIndex5 > 0) {
                classWriter.write(" + \"\\n\" + \n\t\t\t");
            }
            classWriter.write("\"" + classField.fieldName + "=\" + " + classField.fieldName);
            ++fieldIndex5;
        }
        classWriter.write(";\n\t}\n");
        int innerClassCount = classFile.getInnerClassCount();
        if (innerClassCount > 0) {
            classWriter.write("\n" + tab + "\t//Inner classes\n");
            int innerClassIndex = 0;
            while (innerClassIndex < innerClassCount) {
                ClassFile innerClassFile = classFile.getInnerClass(innerClassIndex);
                this.printJavaFile(classWriter, innerClassFile, tab + "\t");
                ++innerClassIndex;
            }
        }
        classWriter.write("\n" + tab + "}");
    }

    public void setNamespaceURIMapping(String namespaceURI, String javaPath) {
        if (namespaceURI == null || javaPath == null) {
            throw new IllegalArgumentException("Argument to 'setNamespaceURIMapping' cannot be null.");
        }
        this.namespaceRegistry.put(namespaceURI, javaPath);
    }

    public void setWorkingDirectory(String dir) throws IllegalArgumentException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument to 'setWorkingDirectory' cannot be null.");
        }
        this.workingDirectory = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setJavac(boolean javac) {
        this.javac = javac;
    }

    private ClassFile simpleType2Field(String name, boolean isArray, SchemaSimpleType simp, ClassFile file) throws SchemaException {
        if (name == null || simp == null || file == null) {
            throw new IllegalArgumentException("Argument to 'simpleType2Field' cannot be null.");
        }
        QName base = simp.getBase();
        String type = this.getJavaType(base, simp.getTargetURI(), "simpleType");
        if (simp.isList()) {
            type = type + "[]";
        }
        file.addField(new ClassField(type, name, isArray));
        return file;
    }

    private void updateRegistry(Vector elements) throws SchemaException {
        QName qName;
        if (elements == null) {
            throw new IllegalArgumentException("Argument to 'updateRegistry' cannot be null.");
        }
        HashMap<QName, SchemaType> simpleTypeTable = new HashMap<QName, SchemaType>();
        int i = 0;
        while (i < elements.size()) {
            SchemaType element = (SchemaType)elements.elementAt(i);
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            qName = new QName(element.getTargetURI(), name);
            if (element.getElementType() == 1) {
                simpleTypeTable.put(qName, element);
            }
            ++i;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator it = simpleTypeTable.keySet().iterator();
            while (it.hasNext()) {
                String javaType;
                qName = (QName)it.next();
                SchemaSimpleType simpleType = (SchemaSimpleType)simpleTypeTable.get(qName);
                QName base = simpleType.getBase();
                boolean isList = simpleType.isList();
                if (base != null) {
                    javaType = (String)this.registry.get(base);
                    if (javaType == null) {
                        if (simpleTypeTable.containsKey(base)) continue;
                        javaType = this.getGenericJavaName(base, "simpleType");
                    }
                    if (isList) {
                        javaType = javaType + "[]";
                    }
                    this.registry.put(qName, javaType);
                    changed = true;
                    simpleTypeTable.remove(qName);
                    continue;
                }
                javaType = this.getGenericJavaName(qName, "simpleType");
                this.registry.put(qName, javaType);
            }
        }
        Iterator it2 = simpleTypeTable.keySet().iterator();
        while (it2.hasNext()) {
            if (this.registry.containsKey((QName)it2.next())) continue;
            throw new SchemaException("'simpleType' definitions have cyclic dependency.");
        }
        int i2 = 0;
        while (i2 < elements.size()) {
            String name;
            SchemaType element = (SchemaType)elements.elementAt(i2);
            String targetURI = element.getTargetURI();
            String targetNSPrefix = this.getNamespaceURIMapping(targetURI);
            if (targetNSPrefix.compareTo("") != 0) {
                targetNSPrefix = targetNSPrefix + ".";
            }
            if ((name = element.getName()) == null) {
                name = "";
            }
            QName qName2 = new QName(targetURI, name);
            switch (element.getElementType()) {
                case 0: {
                    this.registry.put(qName2, targetNSPrefix + Conventions.schema2JavaName("complexType", name, true));
                    break;
                }
                case 5: {
                    this.registry.put(qName2, targetNSPrefix + Conventions.schema2JavaName("group", name, true));
                    break;
                }
                case 4: {
                    this.registry.put(qName2, targetNSPrefix + Conventions.schema2JavaName("attributeGroup", name, true));
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < elements.size()) {
            SchemaType element = (SchemaType)elements.elementAt(i3);
            String name = element.getName();
            String targetURI = element.getTargetURI();
            String targetNSPrefix = this.getNamespaceURIMapping(targetURI);
            if (targetNSPrefix.compareTo("") != 0) {
                targetNSPrefix = targetNSPrefix + ".";
            }
            if (name == null) {
                name = "";
            }
            QName qName3 = new QName(targetURI, name);
            switch (element.getElementType()) {
                case 2: {
                    SchemaElement schemaElement = (SchemaElement)element;
                    QName type = schemaElement.getType();
                    SchemaType child = schemaElement.getChild();
                    if (type != null) {
                        String javaType = (String)this.registry.get(type);
                        if (javaType == null) break;
                        this.registry.put(qName3, javaType);
                        break;
                    }
                    if (child == null) break;
                    if (child.getElementType() == 1) {
                        QName base = ((SchemaSimpleType)child).getBase();
                        String javaType = (String)this.registry.get(base);
                        if (javaType == null) break;
                        if (((SchemaSimpleType)child).isList()) {
                            javaType = javaType + "[]";
                        }
                        this.registry.put(qName3, javaType);
                        break;
                    }
                    if (child.getElementType() != 0) break;
                    this.registry.put(qName3, targetNSPrefix + Conventions.schema2JavaName("complexType", name, true));
                    break;
                }
                case 3: {
                    QName base;
                    String javaType;
                    SchemaAttribute schemaAttribute = (SchemaAttribute)element;
                    QName type = schemaAttribute.getType();
                    SchemaSimpleType simpleType = schemaAttribute.getChild();
                    if (type != null) {
                        String javaType2 = (String)this.registry.get(type);
                        if (javaType2 == null) break;
                        this.registry.put(qName3, javaType2);
                        break;
                    }
                    if (simpleType == null || (javaType = (String)this.registry.get(base = simpleType.getBase())) == null) break;
                    if (simpleType.isList()) {
                        javaType = javaType + "[]";
                    }
                    this.registry.put(qName3, javaType);
                }
            }
            ++i3;
        }
    }
}

