/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.Hashtable;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.base.WSIFServiceCache;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;

public class WSIFServiceFactoryImpl
extends WSIFServiceFactory {
    private boolean useCache = false;
    private WSIFServiceCache cache = null;
    private Map features = new Hashtable();

    public WSIFService getService(String wsdlLoc, String serviceNS, String serviceName, String portTypeNS, String portTypeName) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entry(this, wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName);
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public WSIFService getService(String wsdlLoc, ClassLoader cl, String serviceNS, String serviceName, String portTypeNS, String portTypeName) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entry(this, wsdlLoc, cl, serviceNS, serviceName, portTypeNS, portTypeName);
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(wsdlLoc, cl, serviceNS, serviceName, portTypeNS, portTypeName, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public WSIFService getService(Definition def) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entryExpandWsdl(this, new Object[]{def});
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(def, null, null))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(def, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public WSIFService getService(Definition def, Service service) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entryExpandWsdl(this, new Object[]{def, service});
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(def, service, null))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(def, service, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public WSIFService getService(Definition def, Service service, PortType portType) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entryExpandWsdl(this, new Object[]{def, service, portType});
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(def, service, portType))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(def, service, portType, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public WSIFService getService(Definition def, String serviceNS, String serviceName, String portTypeNS, String portTypeName) throws WSIFException {
        WSIFServiceImpl cachedWSI;
        Trc.entryExpandWsdl(this, new Object[]{def, serviceNS, serviceName, portTypeNS, portTypeName});
        String key = "";
        if (this.useCache && (cachedWSI = (WSIFServiceImpl)this.cache.get(key = this.genCacheKey(def, serviceNS, serviceName, portTypeNS, portTypeName))) != null) {
            WSIFServiceImpl wsi = new WSIFServiceImpl(cachedWSI);
            Trc.exit(wsi);
            return wsi;
        }
        WSIFServiceImpl wsi = new WSIFServiceImpl(def, serviceNS, serviceName, portTypeNS, portTypeName, this.getFeatures());
        if (this.useCache && !key.equals("")) {
            this.cache.put(key, wsi);
        }
        Trc.exit(wsi);
        return wsi;
    }

    public void cachingOn(boolean on) {
        Trc.entry((Object)this, on);
        this.setFeature("org.apache.wsif.servicecaching", new Boolean(on));
        Trc.exit();
    }

    public void setFeature(String name, Object value) {
        Trc.entry(this, name, value);
        if ("org.apache.wsif.servicecaching".equals(name)) {
            if (value != null && value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.useCache = true;
                    if (this.cache == null) {
                        int size = 100;
                        Object tempInt = this.getFeature("org.apache.wsif.servicecachesize");
                        if (tempInt != null && tempInt instanceof Integer) {
                            size = (Integer)tempInt;
                        }
                        this.cache = new WSIFServiceCache(size);
                    }
                } else {
                    this.useCache = false;
                    this.cache = null;
                }
            }
        } else if ("org.apache.wsif.servicecachesize".equals(name) && value != null && value instanceof Integer && this.cache != null) {
            int size = (Integer)value;
            this.cache.setCacheSize(size);
        }
        this.features.put(name, value);
        Trc.exit();
    }

    public void setFeatures(Map map) {
        int size;
        Object value;
        Trc.entry((Object)this, map);
        this.features.clear();
        this.features.putAll(map);
        if (map.containsKey("org.apache.wsif.servicecaching") && (value = map.get("org.apache.wsif.servicecaching")) != null && value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this.useCache = true;
                if (this.cache == null) {
                    size = 100;
                    Object tempInt = this.getFeature("org.apache.wsif.servicecachesize");
                    if (tempInt != null && tempInt instanceof Integer) {
                        size = (Integer)tempInt;
                    }
                    this.cache = new WSIFServiceCache(size);
                }
            } else {
                this.useCache = false;
                this.cache = null;
            }
        }
        if (map.containsKey("org.apache.wsif.servicecachesize") && (value = map.get("org.apache.wsif.servicecachesize")) != null && value instanceof Integer && this.cache != null) {
            size = (Integer)value;
            this.cache.setCacheSize(size);
        }
        Trc.exit();
    }

    public Object getFeature(String name) {
        return this.features.get(name);
    }

    public Map getFeatures() {
        return (Map)((Hashtable)this.features).clone();
    }

    private String genCacheKey(Definition def, Service service, PortType portType) {
        Trc.entry(this, def, service, portType);
        String db = def != null && def.getDocumentBaseURI() != null ? def.getDocumentBaseURI() : "null";
        QName serviceName = service != null ? service.getQName() : null;
        String sn = serviceName != null ? serviceName.toString() : "null";
        QName portTypeName = portType != null ? portType.getQName() : null;
        String ptn = portTypeName != null ? portTypeName.toString() : "null";
        StringBuffer key = new StringBuffer();
        key.append("D=");
        key.append(db);
        key.append("S=");
        key.append(sn);
        key.append("P=");
        key.append(ptn);
        String ret = key.toString();
        if (ret.equals("D=nullS=nullP=null")) {
            ret = "";
        }
        Trc.exit(ret);
        return ret;
    }

    private String genCacheKey(String wsdlLoc, String serviceNS, String serviceName, String portTypeNS, String portTypeName) {
        Trc.entry(this, wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName);
        StringBuffer key = new StringBuffer();
        if (wsdlLoc == null) {
            wsdlLoc = "";
        }
        if (serviceNS == null) {
            serviceNS = "";
        }
        if (serviceName == null) {
            serviceName = "";
        }
        if (portTypeNS == null) {
            portTypeNS = "";
        }
        if (portTypeName == null) {
            portTypeName = "";
        }
        key.append("W=");
        key.append(wsdlLoc);
        key.append("SN=");
        key.append(serviceNS);
        key.append("SS=");
        key.append(serviceName);
        key.append("PN=");
        key.append(portTypeNS);
        key.append("PS=");
        key.append(portTypeName);
        String ret = key.toString();
        if (ret.equals("W=SN=SS=PN=PS=")) {
            ret = "";
        }
        Trc.exit(ret);
        return ret;
    }

    private String genCacheKey(Definition def, String serviceNS, String serviceName, String portTypeNS, String portTypeName) {
        String db;
        Trc.entry(this, def, serviceNS, serviceName, portTypeNS, portTypeName);
        StringBuffer key = new StringBuffer();
        String string = db = def != null && def.getDocumentBaseURI() != null ? def.getDocumentBaseURI() : "null";
        if (serviceNS == null) {
            serviceNS = "";
        }
        if (serviceName == null) {
            serviceName = "";
        }
        if (portTypeNS == null) {
            portTypeNS = "";
        }
        if (portTypeName == null) {
            portTypeName = "";
        }
        key.append("D=");
        key.append(db);
        key.append("SN=");
        key.append(serviceNS);
        key.append("SS=");
        key.append(serviceName);
        key.append("PN=");
        key.append(portTypeNS);
        key.append("PS=");
        key.append(portTypeName);
        String ret = key.toString();
        if (ret.equals("D=nullSN=SS=PN=PS=")) {
            ret = "";
        }
        Trc.exit(ret);
        return ret;
    }
}

