/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.schema;

import com.ibm.wsdl.spi.extensions.lightweightschema.LightWeightSchema;
import com.ibm.wsdl.spi.extensions.lightweightschema.SchemaReference;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.schema.ParserDelegate;
import org.apache.wsif.schema.Schema;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ParserDelegateImpl
implements ParserDelegate,
Serializable {
    private static final QName schema1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    private static final QName schema2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    private static final QName schema2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final String SCHEMAS_LIST_PROPERTY = "org.apache.wsif.schema.parser.types";

    public void getTypesSchemas(Definition def, List schemas, WSDLLocator loc) throws WSIFException {
        if (loc == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            loc = new WSIFWSDLLocatorImpl((String)null, (String)null, cl);
        }
        this.getTypesSchemas(def, schemas, loc, new ArrayList(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTypesSchemas(Definition def, List schemas, WSDLLocator loc, List parsedXSDs, List parsedDefs) throws WSIFException {
        if (parsedDefs.contains(def)) {
            return;
        }
        Definition definition = def;
        synchronized (definition) {
            Types types = def.getTypes();
            if (types != null) {
                Iterator extEleIt = types.getExtensibilityElements().iterator();
                while (extEleIt.hasNext()) {
                    UnknownExtensibilityElement typesElement;
                    Element schemaEl;
                    Object tempElement = extEleIt.next();
                    if (tempElement instanceof LightWeightSchema) {
                        LightWeightSchema lightWeightSchema = (LightWeightSchema)tempElement;
                        this.addSchema(lightWeightSchema, schemas, parsedXSDs);
                        continue;
                    }
                    if (!(tempElement instanceof UnknownExtensibilityElement) || !QNameUtils.matches((QName)schema2001, (Node)(schemaEl = (typesElement = (UnknownExtensibilityElement)tempElement).getElement())) && !QNameUtils.matches((QName)schema2000, (Node)schemaEl) && !QNameUtils.matches((QName)schema1999, (Node)schemaEl)) continue;
                    Schema sc = new Schema(schemaEl);
                    schemas.add(sc);
                    String docBase = def.getDocumentBaseURI();
                    if (docBase == null || loc == null) continue;
                    String[] imports = sc.getImports();
                    int i = 0;
                    while (i < imports.length) {
                        String sl = imports[i];
                        this.getImportedSchemas(docBase, sl, loc, schemas, parsedXSDs, null);
                        ++i;
                    }
                    String[] includes = sc.getIncludes();
                    String parentNamespace = sc.getTargetNamespace();
                    int i2 = 0;
                    while (i2 < includes.length) {
                        String sl = includes[i2];
                        this.getImportedSchemas(docBase, sl, loc, schemas, parsedXSDs, parentNamespace);
                        ++i2;
                    }
                }
            }
            parsedDefs.add(def);
            Map imports = def.getImports();
            if (imports != null) {
                Iterator valueIterator = imports.values().iterator();
                while (valueIterator.hasNext()) {
                    List importList = (List)valueIterator.next();
                    if (importList == null) continue;
                    Iterator importIterator = importList.iterator();
                    while (importIterator.hasNext()) {
                        Import tempImport = (Import)importIterator.next();
                        if (tempImport == null) continue;
                        Definition importedDef = tempImport.getDefinition();
                        if (importedDef != null) {
                            this.getTypesSchemas(importedDef, schemas, loc, parsedXSDs, parsedDefs);
                            continue;
                        }
                        String baseLoc = def.getDocumentBaseURI();
                        String importLoc = tempImport.getLocationURI();
                        if (baseLoc == null || importLoc == null || loc == null) continue;
                        this.getImportedSchemas(baseLoc, importLoc, loc, schemas, parsedXSDs, null);
                    }
                }
            }
        }
    }

    private void addSchema(LightWeightSchema lws, List schemaList, List parsedXSDs) throws WSIFException {
        if (lws == null || this.alreadyParsed(lws, parsedXSDs)) {
            return;
        }
        Element schemaEl = lws.getElement();
        if (QNameUtils.matches((QName)schema2001, (Node)schemaEl) || QNameUtils.matches((QName)schema2000, (Node)schemaEl) || QNameUtils.matches((QName)schema1999, (Node)schemaEl)) {
            List redefines;
            List includes;
            SchemaReference lwsRef;
            Schema sc = new Schema(schemaEl);
            schemaList.add(sc);
            parsedXSDs.add(lws);
            Map xsdImports = lws.getImports();
            if (xsdImports != null) {
                Iterator importsIt = xsdImports.values().iterator();
                while (importsIt.hasNext()) {
                    List xsdList = (List)importsIt.next();
                    if (xsdList.size() <= 0) continue;
                    int i = 0;
                    while (i < xsdList.size()) {
                        lwsRef = (SchemaReference)xsdList.get(i);
                        if (lwsRef != null) {
                            LightWeightSchema importedLWS = lwsRef.getReferencedSchema();
                            this.addSchema(importedLWS, schemaList, parsedXSDs);
                        }
                        ++i;
                    }
                }
            }
            if ((includes = lws.getIncludes()) != null) {
                Iterator includesIt = includes.iterator();
                while (includesIt.hasNext()) {
                    SchemaReference lwsRef2 = (SchemaReference)includesIt.next();
                    if (lwsRef2 == null) continue;
                    LightWeightSchema includedLWS = lwsRef2.getReferencedSchema();
                    this.addSchema(includedLWS, schemaList, parsedXSDs);
                }
            }
            if ((redefines = lws.getRedefines()) != null) {
                Iterator redefinesIt = includes.iterator();
                while (redefinesIt.hasNext()) {
                    lwsRef = (SchemaReference)redefinesIt.next();
                    if (lwsRef == null) continue;
                    LightWeightSchema redefinedLWS = lwsRef.getReferencedSchema();
                    this.addSchema(redefinedLWS, schemaList, parsedXSDs);
                }
            }
        }
    }

    private boolean alreadyParsed(LightWeightSchema lws, List list) {
        boolean seen = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != lws) continue;
            seen = true;
            break;
        }
        return seen;
    }

    private void getImportedSchemas(String base, String rel, WSDLLocator loc, List schemaList, List parsedXSDs, String parentNamespace) throws WSIFException {
        try {
            if (rel.startsWith("http://schemas.xmlsoap.org")) {
                return;
            }
            InputSource inputSource = loc.getImportInputSource(base, rel);
            if (inputSource == null) {
                if (Trc.isDebugEnabled()) {
                    Trc.event(this, "ParserDelegateImpl was unable to locate schema file " + rel + " relative to " + base);
                }
                throw new WSIFException("Unable to locate schema file " + rel + " relative to " + base);
            }
            String lastURI = loc.getLatestImportURI();
            if (parsedXSDs.contains(lastURI)) {
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            if (inputSource.getCharacterStream() != null) {
                inputSource.getCharacterStream().close();
            } else if (inputSource.getByteStream() != null) {
                inputSource.getByteStream().close();
            }
            Element el = doc.getDocumentElement();
            if (el != null && (QNameUtils.matches((QName)schema2001, (Node)el) || QNameUtils.matches((QName)schema2000, (Node)el) || QNameUtils.matches((QName)schema1999, (Node)el))) {
                Schema sc = new Schema(el, parentNamespace);
                schemaList.add(sc);
                parsedXSDs.add(lastURI);
                String[] imports = sc.getImports();
                int i = 0;
                while (i < imports.length) {
                    String sl = imports[i];
                    this.getImportedSchemas(lastURI, sl, loc, schemaList, parsedXSDs, null);
                    ++i;
                }
                String[] includes = sc.getIncludes();
                String newParentNamespace = sc.getTargetNamespace();
                int i2 = 0;
                while (i2 < includes.length) {
                    String sl = includes[i2];
                    this.getImportedSchemas(lastURI, sl, loc, schemaList, parsedXSDs, newParentNamespace);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            Trc.exception(e);
            if (e instanceof WSIFException) {
                throw (WSIFException)e;
            }
            throw new WSIFException("Error when getting imported schemas", e);
        }
    }
}

