/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.transport.http.HTTPTransport;
import com.ibm.ws.webservices.wsif.configuration.WSIFClientConfig;
import com.ibm.ws.webservices.wsif.providers.soap.SOAPConstants;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFJmsTransport;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFOperation_SOAP;
import com.ibm.ws.webservices.wsif.providers.soap.jrom.JROMUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFOperationNotFoundException;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class WSIFPort_SOAP
extends WSIFDefaultPort {
    private static final long serialVersionUID = 2L;
    protected Definition definition;
    protected Port port;
    protected SOAPBinding soapBinding;
    protected SOAPAddress soapAddress;
    protected JMSAddress jmsAddress;
    protected String bindingStyle;
    protected URL endPointURL;
    protected List jmsAddressPropVals;
    protected WSIFDynamicTypeMap wsifdynamictypemap;
    protected Map cachedWSIFOperations;
    protected transient Transport transport;
    protected transient Call call;
    protected transient Call jromCall;
    private static final String HTTP_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    private static final String JMS_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/jms";
    private EngineConfiguration engineConfig = null;
    private boolean useCache = true;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPAddress;
    static /* synthetic */ Class class$org$apache$wsif$wsdl$extensions$jms$JMSAddress;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPOperation;

    public WSIFPort_SOAP(Definition definition, Port port, SOAPBinding soapBinding, WSIFDynamicTypeMap wsifdynamictypemap) throws WSIFException {
        Trc.entry(this, definition, port, soapBinding, wsifdynamictypemap);
        this.definition = definition;
        this.port = port;
        this.soapBinding = soapBinding;
        this.wsifdynamictypemap = wsifdynamictypemap;
        this.parseSoapBinding();
        this.parseServiceAddress();
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    private void parseSoapBinding() throws WSIFException {
        this.bindingStyle = this.soapBinding.getStyle();
        if (this.bindingStyle == null || this.bindingStyle.length() < 1) {
            this.bindingStyle = "document";
        } else if (!SOAPConstants.VALID_STYLES.contains(this.bindingStyle)) {
            throw new WSIFException("unsupported style '" + this.bindingStyle + "' for binding:" + this.soapBinding);
        }
        String transportURI = this.soapBinding.getTransportURI();
        if (!SOAPConstants.VALID_TRANSPORTS.contains(transportURI)) {
            throw new WSIFException("unsupported transport '" + transportURI + "' for binding: " + this.soapBinding);
        }
    }

    private void parseServiceAddress() throws WSIFException {
        this.soapAddress = (SOAPAddress)this.getExtElem(this.port, class$javax$wsdl$extensions$soap$SOAPAddress == null ? (class$javax$wsdl$extensions$soap$SOAPAddress = WSIFPort_SOAP.class$("javax.wsdl.extensions.soap.SOAPAddress")) : class$javax$wsdl$extensions$soap$SOAPAddress, this.port.getExtensibilityElements());
        this.jmsAddress = (JMSAddress)this.getExtElem(this.port, class$org$apache$wsif$wsdl$extensions$jms$JMSAddress == null ? (class$org$apache$wsif$wsdl$extensions$jms$JMSAddress = WSIFPort_SOAP.class$("org.apache.wsif.wsdl.extensions.jms.JMSAddress")) : class$org$apache$wsif$wsdl$extensions$jms$JMSAddress, this.port.getExtensibilityElements());
        if (this.soapAddress != null && this.jmsAddress != null) {
            throw new WSIFException("Both soap:address and jms:address cannot be specified for port " + this.port);
        }
        if (this.soapAddress == null && this.jmsAddress == null) {
            throw new WSIFException("Either soap:address or jms:address must be specified for port " + this.port);
        }
        if (this.isTransportHTTP() && this.soapAddress == null) {
            throw new WSIFException("binding transport http://schemas.xmlsoap.org/soap/http requires soap:address for port " + this.port);
        }
        if (this.soapAddress != null) {
            String s = this.soapAddress.getLocationURI();
            if (s == null || s.length() < 1) {
                throw new WSIFException("soap:address with location URI is required for " + this.port);
            }
            if (s.startsWith("jms:")) {
                this.jmsAddress = WSIFJMSDestination.getJMSAddressFromURL(URLDecoder.decode(s));
                this.soapAddress = null;
            } else {
                try {
                    this.endPointURL = new URL(s);
                }
                catch (MalformedURLException e) {
                    Trc.exception(e);
                    throw new WSIFException("exception setting SOAP address to " + s + ": " + e.getLocalizedMessage(), e);
                }
            }
        }
        if (this.isTransportJMS() && this.jmsAddress == null) {
            throw new WSIFException("binding transport http://schemas.xmlsoap.org/soap/jms requires jms:address for port " + this.port);
        }
        if (this.jmsAddress != null) {
            this.jmsAddressPropVals = this.jmsAddress.getJMSPropertyValues();
        }
    }

    public WSIFOperation createOperation(String operationName) throws WSIFException {
        Trc.entry((Object)this, operationName);
        WSIFOperation wo = this.createOperation(operationName, null, null);
        Trc.exit(wo);
        return wo;
    }

    public WSIFOperation createOperation(String operationName, String inputName, String outputName) throws WSIFException {
        Trc.entry(this, operationName, inputName, outputName);
        WSIFOperation_SOAP op = this.getDynamicWSIFOperation(operationName, inputName, outputName);
        if (op == null) {
            throw new WSIFException("Could not create operation: " + operationName + ":" + inputName + ":" + outputName);
        }
        Trc.exit(op);
        return op;
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        if (this.transport != null && this.transport instanceof WSIFJmsTransport) {
            ((WSIFJmsTransport)this.transport).close();
        }
        Trc.exit();
    }

    public Transport getSoapTransport() throws WSIFException {
        Trc.entry(this);
        Transport t = this.getTransport();
        Trc.exit(t);
        return t;
    }

    public QName getBindingName() {
        Trc.entry(this);
        Binding binding = this.port.getBinding();
        QName bindingQN = binding.getQName();
        Trc.exit(bindingQN);
        return bindingQN;
    }

    public String getBindingStyle() {
        Trc.entry(this);
        Trc.exit(this.bindingStyle);
        return this.bindingStyle;
    }

    public String getPortTypeNamespace() {
        Trc.entry(this);
        String portTypeNamespace = this.port.getBinding().getPortType().getQName().getNamespaceURI();
        Trc.exit(portTypeNamespace);
        return portTypeNamespace;
    }

    public Call getCall() throws WSIFException {
        Trc.entry(this);
        if (this.call == null || !this.useCache) {
            this.call = this.makeNewCallObject("not-jrom");
        }
        Trc.exit(this.call);
        return this.call;
    }

    public Call getJROMCall() throws WSIFException {
        Trc.entry(this);
        if (this.jromCall == null || !this.useCache) {
            this.jromCall = this.makeNewCallObject("jrom");
            TypeMapping tm = WSIFOperation_SOAP.getTypeMapping(this.jromCall.getService(), "http://schemas.xmlsoap.org/soap/encoding/");
            JROMUtils.registerJROMSerializers((javax.xml.rpc.encoding.TypeMapping)tm);
        }
        Trc.exit(this.jromCall);
        return this.jromCall;
    }

    private Call makeNewCallObject(String name) throws WSIFException {
        Call c = null;
        if (this.engineConfig == null) {
            Service s = new Service((EngineConfiguration)new WSIFClientConfig());
            c = new Call(s);
            c.setPortName(new QName(null, this.getPort().getName()));
        } else {
            c = new Call(new Service(this.engineConfig));
            c.setPortName(new QName(null, this.getPort().getName()));
        }
        URL endPoint = this.getEndPoint();
        if (endPoint != null) {
            c.setTargetEndpointAddress(endPoint);
            Transport soaptransport = this.getTransport();
            if (soaptransport != null) {
                soaptransport.setUrl(endPoint.toString());
            }
        }
        c.setMaintainSession(true);
        return c;
    }

    protected EngineConfiguration getContextEngineConfiguration() throws WSIFException {
        EngineConfiguration config = null;
        Object o = null;
        try {
            if (this.context != null) {
                o = this.context.getObjectPart("org.apache.wsif.provider.configuration");
            }
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        if (o != null) {
            if (!(o instanceof List)) {
                throw new WSIFException("expecting type java.util.List for context part 'org.apache.wsif.provider.configuration', found type: " + o.getClass());
            }
            Iterator i = ((List)o).iterator();
            while (config == null && i.hasNext()) {
                Object configX = i.next();
                if (!(configX instanceof EngineConfiguration)) continue;
                config = (EngineConfiguration)configX;
            }
        }
        return config;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.definition);
        return this.definition;
    }

    public WSIFOperation_SOAP getDynamicWSIFOperation(String opName, String inputName, String outputName) throws WSIFException {
        WSIFOperation_SOAP wsifOperation;
        Trc.entry(this, opName, inputName, outputName);
        WSIFOperation_SOAP cachedOp = null;
        if (opName == null) {
            BindingOperation templateBop = (BindingOperation)this.port.getBinding().getBindingOperations().get(0);
            if (templateBop == null) {
                throw new WSIFOperationNotFoundException("no operation found in the binding!");
            }
            opName = templateBop.getName();
        }
        this.useCache = true;
        this.engineConfig = this.getContextEngineConfiguration();
        if (this.engineConfig != null) {
            this.useCache = false;
        }
        if (this.cachedWSIFOperations == null) {
            this.cachedWSIFOperations = new HashMap();
        } else if (this.useCache) {
            cachedOp = (WSIFOperation_SOAP)this.cachedWSIFOperations.get(this.getKey(opName, inputName, outputName));
        }
        if (cachedOp == null) {
            BindingOperation bop = WSIFUtils.getBindingOperation(this.port.getBinding(), opName, inputName, outputName);
            if (bop == null) {
                throw new WSIFOperationNotFoundException("no operation found named " + opName + ", input:" + inputName + ", output:" + outputName);
            }
            cachedOp = new WSIFOperation_SOAP(this, bop.getOperation(), this.wsifdynamictypemap);
            this.cachedWSIFOperations.put(this.getKey(opName, inputName, outputName), cachedOp);
            wsifOperation = cachedOp;
        } else {
            wsifOperation = cachedOp.copy();
        }
        Trc.exit(wsifOperation);
        return wsifOperation;
    }

    public URL getEndPoint() {
        Trc.entry(this);
        Trc.exit(this.endPointURL);
        return this.endPointURL;
    }

    public Object getExtElem(Object ctx, Class extType, List extElems) throws WSIFException {
        Trc.entry(this, ctx, extType, extElems);
        Object o = super.getExtElem(ctx, extType, extElems);
        Trc.exit(o);
        return o;
    }

    public List getExtElems(Object ctx, Class extType, List extElems) throws WSIFException {
        Trc.entry(this, ctx, extType, extElems);
        List l = super.getExtElems(ctx, extType, extElems);
        Trc.exit(l);
        return l;
    }

    public List getJmsAddressPropVals() {
        Trc.entry(this);
        Trc.exit(this.jmsAddressPropVals);
        return this.jmsAddressPropVals;
    }

    public Port getPort() {
        Trc.entry(this);
        Trc.exit(this.port);
        return this.port;
    }

    public SOAPOperation getSOAPOperation(BindingOperation bindingOp) throws WSIFException {
        Trc.entry((Object)this, bindingOp);
        SOAPOperation soapOperation = (SOAPOperation)this.getExtElem(bindingOp, class$javax$wsdl$extensions$soap$SOAPOperation == null ? (class$javax$wsdl$extensions$soap$SOAPOperation = WSIFPort_SOAP.class$("javax.wsdl.extensions.soap.SOAPOperation")) : class$javax$wsdl$extensions$soap$SOAPOperation, bindingOp.getExtensibilityElements());
        if (soapOperation == null) {
            throw new WSIFOperationNotFoundException("no soap:operation found in binding for: " + bindingOp);
        }
        Trc.exit(soapOperation);
        return soapOperation;
    }

    public Transport getTransport() throws WSIFException {
        Trc.entry(this);
        if (this.transport == null) {
            String s = this.soapBinding.getTransportURI();
            if (HTTP_TRANSPORT_URI.equals(s)) {
                this.transport = new HTTPTransport();
            } else if (JMS_TRANSPORT_URI.equals(s)) {
                WSIFJMSDestination jmsDestination = new WSIFJMSDestination(WSIFJMSFinder.newFinder(this.jmsAddress, this.port.getName()), this.jmsAddress.getJmsProvDestName(), WSIFProperties.getSyncTimeout());
                this.transport = new WSIFJmsTransport(jmsDestination);
            }
        }
        Trc.exit(this.transport);
        return this.transport;
    }

    public boolean isTransportHTTP() {
        Trc.entry(this);
        String transportURI = this.soapBinding.getTransportURI();
        boolean httpTransport = HTTP_TRANSPORT_URI.equals(transportURI);
        Trc.exit(httpTransport);
        return httpTransport;
    }

    public boolean isTransportJMS() {
        Trc.entry(this);
        String transportURI = this.soapBinding.getTransportURI();
        boolean jmsTransport = JMS_TRANSPORT_URI.equals(transportURI);
        Trc.exit(jmsTransport);
        return jmsTransport;
    }

    public void setDefinition(Definition definition1) {
        Trc.entry((Object)this, definition1);
        this.definition = definition1;
        Trc.exit();
    }

    public void setDynamicWSIFOperation(String s, String s1, String s2, WSIFOperation_SOAP wsifoperation_soap) {
        Trc.entry(this, s, s1, s2, wsifoperation_soap);
        if (this.cachedWSIFOperations == null) {
            this.cachedWSIFOperations = new HashMap();
        }
        this.cachedWSIFOperations.put(this.getKey(s, s1, s2), wsifoperation_soap);
        Trc.exit();
    }

    public void setEndPoint(URL url1) {
        Trc.entry((Object)this, url1);
        this.endPointURL = url1;
        Trc.exit();
    }

    public void setPort(Port port1) {
        Trc.entry((Object)this, port1);
        this.port = port1;
        Trc.exit();
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        if (this.isTransportJMS()) {
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    public String deep() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(new String(super.toString()));
            buff.append(":\n");
            buff.append(" port: ").append(this.port);
            buff.append(" definition: ").append(this.definition);
            buff.append(" soapbinding: ").append(this.soapBinding);
            buff.append(" bindingStyle: ").append(this.bindingStyle);
            buff.append(" soapAddress: ").append(this.soapAddress);
            buff.append(" jmsAddress: ").append(this.jmsAddress);
            buff.append(" service url: ").append(this.endPointURL);
            buff.append(" jmsAddressPropVals: ").append(this.jmsAddressPropVals);
            buff.append(" dynamicTypeMap: ").append(this.wsifdynamictypemap);
            buff.append(" transport: ").append(this.transport);
            buff.append(" call: ").append(this.call);
            buff.append(" jromCall: ").append(this.jromCall);
            buff.append("operationInstances: ").append(this.cachedWSIFOperations);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

