/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.RASDelegator;
import com.ibm.ws.bootstrap.RASWsLoggerFactory;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static RASDelegator svRASDelegator = RASDelegator.getSingleton();
    private boolean resetEnabled = true;

    public void readConfiguration() throws IOException, SecurityException {
        String string = System.getProperty(CONFIGURE_BY_SERVER_PROPERTY_NAME);
        if (string == null || string.equalsIgnoreCase("false")) {
            super.readConfiguration();
        }
    }

    public synchronized Logger getLogger(String string) {
        Logger logger = super.getLogger(string);
        if (logger == null && (logger = svRASDelegator.createWsLogger(string)) != null) {
            this.addLogger(logger);
        }
        return logger;
    }

    public void initWsLoggerFactory(RASWsLoggerFactory rASWsLoggerFactory) {
        svRASDelegator.setRASWsLogerFactory(rASWsLoggerFactory);
    }

    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }
}

