/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.PathChecksum;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.security.util.AccessController;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class PreloadFile {
    private static final byte CODESOURCE = 0;
    private static final byte CLASSDATA = 1;
    private static int LIVE_CODESOURCE_MAP_SIZE = 300;
    private Map liveCodeSourceInfo = new HashMap(LIVE_CODESOURCE_MAP_SIZE);
    private static final CodeSourceInfo EMPTY_CODE_SOURCE = new CodeSourceInfo("");
    private CodeSourceInfo lastRecordedCodeSource = EMPTY_CODE_SOURCE;
    private CodeSourceInfo lastCodeSourceRead = EMPTY_CODE_SOURCE;
    private boolean lastCodeSourceReadIsValid = false;
    private String preloadPath = null;
    private File preloadFile = null;
    private FileInputStream fileInputStream = null;
    private FileChannel fileChannel = null;
    private FileLock fl = null;
    private DataInputStream inputStream = null;
    private DataOutputStream outputStream = null;
    private String outputStreamPath = null;
    private long preloadFileCRC = -1L;
    private long checkPathCRC = -1L;
    private boolean clearFileOnWrite = false;
    private boolean modificationsHaveBeenMade = false;
    private ExtClassLoader grClassLoader = null;
    private HashSet failedClasses = new HashSet();
    private byte[] preloadImage = null;
    private int preloadIndex = 0;
    private boolean fileError = false;
    private String tmppath = System.getProperty("java.io.tmpdir");

    protected PreloadFile(ExtClassLoader extClassLoader) {
        this.grClassLoader = extClassLoader;
    }

    protected void setPreloadPath(String string) {
        this.preloadPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordClassLoad(String string) {
        if (!this.fileError) {
            if (this.failedClasses.contains(string)) {
                return;
            }
            this.modificationsHaveBeenMade = true;
            try {
                PreloadFile preloadFile = this;
                synchronized (preloadFile) {
                    DataOutputStream dataOutputStream = this.getOutputStream();
                    dataOutputStream.writeUTF(string);
                }
            }
            catch (Throwable throwable) {
                this.fileError = true;
                RuntimeException runtimeException = new RuntimeException("Preload File error.  Check " + this.tmppath + ".", throwable);
                runtimeException.printStackTrace(WSLauncher.out);
            }
        }
    }

    protected void recordFailedClassLoad(String string) {
        this.failedClasses.add(string);
    }

    protected void addLiveCodeSourceInfo(String string) {
        this.liveCodeSourceInfo.put(string.toLowerCase(), new CodeSourceInfo(string));
    }

    protected void removeLiveCodeSourceInfo(String string) {
        this.liveCodeSourceInfo.remove(string.toLowerCase());
    }

    protected void lock() throws FileNotFoundException, IOException {
        if (this.fl == null) {
            this.getInputStream();
            this.fl = this.fileChannel.lock(0L, Long.MAX_VALUE, true);
        }
    }

    protected void unlock() {
        if (this.fl != null) {
            try {
                this.fl.release();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(WSLauncher.out);
            }
            this.fl = null;
        }
    }

    protected boolean checkCRC() {
        String string = System.getProperty("ibm.websphere.preload.checkpath");
        if (string == null) {
            string = System.getProperty("was.install.root") + File.separator + "classes";
        }
        this.checkPathCRC = PathChecksum.pathChecksum(string);
        this.preloadFileCRC = PathChecksum.pathChecksum(this.preloadPath);
        try {
            this.getInputStream();
            if (this.preloadFile.length() == 0L) {
                this.clearFileOnWrite = true;
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        long l = this.nextLong();
        if (l != this.checkPathCRC) {
            this.clearFileOnWrite = true;
            return false;
        }
        return true;
    }

    protected ClassData getNextPreloadClass(ClassData classData) {
        classData.className = null;
        classData.codeSourceInfo = null;
        classData.size = 0;
        try {
            while ((classData.className = this.nextString()) != null) {
                byte by = this.nextByte();
                if (by == 0) {
                    String string = this.nextString();
                    by = this.nextByte();
                    this.lastCodeSourceRead = this.getLiveCodeSourceInfo(string);
                    boolean bl = this.lastCodeSourceReadIsValid = this.lastCodeSourceRead != null;
                }
                if (!this.lastCodeSourceReadIsValid) continue;
                classData.codeSourceInfo = this.lastCodeSourceRead;
                return classData;
            }
        }
        catch (Throwable throwable) {
            this.clearFileOnWrite = true;
            this.fileError = true;
            this.modificationsHaveBeenMade = true;
            RuntimeException runtimeException = new RuntimeException("Preload file is corrupt: " + this.preloadPath, throwable);
            runtimeException.printStackTrace(WSLauncher.out);
        }
        return null;
    }

    protected CodeSource getCurrentCodeSource() throws MalformedURLException {
        return this.lastCodeSourceRead.getCodeSource();
    }

    protected Manifest getCurrentManifest() throws IOException {
        return this.lastCodeSourceRead.jarFile.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollUpChanges() throws IOException {
        Object object;
        Object object2;
        block16: {
            this.closeInputStream();
            this.getOutputStream().close();
            if (this.modificationsHaveBeenMade) {
                object2 = null;
                try {
                    object2 = new RandomAccessFile(this.preloadFile, "rw");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    WSLauncher.trace("preload.error.write");
                }
                if (object2 != null) {
                    object = ((RandomAccessFile)object2).getChannel();
                    FileLock fileLock = ((FileChannel)object).lock();
                    try {
                        long l = PathChecksum.streamChecksum(this.preloadFile.getAbsolutePath(), (RandomAccessFile)object2);
                        if (l != this.preloadFileCRC) break block16;
                        File file = new File(this.outputStreamPath);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                        File file2 = File.createTempFile("preload", "tmp");
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                        String string = file2.getAbsolutePath();
                        if (!this.fileError) {
                            this.copyPreloadData(dataInputStream, dataOutputStream);
                        }
                        dataInputStream.close();
                        fileInputStream.close();
                        dataOutputStream.close();
                        fileOutputStream.close();
                        fileInputStream = new FileInputStream(file2);
                        FileChannel fileChannel = fileInputStream.getChannel();
                        if (this.clearFileOnWrite) {
                            ((FileChannel)object).truncate(0L);
                            ((FileChannel)object).position(0L);
                            ((RandomAccessFile)object2).writeLong(this.checkPathCRC);
                        }
                        if (!this.fileError) {
                            try {
                                ((FileChannel)object).transferFrom(fileChannel, ((FileChannel)object).size(), fileChannel.size());
                            }
                            catch (Throwable throwable) {
                                ((FileChannel)object).truncate(0L);
                                ((FileChannel)object).position(0L);
                                ((RandomAccessFile)object2).writeLong(this.checkPathCRC);
                                RuntimeException runtimeException = new RuntimeException("Preload file error: " + this.preloadPath, throwable);
                                runtimeException.printStackTrace(WSLauncher.out);
                            }
                        }
                        fileChannel.close();
                        fileInputStream.close();
                        file2.delete();
                    }
                    finally {
                        fileLock.release();
                        ((AbstractInterruptibleChannel)object).close();
                        ((RandomAccessFile)object2).close();
                    }
                }
            }
        }
        new File(this.outputStreamPath).delete();
        this.preloadImage = null;
        object2 = this.liveCodeSourceInfo.values().iterator();
        while (object2.hasNext()) {
            object = (CodeSourceInfo)object2.next();
            if (((CodeSourceInfo)object).jarFile != null) {
                try {
                    ((CodeSourceInfo)object).jarFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((CodeSourceInfo)object).jarFile = null;
            ((CodeSourceInfo)object).codeSource = null;
        }
        this.liveCodeSourceInfo.clear();
        this.lastCodeSourceRead = null;
        this.lastRecordedCodeSource = null;
    }

    private void copyPreloadData(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        try {
            URL uRL = null;
            while ((string = dataInputStream.readUTF()) != null) {
                CodeSourceInfo codeSourceInfo;
                final String string4 = string.replace('.', '/') + ".class";
                try {
                    uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            return PreloadFile.this.grClassLoader.getResource(string4);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.printStackTrace(WSLauncher.out);
                }
                if (uRL == null) continue;
                string2 = uRL.getFile().toLowerCase();
                int n = string2.lastIndexOf(33);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((codeSourceInfo = this.getLiveCodeSourceInfo(string2)) == null) continue;
                dataOutputStream.writeUTF(string);
                if (!string2.equals(string3)) {
                    string3 = string2;
                    dataOutputStream.writeByte(0);
                    dataOutputStream.writeUTF(string2);
                }
                dataOutputStream.writeByte(1);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable throwable) {
            this.fileError = true;
            RuntimeException runtimeException = new RuntimeException("Preload file error.  Check " + this.tmppath + ".", throwable);
            runtimeException.printStackTrace(WSLauncher.out);
        }
    }

    private CodeSourceInfo getLiveCodeSourceInfo(String string) {
        return (CodeSourceInfo)this.liveCodeSourceInfo.get(string);
    }

    private DataOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            File file = new File(this.tmppath);
            File file2 = null;
            if (!file.exists()) {
                file.mkdir();
                file2 = File.createTempFile("preload", "tmp", file);
            } else {
                file2 = File.createTempFile("preload", "tmp");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.outputStream = new DataOutputStream(fileOutputStream);
            this.outputStreamPath = file2.getAbsolutePath();
        }
        return this.outputStream;
    }

    private DataInputStream getInputStream() throws FileNotFoundException {
        if (this.inputStream == null) {
            this.preloadFile = new File(this.preloadPath);
            this.fileInputStream = new FileInputStream(this.preloadFile);
            this.fileChannel = this.fileInputStream.getChannel();
            this.inputStream = new DataInputStream(this.fileInputStream);
            this.lastCodeSourceReadIsValid = false;
            this.load();
        }
        return this.inputStream;
    }

    private void closeInputStream() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.fileChannel.close();
            this.fileInputStream.close();
            this.inputStream = null;
        }
    }

    private long nextLong() {
        long l = ((long)(this.preloadImage[this.preloadIndex + 0] & 0xFF) << 56) + ((long)(this.preloadImage[this.preloadIndex + 1] & 0xFF) << 48) + ((long)(this.preloadImage[this.preloadIndex + 2] & 0xFF) << 40) + ((long)(this.preloadImage[this.preloadIndex + 3] & 0xFF) << 32) + ((long)(this.preloadImage[this.preloadIndex + 4] & 0xFF) << 24) + ((long)(this.preloadImage[this.preloadIndex + 5] & 0xFF) << 16) + ((long)(this.preloadImage[this.preloadIndex + 6] & 0xFF) << 8) + ((long)(this.preloadImage[this.preloadIndex + 7] & 0xFF) << 0);
        this.preloadIndex += 8;
        return l;
    }

    private int nextUnsignedShort() {
        int n = (this.preloadImage[this.preloadIndex] & 0xFF) << 8 | this.preloadImage[this.preloadIndex + 1] & 0xFF;
        this.preloadIndex += 2;
        return n;
    }

    private String nextString() {
        if (this.preloadIndex == this.preloadImage.length) {
            return null;
        }
        int n = this.nextUnsignedShort();
        String string = new String(this.preloadImage, this.preloadIndex, n);
        this.preloadIndex += n;
        return string;
    }

    private byte nextByte() {
        return this.preloadImage[this.preloadIndex++];
    }

    public void load() {
        try {
            this.preloadIndex = 0;
            this.preloadImage = new byte[(int)this.preloadFile.length()];
            this.inputStream.read(this.preloadImage);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class CodeSourceInfo {
        String url = null;
        JarFile jarFile = null;
        CodeSource codeSource = null;

        CodeSourceInfo(String string) {
            this.url = string;
        }

        public boolean equals(Object object) {
            CodeSourceInfo codeSourceInfo = (CodeSourceInfo)object;
            return codeSourceInfo.url == this.url;
        }

        private JarFile getJarFile() {
            try {
                if (this.jarFile == null) {
                    URL uRL = new URL(this.url);
                    File file = new File(uRL.getFile());
                    this.jarFile = new JarFile(file);
                }
                return this.jarFile;
            }
            catch (Exception exception) {
                return null;
            }
        }

        CodeSource getCodeSource() throws MalformedURLException {
            if (this.codeSource == null) {
                this.codeSource = new CodeSource(new URL(this.url), null);
            }
            return this.codeSource;
        }

        byte[] getByteCodes(ClassData classData) {
            try {
                String string;
                ZipEntry zipEntry;
                JarFile jarFile = this.getJarFile();
                if (jarFile != null && (zipEntry = jarFile.getEntry(string = classData.className.replace('.', '/') + ".class")) != null) {
                    classData.size = (int)zipEntry.getSize();
                    if (classData.byteCodes.length < classData.size) {
                        classData.byteCodes = new byte[classData.size];
                    }
                    DataInputStream dataInputStream = new DataInputStream(jarFile.getInputStream(zipEntry));
                    dataInputStream.readFully(classData.byteCodes, 0, classData.size);
                    dataInputStream.close();
                    return classData.byteCodes;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    static class ClassData {
        String className = null;
        byte[] byteCodes = new byte[100000];
        int size = 0;
        CodeSource codeSource = null;
        CodeSourceInfo codeSourceInfo = null;

        ClassData() {
        }

        byte[] getByteCodes() {
            return this.codeSourceInfo.getByteCodes(this);
        }
    }
}

