/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.Permission;

public class WSSecurityPropagationHelper {
    private ContextManager contextManager = null;
    private static WSSecurityPropagationHelper wsSecurityPropagationHelper = null;
    public static boolean rmiInboundPropagationEnabled = false;
    public static boolean rmiOutboundPropagationEnabled = false;
    public static boolean webInboundPropagationEnabled = false;
    private static final WebSphereRuntimePermission UPDATE_PROP = new WebSphereRuntimePermission("setPropagationToken");
    private static final WebSphereRuntimePermission VALIDATE_TOKEN = new WebSphereRuntimePermission("validateLTPAToken");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$wsspi$security$token$WSSecurityPropagationHelper == null ? (class$com$ibm$wsspi$security$token$WSSecurityPropagationHelper = WSSecurityPropagationHelper.class$("com.ibm.wsspi.security.token.WSSecurityPropagationHelper")) : class$com$ibm$wsspi$security$token$WSSecurityPropagationHelper), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$WSSecurityPropagationHelper;

    public static WSSecurityPropagationHelper getInstance() {
        if (wsSecurityPropagationHelper == null) {
            wsSecurityPropagationHelper = new WSSecurityPropagationHelper();
            rmiInboundPropagationEnabled = Boolean.valueOf(ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
            rmiOutboundPropagationEnabled = Boolean.valueOf(ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
            webInboundPropagationEnabled = Boolean.valueOf(ContextManagerFactory.getInstance().getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RMI inbound propagation enabled: " + rmiInboundPropagationEnabled));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RMI outbound propagation enabled: " + rmiOutboundPropagationEnabled));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WEB inbound propagation enabled: " + webInboundPropagationEnabled));
            }
        }
        return wsSecurityPropagationHelper;
    }

    private WSSecurityPropagationHelper() {
        try {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.constructor", (String)"86", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting ContextManager.", (Object)new Object[]{exception});
            }
            this.contextManager.setRootException(exception);
        }
    }

    public boolean isRMIInboundPropagationEnabled() {
        return rmiInboundPropagationEnabled;
    }

    public boolean isRMIOutboundPropagationEnabled() {
        return rmiOutboundPropagationEnabled;
    }

    public boolean isWebInboundPropagationEnabled() {
        return webInboundPropagationEnabled;
    }

    public static PropagationToken getPropagationToken(String string, int n) throws WSSecurityException {
        String string2 = string + ":" + n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Looking up propagation token with key " + string2));
        }
        return ContextManagerFactory.getInstance().getPropagationToken(string2);
    }

    public static PropagationToken addPropagationToken(PropagationToken propagationToken) throws WSSecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + UPDATE_PROP.toString()));
            }
            securityManager.checkPermission((Permission)UPDATE_PROP);
        }
        String string = propagationToken.getName() + ":" + propagationToken.getVersion();
        PropagationToken propagationToken2 = ContextManagerFactory.getInstance().getPropagationToken(string);
        if (propagationToken2 != null) {
            Tr.warning((TraceComponent)tc, (String)"security.sap.warning.propagation.token.exists", (Object)new Object[]{propagationToken.getName(), new Short(propagationToken.getVersion())});
            return propagationToken2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting propagation token with key " + string));
        }
        return ContextManagerFactory.getInstance().setPropagationToken(string, propagationToken);
    }

    public static String validateLTPAToken(byte[] byArray) throws WSLoginFailedException {
        block11: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting : " + VALIDATE_TOKEN.toString()));
                }
                securityManager.checkPermission((Permission)VALIDATE_TOKEN);
            }
            try {
                Token token = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(byArray);
                if (token != null) {
                    String[] stringArray = token.getAttributes("u");
                    String string = null;
                    if (stringArray != null && stringArray[0] != null) {
                        int n = stringArray[0].indexOf(":");
                        string = stringArray[0].startsWith("user:") ? stringArray[0].substring(n + 1) : stringArray[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Returning securityName: " + string));
                        }
                        return string;
                    }
                    break block11;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Throwing WSLoginFailedException, token was null.");
                }
                throw new WSLoginFailedException("Invalid token, token returned from validation is null.");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received exception during validation.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.WSSecurityPropagationHelper.validateLTPAToken", (String)"303");
                if (exception instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)exception;
                }
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning null.");
        }
        return null;
    }

    public static String getUserFromUniqueID(String string) {
        return RealmSecurityName.getSecurityName(string);
    }

    public static String getRealmFromUniqueID(String string) {
        int n = string.indexOf(":");
        if (string.startsWith("user:")) {
            string = string.substring(n + 1);
        }
        return RealmSecurityName.getRealm(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

